/*
	Copyright (c) 2015 Ki

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.
*/

using System;
using dnlib.DotNet;

namespace dnSpy.BamlDecompiler.Baml {
	internal partial class KnownThings {
		// Auto generated. Do not modify.

		void InitAssemblies() {
			assemblies[0] = ResolveThrow("mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
			assemblies[1] = ResolveThrow("System, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
			assemblies[2] = ResolveThrow("WindowsBase, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35");
			assemblies[3] = ResolveThrow("PresentationCore, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35");
			assemblies[4] = ResolveThrow("PresentationFramework, Version=4.0.0.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35");
			assemblies[5] = ResolveThrow("System.Xml, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
		}

		void InitTypes() {

			types[KnownTypes.AccessText] = InitType(assemblies[4], "System.Windows.Controls", "AccessText");
			types[KnownTypes.AdornedElementPlaceholder] = InitType(assemblies[4], "System.Windows.Controls", "AdornedElementPlaceholder");
			types[KnownTypes.Adorner] = InitType(assemblies[4], "System.Windows.Documents", "Adorner");
			types[KnownTypes.AdornerDecorator] = InitType(assemblies[4], "System.Windows.Documents", "AdornerDecorator");
			types[KnownTypes.AdornerLayer] = InitType(assemblies[4], "System.Windows.Documents", "AdornerLayer");
			types[KnownTypes.AffineTransform3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "AffineTransform3D");
			types[KnownTypes.AmbientLight] = InitType(assemblies[3], "System.Windows.Media.Media3D", "AmbientLight");
			types[KnownTypes.AnchoredBlock] = InitType(assemblies[4], "System.Windows.Documents", "AnchoredBlock");
			types[KnownTypes.Animatable] = InitType(assemblies[3], "System.Windows.Media.Animation", "Animatable");
			types[KnownTypes.AnimationClock] = InitType(assemblies[3], "System.Windows.Media.Animation", "AnimationClock");
			types[KnownTypes.AnimationTimeline] = InitType(assemblies[3], "System.Windows.Media.Animation", "AnimationTimeline");
			types[KnownTypes.Application] = InitType(assemblies[4], "System.Windows", "Application");
			types[KnownTypes.ArcSegment] = InitType(assemblies[3], "System.Windows.Media", "ArcSegment");
			types[KnownTypes.ArrayExtension] = InitType(assemblies[4], "System.Windows.Markup", "ArrayExtension");
			types[KnownTypes.AxisAngleRotation3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "AxisAngleRotation3D");
			types[KnownTypes.BaseIListConverter] = InitType(assemblies[3], "System.Windows.Media.Converters", "BaseIListConverter");
			types[KnownTypes.BeginStoryboard] = InitType(assemblies[4], "System.Windows.Media.Animation", "BeginStoryboard");
			types[KnownTypes.BevelBitmapEffect] = InitType(assemblies[3], "System.Windows.Media.Effects", "BevelBitmapEffect");
			types[KnownTypes.BezierSegment] = InitType(assemblies[3], "System.Windows.Media", "BezierSegment");
			types[KnownTypes.Binding] = InitType(assemblies[4], "System.Windows.Data", "Binding");
			types[KnownTypes.BindingBase] = InitType(assemblies[4], "System.Windows.Data", "BindingBase");
			types[KnownTypes.BindingExpression] = InitType(assemblies[4], "System.Windows.Data", "BindingExpression");
			types[KnownTypes.BindingExpressionBase] = InitType(assemblies[4], "System.Windows.Data", "BindingExpressionBase");
			types[KnownTypes.BindingListCollectionView] = InitType(assemblies[4], "System.Windows.Data", "BindingListCollectionView");
			types[KnownTypes.BitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BitmapDecoder");
			types[KnownTypes.BitmapEffect] = InitType(assemblies[3], "System.Windows.Media.Effects", "BitmapEffect");
			types[KnownTypes.BitmapEffectCollection] = InitType(assemblies[3], "System.Windows.Media.Effects", "BitmapEffectCollection");
			types[KnownTypes.BitmapEffectGroup] = InitType(assemblies[3], "System.Windows.Media.Effects", "BitmapEffectGroup");
			types[KnownTypes.BitmapEffectInput] = InitType(assemblies[3], "System.Windows.Media.Effects", "BitmapEffectInput");
			types[KnownTypes.BitmapEncoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BitmapEncoder");
			types[KnownTypes.BitmapFrame] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BitmapFrame");
			types[KnownTypes.BitmapImage] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BitmapImage");
			types[KnownTypes.BitmapMetadata] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BitmapMetadata");
			types[KnownTypes.BitmapPalette] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BitmapPalette");
			types[KnownTypes.BitmapSource] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BitmapSource");
			types[KnownTypes.Block] = InitType(assemblies[4], "System.Windows.Documents", "Block");
			types[KnownTypes.BlockUIContainer] = InitType(assemblies[4], "System.Windows.Documents", "BlockUIContainer");
			types[KnownTypes.BlurBitmapEffect] = InitType(assemblies[3], "System.Windows.Media.Effects", "BlurBitmapEffect");
			types[KnownTypes.BmpBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BmpBitmapDecoder");
			types[KnownTypes.BmpBitmapEncoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "BmpBitmapEncoder");
			types[KnownTypes.Bold] = InitType(assemblies[4], "System.Windows.Documents", "Bold");
			types[KnownTypes.BoolIListConverter] = InitType(assemblies[3], "System.Windows.Media.Converters", "BoolIListConverter");
			types[KnownTypes.Boolean] = InitType(assemblies[0], "System", "Boolean");
			types[KnownTypes.BooleanAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "BooleanAnimationBase");
			types[KnownTypes.BooleanAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "BooleanAnimationUsingKeyFrames");
			types[KnownTypes.BooleanConverter] = InitType(assemblies[1], "System.ComponentModel", "BooleanConverter");
			types[KnownTypes.BooleanKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "BooleanKeyFrame");
			types[KnownTypes.BooleanKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "BooleanKeyFrameCollection");
			types[KnownTypes.BooleanToVisibilityConverter] = InitType(assemblies[4], "System.Windows.Controls", "BooleanToVisibilityConverter");
			types[KnownTypes.Border] = InitType(assemblies[4], "System.Windows.Controls", "Border");
			types[KnownTypes.BorderGapMaskConverter] = InitType(assemblies[4], "System.Windows.Controls", "BorderGapMaskConverter");
			types[KnownTypes.Brush] = InitType(assemblies[3], "System.Windows.Media", "Brush");
			types[KnownTypes.BrushConverter] = InitType(assemblies[3], "System.Windows.Media", "BrushConverter");
			types[KnownTypes.BulletDecorator] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "BulletDecorator");
			types[KnownTypes.Button] = InitType(assemblies[4], "System.Windows.Controls", "Button");
			types[KnownTypes.ButtonBase] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "ButtonBase");
			types[KnownTypes.Byte] = InitType(assemblies[0], "System", "Byte");
			types[KnownTypes.ByteAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "ByteAnimation");
			types[KnownTypes.ByteAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "ByteAnimationBase");
			types[KnownTypes.ByteAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "ByteAnimationUsingKeyFrames");
			types[KnownTypes.ByteConverter] = InitType(assemblies[1], "System.ComponentModel", "ByteConverter");
			types[KnownTypes.ByteKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "ByteKeyFrame");
			types[KnownTypes.ByteKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "ByteKeyFrameCollection");
			types[KnownTypes.CachedBitmap] = InitType(assemblies[3], "System.Windows.Media.Imaging", "CachedBitmap");
			types[KnownTypes.Camera] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Camera");
			types[KnownTypes.Canvas] = InitType(assemblies[4], "System.Windows.Controls", "Canvas");
			types[KnownTypes.Char] = InitType(assemblies[0], "System", "Char");
			types[KnownTypes.CharAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "CharAnimationBase");
			types[KnownTypes.CharAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "CharAnimationUsingKeyFrames");
			types[KnownTypes.CharConverter] = InitType(assemblies[1], "System.ComponentModel", "CharConverter");
			types[KnownTypes.CharIListConverter] = InitType(assemblies[3], "System.Windows.Media.Converters", "CharIListConverter");
			types[KnownTypes.CharKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "CharKeyFrame");
			types[KnownTypes.CharKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "CharKeyFrameCollection");
			types[KnownTypes.CheckBox] = InitType(assemblies[4], "System.Windows.Controls", "CheckBox");
			types[KnownTypes.Clock] = InitType(assemblies[3], "System.Windows.Media.Animation", "Clock");
			types[KnownTypes.ClockController] = InitType(assemblies[3], "System.Windows.Media.Animation", "ClockController");
			types[KnownTypes.ClockGroup] = InitType(assemblies[3], "System.Windows.Media.Animation", "ClockGroup");
			types[KnownTypes.CollectionContainer] = InitType(assemblies[4], "System.Windows.Data", "CollectionContainer");
			types[KnownTypes.CollectionView] = InitType(assemblies[4], "System.Windows.Data", "CollectionView");
			types[KnownTypes.CollectionViewSource] = InitType(assemblies[4], "System.Windows.Data", "CollectionViewSource");
			types[KnownTypes.Color] = InitType(assemblies[3], "System.Windows.Media", "Color");
			types[KnownTypes.ColorAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "ColorAnimation");
			types[KnownTypes.ColorAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "ColorAnimationBase");
			types[KnownTypes.ColorAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "ColorAnimationUsingKeyFrames");
			types[KnownTypes.ColorConvertedBitmap] = InitType(assemblies[3], "System.Windows.Media.Imaging", "ColorConvertedBitmap");
			types[KnownTypes.ColorConvertedBitmapExtension] = InitType(assemblies[4], "System.Windows", "ColorConvertedBitmapExtension");
			types[KnownTypes.ColorConverter] = InitType(assemblies[3], "System.Windows.Media", "ColorConverter");
			types[KnownTypes.ColorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "ColorKeyFrame");
			types[KnownTypes.ColorKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "ColorKeyFrameCollection");
			types[KnownTypes.ColumnDefinition] = InitType(assemblies[4], "System.Windows.Controls", "ColumnDefinition");
			types[KnownTypes.CombinedGeometry] = InitType(assemblies[3], "System.Windows.Media", "CombinedGeometry");
			types[KnownTypes.ComboBox] = InitType(assemblies[4], "System.Windows.Controls", "ComboBox");
			types[KnownTypes.ComboBoxItem] = InitType(assemblies[4], "System.Windows.Controls", "ComboBoxItem");
			types[KnownTypes.CommandConverter] = InitType(assemblies[4], "System.Windows.Input", "CommandConverter");
			types[KnownTypes.ComponentResourceKey] = InitType(assemblies[4], "System.Windows", "ComponentResourceKey");
			types[KnownTypes.ComponentResourceKeyConverter] = InitType(assemblies[4], "System.Windows.Markup", "ComponentResourceKeyConverter");
			types[KnownTypes.CompositionTarget] = InitType(assemblies[3], "System.Windows.Media", "CompositionTarget");
			types[KnownTypes.Condition] = InitType(assemblies[4], "System.Windows", "Condition");
			types[KnownTypes.ContainerVisual] = InitType(assemblies[3], "System.Windows.Media", "ContainerVisual");
			types[KnownTypes.ContentControl] = InitType(assemblies[4], "System.Windows.Controls", "ContentControl");
			types[KnownTypes.ContentElement] = InitType(assemblies[3], "System.Windows", "ContentElement");
			types[KnownTypes.ContentPresenter] = InitType(assemblies[4], "System.Windows.Controls", "ContentPresenter");
			types[KnownTypes.ContentPropertyAttribute] = InitType(assemblies[2], "System.Windows.Markup", "ContentPropertyAttribute");
			types[KnownTypes.ContentWrapperAttribute] = InitType(assemblies[2], "System.Windows.Markup", "ContentWrapperAttribute");
			types[KnownTypes.ContextMenu] = InitType(assemblies[4], "System.Windows.Controls", "ContextMenu");
			types[KnownTypes.ContextMenuService] = InitType(assemblies[4], "System.Windows.Controls", "ContextMenuService");
			types[KnownTypes.Control] = InitType(assemblies[4], "System.Windows.Controls", "Control");
			types[KnownTypes.ControlTemplate] = InitType(assemblies[4], "System.Windows.Controls", "ControlTemplate");
			types[KnownTypes.ControllableStoryboardAction] = InitType(assemblies[4], "System.Windows.Media.Animation", "ControllableStoryboardAction");
			types[KnownTypes.CornerRadius] = InitType(assemblies[4], "System.Windows", "CornerRadius");
			types[KnownTypes.CornerRadiusConverter] = InitType(assemblies[4], "System.Windows", "CornerRadiusConverter");
			types[KnownTypes.CroppedBitmap] = InitType(assemblies[3], "System.Windows.Media.Imaging", "CroppedBitmap");
			types[KnownTypes.CultureInfo] = InitType(assemblies[0], "System.Globalization", "CultureInfo");
			types[KnownTypes.CultureInfoConverter] = InitType(assemblies[1], "System.ComponentModel", "CultureInfoConverter");
			types[KnownTypes.CultureInfoIetfLanguageTagConverter] = InitType(assemblies[3], "System.Windows", "CultureInfoIetfLanguageTagConverter");
			types[KnownTypes.Cursor] = InitType(assemblies[3], "System.Windows.Input", "Cursor");
			types[KnownTypes.CursorConverter] = InitType(assemblies[3], "System.Windows.Input", "CursorConverter");
			types[KnownTypes.DashStyle] = InitType(assemblies[3], "System.Windows.Media", "DashStyle");
			types[KnownTypes.DataChangedEventManager] = InitType(assemblies[4], "System.Windows.Data", "DataChangedEventManager");
			types[KnownTypes.DataTemplate] = InitType(assemblies[4], "System.Windows", "DataTemplate");
			types[KnownTypes.DataTemplateKey] = InitType(assemblies[4], "System.Windows", "DataTemplateKey");
			types[KnownTypes.DataTrigger] = InitType(assemblies[4], "System.Windows", "DataTrigger");
			types[KnownTypes.DateTime] = InitType(assemblies[0], "System", "DateTime");
			types[KnownTypes.DateTimeConverter] = InitType(assemblies[1], "System.ComponentModel", "DateTimeConverter");
			types[KnownTypes.DateTimeConverter2] = InitType(assemblies[2], "System.Windows.Markup", "DateTimeConverter2");
			types[KnownTypes.Decimal] = InitType(assemblies[0], "System", "Decimal");
			types[KnownTypes.DecimalAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "DecimalAnimation");
			types[KnownTypes.DecimalAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "DecimalAnimationBase");
			types[KnownTypes.DecimalAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "DecimalAnimationUsingKeyFrames");
			types[KnownTypes.DecimalConverter] = InitType(assemblies[1], "System.ComponentModel", "DecimalConverter");
			types[KnownTypes.DecimalKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DecimalKeyFrame");
			types[KnownTypes.DecimalKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "DecimalKeyFrameCollection");
			types[KnownTypes.Decorator] = InitType(assemblies[4], "System.Windows.Controls", "Decorator");
			types[KnownTypes.DefinitionBase] = InitType(assemblies[4], "System.Windows.Controls", "DefinitionBase");
			types[KnownTypes.DependencyObject] = InitType(assemblies[2], "System.Windows", "DependencyObject");
			types[KnownTypes.DependencyProperty] = InitType(assemblies[2], "System.Windows", "DependencyProperty");
			types[KnownTypes.DependencyPropertyConverter] = InitType(assemblies[4], "System.Windows.Markup", "DependencyPropertyConverter");
			types[KnownTypes.DialogResultConverter] = InitType(assemblies[4], "System.Windows", "DialogResultConverter");
			types[KnownTypes.DiffuseMaterial] = InitType(assemblies[3], "System.Windows.Media.Media3D", "DiffuseMaterial");
			types[KnownTypes.DirectionalLight] = InitType(assemblies[3], "System.Windows.Media.Media3D", "DirectionalLight");
			types[KnownTypes.DiscreteBooleanKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteBooleanKeyFrame");
			types[KnownTypes.DiscreteByteKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteByteKeyFrame");
			types[KnownTypes.DiscreteCharKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteCharKeyFrame");
			types[KnownTypes.DiscreteColorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteColorKeyFrame");
			types[KnownTypes.DiscreteDecimalKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteDecimalKeyFrame");
			types[KnownTypes.DiscreteDoubleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteDoubleKeyFrame");
			types[KnownTypes.DiscreteInt16KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteInt16KeyFrame");
			types[KnownTypes.DiscreteInt32KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteInt32KeyFrame");
			types[KnownTypes.DiscreteInt64KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteInt64KeyFrame");
			types[KnownTypes.DiscreteMatrixKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteMatrixKeyFrame");
			types[KnownTypes.DiscreteObjectKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteObjectKeyFrame");
			types[KnownTypes.DiscretePoint3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscretePoint3DKeyFrame");
			types[KnownTypes.DiscretePointKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscretePointKeyFrame");
			types[KnownTypes.DiscreteQuaternionKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteQuaternionKeyFrame");
			types[KnownTypes.DiscreteRectKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteRectKeyFrame");
			types[KnownTypes.DiscreteRotation3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteRotation3DKeyFrame");
			types[KnownTypes.DiscreteSingleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteSingleKeyFrame");
			types[KnownTypes.DiscreteSizeKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteSizeKeyFrame");
			types[KnownTypes.DiscreteStringKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteStringKeyFrame");
			types[KnownTypes.DiscreteThicknessKeyFrame] = InitType(assemblies[4], "System.Windows.Media.Animation", "DiscreteThicknessKeyFrame");
			types[KnownTypes.DiscreteVector3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteVector3DKeyFrame");
			types[KnownTypes.DiscreteVectorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DiscreteVectorKeyFrame");
			types[KnownTypes.DockPanel] = InitType(assemblies[4], "System.Windows.Controls", "DockPanel");
			types[KnownTypes.DocumentPageView] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "DocumentPageView");
			types[KnownTypes.DocumentReference] = InitType(assemblies[4], "System.Windows.Documents", "DocumentReference");
			types[KnownTypes.DocumentViewer] = InitType(assemblies[4], "System.Windows.Controls", "DocumentViewer");
			types[KnownTypes.DocumentViewerBase] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "DocumentViewerBase");
			types[KnownTypes.Double] = InitType(assemblies[0], "System", "Double");
			types[KnownTypes.DoubleAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "DoubleAnimation");
			types[KnownTypes.DoubleAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "DoubleAnimationBase");
			types[KnownTypes.DoubleAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "DoubleAnimationUsingKeyFrames");
			types[KnownTypes.DoubleAnimationUsingPath] = InitType(assemblies[3], "System.Windows.Media.Animation", "DoubleAnimationUsingPath");
			types[KnownTypes.DoubleCollection] = InitType(assemblies[3], "System.Windows.Media", "DoubleCollection");
			types[KnownTypes.DoubleCollectionConverter] = InitType(assemblies[3], "System.Windows.Media", "DoubleCollectionConverter");
			types[KnownTypes.DoubleConverter] = InitType(assemblies[1], "System.ComponentModel", "DoubleConverter");
			types[KnownTypes.DoubleIListConverter] = InitType(assemblies[3], "System.Windows.Media.Converters", "DoubleIListConverter");
			types[KnownTypes.DoubleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "DoubleKeyFrame");
			types[KnownTypes.DoubleKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "DoubleKeyFrameCollection");
			types[KnownTypes.Drawing] = InitType(assemblies[3], "System.Windows.Media", "Drawing");
			types[KnownTypes.DrawingBrush] = InitType(assemblies[3], "System.Windows.Media", "DrawingBrush");
			types[KnownTypes.DrawingCollection] = InitType(assemblies[3], "System.Windows.Media", "DrawingCollection");
			types[KnownTypes.DrawingContext] = InitType(assemblies[3], "System.Windows.Media", "DrawingContext");
			types[KnownTypes.DrawingGroup] = InitType(assemblies[3], "System.Windows.Media", "DrawingGroup");
			types[KnownTypes.DrawingImage] = InitType(assemblies[3], "System.Windows.Media", "DrawingImage");
			types[KnownTypes.DrawingVisual] = InitType(assemblies[3], "System.Windows.Media", "DrawingVisual");
			types[KnownTypes.DropShadowBitmapEffect] = InitType(assemblies[3], "System.Windows.Media.Effects", "DropShadowBitmapEffect");
			types[KnownTypes.Duration] = InitType(assemblies[3], "System.Windows", "Duration");
			types[KnownTypes.DurationConverter] = InitType(assemblies[3], "System.Windows", "DurationConverter");
			types[KnownTypes.DynamicResourceExtension] = InitType(assemblies[4], "System.Windows", "DynamicResourceExtension");
			types[KnownTypes.DynamicResourceExtensionConverter] = InitType(assemblies[4], "System.Windows", "DynamicResourceExtensionConverter");
			types[KnownTypes.Ellipse] = InitType(assemblies[4], "System.Windows.Shapes", "Ellipse");
			types[KnownTypes.EllipseGeometry] = InitType(assemblies[3], "System.Windows.Media", "EllipseGeometry");
			types[KnownTypes.EmbossBitmapEffect] = InitType(assemblies[3], "System.Windows.Media.Effects", "EmbossBitmapEffect");
			types[KnownTypes.EmissiveMaterial] = InitType(assemblies[3], "System.Windows.Media.Media3D", "EmissiveMaterial");
			types[KnownTypes.EnumConverter] = InitType(assemblies[1], "System.ComponentModel", "EnumConverter");
			types[KnownTypes.EventManager] = InitType(assemblies[3], "System.Windows", "EventManager");
			types[KnownTypes.EventSetter] = InitType(assemblies[4], "System.Windows", "EventSetter");
			types[KnownTypes.EventTrigger] = InitType(assemblies[4], "System.Windows", "EventTrigger");
			types[KnownTypes.Expander] = InitType(assemblies[4], "System.Windows.Controls", "Expander");
			types[KnownTypes.Expression] = InitType(assemblies[2], "System.Windows", "Expression");
			types[KnownTypes.ExpressionConverter] = InitType(assemblies[2], "System.Windows", "ExpressionConverter");
			types[KnownTypes.Figure] = InitType(assemblies[4], "System.Windows.Documents", "Figure");
			types[KnownTypes.FigureLength] = InitType(assemblies[4], "System.Windows", "FigureLength");
			types[KnownTypes.FigureLengthConverter] = InitType(assemblies[4], "System.Windows", "FigureLengthConverter");
			types[KnownTypes.FixedDocument] = InitType(assemblies[4], "System.Windows.Documents", "FixedDocument");
			types[KnownTypes.FixedDocumentSequence] = InitType(assemblies[4], "System.Windows.Documents", "FixedDocumentSequence");
			types[KnownTypes.FixedPage] = InitType(assemblies[4], "System.Windows.Documents", "FixedPage");
			types[KnownTypes.Floater] = InitType(assemblies[4], "System.Windows.Documents", "Floater");
			types[KnownTypes.FlowDocument] = InitType(assemblies[4], "System.Windows.Documents", "FlowDocument");
			types[KnownTypes.FlowDocumentPageViewer] = InitType(assemblies[4], "System.Windows.Controls", "FlowDocumentPageViewer");
			types[KnownTypes.FlowDocumentReader] = InitType(assemblies[4], "System.Windows.Controls", "FlowDocumentReader");
			types[KnownTypes.FlowDocumentScrollViewer] = InitType(assemblies[4], "System.Windows.Controls", "FlowDocumentScrollViewer");
			types[KnownTypes.FocusManager] = InitType(assemblies[3], "System.Windows.Input", "FocusManager");
			types[KnownTypes.FontFamily] = InitType(assemblies[3], "System.Windows.Media", "FontFamily");
			types[KnownTypes.FontFamilyConverter] = InitType(assemblies[3], "System.Windows.Media", "FontFamilyConverter");
			types[KnownTypes.FontSizeConverter] = InitType(assemblies[4], "System.Windows", "FontSizeConverter");
			types[KnownTypes.FontStretch] = InitType(assemblies[3], "System.Windows", "FontStretch");
			types[KnownTypes.FontStretchConverter] = InitType(assemblies[3], "System.Windows", "FontStretchConverter");
			types[KnownTypes.FontStyle] = InitType(assemblies[3], "System.Windows", "FontStyle");
			types[KnownTypes.FontStyleConverter] = InitType(assemblies[3], "System.Windows", "FontStyleConverter");
			types[KnownTypes.FontWeight] = InitType(assemblies[3], "System.Windows", "FontWeight");
			types[KnownTypes.FontWeightConverter] = InitType(assemblies[3], "System.Windows", "FontWeightConverter");
			types[KnownTypes.FormatConvertedBitmap] = InitType(assemblies[3], "System.Windows.Media.Imaging", "FormatConvertedBitmap");
			types[KnownTypes.Frame] = InitType(assemblies[4], "System.Windows.Controls", "Frame");
			types[KnownTypes.FrameworkContentElement] = InitType(assemblies[4], "System.Windows", "FrameworkContentElement");
			types[KnownTypes.FrameworkElement] = InitType(assemblies[4], "System.Windows", "FrameworkElement");
			types[KnownTypes.FrameworkElementFactory] = InitType(assemblies[4], "System.Windows", "FrameworkElementFactory");
			types[KnownTypes.FrameworkPropertyMetadata] = InitType(assemblies[4], "System.Windows", "FrameworkPropertyMetadata");
			types[KnownTypes.FrameworkPropertyMetadataOptions] = InitType(assemblies[4], "System.Windows", "FrameworkPropertyMetadataOptions");
			types[KnownTypes.FrameworkRichTextComposition] = InitType(assemblies[4], "System.Windows.Documents", "FrameworkRichTextComposition");
			types[KnownTypes.FrameworkTemplate] = InitType(assemblies[4], "System.Windows", "FrameworkTemplate");
			types[KnownTypes.FrameworkTextComposition] = InitType(assemblies[4], "System.Windows.Documents", "FrameworkTextComposition");
			types[KnownTypes.Freezable] = InitType(assemblies[2], "System.Windows", "Freezable");
			types[KnownTypes.GeneralTransform] = InitType(assemblies[3], "System.Windows.Media", "GeneralTransform");
			types[KnownTypes.GeneralTransformCollection] = InitType(assemblies[3], "System.Windows.Media", "GeneralTransformCollection");
			types[KnownTypes.GeneralTransformGroup] = InitType(assemblies[3], "System.Windows.Media", "GeneralTransformGroup");
			types[KnownTypes.Geometry] = InitType(assemblies[3], "System.Windows.Media", "Geometry");
			types[KnownTypes.Geometry3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Geometry3D");
			types[KnownTypes.GeometryCollection] = InitType(assemblies[3], "System.Windows.Media", "GeometryCollection");
			types[KnownTypes.GeometryConverter] = InitType(assemblies[3], "System.Windows.Media", "GeometryConverter");
			types[KnownTypes.GeometryDrawing] = InitType(assemblies[3], "System.Windows.Media", "GeometryDrawing");
			types[KnownTypes.GeometryGroup] = InitType(assemblies[3], "System.Windows.Media", "GeometryGroup");
			types[KnownTypes.GeometryModel3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "GeometryModel3D");
			types[KnownTypes.GestureRecognizer] = InitType(assemblies[3], "System.Windows.Ink", "GestureRecognizer");
			types[KnownTypes.GifBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "GifBitmapDecoder");
			types[KnownTypes.GifBitmapEncoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "GifBitmapEncoder");
			types[KnownTypes.GlyphRun] = InitType(assemblies[3], "System.Windows.Media", "GlyphRun");
			types[KnownTypes.GlyphRunDrawing] = InitType(assemblies[3], "System.Windows.Media", "GlyphRunDrawing");
			types[KnownTypes.GlyphTypeface] = InitType(assemblies[3], "System.Windows.Media", "GlyphTypeface");
			types[KnownTypes.Glyphs] = InitType(assemblies[4], "System.Windows.Documents", "Glyphs");
			types[KnownTypes.GradientBrush] = InitType(assemblies[3], "System.Windows.Media", "GradientBrush");
			types[KnownTypes.GradientStop] = InitType(assemblies[3], "System.Windows.Media", "GradientStop");
			types[KnownTypes.GradientStopCollection] = InitType(assemblies[3], "System.Windows.Media", "GradientStopCollection");
			types[KnownTypes.Grid] = InitType(assemblies[4], "System.Windows.Controls", "Grid");
			types[KnownTypes.GridLength] = InitType(assemblies[4], "System.Windows", "GridLength");
			types[KnownTypes.GridLengthConverter] = InitType(assemblies[4], "System.Windows", "GridLengthConverter");
			types[KnownTypes.GridSplitter] = InitType(assemblies[4], "System.Windows.Controls", "GridSplitter");
			types[KnownTypes.GridView] = InitType(assemblies[4], "System.Windows.Controls", "GridView");
			types[KnownTypes.GridViewColumn] = InitType(assemblies[4], "System.Windows.Controls", "GridViewColumn");
			types[KnownTypes.GridViewColumnHeader] = InitType(assemblies[4], "System.Windows.Controls", "GridViewColumnHeader");
			types[KnownTypes.GridViewHeaderRowPresenter] = InitType(assemblies[4], "System.Windows.Controls", "GridViewHeaderRowPresenter");
			types[KnownTypes.GridViewRowPresenter] = InitType(assemblies[4], "System.Windows.Controls", "GridViewRowPresenter");
			types[KnownTypes.GridViewRowPresenterBase] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "GridViewRowPresenterBase");
			types[KnownTypes.GroupBox] = InitType(assemblies[4], "System.Windows.Controls", "GroupBox");
			types[KnownTypes.GroupItem] = InitType(assemblies[4], "System.Windows.Controls", "GroupItem");
			types[KnownTypes.Guid] = InitType(assemblies[0], "System", "Guid");
			types[KnownTypes.GuidConverter] = InitType(assemblies[1], "System.ComponentModel", "GuidConverter");
			types[KnownTypes.GuidelineSet] = InitType(assemblies[3], "System.Windows.Media", "GuidelineSet");
			types[KnownTypes.HeaderedContentControl] = InitType(assemblies[4], "System.Windows.Controls", "HeaderedContentControl");
			types[KnownTypes.HeaderedItemsControl] = InitType(assemblies[4], "System.Windows.Controls", "HeaderedItemsControl");
			types[KnownTypes.HierarchicalDataTemplate] = InitType(assemblies[4], "System.Windows", "HierarchicalDataTemplate");
			types[KnownTypes.HostVisual] = InitType(assemblies[3], "System.Windows.Media", "HostVisual");
			types[KnownTypes.Hyperlink] = InitType(assemblies[4], "System.Windows.Documents", "Hyperlink");
			types[KnownTypes.IAddChild] = InitType(assemblies[3], "System.Windows.Markup", "IAddChild");
			types[KnownTypes.IAddChildInternal] = InitType(assemblies[3], "System.Windows.Markup", "IAddChildInternal");
			types[KnownTypes.ICommand] = InitType(assemblies[3], "System.Windows.Input", "ICommand");
			types[KnownTypes.IComponentConnector] = InitType(assemblies[2], "System.Windows.Markup", "IComponentConnector");
			types[KnownTypes.INameScope] = InitType(assemblies[2], "System.Windows.Markup", "INameScope");
			types[KnownTypes.IStyleConnector] = InitType(assemblies[4], "System.Windows.Markup", "IStyleConnector");
			types[KnownTypes.IconBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "IconBitmapDecoder");
			types[KnownTypes.Image] = InitType(assemblies[4], "System.Windows.Controls", "Image");
			types[KnownTypes.ImageBrush] = InitType(assemblies[3], "System.Windows.Media", "ImageBrush");
			types[KnownTypes.ImageDrawing] = InitType(assemblies[3], "System.Windows.Media", "ImageDrawing");
			types[KnownTypes.ImageMetadata] = InitType(assemblies[3], "System.Windows.Media", "ImageMetadata");
			types[KnownTypes.ImageSource] = InitType(assemblies[3], "System.Windows.Media", "ImageSource");
			types[KnownTypes.ImageSourceConverter] = InitType(assemblies[3], "System.Windows.Media", "ImageSourceConverter");
			types[KnownTypes.InPlaceBitmapMetadataWriter] = InitType(assemblies[3], "System.Windows.Media.Imaging", "InPlaceBitmapMetadataWriter");
			types[KnownTypes.InkCanvas] = InitType(assemblies[4], "System.Windows.Controls", "InkCanvas");
			types[KnownTypes.InkPresenter] = InitType(assemblies[4], "System.Windows.Controls", "InkPresenter");
			types[KnownTypes.Inline] = InitType(assemblies[4], "System.Windows.Documents", "Inline");
			types[KnownTypes.InlineCollection] = InitType(assemblies[4], "System.Windows.Documents", "InlineCollection");
			types[KnownTypes.InlineUIContainer] = InitType(assemblies[4], "System.Windows.Documents", "InlineUIContainer");
			types[KnownTypes.InputBinding] = InitType(assemblies[3], "System.Windows.Input", "InputBinding");
			types[KnownTypes.InputDevice] = InitType(assemblies[3], "System.Windows.Input", "InputDevice");
			types[KnownTypes.InputLanguageManager] = InitType(assemblies[3], "System.Windows.Input", "InputLanguageManager");
			types[KnownTypes.InputManager] = InitType(assemblies[3], "System.Windows.Input", "InputManager");
			types[KnownTypes.InputMethod] = InitType(assemblies[3], "System.Windows.Input", "InputMethod");
			types[KnownTypes.InputScope] = InitType(assemblies[3], "System.Windows.Input", "InputScope");
			types[KnownTypes.InputScopeConverter] = InitType(assemblies[3], "System.Windows.Input", "InputScopeConverter");
			types[KnownTypes.InputScopeName] = InitType(assemblies[3], "System.Windows.Input", "InputScopeName");
			types[KnownTypes.InputScopeNameConverter] = InitType(assemblies[3], "System.Windows.Input", "InputScopeNameConverter");
			types[KnownTypes.Int16] = InitType(assemblies[0], "System", "Int16");
			types[KnownTypes.Int16Animation] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int16Animation");
			types[KnownTypes.Int16AnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int16AnimationBase");
			types[KnownTypes.Int16AnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int16AnimationUsingKeyFrames");
			types[KnownTypes.Int16Converter] = InitType(assemblies[1], "System.ComponentModel", "Int16Converter");
			types[KnownTypes.Int16KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int16KeyFrame");
			types[KnownTypes.Int16KeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int16KeyFrameCollection");
			types[KnownTypes.Int32] = InitType(assemblies[0], "System", "Int32");
			types[KnownTypes.Int32Animation] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int32Animation");
			types[KnownTypes.Int32AnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int32AnimationBase");
			types[KnownTypes.Int32AnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int32AnimationUsingKeyFrames");
			types[KnownTypes.Int32Collection] = InitType(assemblies[3], "System.Windows.Media", "Int32Collection");
			types[KnownTypes.Int32CollectionConverter] = InitType(assemblies[3], "System.Windows.Media", "Int32CollectionConverter");
			types[KnownTypes.Int32Converter] = InitType(assemblies[1], "System.ComponentModel", "Int32Converter");
			types[KnownTypes.Int32KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int32KeyFrame");
			types[KnownTypes.Int32KeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int32KeyFrameCollection");
			types[KnownTypes.Int32Rect] = InitType(assemblies[2], "System.Windows", "Int32Rect");
			types[KnownTypes.Int32RectConverter] = InitType(assemblies[2], "System.Windows", "Int32RectConverter");
			types[KnownTypes.Int64] = InitType(assemblies[0], "System", "Int64");
			types[KnownTypes.Int64Animation] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int64Animation");
			types[KnownTypes.Int64AnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int64AnimationBase");
			types[KnownTypes.Int64AnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int64AnimationUsingKeyFrames");
			types[KnownTypes.Int64Converter] = InitType(assemblies[1], "System.ComponentModel", "Int64Converter");
			types[KnownTypes.Int64KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int64KeyFrame");
			types[KnownTypes.Int64KeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "Int64KeyFrameCollection");
			types[KnownTypes.Italic] = InitType(assemblies[4], "System.Windows.Documents", "Italic");
			types[KnownTypes.ItemCollection] = InitType(assemblies[4], "System.Windows.Controls", "ItemCollection");
			types[KnownTypes.ItemsControl] = InitType(assemblies[4], "System.Windows.Controls", "ItemsControl");
			types[KnownTypes.ItemsPanelTemplate] = InitType(assemblies[4], "System.Windows.Controls", "ItemsPanelTemplate");
			types[KnownTypes.ItemsPresenter] = InitType(assemblies[4], "System.Windows.Controls", "ItemsPresenter");
			types[KnownTypes.JournalEntry] = InitType(assemblies[4], "System.Windows.Navigation", "JournalEntry");
			types[KnownTypes.JournalEntryListConverter] = InitType(assemblies[4], "System.Windows.Navigation", "JournalEntryListConverter");
			types[KnownTypes.JournalEntryUnifiedViewConverter] = InitType(assemblies[4], "System.Windows.Navigation", "JournalEntryUnifiedViewConverter");
			types[KnownTypes.JpegBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "JpegBitmapDecoder");
			types[KnownTypes.JpegBitmapEncoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "JpegBitmapEncoder");
			types[KnownTypes.KeyBinding] = InitType(assemblies[3], "System.Windows.Input", "KeyBinding");
			types[KnownTypes.KeyConverter] = InitType(assemblies[2], "System.Windows.Input", "KeyConverter");
			types[KnownTypes.KeyGesture] = InitType(assemblies[3], "System.Windows.Input", "KeyGesture");
			types[KnownTypes.KeyGestureConverter] = InitType(assemblies[3], "System.Windows.Input", "KeyGestureConverter");
			types[KnownTypes.KeySpline] = InitType(assemblies[3], "System.Windows.Media.Animation", "KeySpline");
			types[KnownTypes.KeySplineConverter] = InitType(assemblies[3], "System.Windows", "KeySplineConverter");
			types[KnownTypes.KeyTime] = InitType(assemblies[3], "System.Windows.Media.Animation", "KeyTime");
			types[KnownTypes.KeyTimeConverter] = InitType(assemblies[3], "System.Windows", "KeyTimeConverter");
			types[KnownTypes.KeyboardDevice] = InitType(assemblies[3], "System.Windows.Input", "KeyboardDevice");
			types[KnownTypes.Label] = InitType(assemblies[4], "System.Windows.Controls", "Label");
			types[KnownTypes.LateBoundBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "LateBoundBitmapDecoder");
			types[KnownTypes.LengthConverter] = InitType(assemblies[4], "System.Windows", "LengthConverter");
			types[KnownTypes.Light] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Light");
			types[KnownTypes.Line] = InitType(assemblies[4], "System.Windows.Shapes", "Line");
			types[KnownTypes.LineBreak] = InitType(assemblies[4], "System.Windows.Documents", "LineBreak");
			types[KnownTypes.LineGeometry] = InitType(assemblies[3], "System.Windows.Media", "LineGeometry");
			types[KnownTypes.LineSegment] = InitType(assemblies[3], "System.Windows.Media", "LineSegment");
			types[KnownTypes.LinearByteKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearByteKeyFrame");
			types[KnownTypes.LinearColorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearColorKeyFrame");
			types[KnownTypes.LinearDecimalKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearDecimalKeyFrame");
			types[KnownTypes.LinearDoubleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearDoubleKeyFrame");
			types[KnownTypes.LinearGradientBrush] = InitType(assemblies[3], "System.Windows.Media", "LinearGradientBrush");
			types[KnownTypes.LinearInt16KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearInt16KeyFrame");
			types[KnownTypes.LinearInt32KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearInt32KeyFrame");
			types[KnownTypes.LinearInt64KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearInt64KeyFrame");
			types[KnownTypes.LinearPoint3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearPoint3DKeyFrame");
			types[KnownTypes.LinearPointKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearPointKeyFrame");
			types[KnownTypes.LinearQuaternionKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearQuaternionKeyFrame");
			types[KnownTypes.LinearRectKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearRectKeyFrame");
			types[KnownTypes.LinearRotation3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearRotation3DKeyFrame");
			types[KnownTypes.LinearSingleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearSingleKeyFrame");
			types[KnownTypes.LinearSizeKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearSizeKeyFrame");
			types[KnownTypes.LinearThicknessKeyFrame] = InitType(assemblies[4], "System.Windows.Media.Animation", "LinearThicknessKeyFrame");
			types[KnownTypes.LinearVector3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearVector3DKeyFrame");
			types[KnownTypes.LinearVectorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "LinearVectorKeyFrame");
			types[KnownTypes.List] = InitType(assemblies[4], "System.Windows.Documents", "List");
			types[KnownTypes.ListBox] = InitType(assemblies[4], "System.Windows.Controls", "ListBox");
			types[KnownTypes.ListBoxItem] = InitType(assemblies[4], "System.Windows.Controls", "ListBoxItem");
			types[KnownTypes.ListCollectionView] = InitType(assemblies[4], "System.Windows.Data", "ListCollectionView");
			types[KnownTypes.ListItem] = InitType(assemblies[4], "System.Windows.Documents", "ListItem");
			types[KnownTypes.ListView] = InitType(assemblies[4], "System.Windows.Controls", "ListView");
			types[KnownTypes.ListViewItem] = InitType(assemblies[4], "System.Windows.Controls", "ListViewItem");
			types[KnownTypes.Localization] = InitType(assemblies[4], "System.Windows", "Localization");
			types[KnownTypes.LostFocusEventManager] = InitType(assemblies[4], "System.Windows", "LostFocusEventManager");
			types[KnownTypes.MarkupExtension] = InitType(assemblies[2], "System.Windows.Markup", "MarkupExtension");
			types[KnownTypes.Material] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Material");
			types[KnownTypes.MaterialCollection] = InitType(assemblies[3], "System.Windows.Media.Media3D", "MaterialCollection");
			types[KnownTypes.MaterialGroup] = InitType(assemblies[3], "System.Windows.Media.Media3D", "MaterialGroup");
			types[KnownTypes.Matrix] = InitType(assemblies[2], "System.Windows.Media", "Matrix");
			types[KnownTypes.Matrix3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Matrix3D");
			types[KnownTypes.Matrix3DConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Matrix3DConverter");
			types[KnownTypes.MatrixAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "MatrixAnimationBase");
			types[KnownTypes.MatrixAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "MatrixAnimationUsingKeyFrames");
			types[KnownTypes.MatrixAnimationUsingPath] = InitType(assemblies[3], "System.Windows.Media.Animation", "MatrixAnimationUsingPath");
			types[KnownTypes.MatrixCamera] = InitType(assemblies[3], "System.Windows.Media.Media3D", "MatrixCamera");
			types[KnownTypes.MatrixConverter] = InitType(assemblies[2], "System.Windows.Media", "MatrixConverter");
			types[KnownTypes.MatrixKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "MatrixKeyFrame");
			types[KnownTypes.MatrixKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "MatrixKeyFrameCollection");
			types[KnownTypes.MatrixTransform] = InitType(assemblies[3], "System.Windows.Media", "MatrixTransform");
			types[KnownTypes.MatrixTransform3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "MatrixTransform3D");
			types[KnownTypes.MediaClock] = InitType(assemblies[3], "System.Windows.Media", "MediaClock");
			types[KnownTypes.MediaElement] = InitType(assemblies[4], "System.Windows.Controls", "MediaElement");
			types[KnownTypes.MediaPlayer] = InitType(assemblies[3], "System.Windows.Media", "MediaPlayer");
			types[KnownTypes.MediaTimeline] = InitType(assemblies[3], "System.Windows.Media", "MediaTimeline");
			types[KnownTypes.Menu] = InitType(assemblies[4], "System.Windows.Controls", "Menu");
			types[KnownTypes.MenuBase] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "MenuBase");
			types[KnownTypes.MenuItem] = InitType(assemblies[4], "System.Windows.Controls", "MenuItem");
			types[KnownTypes.MenuScrollingVisibilityConverter] = InitType(assemblies[4], "System.Windows.Controls", "MenuScrollingVisibilityConverter");
			types[KnownTypes.MeshGeometry3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "MeshGeometry3D");
			types[KnownTypes.Model3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Model3D");
			types[KnownTypes.Model3DCollection] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Model3DCollection");
			types[KnownTypes.Model3DGroup] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Model3DGroup");
			types[KnownTypes.ModelVisual3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "ModelVisual3D");
			types[KnownTypes.ModifierKeysConverter] = InitType(assemblies[2], "System.Windows.Input", "ModifierKeysConverter");
			types[KnownTypes.MouseActionConverter] = InitType(assemblies[3], "System.Windows.Input", "MouseActionConverter");
			types[KnownTypes.MouseBinding] = InitType(assemblies[3], "System.Windows.Input", "MouseBinding");
			types[KnownTypes.MouseDevice] = InitType(assemblies[3], "System.Windows.Input", "MouseDevice");
			types[KnownTypes.MouseGesture] = InitType(assemblies[3], "System.Windows.Input", "MouseGesture");
			types[KnownTypes.MouseGestureConverter] = InitType(assemblies[3], "System.Windows.Input", "MouseGestureConverter");
			types[KnownTypes.MultiBinding] = InitType(assemblies[4], "System.Windows.Data", "MultiBinding");
			types[KnownTypes.MultiBindingExpression] = InitType(assemblies[4], "System.Windows.Data", "MultiBindingExpression");
			types[KnownTypes.MultiDataTrigger] = InitType(assemblies[4], "System.Windows", "MultiDataTrigger");
			types[KnownTypes.MultiTrigger] = InitType(assemblies[4], "System.Windows", "MultiTrigger");
			types[KnownTypes.NameScope] = InitType(assemblies[4], "System.Windows", "NameScope");
			types[KnownTypes.NavigationWindow] = InitType(assemblies[4], "System.Windows.Navigation", "NavigationWindow");
			types[KnownTypes.NullExtension] = InitType(assemblies[4], "System.Windows.Markup", "NullExtension");
			types[KnownTypes.NullableBoolConverter] = InitType(assemblies[4], "System.Windows", "NullableBoolConverter");
			types[KnownTypes.NullableConverter] = InitType(assemblies[1], "System.ComponentModel", "NullableConverter");
			types[KnownTypes.NumberSubstitution] = InitType(assemblies[3], "System.Windows.Media", "NumberSubstitution");
			types[KnownTypes.Object] = InitType(assemblies[0], "System", "Object");
			types[KnownTypes.ObjectAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "ObjectAnimationBase");
			types[KnownTypes.ObjectAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "ObjectAnimationUsingKeyFrames");
			types[KnownTypes.ObjectDataProvider] = InitType(assemblies[4], "System.Windows.Data", "ObjectDataProvider");
			types[KnownTypes.ObjectKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "ObjectKeyFrame");
			types[KnownTypes.ObjectKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "ObjectKeyFrameCollection");
			types[KnownTypes.OrthographicCamera] = InitType(assemblies[3], "System.Windows.Media.Media3D", "OrthographicCamera");
			types[KnownTypes.OuterGlowBitmapEffect] = InitType(assemblies[3], "System.Windows.Media.Effects", "OuterGlowBitmapEffect");
			types[KnownTypes.Page] = InitType(assemblies[4], "System.Windows.Controls", "Page");
			types[KnownTypes.PageContent] = InitType(assemblies[4], "System.Windows.Documents", "PageContent");
			types[KnownTypes.PageFunctionBase] = InitType(assemblies[4], "System.Windows.Navigation", "PageFunctionBase");
			types[KnownTypes.Panel] = InitType(assemblies[4], "System.Windows.Controls", "Panel");
			types[KnownTypes.Paragraph] = InitType(assemblies[4], "System.Windows.Documents", "Paragraph");
			types[KnownTypes.ParallelTimeline] = InitType(assemblies[3], "System.Windows.Media.Animation", "ParallelTimeline");
			types[KnownTypes.ParserContext] = InitType(assemblies[4], "System.Windows.Markup", "ParserContext");
			types[KnownTypes.PasswordBox] = InitType(assemblies[4], "System.Windows.Controls", "PasswordBox");
			types[KnownTypes.Path] = InitType(assemblies[4], "System.Windows.Shapes", "Path");
			types[KnownTypes.PathFigure] = InitType(assemblies[3], "System.Windows.Media", "PathFigure");
			types[KnownTypes.PathFigureCollection] = InitType(assemblies[3], "System.Windows.Media", "PathFigureCollection");
			types[KnownTypes.PathFigureCollectionConverter] = InitType(assemblies[3], "System.Windows.Media", "PathFigureCollectionConverter");
			types[KnownTypes.PathGeometry] = InitType(assemblies[3], "System.Windows.Media", "PathGeometry");
			types[KnownTypes.PathSegment] = InitType(assemblies[3], "System.Windows.Media", "PathSegment");
			types[KnownTypes.PathSegmentCollection] = InitType(assemblies[3], "System.Windows.Media", "PathSegmentCollection");
			types[KnownTypes.PauseStoryboard] = InitType(assemblies[4], "System.Windows.Media.Animation", "PauseStoryboard");
			types[KnownTypes.Pen] = InitType(assemblies[3], "System.Windows.Media", "Pen");
			types[KnownTypes.PerspectiveCamera] = InitType(assemblies[3], "System.Windows.Media.Media3D", "PerspectiveCamera");
			types[KnownTypes.PixelFormat] = InitType(assemblies[3], "System.Windows.Media", "PixelFormat");
			types[KnownTypes.PixelFormatConverter] = InitType(assemblies[3], "System.Windows.Media", "PixelFormatConverter");
			types[KnownTypes.PngBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "PngBitmapDecoder");
			types[KnownTypes.PngBitmapEncoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "PngBitmapEncoder");
			types[KnownTypes.Point] = InitType(assemblies[2], "System.Windows", "Point");
			types[KnownTypes.Point3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Point3D");
			types[KnownTypes.Point3DAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "Point3DAnimation");
			types[KnownTypes.Point3DAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "Point3DAnimationBase");
			types[KnownTypes.Point3DAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "Point3DAnimationUsingKeyFrames");
			types[KnownTypes.Point3DCollection] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Point3DCollection");
			types[KnownTypes.Point3DCollectionConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Point3DCollectionConverter");
			types[KnownTypes.Point3DConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Point3DConverter");
			types[KnownTypes.Point3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "Point3DKeyFrame");
			types[KnownTypes.Point3DKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "Point3DKeyFrameCollection");
			types[KnownTypes.Point4D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Point4D");
			types[KnownTypes.Point4DConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Point4DConverter");
			types[KnownTypes.PointAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "PointAnimation");
			types[KnownTypes.PointAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "PointAnimationBase");
			types[KnownTypes.PointAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "PointAnimationUsingKeyFrames");
			types[KnownTypes.PointAnimationUsingPath] = InitType(assemblies[3], "System.Windows.Media.Animation", "PointAnimationUsingPath");
			types[KnownTypes.PointCollection] = InitType(assemblies[3], "System.Windows.Media", "PointCollection");
			types[KnownTypes.PointCollectionConverter] = InitType(assemblies[3], "System.Windows.Media", "PointCollectionConverter");
			types[KnownTypes.PointConverter] = InitType(assemblies[2], "System.Windows", "PointConverter");
			types[KnownTypes.PointIListConverter] = InitType(assemblies[3], "System.Windows.Media.Converters", "PointIListConverter");
			types[KnownTypes.PointKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "PointKeyFrame");
			types[KnownTypes.PointKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "PointKeyFrameCollection");
			types[KnownTypes.PointLight] = InitType(assemblies[3], "System.Windows.Media.Media3D", "PointLight");
			types[KnownTypes.PointLightBase] = InitType(assemblies[3], "System.Windows.Media.Media3D", "PointLightBase");
			types[KnownTypes.PolyBezierSegment] = InitType(assemblies[3], "System.Windows.Media", "PolyBezierSegment");
			types[KnownTypes.PolyLineSegment] = InitType(assemblies[3], "System.Windows.Media", "PolyLineSegment");
			types[KnownTypes.PolyQuadraticBezierSegment] = InitType(assemblies[3], "System.Windows.Media", "PolyQuadraticBezierSegment");
			types[KnownTypes.Polygon] = InitType(assemblies[4], "System.Windows.Shapes", "Polygon");
			types[KnownTypes.Polyline] = InitType(assemblies[4], "System.Windows.Shapes", "Polyline");
			types[KnownTypes.Popup] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "Popup");
			types[KnownTypes.PresentationSource] = InitType(assemblies[3], "System.Windows", "PresentationSource");
			types[KnownTypes.PriorityBinding] = InitType(assemblies[4], "System.Windows.Data", "PriorityBinding");
			types[KnownTypes.PriorityBindingExpression] = InitType(assemblies[4], "System.Windows.Data", "PriorityBindingExpression");
			types[KnownTypes.ProgressBar] = InitType(assemblies[4], "System.Windows.Controls", "ProgressBar");
			types[KnownTypes.ProjectionCamera] = InitType(assemblies[3], "System.Windows.Media.Media3D", "ProjectionCamera");
			types[KnownTypes.PropertyPath] = InitType(assemblies[4], "System.Windows", "PropertyPath");
			types[KnownTypes.PropertyPathConverter] = InitType(assemblies[4], "System.Windows", "PropertyPathConverter");
			types[KnownTypes.QuadraticBezierSegment] = InitType(assemblies[3], "System.Windows.Media", "QuadraticBezierSegment");
			types[KnownTypes.Quaternion] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Quaternion");
			types[KnownTypes.QuaternionAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "QuaternionAnimation");
			types[KnownTypes.QuaternionAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "QuaternionAnimationBase");
			types[KnownTypes.QuaternionAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "QuaternionAnimationUsingKeyFrames");
			types[KnownTypes.QuaternionConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "QuaternionConverter");
			types[KnownTypes.QuaternionKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "QuaternionKeyFrame");
			types[KnownTypes.QuaternionKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "QuaternionKeyFrameCollection");
			types[KnownTypes.QuaternionRotation3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "QuaternionRotation3D");
			types[KnownTypes.RadialGradientBrush] = InitType(assemblies[3], "System.Windows.Media", "RadialGradientBrush");
			types[KnownTypes.RadioButton] = InitType(assemblies[4], "System.Windows.Controls", "RadioButton");
			types[KnownTypes.RangeBase] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "RangeBase");
			types[KnownTypes.Rect] = InitType(assemblies[2], "System.Windows", "Rect");
			types[KnownTypes.Rect3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Rect3D");
			types[KnownTypes.Rect3DConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Rect3DConverter");
			types[KnownTypes.RectAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "RectAnimation");
			types[KnownTypes.RectAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "RectAnimationBase");
			types[KnownTypes.RectAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "RectAnimationUsingKeyFrames");
			types[KnownTypes.RectConverter] = InitType(assemblies[2], "System.Windows", "RectConverter");
			types[KnownTypes.RectKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "RectKeyFrame");
			types[KnownTypes.RectKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "RectKeyFrameCollection");
			types[KnownTypes.Rectangle] = InitType(assemblies[4], "System.Windows.Shapes", "Rectangle");
			types[KnownTypes.RectangleGeometry] = InitType(assemblies[3], "System.Windows.Media", "RectangleGeometry");
			types[KnownTypes.RelativeSource] = InitType(assemblies[4], "System.Windows.Data", "RelativeSource");
			types[KnownTypes.RemoveStoryboard] = InitType(assemblies[4], "System.Windows.Media.Animation", "RemoveStoryboard");
			types[KnownTypes.RenderOptions] = InitType(assemblies[3], "System.Windows.Media", "RenderOptions");
			types[KnownTypes.RenderTargetBitmap] = InitType(assemblies[3], "System.Windows.Media.Imaging", "RenderTargetBitmap");
			types[KnownTypes.RepeatBehavior] = InitType(assemblies[3], "System.Windows.Media.Animation", "RepeatBehavior");
			types[KnownTypes.RepeatBehaviorConverter] = InitType(assemblies[3], "System.Windows.Media.Animation", "RepeatBehaviorConverter");
			types[KnownTypes.RepeatButton] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "RepeatButton");
			types[KnownTypes.ResizeGrip] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "ResizeGrip");
			types[KnownTypes.ResourceDictionary] = InitType(assemblies[4], "System.Windows", "ResourceDictionary");
			types[KnownTypes.ResourceKey] = InitType(assemblies[4], "System.Windows", "ResourceKey");
			types[KnownTypes.ResumeStoryboard] = InitType(assemblies[4], "System.Windows.Media.Animation", "ResumeStoryboard");
			types[KnownTypes.RichTextBox] = InitType(assemblies[4], "System.Windows.Controls", "RichTextBox");
			types[KnownTypes.RotateTransform] = InitType(assemblies[3], "System.Windows.Media", "RotateTransform");
			types[KnownTypes.RotateTransform3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "RotateTransform3D");
			types[KnownTypes.Rotation3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Rotation3D");
			types[KnownTypes.Rotation3DAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "Rotation3DAnimation");
			types[KnownTypes.Rotation3DAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "Rotation3DAnimationBase");
			types[KnownTypes.Rotation3DAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "Rotation3DAnimationUsingKeyFrames");
			types[KnownTypes.Rotation3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "Rotation3DKeyFrame");
			types[KnownTypes.Rotation3DKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "Rotation3DKeyFrameCollection");
			types[KnownTypes.RoutedCommand] = InitType(assemblies[3], "System.Windows.Input", "RoutedCommand");
			types[KnownTypes.RoutedEvent] = InitType(assemblies[3], "System.Windows", "RoutedEvent");
			types[KnownTypes.RoutedEventConverter] = InitType(assemblies[4], "System.Windows.Markup", "RoutedEventConverter");
			types[KnownTypes.RoutedUICommand] = InitType(assemblies[3], "System.Windows.Input", "RoutedUICommand");
			types[KnownTypes.RoutingStrategy] = InitType(assemblies[3], "System.Windows", "RoutingStrategy");
			types[KnownTypes.RowDefinition] = InitType(assemblies[4], "System.Windows.Controls", "RowDefinition");
			types[KnownTypes.Run] = InitType(assemblies[4], "System.Windows.Documents", "Run");
			types[KnownTypes.RuntimeNamePropertyAttribute] = InitType(assemblies[2], "System.Windows.Markup", "RuntimeNamePropertyAttribute");
			types[KnownTypes.SByte] = InitType(assemblies[0], "System", "SByte");
			types[KnownTypes.SByteConverter] = InitType(assemblies[1], "System.ComponentModel", "SByteConverter");
			types[KnownTypes.ScaleTransform] = InitType(assemblies[3], "System.Windows.Media", "ScaleTransform");
			types[KnownTypes.ScaleTransform3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "ScaleTransform3D");
			types[KnownTypes.ScrollBar] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "ScrollBar");
			types[KnownTypes.ScrollContentPresenter] = InitType(assemblies[4], "System.Windows.Controls", "ScrollContentPresenter");
			types[KnownTypes.ScrollViewer] = InitType(assemblies[4], "System.Windows.Controls", "ScrollViewer");
			types[KnownTypes.Section] = InitType(assemblies[4], "System.Windows.Documents", "Section");
			types[KnownTypes.SeekStoryboard] = InitType(assemblies[4], "System.Windows.Media.Animation", "SeekStoryboard");
			types[KnownTypes.Selector] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "Selector");
			types[KnownTypes.Separator] = InitType(assemblies[4], "System.Windows.Controls", "Separator");
			types[KnownTypes.SetStoryboardSpeedRatio] = InitType(assemblies[4], "System.Windows.Media.Animation", "SetStoryboardSpeedRatio");
			types[KnownTypes.Setter] = InitType(assemblies[4], "System.Windows", "Setter");
			types[KnownTypes.SetterBase] = InitType(assemblies[4], "System.Windows", "SetterBase");
			types[KnownTypes.Shape] = InitType(assemblies[4], "System.Windows.Shapes", "Shape");
			types[KnownTypes.Single] = InitType(assemblies[0], "System", "Single");
			types[KnownTypes.SingleAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "SingleAnimation");
			types[KnownTypes.SingleAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "SingleAnimationBase");
			types[KnownTypes.SingleAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "SingleAnimationUsingKeyFrames");
			types[KnownTypes.SingleConverter] = InitType(assemblies[1], "System.ComponentModel", "SingleConverter");
			types[KnownTypes.SingleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SingleKeyFrame");
			types[KnownTypes.SingleKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "SingleKeyFrameCollection");
			types[KnownTypes.Size] = InitType(assemblies[2], "System.Windows", "Size");
			types[KnownTypes.Size3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Size3D");
			types[KnownTypes.Size3DConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Size3DConverter");
			types[KnownTypes.SizeAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "SizeAnimation");
			types[KnownTypes.SizeAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "SizeAnimationBase");
			types[KnownTypes.SizeAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "SizeAnimationUsingKeyFrames");
			types[KnownTypes.SizeConverter] = InitType(assemblies[2], "System.Windows", "SizeConverter");
			types[KnownTypes.SizeKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SizeKeyFrame");
			types[KnownTypes.SizeKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "SizeKeyFrameCollection");
			types[KnownTypes.SkewTransform] = InitType(assemblies[3], "System.Windows.Media", "SkewTransform");
			types[KnownTypes.SkipStoryboardToFill] = InitType(assemblies[4], "System.Windows.Media.Animation", "SkipStoryboardToFill");
			types[KnownTypes.Slider] = InitType(assemblies[4], "System.Windows.Controls", "Slider");
			types[KnownTypes.SolidColorBrush] = InitType(assemblies[3], "System.Windows.Media", "SolidColorBrush");
			types[KnownTypes.SoundPlayerAction] = InitType(assemblies[4], "System.Windows.Controls", "SoundPlayerAction");
			types[KnownTypes.Span] = InitType(assemblies[4], "System.Windows.Documents", "Span");
			types[KnownTypes.SpecularMaterial] = InitType(assemblies[3], "System.Windows.Media.Media3D", "SpecularMaterial");
			types[KnownTypes.SpellCheck] = InitType(assemblies[4], "System.Windows.Controls", "SpellCheck");
			types[KnownTypes.SplineByteKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineByteKeyFrame");
			types[KnownTypes.SplineColorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineColorKeyFrame");
			types[KnownTypes.SplineDecimalKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineDecimalKeyFrame");
			types[KnownTypes.SplineDoubleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineDoubleKeyFrame");
			types[KnownTypes.SplineInt16KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineInt16KeyFrame");
			types[KnownTypes.SplineInt32KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineInt32KeyFrame");
			types[KnownTypes.SplineInt64KeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineInt64KeyFrame");
			types[KnownTypes.SplinePoint3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplinePoint3DKeyFrame");
			types[KnownTypes.SplinePointKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplinePointKeyFrame");
			types[KnownTypes.SplineQuaternionKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineQuaternionKeyFrame");
			types[KnownTypes.SplineRectKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineRectKeyFrame");
			types[KnownTypes.SplineRotation3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineRotation3DKeyFrame");
			types[KnownTypes.SplineSingleKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineSingleKeyFrame");
			types[KnownTypes.SplineSizeKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineSizeKeyFrame");
			types[KnownTypes.SplineThicknessKeyFrame] = InitType(assemblies[4], "System.Windows.Media.Animation", "SplineThicknessKeyFrame");
			types[KnownTypes.SplineVector3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineVector3DKeyFrame");
			types[KnownTypes.SplineVectorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "SplineVectorKeyFrame");
			types[KnownTypes.SpotLight] = InitType(assemblies[3], "System.Windows.Media.Media3D", "SpotLight");
			types[KnownTypes.StackPanel] = InitType(assemblies[4], "System.Windows.Controls", "StackPanel");
			types[KnownTypes.StaticExtension] = InitType(assemblies[4], "System.Windows.Markup", "StaticExtension");
			types[KnownTypes.StaticResourceExtension] = InitType(assemblies[4], "System.Windows", "StaticResourceExtension");
			types[KnownTypes.StatusBar] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "StatusBar");
			types[KnownTypes.StatusBarItem] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "StatusBarItem");
			types[KnownTypes.StickyNoteControl] = InitType(assemblies[4], "System.Windows.Controls", "StickyNoteControl");
			types[KnownTypes.StopStoryboard] = InitType(assemblies[4], "System.Windows.Media.Animation", "StopStoryboard");
			types[KnownTypes.Storyboard] = InitType(assemblies[4], "System.Windows.Media.Animation", "Storyboard");
			types[KnownTypes.StreamGeometry] = InitType(assemblies[3], "System.Windows.Media", "StreamGeometry");
			types[KnownTypes.StreamGeometryContext] = InitType(assemblies[3], "System.Windows.Media", "StreamGeometryContext");
			types[KnownTypes.StreamResourceInfo] = InitType(assemblies[4], "System.Windows.Resources", "StreamResourceInfo");
			types[KnownTypes.String] = InitType(assemblies[0], "System", "String");
			types[KnownTypes.StringAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "StringAnimationBase");
			types[KnownTypes.StringAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "StringAnimationUsingKeyFrames");
			types[KnownTypes.StringConverter] = InitType(assemblies[1], "System.ComponentModel", "StringConverter");
			types[KnownTypes.StringKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "StringKeyFrame");
			types[KnownTypes.StringKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "StringKeyFrameCollection");
			types[KnownTypes.StrokeCollection] = InitType(assemblies[3], "System.Windows.Ink", "StrokeCollection");
			types[KnownTypes.StrokeCollectionConverter] = InitType(assemblies[3], "System.Windows", "StrokeCollectionConverter");
			types[KnownTypes.Style] = InitType(assemblies[4], "System.Windows", "Style");
			types[KnownTypes.Stylus] = InitType(assemblies[3], "System.Windows.Input", "Stylus");
			types[KnownTypes.StylusDevice] = InitType(assemblies[3], "System.Windows.Input", "StylusDevice");
			types[KnownTypes.TabControl] = InitType(assemblies[4], "System.Windows.Controls", "TabControl");
			types[KnownTypes.TabItem] = InitType(assemblies[4], "System.Windows.Controls", "TabItem");
			types[KnownTypes.TabPanel] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "TabPanel");
			types[KnownTypes.Table] = InitType(assemblies[4], "System.Windows.Documents", "Table");
			types[KnownTypes.TableCell] = InitType(assemblies[4], "System.Windows.Documents", "TableCell");
			types[KnownTypes.TableColumn] = InitType(assemblies[4], "System.Windows.Documents", "TableColumn");
			types[KnownTypes.TableRow] = InitType(assemblies[4], "System.Windows.Documents", "TableRow");
			types[KnownTypes.TableRowGroup] = InitType(assemblies[4], "System.Windows.Documents", "TableRowGroup");
			types[KnownTypes.TabletDevice] = InitType(assemblies[3], "System.Windows.Input", "TabletDevice");
			types[KnownTypes.TemplateBindingExpression] = InitType(assemblies[4], "System.Windows", "TemplateBindingExpression");
			types[KnownTypes.TemplateBindingExpressionConverter] = InitType(assemblies[4], "System.Windows", "TemplateBindingExpressionConverter");
			types[KnownTypes.TemplateBindingExtension] = InitType(assemblies[4], "System.Windows", "TemplateBindingExtension");
			types[KnownTypes.TemplateBindingExtensionConverter] = InitType(assemblies[4], "System.Windows", "TemplateBindingExtensionConverter");
			types[KnownTypes.TemplateKey] = InitType(assemblies[4], "System.Windows", "TemplateKey");
			types[KnownTypes.TemplateKeyConverter] = InitType(assemblies[4], "System.Windows.Markup", "TemplateKeyConverter");
			types[KnownTypes.TextBlock] = InitType(assemblies[4], "System.Windows.Controls", "TextBlock");
			types[KnownTypes.TextBox] = InitType(assemblies[4], "System.Windows.Controls", "TextBox");
			types[KnownTypes.TextBoxBase] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "TextBoxBase");
			types[KnownTypes.TextComposition] = InitType(assemblies[3], "System.Windows.Input", "TextComposition");
			types[KnownTypes.TextCompositionManager] = InitType(assemblies[3], "System.Windows.Input", "TextCompositionManager");
			types[KnownTypes.TextDecoration] = InitType(assemblies[3], "System.Windows", "TextDecoration");
			types[KnownTypes.TextDecorationCollection] = InitType(assemblies[3], "System.Windows", "TextDecorationCollection");
			types[KnownTypes.TextDecorationCollectionConverter] = InitType(assemblies[3], "System.Windows", "TextDecorationCollectionConverter");
			types[KnownTypes.TextEffect] = InitType(assemblies[3], "System.Windows.Media", "TextEffect");
			types[KnownTypes.TextEffectCollection] = InitType(assemblies[3], "System.Windows.Media", "TextEffectCollection");
			types[KnownTypes.TextElement] = InitType(assemblies[4], "System.Windows.Documents", "TextElement");
			types[KnownTypes.TextSearch] = InitType(assemblies[4], "System.Windows.Controls", "TextSearch");
			types[KnownTypes.ThemeDictionaryExtension] = InitType(assemblies[4], "System.Windows", "ThemeDictionaryExtension");
			types[KnownTypes.Thickness] = InitType(assemblies[4], "System.Windows", "Thickness");
			types[KnownTypes.ThicknessAnimation] = InitType(assemblies[4], "System.Windows.Media.Animation", "ThicknessAnimation");
			types[KnownTypes.ThicknessAnimationBase] = InitType(assemblies[4], "System.Windows.Media.Animation", "ThicknessAnimationBase");
			types[KnownTypes.ThicknessAnimationUsingKeyFrames] = InitType(assemblies[4], "System.Windows.Media.Animation", "ThicknessAnimationUsingKeyFrames");
			types[KnownTypes.ThicknessConverter] = InitType(assemblies[4], "System.Windows", "ThicknessConverter");
			types[KnownTypes.ThicknessKeyFrame] = InitType(assemblies[4], "System.Windows.Media.Animation", "ThicknessKeyFrame");
			types[KnownTypes.ThicknessKeyFrameCollection] = InitType(assemblies[4], "System.Windows.Media.Animation", "ThicknessKeyFrameCollection");
			types[KnownTypes.Thumb] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "Thumb");
			types[KnownTypes.TickBar] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "TickBar");
			types[KnownTypes.TiffBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "TiffBitmapDecoder");
			types[KnownTypes.TiffBitmapEncoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "TiffBitmapEncoder");
			types[KnownTypes.TileBrush] = InitType(assemblies[3], "System.Windows.Media", "TileBrush");
			types[KnownTypes.TimeSpan] = InitType(assemblies[0], "System", "TimeSpan");
			types[KnownTypes.TimeSpanConverter] = InitType(assemblies[1], "System.ComponentModel", "TimeSpanConverter");
			types[KnownTypes.Timeline] = InitType(assemblies[3], "System.Windows.Media.Animation", "Timeline");
			types[KnownTypes.TimelineCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "TimelineCollection");
			types[KnownTypes.TimelineGroup] = InitType(assemblies[3], "System.Windows.Media.Animation", "TimelineGroup");
			types[KnownTypes.ToggleButton] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "ToggleButton");
			types[KnownTypes.ToolBar] = InitType(assemblies[4], "System.Windows.Controls", "ToolBar");
			types[KnownTypes.ToolBarOverflowPanel] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "ToolBarOverflowPanel");
			types[KnownTypes.ToolBarPanel] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "ToolBarPanel");
			types[KnownTypes.ToolBarTray] = InitType(assemblies[4], "System.Windows.Controls", "ToolBarTray");
			types[KnownTypes.ToolTip] = InitType(assemblies[4], "System.Windows.Controls", "ToolTip");
			types[KnownTypes.ToolTipService] = InitType(assemblies[4], "System.Windows.Controls", "ToolTipService");
			types[KnownTypes.Track] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "Track");
			types[KnownTypes.Transform] = InitType(assemblies[3], "System.Windows.Media", "Transform");
			types[KnownTypes.Transform3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Transform3D");
			types[KnownTypes.Transform3DCollection] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Transform3DCollection");
			types[KnownTypes.Transform3DGroup] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Transform3DGroup");
			types[KnownTypes.TransformCollection] = InitType(assemblies[3], "System.Windows.Media", "TransformCollection");
			types[KnownTypes.TransformConverter] = InitType(assemblies[3], "System.Windows.Media", "TransformConverter");
			types[KnownTypes.TransformGroup] = InitType(assemblies[3], "System.Windows.Media", "TransformGroup");
			types[KnownTypes.TransformedBitmap] = InitType(assemblies[3], "System.Windows.Media.Imaging", "TransformedBitmap");
			types[KnownTypes.TranslateTransform] = InitType(assemblies[3], "System.Windows.Media", "TranslateTransform");
			types[KnownTypes.TranslateTransform3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "TranslateTransform3D");
			types[KnownTypes.TreeView] = InitType(assemblies[4], "System.Windows.Controls", "TreeView");
			types[KnownTypes.TreeViewItem] = InitType(assemblies[4], "System.Windows.Controls", "TreeViewItem");
			types[KnownTypes.Trigger] = InitType(assemblies[4], "System.Windows", "Trigger");
			types[KnownTypes.TriggerAction] = InitType(assemblies[4], "System.Windows", "TriggerAction");
			types[KnownTypes.TriggerBase] = InitType(assemblies[4], "System.Windows", "TriggerBase");
			types[KnownTypes.TypeExtension] = InitType(assemblies[4], "System.Windows.Markup", "TypeExtension");
			types[KnownTypes.TypeTypeConverter] = InitType(assemblies[2], "System.Windows.Markup", "TypeTypeConverter");
			types[KnownTypes.Typography] = InitType(assemblies[4], "System.Windows.Documents", "Typography");
			types[KnownTypes.UIElement] = InitType(assemblies[3], "System.Windows", "UIElement");
			types[KnownTypes.UInt16] = InitType(assemblies[0], "System", "UInt16");
			types[KnownTypes.UInt16Converter] = InitType(assemblies[1], "System.ComponentModel", "UInt16Converter");
			types[KnownTypes.UInt32] = InitType(assemblies[0], "System", "UInt32");
			types[KnownTypes.UInt32Converter] = InitType(assemblies[1], "System.ComponentModel", "UInt32Converter");
			types[KnownTypes.UInt64] = InitType(assemblies[0], "System", "UInt64");
			types[KnownTypes.UInt64Converter] = InitType(assemblies[1], "System.ComponentModel", "UInt64Converter");
			types[KnownTypes.UShortIListConverter] = InitType(assemblies[3], "System.Windows.Media.Converters", "UShortIListConverter");
			types[KnownTypes.Underline] = InitType(assemblies[4], "System.Windows.Documents", "Underline");
			types[KnownTypes.UniformGrid] = InitType(assemblies[4], "System.Windows.Controls.Primitives", "UniformGrid");
			types[KnownTypes.Uri] = InitType(assemblies[1], "System", "Uri");
			types[KnownTypes.UriTypeConverter] = InitType(assemblies[1], "System", "UriTypeConverter");
			types[KnownTypes.UserControl] = InitType(assemblies[4], "System.Windows.Controls", "UserControl");
			types[KnownTypes.Validation] = InitType(assemblies[4], "System.Windows.Controls", "Validation");
			types[KnownTypes.Vector] = InitType(assemblies[2], "System.Windows", "Vector");
			types[KnownTypes.Vector3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Vector3D");
			types[KnownTypes.Vector3DAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "Vector3DAnimation");
			types[KnownTypes.Vector3DAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "Vector3DAnimationBase");
			types[KnownTypes.Vector3DAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "Vector3DAnimationUsingKeyFrames");
			types[KnownTypes.Vector3DCollection] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Vector3DCollection");
			types[KnownTypes.Vector3DCollectionConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Vector3DCollectionConverter");
			types[KnownTypes.Vector3DConverter] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Vector3DConverter");
			types[KnownTypes.Vector3DKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "Vector3DKeyFrame");
			types[KnownTypes.Vector3DKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "Vector3DKeyFrameCollection");
			types[KnownTypes.VectorAnimation] = InitType(assemblies[3], "System.Windows.Media.Animation", "VectorAnimation");
			types[KnownTypes.VectorAnimationBase] = InitType(assemblies[3], "System.Windows.Media.Animation", "VectorAnimationBase");
			types[KnownTypes.VectorAnimationUsingKeyFrames] = InitType(assemblies[3], "System.Windows.Media.Animation", "VectorAnimationUsingKeyFrames");
			types[KnownTypes.VectorCollection] = InitType(assemblies[3], "System.Windows.Media", "VectorCollection");
			types[KnownTypes.VectorCollectionConverter] = InitType(assemblies[3], "System.Windows.Media", "VectorCollectionConverter");
			types[KnownTypes.VectorConverter] = InitType(assemblies[2], "System.Windows", "VectorConverter");
			types[KnownTypes.VectorKeyFrame] = InitType(assemblies[3], "System.Windows.Media.Animation", "VectorKeyFrame");
			types[KnownTypes.VectorKeyFrameCollection] = InitType(assemblies[3], "System.Windows.Media.Animation", "VectorKeyFrameCollection");
			types[KnownTypes.VideoDrawing] = InitType(assemblies[3], "System.Windows.Media", "VideoDrawing");
			types[KnownTypes.ViewBase] = InitType(assemblies[4], "System.Windows.Controls", "ViewBase");
			types[KnownTypes.Viewbox] = InitType(assemblies[4], "System.Windows.Controls", "Viewbox");
			types[KnownTypes.Viewport3D] = InitType(assemblies[4], "System.Windows.Controls", "Viewport3D");
			types[KnownTypes.Viewport3DVisual] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Viewport3DVisual");
			types[KnownTypes.VirtualizingPanel] = InitType(assemblies[4], "System.Windows.Controls", "VirtualizingPanel");
			types[KnownTypes.VirtualizingStackPanel] = InitType(assemblies[4], "System.Windows.Controls", "VirtualizingStackPanel");
			types[KnownTypes.Visual] = InitType(assemblies[3], "System.Windows.Media", "Visual");
			types[KnownTypes.Visual3D] = InitType(assemblies[3], "System.Windows.Media.Media3D", "Visual3D");
			types[KnownTypes.VisualBrush] = InitType(assemblies[3], "System.Windows.Media", "VisualBrush");
			types[KnownTypes.VisualTarget] = InitType(assemblies[3], "System.Windows.Media", "VisualTarget");
			types[KnownTypes.WeakEventManager] = InitType(assemblies[2], "System.Windows", "WeakEventManager");
			types[KnownTypes.WhitespaceSignificantCollectionAttribute] = InitType(assemblies[2], "System.Windows.Markup", "WhitespaceSignificantCollectionAttribute");
			types[KnownTypes.Window] = InitType(assemblies[4], "System.Windows", "Window");
			types[KnownTypes.WmpBitmapDecoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "WmpBitmapDecoder");
			types[KnownTypes.WmpBitmapEncoder] = InitType(assemblies[3], "System.Windows.Media.Imaging", "WmpBitmapEncoder");
			types[KnownTypes.WrapPanel] = InitType(assemblies[4], "System.Windows.Controls", "WrapPanel");
			types[KnownTypes.WriteableBitmap] = InitType(assemblies[3], "System.Windows.Media.Imaging", "WriteableBitmap");
			types[KnownTypes.XamlBrushSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlBrushSerializer");
			types[KnownTypes.XamlInt32CollectionSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlInt32CollectionSerializer");
			types[KnownTypes.XamlPathDataSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlPathDataSerializer");
			types[KnownTypes.XamlPoint3DCollectionSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlPoint3DCollectionSerializer");
			types[KnownTypes.XamlPointCollectionSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlPointCollectionSerializer");
			types[KnownTypes.XamlReader] = InitType(assemblies[4], "System.Windows.Markup", "XamlReader");
			types[KnownTypes.XamlStyleSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlStyleSerializer");
			types[KnownTypes.XamlTemplateSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlTemplateSerializer");
			types[KnownTypes.XamlVector3DCollectionSerializer] = InitType(assemblies[4], "System.Windows.Markup", "XamlVector3DCollectionSerializer");
			types[KnownTypes.XamlWriter] = InitType(assemblies[4], "System.Windows.Markup", "XamlWriter");
			types[KnownTypes.XmlDataProvider] = InitType(assemblies[4], "System.Windows.Data", "XmlDataProvider");
			types[KnownTypes.XmlLangPropertyAttribute] = InitType(assemblies[2], "System.Windows.Markup", "XmlLangPropertyAttribute");
			types[KnownTypes.XmlLanguage] = InitType(assemblies[3], "System.Windows.Markup", "XmlLanguage");
			types[KnownTypes.XmlLanguageConverter] = InitType(assemblies[3], "System.Windows.Markup", "XmlLanguageConverter");
			types[KnownTypes.XmlNamespaceMapping] = InitType(assemblies[4], "System.Windows.Data", "XmlNamespaceMapping");
			types[KnownTypes.ZoomPercentageConverter] = InitType(assemblies[4], "System.Windows.Documents", "ZoomPercentageConverter");
		}

		void InitMembers() {

			members[KnownMembers.AccessText_Text] = InitMember(KnownTypes.AccessText, "Text", InitType(assemblies[0], "System", "String"));
			members[KnownMembers.BeginStoryboard_Storyboard] = InitMember(KnownTypes.BeginStoryboard, "Storyboard", InitType(assemblies[4], "System.Windows.Media.Animation", "Storyboard"));
			members[KnownMembers.BitmapEffectGroup_Children] = InitMember(KnownTypes.BitmapEffectGroup, "Children", InitType(assemblies[3], "System.Windows.Media.Effects", "BitmapEffectCollection"));
			members[KnownMembers.Border_Background] = InitMember(KnownTypes.Border, "Background", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Border_BorderBrush] = InitMember(KnownTypes.Border, "BorderBrush", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Border_BorderThickness] = InitMember(KnownTypes.Border, "BorderThickness", InitType(assemblies[4], "System.Windows", "Thickness"));
			members[KnownMembers.ButtonBase_Command] = InitMember(KnownTypes.ButtonBase, "Command", InitType(assemblies[3], "System.Windows.Input", "ICommand"));
			members[KnownMembers.ButtonBase_CommandParameter] = InitMember(KnownTypes.ButtonBase, "CommandParameter", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ButtonBase_CommandTarget] = InitMember(KnownTypes.ButtonBase, "CommandTarget", InitType(assemblies[3], "System.Windows", "IInputElement"));
			members[KnownMembers.ButtonBase_IsPressed] = InitMember(KnownTypes.ButtonBase, "IsPressed", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.ColumnDefinition_MaxWidth] = InitMember(KnownTypes.ColumnDefinition, "MaxWidth", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.ColumnDefinition_MinWidth] = InitMember(KnownTypes.ColumnDefinition, "MinWidth", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.ColumnDefinition_Width] = InitMember(KnownTypes.ColumnDefinition, "Width", InitType(assemblies[4], "System.Windows", "GridLength"));
			members[KnownMembers.ContentControl_Content] = InitMember(KnownTypes.ContentControl, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ContentControl_ContentTemplate] = InitMember(KnownTypes.ContentControl, "ContentTemplate", InitType(assemblies[4], "System.Windows", "DataTemplate"));
			members[KnownMembers.ContentControl_ContentTemplateSelector] = InitMember(KnownTypes.ContentControl, "ContentTemplateSelector", InitType(assemblies[4], "System.Windows.Controls", "DataTemplateSelector"));
			members[KnownMembers.ContentControl_HasContent] = InitMember(KnownTypes.ContentControl, "HasContent", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.ContentElement_Focusable] = InitMember(KnownTypes.ContentElement, "Focusable", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.ContentPresenter_Content] = InitMember(KnownTypes.ContentPresenter, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ContentPresenter_ContentSource] = InitMember(KnownTypes.ContentPresenter, "ContentSource", InitType(assemblies[0], "System", "String"));
			members[KnownMembers.ContentPresenter_ContentTemplate] = InitMember(KnownTypes.ContentPresenter, "ContentTemplate", InitType(assemblies[4], "System.Windows", "DataTemplate"));
			members[KnownMembers.ContentPresenter_ContentTemplateSelector] = InitMember(KnownTypes.ContentPresenter, "ContentTemplateSelector", InitType(assemblies[4], "System.Windows.Controls", "DataTemplateSelector"));
			members[KnownMembers.ContentPresenter_RecognizesAccessKey] = InitMember(KnownTypes.ContentPresenter, "RecognizesAccessKey", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.Control_Background] = InitMember(KnownTypes.Control, "Background", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Control_BorderBrush] = InitMember(KnownTypes.Control, "BorderBrush", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Control_BorderThickness] = InitMember(KnownTypes.Control, "BorderThickness", InitType(assemblies[4], "System.Windows", "Thickness"));
			members[KnownMembers.Control_FontFamily] = InitMember(KnownTypes.Control, "FontFamily", InitType(assemblies[3], "System.Windows.Media", "FontFamily"));
			members[KnownMembers.Control_FontSize] = InitMember(KnownTypes.Control, "FontSize", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.Control_FontStretch] = InitMember(KnownTypes.Control, "FontStretch", InitType(assemblies[3], "System.Windows", "FontStretch"));
			members[KnownMembers.Control_FontStyle] = InitMember(KnownTypes.Control, "FontStyle", InitType(assemblies[3], "System.Windows", "FontStyle"));
			members[KnownMembers.Control_FontWeight] = InitMember(KnownTypes.Control, "FontWeight", InitType(assemblies[3], "System.Windows", "FontWeight"));
			members[KnownMembers.Control_Foreground] = InitMember(KnownTypes.Control, "Foreground", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Control_HorizontalContentAlignment] = InitMember(KnownTypes.Control, "HorizontalContentAlignment", InitType(assemblies[4], "System.Windows", "HorizontalAlignment"));
			members[KnownMembers.Control_IsTabStop] = InitMember(KnownTypes.Control, "IsTabStop", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.Control_Padding] = InitMember(KnownTypes.Control, "Padding", InitType(assemblies[4], "System.Windows", "Thickness"));
			members[KnownMembers.Control_TabIndex] = InitMember(KnownTypes.Control, "TabIndex", InitType(assemblies[0], "System", "Int32"));
			members[KnownMembers.Control_Template] = InitMember(KnownTypes.Control, "Template", InitType(assemblies[4], "System.Windows.Controls", "ControlTemplate"));
			members[KnownMembers.Control_VerticalContentAlignment] = InitMember(KnownTypes.Control, "VerticalContentAlignment", InitType(assemblies[4], "System.Windows", "VerticalAlignment"));
			members[KnownMembers.DockPanel_Dock] = InitMember(KnownTypes.DockPanel, "Dock", InitType(assemblies[4], "System.Windows.Controls", "Dock"));
			members[KnownMembers.DockPanel_LastChildFill] = InitMember(KnownTypes.DockPanel, "LastChildFill", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.DocumentViewerBase_Document] = InitMember(KnownTypes.DocumentViewerBase, "Document", InitType(assemblies[3], "System.Windows.Documents", "IDocumentPaginatorSource"));
			members[KnownMembers.DrawingGroup_Children] = InitMember(KnownTypes.DrawingGroup, "Children", InitType(assemblies[3], "System.Windows.Media", "DrawingCollection"));
			members[KnownMembers.FlowDocumentReader_Document] = InitMember(KnownTypes.FlowDocumentReader, "Document", InitType(assemblies[4], "System.Windows.Documents", "FlowDocument"));
			members[KnownMembers.FlowDocumentScrollViewer_Document] = InitMember(KnownTypes.FlowDocumentScrollViewer, "Document", InitType(assemblies[4], "System.Windows.Documents", "FlowDocument"));
			members[KnownMembers.FrameworkContentElement_Style] = InitMember(KnownTypes.FrameworkContentElement, "Style", InitType(assemblies[4], "System.Windows", "Style"));
			members[KnownMembers.FrameworkElement_FlowDirection] = InitMember(KnownTypes.FrameworkElement, "FlowDirection", InitType(assemblies[3], "System.Windows", "FlowDirection"));
			members[KnownMembers.FrameworkElement_Height] = InitMember(KnownTypes.FrameworkElement, "Height", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.FrameworkElement_HorizontalAlignment] = InitMember(KnownTypes.FrameworkElement, "HorizontalAlignment", InitType(assemblies[4], "System.Windows", "HorizontalAlignment"));
			members[KnownMembers.FrameworkElement_Margin] = InitMember(KnownTypes.FrameworkElement, "Margin", InitType(assemblies[4], "System.Windows", "Thickness"));
			members[KnownMembers.FrameworkElement_MaxHeight] = InitMember(KnownTypes.FrameworkElement, "MaxHeight", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.FrameworkElement_MaxWidth] = InitMember(KnownTypes.FrameworkElement, "MaxWidth", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.FrameworkElement_MinHeight] = InitMember(KnownTypes.FrameworkElement, "MinHeight", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.FrameworkElement_MinWidth] = InitMember(KnownTypes.FrameworkElement, "MinWidth", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.FrameworkElement_Name] = InitMember(KnownTypes.FrameworkElement, "Name", InitType(assemblies[0], "System", "String"));
			members[KnownMembers.FrameworkElement_Style] = InitMember(KnownTypes.FrameworkElement, "Style", InitType(assemblies[4], "System.Windows", "Style"));
			members[KnownMembers.FrameworkElement_VerticalAlignment] = InitMember(KnownTypes.FrameworkElement, "VerticalAlignment", InitType(assemblies[4], "System.Windows", "VerticalAlignment"));
			members[KnownMembers.FrameworkElement_Width] = InitMember(KnownTypes.FrameworkElement, "Width", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.GeneralTransformGroup_Children] = InitMember(KnownTypes.GeneralTransformGroup, "Children", InitType(assemblies[3], "System.Windows.Media", "GeneralTransformCollection"));
			members[KnownMembers.GeometryGroup_Children] = InitMember(KnownTypes.GeometryGroup, "Children", InitType(assemblies[3], "System.Windows.Media", "GeometryCollection"));
			members[KnownMembers.GradientBrush_GradientStops] = InitMember(KnownTypes.GradientBrush, "GradientStops", InitType(assemblies[3], "System.Windows.Media", "GradientStopCollection"));
			members[KnownMembers.Grid_Column] = InitMember(KnownTypes.Grid, "Column", InitType(assemblies[0], "System", "Int32"));
			members[KnownMembers.Grid_ColumnSpan] = InitMember(KnownTypes.Grid, "ColumnSpan", InitType(assemblies[0], "System", "Int32"));
			members[KnownMembers.Grid_Row] = InitMember(KnownTypes.Grid, "Row", InitType(assemblies[0], "System", "Int32"));
			members[KnownMembers.Grid_RowSpan] = InitMember(KnownTypes.Grid, "RowSpan", InitType(assemblies[0], "System", "Int32"));
			members[KnownMembers.GridViewColumn_Header] = InitMember(KnownTypes.GridViewColumn, "Header", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.HeaderedContentControl_HasHeader] = InitMember(KnownTypes.HeaderedContentControl, "HasHeader", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.HeaderedContentControl_Header] = InitMember(KnownTypes.HeaderedContentControl, "Header", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.HeaderedContentControl_HeaderTemplate] = InitMember(KnownTypes.HeaderedContentControl, "HeaderTemplate", InitType(assemblies[4], "System.Windows", "DataTemplate"));
			members[KnownMembers.HeaderedContentControl_HeaderTemplateSelector] = InitMember(KnownTypes.HeaderedContentControl, "HeaderTemplateSelector", InitType(assemblies[4], "System.Windows.Controls", "DataTemplateSelector"));
			members[KnownMembers.HeaderedItemsControl_HasHeader] = InitMember(KnownTypes.HeaderedItemsControl, "HasHeader", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.HeaderedItemsControl_Header] = InitMember(KnownTypes.HeaderedItemsControl, "Header", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.HeaderedItemsControl_HeaderTemplate] = InitMember(KnownTypes.HeaderedItemsControl, "HeaderTemplate", InitType(assemblies[4], "System.Windows", "DataTemplate"));
			members[KnownMembers.HeaderedItemsControl_HeaderTemplateSelector] = InitMember(KnownTypes.HeaderedItemsControl, "HeaderTemplateSelector", InitType(assemblies[4], "System.Windows.Controls", "DataTemplateSelector"));
			members[KnownMembers.Hyperlink_NavigateUri] = InitMember(KnownTypes.Hyperlink, "NavigateUri", InitType(assemblies[1], "System", "Uri"));
			members[KnownMembers.Image_Source] = InitMember(KnownTypes.Image, "Source", InitType(assemblies[3], "System.Windows.Media", "ImageSource"));
			members[KnownMembers.Image_Stretch] = InitMember(KnownTypes.Image, "Stretch", InitType(assemblies[3], "System.Windows.Media", "Stretch"));
			members[KnownMembers.ItemsControl_ItemContainerStyle] = InitMember(KnownTypes.ItemsControl, "ItemContainerStyle", InitType(assemblies[4], "System.Windows", "Style"));
			members[KnownMembers.ItemsControl_ItemContainerStyleSelector] = InitMember(KnownTypes.ItemsControl, "ItemContainerStyleSelector", InitType(assemblies[4], "System.Windows.Controls", "StyleSelector"));
			members[KnownMembers.ItemsControl_ItemTemplate] = InitMember(KnownTypes.ItemsControl, "ItemTemplate", InitType(assemblies[4], "System.Windows", "DataTemplate"));
			members[KnownMembers.ItemsControl_ItemTemplateSelector] = InitMember(KnownTypes.ItemsControl, "ItemTemplateSelector", InitType(assemblies[4], "System.Windows.Controls", "DataTemplateSelector"));
			members[KnownMembers.ItemsControl_ItemsPanel] = InitMember(KnownTypes.ItemsControl, "ItemsPanel", InitType(assemblies[4], "System.Windows.Controls", "ItemsPanelTemplate"));
			members[KnownMembers.ItemsControl_ItemsSource] = InitMember(KnownTypes.ItemsControl, "ItemsSource", InitType(assemblies[0], "System.Collections", "IEnumerable"));
			members[KnownMembers.MaterialGroup_Children] = InitMember(KnownTypes.MaterialGroup, "Children", InitType(assemblies[3], "System.Windows.Media.Media3D", "MaterialCollection"));
			members[KnownMembers.Model3DGroup_Children] = InitMember(KnownTypes.Model3DGroup, "Children", InitType(assemblies[3], "System.Windows.Media.Media3D", "Model3DCollection"));
			members[KnownMembers.Page_Content] = InitMember(KnownTypes.Page, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.Panel_Background] = InitMember(KnownTypes.Panel, "Background", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Path_Data] = InitMember(KnownTypes.Path, "Data", InitType(assemblies[3], "System.Windows.Media", "Geometry"));
			members[KnownMembers.PathFigure_Segments] = InitMember(KnownTypes.PathFigure, "Segments", InitType(assemblies[3], "System.Windows.Media", "PathSegmentCollection"));
			members[KnownMembers.PathGeometry_Figures] = InitMember(KnownTypes.PathGeometry, "Figures", InitType(assemblies[3], "System.Windows.Media", "PathFigureCollection"));
			members[KnownMembers.Popup_Child] = InitMember(KnownTypes.Popup, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.Popup_IsOpen] = InitMember(KnownTypes.Popup, "IsOpen", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.Popup_Placement] = InitMember(KnownTypes.Popup, "Placement", InitType(assemblies[4], "System.Windows.Controls.Primitives", "PlacementMode"));
			members[KnownMembers.Popup_PopupAnimation] = InitMember(KnownTypes.Popup, "PopupAnimation", InitType(assemblies[4], "System.Windows.Controls.Primitives", "PopupAnimation"));
			members[KnownMembers.RowDefinition_Height] = InitMember(KnownTypes.RowDefinition, "Height", InitType(assemblies[4], "System.Windows", "GridLength"));
			members[KnownMembers.RowDefinition_MaxHeight] = InitMember(KnownTypes.RowDefinition, "MaxHeight", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.RowDefinition_MinHeight] = InitMember(KnownTypes.RowDefinition, "MinHeight", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.ScrollViewer_CanContentScroll] = InitMember(KnownTypes.ScrollViewer, "CanContentScroll", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.ScrollViewer_HorizontalScrollBarVisibility] = InitMember(KnownTypes.ScrollViewer, "HorizontalScrollBarVisibility", InitType(assemblies[4], "System.Windows.Controls", "ScrollBarVisibility"));
			members[KnownMembers.ScrollViewer_VerticalScrollBarVisibility] = InitMember(KnownTypes.ScrollViewer, "VerticalScrollBarVisibility", InitType(assemblies[4], "System.Windows.Controls", "ScrollBarVisibility"));
			members[KnownMembers.Shape_Fill] = InitMember(KnownTypes.Shape, "Fill", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Shape_Stroke] = InitMember(KnownTypes.Shape, "Stroke", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.Shape_StrokeThickness] = InitMember(KnownTypes.Shape, "StrokeThickness", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.TextBlock_Background] = InitMember(KnownTypes.TextBlock, "Background", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.TextBlock_FontFamily] = InitMember(KnownTypes.TextBlock, "FontFamily", InitType(assemblies[3], "System.Windows.Media", "FontFamily"));
			members[KnownMembers.TextBlock_FontSize] = InitMember(KnownTypes.TextBlock, "FontSize", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.TextBlock_FontStretch] = InitMember(KnownTypes.TextBlock, "FontStretch", InitType(assemblies[3], "System.Windows", "FontStretch"));
			members[KnownMembers.TextBlock_FontStyle] = InitMember(KnownTypes.TextBlock, "FontStyle", InitType(assemblies[3], "System.Windows", "FontStyle"));
			members[KnownMembers.TextBlock_FontWeight] = InitMember(KnownTypes.TextBlock, "FontWeight", InitType(assemblies[3], "System.Windows", "FontWeight"));
			members[KnownMembers.TextBlock_Foreground] = InitMember(KnownTypes.TextBlock, "Foreground", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.TextBlock_Text] = InitMember(KnownTypes.TextBlock, "Text", InitType(assemblies[0], "System", "String"));
			members[KnownMembers.TextBlock_TextDecorations] = InitMember(KnownTypes.TextBlock, "TextDecorations", InitType(assemblies[3], "System.Windows", "TextDecorationCollection"));
			members[KnownMembers.TextBlock_TextTrimming] = InitMember(KnownTypes.TextBlock, "TextTrimming", InitType(assemblies[3], "System.Windows", "TextTrimming"));
			members[KnownMembers.TextBlock_TextWrapping] = InitMember(KnownTypes.TextBlock, "TextWrapping", InitType(assemblies[3], "System.Windows", "TextWrapping"));
			members[KnownMembers.TextBox_Text] = InitMember(KnownTypes.TextBox, "Text", InitType(assemblies[0], "System", "String"));
			members[KnownMembers.TextElement_Background] = InitMember(KnownTypes.TextElement, "Background", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.TextElement_FontFamily] = InitMember(KnownTypes.TextElement, "FontFamily", InitType(assemblies[3], "System.Windows.Media", "FontFamily"));
			members[KnownMembers.TextElement_FontSize] = InitMember(KnownTypes.TextElement, "FontSize", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.TextElement_FontStretch] = InitMember(KnownTypes.TextElement, "FontStretch", InitType(assemblies[3], "System.Windows", "FontStretch"));
			members[KnownMembers.TextElement_FontStyle] = InitMember(KnownTypes.TextElement, "FontStyle", InitType(assemblies[3], "System.Windows", "FontStyle"));
			members[KnownMembers.TextElement_FontWeight] = InitMember(KnownTypes.TextElement, "FontWeight", InitType(assemblies[3], "System.Windows", "FontWeight"));
			members[KnownMembers.TextElement_Foreground] = InitMember(KnownTypes.TextElement, "Foreground", InitType(assemblies[3], "System.Windows.Media", "Brush"));
			members[KnownMembers.TimelineGroup_Children] = InitMember(KnownTypes.TimelineGroup, "Children", InitType(assemblies[3], "System.Windows.Media.Animation", "TimelineCollection"));
			members[KnownMembers.Track_IsDirectionReversed] = InitMember(KnownTypes.Track, "IsDirectionReversed", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.Track_Maximum] = InitMember(KnownTypes.Track, "Maximum", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.Track_Minimum] = InitMember(KnownTypes.Track, "Minimum", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.Track_Orientation] = InitMember(KnownTypes.Track, "Orientation", InitType(assemblies[4], "System.Windows.Controls", "Orientation"));
			members[KnownMembers.Track_Value] = InitMember(KnownTypes.Track, "Value", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.Track_ViewportSize] = InitMember(KnownTypes.Track, "ViewportSize", InitType(assemblies[0], "System", "Double"));
			members[KnownMembers.Transform3DGroup_Children] = InitMember(KnownTypes.Transform3DGroup, "Children", InitType(assemblies[3], "System.Windows.Media.Media3D", "Transform3DCollection"));
			members[KnownMembers.TransformGroup_Children] = InitMember(KnownTypes.TransformGroup, "Children", InitType(assemblies[3], "System.Windows.Media", "TransformCollection"));
			members[KnownMembers.UIElement_ClipToBounds] = InitMember(KnownTypes.UIElement, "ClipToBounds", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.UIElement_Focusable] = InitMember(KnownTypes.UIElement, "Focusable", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.UIElement_IsEnabled] = InitMember(KnownTypes.UIElement, "IsEnabled", InitType(assemblies[0], "System", "Boolean"));
			members[KnownMembers.UIElement_RenderTransform] = InitMember(KnownTypes.UIElement, "RenderTransform", InitType(assemblies[3], "System.Windows.Media", "Transform"));
			members[KnownMembers.UIElement_Visibility] = InitMember(KnownTypes.UIElement, "Visibility", InitType(assemblies[3], "System.Windows", "Visibility"));
			members[KnownMembers.Viewport3D_Children] = InitMember(KnownTypes.Viewport3D, "Children", InitType(assemblies[3], "System.Windows.Media.Media3D", "Visual3DCollection"));

			members[KnownMembers.AdornedElementPlaceholder_Child] = InitMember(KnownTypes.AdornedElementPlaceholder, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.AdornerDecorator_Child] = InitMember(KnownTypes.AdornerDecorator, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.AnchoredBlock_Blocks] = InitMember(KnownTypes.AnchoredBlock, "Blocks", InitType(assemblies[4], "System.Windows.Documents", "BlockCollection"));
			members[KnownMembers.ArrayExtension_Items] = InitMember(KnownTypes.ArrayExtension, "Items", InitType(assemblies[0], "System.Collections", "IList"));
			members[KnownMembers.BlockUIContainer_Child] = InitMember(KnownTypes.BlockUIContainer, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.Bold_Inlines] = InitMember(KnownTypes.Bold, "Inlines", InitType(assemblies[4], "System.Windows.Documents", "InlineCollection"));
			members[KnownMembers.BooleanAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.BooleanAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "BooleanKeyFrameCollection"));
			members[KnownMembers.Border_Child] = InitMember(KnownTypes.Border, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.BulletDecorator_Child] = InitMember(KnownTypes.BulletDecorator, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.Button_Content] = InitMember(KnownTypes.Button, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ButtonBase_Content] = InitMember(KnownTypes.ButtonBase, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ByteAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.ByteAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "ByteKeyFrameCollection"));
			members[KnownMembers.Canvas_Children] = InitMember(KnownTypes.Canvas, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.CharAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.CharAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "CharKeyFrameCollection"));
			members[KnownMembers.CheckBox_Content] = InitMember(KnownTypes.CheckBox, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ColorAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.ColorAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "ColorKeyFrameCollection"));
			members[KnownMembers.ComboBox_Items] = InitMember(KnownTypes.ComboBox, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.ComboBoxItem_Content] = InitMember(KnownTypes.ComboBoxItem, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ContextMenu_Items] = InitMember(KnownTypes.ContextMenu, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.ControlTemplate_VisualTree] = InitMember(KnownTypes.ControlTemplate, "VisualTree", InitType(assemblies[4], "System.Windows", "FrameworkElementFactory"));
			members[KnownMembers.DataTemplate_VisualTree] = InitMember(KnownTypes.DataTemplate, "VisualTree", InitType(assemblies[4], "System.Windows", "FrameworkElementFactory"));
			members[KnownMembers.DataTrigger_Setters] = InitMember(KnownTypes.DataTrigger, "Setters", InitType(assemblies[4], "System.Windows", "SetterBaseCollection"));
			members[KnownMembers.DecimalAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.DecimalAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "DecimalKeyFrameCollection"));
			members[KnownMembers.Decorator_Child] = InitMember(KnownTypes.Decorator, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.DockPanel_Children] = InitMember(KnownTypes.DockPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.DocumentViewer_Document] = InitMember(KnownTypes.DocumentViewer, "Document", InitType(assemblies[3], "System.Windows.Documents", "IDocumentPaginatorSource"));
			members[KnownMembers.DoubleAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.DoubleAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "DoubleKeyFrameCollection"));
			members[KnownMembers.EventTrigger_Actions] = InitMember(KnownTypes.EventTrigger, "Actions", InitType(assemblies[4], "System.Windows", "TriggerActionCollection"));
			members[KnownMembers.Expander_Content] = InitMember(KnownTypes.Expander, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.Figure_Blocks] = InitMember(KnownTypes.Figure, "Blocks", InitType(assemblies[4], "System.Windows.Documents", "BlockCollection"));
			members[KnownMembers.FixedDocument_Pages] = InitMember(KnownTypes.FixedDocument, "Pages", InitType(assemblies[4], "System.Windows.Documents", "PageContentCollection"));
			members[KnownMembers.FixedDocumentSequence_References] = InitMember(KnownTypes.FixedDocumentSequence, "References", InitType(assemblies[4], "System.Windows.Documents", "DocumentReferenceCollection"));
			members[KnownMembers.FixedPage_Children] = InitMember(KnownTypes.FixedPage, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.Floater_Blocks] = InitMember(KnownTypes.Floater, "Blocks", InitType(assemblies[4], "System.Windows.Documents", "BlockCollection"));
			members[KnownMembers.FlowDocument_Blocks] = InitMember(KnownTypes.FlowDocument, "Blocks", InitType(assemblies[4], "System.Windows.Documents", "BlockCollection"));
			members[KnownMembers.FlowDocumentPageViewer_Document] = InitMember(KnownTypes.FlowDocumentPageViewer, "Document", InitType(assemblies[3], "System.Windows.Documents", "IDocumentPaginatorSource"));
			members[KnownMembers.FrameworkTemplate_VisualTree] = InitMember(KnownTypes.FrameworkTemplate, "VisualTree", InitType(assemblies[4], "System.Windows", "FrameworkElementFactory"));
			members[KnownMembers.Grid_Children] = InitMember(KnownTypes.Grid, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.GridView_Columns] = InitMember(KnownTypes.GridView, "Columns", InitType(assemblies[4], "System.Windows.Controls", "GridViewColumnCollection"));
			members[KnownMembers.GridViewColumnHeader_Content] = InitMember(KnownTypes.GridViewColumnHeader, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.GroupBox_Content] = InitMember(KnownTypes.GroupBox, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.GroupItem_Content] = InitMember(KnownTypes.GroupItem, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.HeaderedContentControl_Content] = InitMember(KnownTypes.HeaderedContentControl, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.HeaderedItemsControl_Items] = InitMember(KnownTypes.HeaderedItemsControl, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.HierarchicalDataTemplate_VisualTree] = InitMember(KnownTypes.HierarchicalDataTemplate, "VisualTree", InitType(assemblies[4], "System.Windows", "FrameworkElementFactory"));
			members[KnownMembers.Hyperlink_Inlines] = InitMember(KnownTypes.Hyperlink, "Inlines", InitType(assemblies[4], "System.Windows.Documents", "InlineCollection"));
			members[KnownMembers.InkCanvas_Children] = InitMember(KnownTypes.InkCanvas, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.InkPresenter_Child] = InitMember(KnownTypes.InkPresenter, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.InlineUIContainer_Child] = InitMember(KnownTypes.InlineUIContainer, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.InputScopeName_NameValue] = InitMember(KnownTypes.InputScopeName, "NameValue", InitType(assemblies[3], "System.Windows.Input", "InputScopeNameValue"));
			members[KnownMembers.Int16AnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.Int16AnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "Int16KeyFrameCollection"));
			members[KnownMembers.Int32AnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.Int32AnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "Int32KeyFrameCollection"));
			members[KnownMembers.Int64AnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.Int64AnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "Int64KeyFrameCollection"));
			members[KnownMembers.Italic_Inlines] = InitMember(KnownTypes.Italic, "Inlines", InitType(assemblies[4], "System.Windows.Documents", "InlineCollection"));
			members[KnownMembers.ItemsControl_Items] = InitMember(KnownTypes.ItemsControl, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.ItemsPanelTemplate_VisualTree] = InitMember(KnownTypes.ItemsPanelTemplate, "VisualTree", InitType(assemblies[4], "System.Windows", "FrameworkElementFactory"));
			members[KnownMembers.Label_Content] = InitMember(KnownTypes.Label, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.LinearGradientBrush_GradientStops] = InitMember(KnownTypes.LinearGradientBrush, "GradientStops", InitType(assemblies[3], "System.Windows.Media", "GradientStopCollection"));
			members[KnownMembers.List_ListItems] = InitMember(KnownTypes.List, "ListItems", InitType(assemblies[4], "System.Windows.Documents", "ListItemCollection"));
			members[KnownMembers.ListBox_Items] = InitMember(KnownTypes.ListBox, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.ListBoxItem_Content] = InitMember(KnownTypes.ListBoxItem, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ListItem_Blocks] = InitMember(KnownTypes.ListItem, "Blocks", InitType(assemblies[4], "System.Windows.Documents", "BlockCollection"));
			members[KnownMembers.ListView_Items] = InitMember(KnownTypes.ListView, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.ListViewItem_Content] = InitMember(KnownTypes.ListViewItem, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.MatrixAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.MatrixAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "MatrixKeyFrameCollection"));
			members[KnownMembers.Menu_Items] = InitMember(KnownTypes.Menu, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.MenuBase_Items] = InitMember(KnownTypes.MenuBase, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.MenuItem_Items] = InitMember(KnownTypes.MenuItem, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.ModelVisual3D_Children] = InitMember(KnownTypes.ModelVisual3D, "Children", InitType(assemblies[3], "System.Windows.Media.Media3D", "Visual3DCollection"));
			members[KnownMembers.MultiBinding_Bindings] = InitMember(KnownTypes.MultiBinding, "Bindings", InitType(assemblies[0], "System.Collections.ObjectModel", "Collection`1"));
			members[KnownMembers.MultiDataTrigger_Setters] = InitMember(KnownTypes.MultiDataTrigger, "Setters", InitType(assemblies[4], "System.Windows", "SetterBaseCollection"));
			members[KnownMembers.MultiTrigger_Setters] = InitMember(KnownTypes.MultiTrigger, "Setters", InitType(assemblies[4], "System.Windows", "SetterBaseCollection"));
			members[KnownMembers.ObjectAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.ObjectAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "ObjectKeyFrameCollection"));
			members[KnownMembers.PageContent_Child] = InitMember(KnownTypes.PageContent, "Child", InitType(assemblies[4], "System.Windows.Documents", "FixedPage"));
			members[KnownMembers.PageFunctionBase_Content] = InitMember(KnownTypes.PageFunctionBase, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.Panel_Children] = InitMember(KnownTypes.Panel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.Paragraph_Inlines] = InitMember(KnownTypes.Paragraph, "Inlines", InitType(assemblies[4], "System.Windows.Documents", "InlineCollection"));
			members[KnownMembers.ParallelTimeline_Children] = InitMember(KnownTypes.ParallelTimeline, "Children", InitType(assemblies[3], "System.Windows.Media.Animation", "TimelineCollection"));
			members[KnownMembers.Point3DAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.Point3DAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "Point3DKeyFrameCollection"));
			members[KnownMembers.PointAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.PointAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "PointKeyFrameCollection"));
			members[KnownMembers.PriorityBinding_Bindings] = InitMember(KnownTypes.PriorityBinding, "Bindings", InitType(assemblies[0], "System.Collections.ObjectModel", "Collection`1"));
			members[KnownMembers.QuaternionAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.QuaternionAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "QuaternionKeyFrameCollection"));
			members[KnownMembers.RadialGradientBrush_GradientStops] = InitMember(KnownTypes.RadialGradientBrush, "GradientStops", InitType(assemblies[3], "System.Windows.Media", "GradientStopCollection"));
			members[KnownMembers.RadioButton_Content] = InitMember(KnownTypes.RadioButton, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.RectAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.RectAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "RectKeyFrameCollection"));
			members[KnownMembers.RepeatButton_Content] = InitMember(KnownTypes.RepeatButton, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.RichTextBox_Document] = InitMember(KnownTypes.RichTextBox, "Document", InitType(assemblies[4], "System.Windows.Documents", "FlowDocument"));
			members[KnownMembers.Rotation3DAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.Rotation3DAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "Rotation3DKeyFrameCollection"));
			members[KnownMembers.Run_Text] = InitMember(KnownTypes.Run, "Text", InitType(assemblies[0], "System", "String"));
			members[KnownMembers.ScrollViewer_Content] = InitMember(KnownTypes.ScrollViewer, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.Section_Blocks] = InitMember(KnownTypes.Section, "Blocks", InitType(assemblies[4], "System.Windows.Documents", "BlockCollection"));
			members[KnownMembers.Selector_Items] = InitMember(KnownTypes.Selector, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.SingleAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.SingleAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "SingleKeyFrameCollection"));
			members[KnownMembers.SizeAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.SizeAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "SizeKeyFrameCollection"));
			members[KnownMembers.Span_Inlines] = InitMember(KnownTypes.Span, "Inlines", InitType(assemblies[4], "System.Windows.Documents", "InlineCollection"));
			members[KnownMembers.StackPanel_Children] = InitMember(KnownTypes.StackPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.StatusBar_Items] = InitMember(KnownTypes.StatusBar, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.StatusBarItem_Content] = InitMember(KnownTypes.StatusBarItem, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.Storyboard_Children] = InitMember(KnownTypes.Storyboard, "Children", InitType(assemblies[3], "System.Windows.Media.Animation", "TimelineCollection"));
			members[KnownMembers.StringAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.StringAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "StringKeyFrameCollection"));
			members[KnownMembers.Style_Setters] = InitMember(KnownTypes.Style, "Setters", InitType(assemblies[4], "System.Windows", "SetterBaseCollection"));
			members[KnownMembers.TabControl_Items] = InitMember(KnownTypes.TabControl, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.TabItem_Content] = InitMember(KnownTypes.TabItem, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.TabPanel_Children] = InitMember(KnownTypes.TabPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.Table_RowGroups] = InitMember(KnownTypes.Table, "RowGroups", InitType(assemblies[4], "System.Windows.Documents", "TableRowGroupCollection"));
			members[KnownMembers.TableCell_Blocks] = InitMember(KnownTypes.TableCell, "Blocks", InitType(assemblies[4], "System.Windows.Documents", "BlockCollection"));
			members[KnownMembers.TableRow_Cells] = InitMember(KnownTypes.TableRow, "Cells", InitType(assemblies[4], "System.Windows.Documents", "TableCellCollection"));
			members[KnownMembers.TableRowGroup_Rows] = InitMember(KnownTypes.TableRowGroup, "Rows", InitType(assemblies[4], "System.Windows.Documents", "TableRowCollection"));
			members[KnownMembers.TextBlock_Inlines] = InitMember(KnownTypes.TextBlock, "Inlines", InitType(assemblies[4], "System.Windows.Documents", "InlineCollection"));
			members[KnownMembers.ThicknessAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.ThicknessAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[4], "System.Windows.Media.Animation", "ThicknessKeyFrameCollection"));
			members[KnownMembers.ToggleButton_Content] = InitMember(KnownTypes.ToggleButton, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.ToolBar_Items] = InitMember(KnownTypes.ToolBar, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.ToolBarOverflowPanel_Children] = InitMember(KnownTypes.ToolBarOverflowPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.ToolBarPanel_Children] = InitMember(KnownTypes.ToolBarPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.ToolBarTray_ToolBars] = InitMember(KnownTypes.ToolBarTray, "ToolBars", InitType(assemblies[0], "System.Collections.ObjectModel", "Collection`1"));
			members[KnownMembers.ToolTip_Content] = InitMember(KnownTypes.ToolTip, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.TreeView_Items] = InitMember(KnownTypes.TreeView, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.TreeViewItem_Items] = InitMember(KnownTypes.TreeViewItem, "Items", InitType(assemblies[4], "System.Windows.Controls", "ItemCollection"));
			members[KnownMembers.Trigger_Setters] = InitMember(KnownTypes.Trigger, "Setters", InitType(assemblies[4], "System.Windows", "SetterBaseCollection"));
			members[KnownMembers.Underline_Inlines] = InitMember(KnownTypes.Underline, "Inlines", InitType(assemblies[4], "System.Windows.Documents", "InlineCollection"));
			members[KnownMembers.UniformGrid_Children] = InitMember(KnownTypes.UniformGrid, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.UserControl_Content] = InitMember(KnownTypes.UserControl, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.Vector3DAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.Vector3DAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "Vector3DKeyFrameCollection"));
			members[KnownMembers.VectorAnimationUsingKeyFrames_KeyFrames] = InitMember(KnownTypes.VectorAnimationUsingKeyFrames, "KeyFrames", InitType(assemblies[3], "System.Windows.Media.Animation", "VectorKeyFrameCollection"));
			members[KnownMembers.Viewbox_Child] = InitMember(KnownTypes.Viewbox, "Child", InitType(assemblies[3], "System.Windows", "UIElement"));
			members[KnownMembers.Viewport3DVisual_Children] = InitMember(KnownTypes.Viewport3DVisual, "Children", InitType(assemblies[3], "System.Windows.Media.Media3D", "Visual3DCollection"));
			members[KnownMembers.VirtualizingPanel_Children] = InitMember(KnownTypes.VirtualizingPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.VirtualizingStackPanel_Children] = InitMember(KnownTypes.VirtualizingStackPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.Window_Content] = InitMember(KnownTypes.Window, "Content", InitType(assemblies[0], "System", "Object"));
			members[KnownMembers.WrapPanel_Children] = InitMember(KnownTypes.WrapPanel, "Children", InitType(assemblies[4], "System.Windows.Controls", "UIElementCollection"));
			members[KnownMembers.XmlDataProvider_XmlSerializer] = InitMember(KnownTypes.XmlDataProvider, "XmlSerializer", InitType(assemblies[5], "System.Xml.Serialization", "IXmlSerializable"));
		}

		void InitStrings() {
			strings[1] = "Name";
			strings[2] = "Uid";
		}

		void InitResources() {

			resources[1] = Tuple.Create("SystemColors", "ActiveBorderBrushKey", "ActiveBorderBrush");
			resources[2] = Tuple.Create("SystemColors", "ActiveCaptionBrushKey", "ActiveCaptionBrush");
			resources[3] = Tuple.Create("SystemColors", "ActiveCaptionTextBrushKey", "ActiveCaptionTextBrush");
			resources[4] = Tuple.Create("SystemColors", "AppWorkspaceBrushKey", "AppWorkspaceBrush");
			resources[5] = Tuple.Create("SystemColors", "ControlBrushKey", "ControlBrush");
			resources[6] = Tuple.Create("SystemColors", "ControlDarkBrushKey", "ControlDarkBrush");
			resources[7] = Tuple.Create("SystemColors", "ControlDarkDarkBrushKey", "ControlDarkDarkBrush");
			resources[8] = Tuple.Create("SystemColors", "ControlLightBrushKey", "ControlLightBrush");
			resources[9] = Tuple.Create("SystemColors", "ControlLightLightBrushKey", "ControlLightLightBrush");
			resources[10] = Tuple.Create("SystemColors", "ControlTextBrushKey", "ControlTextBrush");
			resources[11] = Tuple.Create("SystemColors", "DesktopBrushKey", "DesktopBrush");
			resources[12] = Tuple.Create("SystemColors", "GradientActiveCaptionBrushKey", "GradientActiveCaptionBrush");
			resources[13] = Tuple.Create("SystemColors", "GradientInactiveCaptionBrushKey", "GradientInactiveCaptionBrush");
			resources[14] = Tuple.Create("SystemColors", "GrayTextBrushKey", "GrayTextBrush");
			resources[15] = Tuple.Create("SystemColors", "HighlightBrushKey", "HighlightBrush");
			resources[16] = Tuple.Create("SystemColors", "HighlightTextBrushKey", "HighlightTextBrush");
			resources[17] = Tuple.Create("SystemColors", "HotTrackBrushKey", "HotTrackBrush");
			resources[18] = Tuple.Create("SystemColors", "InactiveBorderBrushKey", "InactiveBorderBrush");
			resources[19] = Tuple.Create("SystemColors", "InactiveCaptionBrushKey", "InactiveCaptionBrush");
			resources[20] = Tuple.Create("SystemColors", "InactiveCaptionTextBrushKey", "InactiveCaptionTextBrush");
			resources[21] = Tuple.Create("SystemColors", "InfoBrushKey", "InfoBrush");
			resources[22] = Tuple.Create("SystemColors", "InfoTextBrushKey", "InfoTextBrush");
			resources[23] = Tuple.Create("SystemColors", "MenuBrushKey", "MenuBrush");
			resources[24] = Tuple.Create("SystemColors", "MenuBarBrushKey", "MenuBarBrush");
			resources[25] = Tuple.Create("SystemColors", "MenuHighlightBrushKey", "MenuHighlightBrush");
			resources[26] = Tuple.Create("SystemColors", "MenuTextBrushKey", "MenuTextBrush");
			resources[27] = Tuple.Create("SystemColors", "ScrollBarBrushKey", "ScrollBarBrush");
			resources[28] = Tuple.Create("SystemColors", "WindowBrushKey", "WindowBrush");
			resources[29] = Tuple.Create("SystemColors", "WindowFrameBrushKey", "WindowFrameBrush");
			resources[30] = Tuple.Create("SystemColors", "WindowTextBrushKey", "WindowTextBrush");
			resources[31] = Tuple.Create("SystemColors", "ActiveBorderColorKey", "ActiveBorderColor");
			resources[32] = Tuple.Create("SystemColors", "ActiveCaptionColorKey", "ActiveCaptionColor");
			resources[33] = Tuple.Create("SystemColors", "ActiveCaptionTextColorKey", "ActiveCaptionTextColor");
			resources[34] = Tuple.Create("SystemColors", "AppWorkspaceColorKey", "AppWorkspaceColor");
			resources[35] = Tuple.Create("SystemColors", "ControlColorKey", "ControlColor");
			resources[36] = Tuple.Create("SystemColors", "ControlDarkColorKey", "ControlDarkColor");
			resources[37] = Tuple.Create("SystemColors", "ControlDarkDarkColorKey", "ControlDarkDarkColor");
			resources[38] = Tuple.Create("SystemColors", "ControlLightColorKey", "ControlLightColor");
			resources[39] = Tuple.Create("SystemColors", "ControlLightLightColorKey", "ControlLightLightColor");
			resources[40] = Tuple.Create("SystemColors", "ControlTextColorKey", "ControlTextColor");
			resources[41] = Tuple.Create("SystemColors", "DesktopColorKey", "DesktopColor");
			resources[42] = Tuple.Create("SystemColors", "GradientActiveCaptionColorKey", "GradientActiveCaptionColor");
			resources[43] = Tuple.Create("SystemColors", "GradientInactiveCaptionColorKey", "GradientInactiveCaptionColor");
			resources[44] = Tuple.Create("SystemColors", "GrayTextColorKey", "GrayTextColor");
			resources[45] = Tuple.Create("SystemColors", "HighlightColorKey", "HighlightColor");
			resources[46] = Tuple.Create("SystemColors", "HighlightTextColorKey", "HighlightTextColor");
			resources[47] = Tuple.Create("SystemColors", "HotTrackColorKey", "HotTrackColor");
			resources[48] = Tuple.Create("SystemColors", "InactiveBorderColorKey", "InactiveBorderColor");
			resources[49] = Tuple.Create("SystemColors", "InactiveCaptionColorKey", "InactiveCaptionColor");
			resources[50] = Tuple.Create("SystemColors", "InactiveCaptionTextColorKey", "InactiveCaptionTextColor");
			resources[51] = Tuple.Create("SystemColors", "InfoColorKey", "InfoColor");
			resources[52] = Tuple.Create("SystemColors", "InfoTextColorKey", "InfoTextColor");
			resources[53] = Tuple.Create("SystemColors", "MenuColorKey", "MenuColor");
			resources[54] = Tuple.Create("SystemColors", "MenuBarColorKey", "MenuBarColor");
			resources[55] = Tuple.Create("SystemColors", "MenuHighlightColorKey", "MenuHighlightColor");
			resources[56] = Tuple.Create("SystemColors", "MenuTextColorKey", "MenuTextColor");
			resources[57] = Tuple.Create("SystemColors", "ScrollBarColorKey", "ScrollBarColor");
			resources[58] = Tuple.Create("SystemColors", "WindowColorKey", "WindowColor");
			resources[59] = Tuple.Create("SystemColors", "WindowFrameColorKey", "WindowFrameColor");
			resources[60] = Tuple.Create("SystemColors", "WindowTextColorKey", "WindowTextColor");


			resources[63] = Tuple.Create("SystemFonts", "CaptionFontSizeKey", "CaptionFontSize");
			resources[64] = Tuple.Create("SystemFonts", "CaptionFontFamilyKey", "CaptionFontFamily");
			resources[65] = Tuple.Create("SystemFonts", "CaptionFontStyleKey", "CaptionFontStyle");
			resources[66] = Tuple.Create("SystemFonts", "CaptionFontWeightKey", "CaptionFontWeight");
			resources[67] = Tuple.Create("SystemFonts", "CaptionFontTextDecorationsKey", "CaptionFontTextDecorations");
			resources[68] = Tuple.Create("SystemFonts", "SmallCaptionFontSizeKey", "SmallCaptionFontSize");
			resources[69] = Tuple.Create("SystemFonts", "SmallCaptionFontFamilyKey", "SmallCaptionFontFamily");
			resources[70] = Tuple.Create("SystemFonts", "SmallCaptionFontStyleKey", "SmallCaptionFontStyle");
			resources[71] = Tuple.Create("SystemFonts", "SmallCaptionFontWeightKey", "SmallCaptionFontWeight");
			resources[72] = Tuple.Create("SystemFonts", "SmallCaptionFontTextDecorationsKey", "SmallCaptionFontTextDecorations");
			resources[73] = Tuple.Create("SystemFonts", "MenuFontSizeKey", "MenuFontSize");
			resources[74] = Tuple.Create("SystemFonts", "MenuFontFamilyKey", "MenuFontFamily");
			resources[75] = Tuple.Create("SystemFonts", "MenuFontStyleKey", "MenuFontStyle");
			resources[76] = Tuple.Create("SystemFonts", "MenuFontWeightKey", "MenuFontWeight");
			resources[77] = Tuple.Create("SystemFonts", "MenuFontTextDecorationsKey", "MenuFontTextDecorations");
			resources[78] = Tuple.Create("SystemFonts", "StatusFontSizeKey", "StatusFontSize");
			resources[79] = Tuple.Create("SystemFonts", "StatusFontFamilyKey", "StatusFontFamily");
			resources[80] = Tuple.Create("SystemFonts", "StatusFontStyleKey", "StatusFontStyle");
			resources[81] = Tuple.Create("SystemFonts", "StatusFontWeightKey", "StatusFontWeight");
			resources[82] = Tuple.Create("SystemFonts", "StatusFontTextDecorationsKey", "StatusFontTextDecorations");
			resources[83] = Tuple.Create("SystemFonts", "MessageFontSizeKey", "MessageFontSize");
			resources[84] = Tuple.Create("SystemFonts", "MessageFontFamilyKey", "MessageFontFamily");
			resources[85] = Tuple.Create("SystemFonts", "MessageFontStyleKey", "MessageFontStyle");
			resources[86] = Tuple.Create("SystemFonts", "MessageFontWeightKey", "MessageFontWeight");
			resources[87] = Tuple.Create("SystemFonts", "MessageFontTextDecorationsKey", "MessageFontTextDecorations");
			resources[88] = Tuple.Create("SystemFonts", "IconFontSizeKey", "IconFontSize");
			resources[89] = Tuple.Create("SystemFonts", "IconFontFamilyKey", "IconFontFamily");
			resources[90] = Tuple.Create("SystemFonts", "IconFontStyleKey", "IconFontStyle");
			resources[91] = Tuple.Create("SystemFonts", "IconFontWeightKey", "IconFontWeight");
			resources[92] = Tuple.Create("SystemFonts", "IconFontTextDecorationsKey", "IconFontTextDecorations");


			resources[95] = Tuple.Create("SystemParameters", "ThinHorizontalBorderHeightKey", "ThinHorizontalBorderHeight");
			resources[96] = Tuple.Create("SystemParameters", "ThinVerticalBorderWidthKey", "ThinVerticalBorderWidth");
			resources[97] = Tuple.Create("SystemParameters", "CursorWidthKey", "CursorWidth");
			resources[98] = Tuple.Create("SystemParameters", "CursorHeightKey", "CursorHeight");
			resources[99] = Tuple.Create("SystemParameters", "ThickHorizontalBorderHeightKey", "ThickHorizontalBorderHeight");
			resources[100] = Tuple.Create("SystemParameters", "ThickVerticalBorderWidthKey", "ThickVerticalBorderWidth");
			resources[101] = Tuple.Create("SystemParameters", "FixedFrameHorizontalBorderHeightKey", "FixedFrameHorizontalBorderHeight");
			resources[102] = Tuple.Create("SystemParameters", "FixedFrameVerticalBorderWidthKey", "FixedFrameVerticalBorderWidth");
			resources[103] = Tuple.Create("SystemParameters", "FocusHorizontalBorderHeightKey", "FocusHorizontalBorderHeight");
			resources[104] = Tuple.Create("SystemParameters", "FocusVerticalBorderWidthKey", "FocusVerticalBorderWidth");
			resources[105] = Tuple.Create("SystemParameters", "FullPrimaryScreenWidthKey", "FullPrimaryScreenWidth");
			resources[106] = Tuple.Create("SystemParameters", "FullPrimaryScreenHeightKey", "FullPrimaryScreenHeight");
			resources[107] = Tuple.Create("SystemParameters", "HorizontalScrollBarButtonWidthKey", "HorizontalScrollBarButtonWidth");
			resources[108] = Tuple.Create("SystemParameters", "HorizontalScrollBarHeightKey", "HorizontalScrollBarHeight");
			resources[109] = Tuple.Create("SystemParameters", "HorizontalScrollBarThumbWidthKey", "HorizontalScrollBarThumbWidth");
			resources[110] = Tuple.Create("SystemParameters", "IconWidthKey", "IconWidth");
			resources[111] = Tuple.Create("SystemParameters", "IconHeightKey", "IconHeight");
			resources[112] = Tuple.Create("SystemParameters", "IconGridWidthKey", "IconGridWidth");
			resources[113] = Tuple.Create("SystemParameters", "IconGridHeightKey", "IconGridHeight");
			resources[114] = Tuple.Create("SystemParameters", "MaximizedPrimaryScreenWidthKey", "MaximizedPrimaryScreenWidth");
			resources[115] = Tuple.Create("SystemParameters", "MaximizedPrimaryScreenHeightKey", "MaximizedPrimaryScreenHeight");
			resources[116] = Tuple.Create("SystemParameters", "MaximumWindowTrackWidthKey", "MaximumWindowTrackWidth");
			resources[117] = Tuple.Create("SystemParameters", "MaximumWindowTrackHeightKey", "MaximumWindowTrackHeight");
			resources[118] = Tuple.Create("SystemParameters", "MenuCheckmarkWidthKey", "MenuCheckmarkWidth");
			resources[119] = Tuple.Create("SystemParameters", "MenuCheckmarkHeightKey", "MenuCheckmarkHeight");
			resources[120] = Tuple.Create("SystemParameters", "MenuButtonWidthKey", "MenuButtonWidth");
			resources[121] = Tuple.Create("SystemParameters", "MenuButtonHeightKey", "MenuButtonHeight");
			resources[122] = Tuple.Create("SystemParameters", "MinimumWindowWidthKey", "MinimumWindowWidth");
			resources[123] = Tuple.Create("SystemParameters", "MinimumWindowHeightKey", "MinimumWindowHeight");
			resources[124] = Tuple.Create("SystemParameters", "MinimizedWindowWidthKey", "MinimizedWindowWidth");
			resources[125] = Tuple.Create("SystemParameters", "MinimizedWindowHeightKey", "MinimizedWindowHeight");
			resources[126] = Tuple.Create("SystemParameters", "MinimizedGridWidthKey", "MinimizedGridWidth");
			resources[127] = Tuple.Create("SystemParameters", "MinimizedGridHeightKey", "MinimizedGridHeight");
			resources[128] = Tuple.Create("SystemParameters", "MinimumWindowTrackWidthKey", "MinimumWindowTrackWidth");
			resources[129] = Tuple.Create("SystemParameters", "MinimumWindowTrackHeightKey", "MinimumWindowTrackHeight");
			resources[130] = Tuple.Create("SystemParameters", "PrimaryScreenWidthKey", "PrimaryScreenWidth");
			resources[131] = Tuple.Create("SystemParameters", "PrimaryScreenHeightKey", "PrimaryScreenHeight");
			resources[132] = Tuple.Create("SystemParameters", "WindowCaptionButtonWidthKey", "WindowCaptionButtonWidth");
			resources[133] = Tuple.Create("SystemParameters", "WindowCaptionButtonHeightKey", "WindowCaptionButtonHeight");
			resources[134] = Tuple.Create("SystemParameters", "ResizeFrameHorizontalBorderHeightKey", "ResizeFrameHorizontalBorderHeight");
			resources[135] = Tuple.Create("SystemParameters", "ResizeFrameVerticalBorderWidthKey", "ResizeFrameVerticalBorderWidth");
			resources[136] = Tuple.Create("SystemParameters", "SmallIconWidthKey", "SmallIconWidth");
			resources[137] = Tuple.Create("SystemParameters", "SmallIconHeightKey", "SmallIconHeight");
			resources[138] = Tuple.Create("SystemParameters", "SmallWindowCaptionButtonWidthKey", "SmallWindowCaptionButtonWidth");
			resources[139] = Tuple.Create("SystemParameters", "SmallWindowCaptionButtonHeightKey", "SmallWindowCaptionButtonHeight");
			resources[140] = Tuple.Create("SystemParameters", "VirtualScreenWidthKey", "VirtualScreenWidth");
			resources[141] = Tuple.Create("SystemParameters", "VirtualScreenHeightKey", "VirtualScreenHeight");
			resources[142] = Tuple.Create("SystemParameters", "VerticalScrollBarWidthKey", "VerticalScrollBarWidth");
			resources[143] = Tuple.Create("SystemParameters", "VerticalScrollBarButtonHeightKey", "VerticalScrollBarButtonHeight");
			resources[144] = Tuple.Create("SystemParameters", "WindowCaptionHeightKey", "WindowCaptionHeight");
			resources[145] = Tuple.Create("SystemParameters", "KanjiWindowHeightKey", "KanjiWindowHeight");
			resources[146] = Tuple.Create("SystemParameters", "MenuBarHeightKey", "MenuBarHeight");
			resources[147] = Tuple.Create("SystemParameters", "SmallCaptionHeightKey", "SmallCaptionHeight");
			resources[148] = Tuple.Create("SystemParameters", "VerticalScrollBarThumbHeightKey", "VerticalScrollBarThumbHeight");
			resources[149] = Tuple.Create("SystemParameters", "IsImmEnabledKey", "IsImmEnabled");
			resources[150] = Tuple.Create("SystemParameters", "IsMediaCenterKey", "IsMediaCenter");
			resources[151] = Tuple.Create("SystemParameters", "IsMenuDropRightAlignedKey", "IsMenuDropRightAligned");
			resources[152] = Tuple.Create("SystemParameters", "IsMiddleEastEnabledKey", "IsMiddleEastEnabled");
			resources[153] = Tuple.Create("SystemParameters", "IsMousePresentKey", "IsMousePresent");
			resources[154] = Tuple.Create("SystemParameters", "IsMouseWheelPresentKey", "IsMouseWheelPresent");
			resources[155] = Tuple.Create("SystemParameters", "IsPenWindowsKey", "IsPenWindows");
			resources[156] = Tuple.Create("SystemParameters", "IsRemotelyControlledKey", "IsRemotelyControlled");
			resources[157] = Tuple.Create("SystemParameters", "IsRemoteSessionKey", "IsRemoteSession");
			resources[158] = Tuple.Create("SystemParameters", "ShowSoundsKey", "ShowSounds");
			resources[159] = Tuple.Create("SystemParameters", "IsSlowMachineKey", "IsSlowMachine");
			resources[160] = Tuple.Create("SystemParameters", "SwapButtonsKey", "SwapButtons");
			resources[161] = Tuple.Create("SystemParameters", "IsTabletPCKey", "IsTabletPC");
			resources[162] = Tuple.Create("SystemParameters", "VirtualScreenLeftKey", "VirtualScreenLeft");
			resources[163] = Tuple.Create("SystemParameters", "VirtualScreenTopKey", "VirtualScreenTop");
			resources[164] = Tuple.Create("SystemParameters", "FocusBorderWidthKey", "FocusBorderWidth");
			resources[165] = Tuple.Create("SystemParameters", "FocusBorderHeightKey", "FocusBorderHeight");
			resources[166] = Tuple.Create("SystemParameters", "HighContrastKey", "HighContrast");
			resources[167] = Tuple.Create("SystemParameters", "DropShadowKey", "DropShadow");
			resources[168] = Tuple.Create("SystemParameters", "FlatMenuKey", "FlatMenu");
			resources[169] = Tuple.Create("SystemParameters", "WorkAreaKey", "WorkArea");
			resources[170] = Tuple.Create("SystemParameters", "IconHorizontalSpacingKey", "IconHorizontalSpacing");
			resources[171] = Tuple.Create("SystemParameters", "IconVerticalSpacingKey", "IconVerticalSpacing");
			resources[172] = Tuple.Create("SystemParameters", "IconTitleWrapKey", "IconTitleWrap");
			resources[173] = Tuple.Create("SystemParameters", "KeyboardCuesKey", "KeyboardCues");
			resources[174] = Tuple.Create("SystemParameters", "KeyboardDelayKey", "KeyboardDelay");
			resources[175] = Tuple.Create("SystemParameters", "KeyboardPreferenceKey", "KeyboardPreference");
			resources[176] = Tuple.Create("SystemParameters", "KeyboardSpeedKey", "KeyboardSpeed");
			resources[177] = Tuple.Create("SystemParameters", "SnapToDefaultButtonKey", "SnapToDefaultButton");
			resources[178] = Tuple.Create("SystemParameters", "WheelScrollLinesKey", "WheelScrollLines");
			resources[179] = Tuple.Create("SystemParameters", "MouseHoverTimeKey", "MouseHoverTime");
			resources[180] = Tuple.Create("SystemParameters", "MouseHoverHeightKey", "MouseHoverHeight");
			resources[181] = Tuple.Create("SystemParameters", "MouseHoverWidthKey", "MouseHoverWidth");
			resources[182] = Tuple.Create("SystemParameters", "MenuDropAlignmentKey", "MenuDropAlignment");
			resources[183] = Tuple.Create("SystemParameters", "MenuFadeKey", "MenuFade");
			resources[184] = Tuple.Create("SystemParameters", "MenuShowDelayKey", "MenuShowDelay");
			resources[185] = Tuple.Create("SystemParameters", "ComboBoxAnimationKey", "ComboBoxAnimation");
			resources[186] = Tuple.Create("SystemParameters", "ClientAreaAnimationKey", "ClientAreaAnimation");
			resources[187] = Tuple.Create("SystemParameters", "CursorShadowKey", "CursorShadow");
			resources[188] = Tuple.Create("SystemParameters", "GradientCaptionsKey", "GradientCaptions");
			resources[189] = Tuple.Create("SystemParameters", "HotTrackingKey", "HotTracking");
			resources[190] = Tuple.Create("SystemParameters", "ListBoxSmoothScrollingKey", "ListBoxSmoothScrolling");
			resources[191] = Tuple.Create("SystemParameters", "MenuAnimationKey", "MenuAnimation");
			resources[192] = Tuple.Create("SystemParameters", "SelectionFadeKey", "SelectionFade");
			resources[193] = Tuple.Create("SystemParameters", "StylusHotTrackingKey", "StylusHotTracking");
			resources[194] = Tuple.Create("SystemParameters", "ToolTipAnimationKey", "ToolTipAnimation");
			resources[195] = Tuple.Create("SystemParameters", "ToolTipFadeKey", "ToolTipFade");
			resources[196] = Tuple.Create("SystemParameters", "UIEffectsKey", "UIEffects");
			resources[197] = Tuple.Create("SystemParameters", "MinimizeAnimationKey", "MinimizeAnimation");
			resources[198] = Tuple.Create("SystemParameters", "BorderKey", "Border");
			resources[199] = Tuple.Create("SystemParameters", "CaretWidthKey", "CaretWidth");
			resources[200] = Tuple.Create("SystemParameters", "ForegroundFlashCountKey", "ForegroundFlashCount");
			resources[201] = Tuple.Create("SystemParameters", "DragFullWindowsKey", "DragFullWindows");
			resources[202] = Tuple.Create("SystemParameters", "BorderWidthKey", "BorderWidth");
			resources[203] = Tuple.Create("SystemParameters", "ScrollWidthKey", "ScrollWidth");
			resources[204] = Tuple.Create("SystemParameters", "ScrollHeightKey", "ScrollHeight");
			resources[205] = Tuple.Create("SystemParameters", "CaptionWidthKey", "CaptionWidth");
			resources[206] = Tuple.Create("SystemParameters", "CaptionHeightKey", "CaptionHeight");
			resources[207] = Tuple.Create("SystemParameters", "SmallCaptionWidthKey", "SmallCaptionWidth");
			resources[208] = Tuple.Create("SystemParameters", "MenuWidthKey", "MenuWidth");
			resources[209] = Tuple.Create("SystemParameters", "MenuHeightKey", "MenuHeight");
			resources[210] = Tuple.Create("SystemParameters", "ComboBoxPopupAnimationKey", "ComboBoxPopupAnimation");
			resources[211] = Tuple.Create("SystemParameters", "MenuPopupAnimationKey", "MenuPopupAnimation");
			resources[212] = Tuple.Create("SystemParameters", "ToolTipPopupAnimationKey", "ToolTipPopupAnimation");
			resources[213] = Tuple.Create("SystemParameters", "PowerLineStatusKey", "PowerLineStatus");

			resources[215] = Tuple.Create("SystemParameters", "FocusVisualStyleKey", "FocusVisualStyle");
			resources[216] = Tuple.Create("SystemParameters", "NavigationChromeDownLevelStyleKey", "NavigationChromeDownLevelStyle");
			resources[217] = Tuple.Create("SystemParameters", "NavigationChromeStyleKey", "NavigationChromeStyle");

			resources[219] = Tuple.Create("MenuItem", "SeparatorStyleKey", "MenuItemSeparatorStyle");
			resources[220] = Tuple.Create("GridView", "GridViewScrollViewerStyleKey", "GridViewScrollViewerStyle");
			resources[221] = Tuple.Create("GridView", "GridViewStyleKey", "GridViewStyle");
			resources[222] = Tuple.Create("GridView", "GridViewItemContainerStyleKey", "GridViewItemContainerStyle");
			resources[223] = Tuple.Create("StatusBar", "SeparatorStyleKey", "StatusBarSeparatorStyle");
			resources[224] = Tuple.Create("ToolBar", "ButtonStyleKey", "ToolBarButtonStyle");
			resources[225] = Tuple.Create("ToolBar", "ToggleButtonStyleKey", "ToolBarToggleButtonStyle");
			resources[226] = Tuple.Create("ToolBar", "SeparatorStyleKey", "ToolBarSeparatorStyle");
			resources[227] = Tuple.Create("ToolBar", "CheckBoxStyleKey", "ToolBarCheckBoxStyle");
			resources[228] = Tuple.Create("ToolBar", "RadioButtonStyleKey", "ToolBarRadioButtonStyle");
			resources[229] = Tuple.Create("ToolBar", "ComboBoxStyleKey", "ToolBarComboBoxStyle");
			resources[230] = Tuple.Create("ToolBar", "TextBoxStyleKey", "ToolBarTextBoxStyle");
			resources[231] = Tuple.Create("ToolBar", "MenuStyleKey", "ToolBarMenuStyle");


			resources[234] = Tuple.Create("SystemColors", "InactiveSelectionHighlightBrushKey", "InactiveSelectionHighlightBrush");
			resources[235] = Tuple.Create("SystemColors", "InactiveSelectionHighlightTextBrushKey", "InactiveSelectionHighlightTextBrush");

		}
	}
}
