/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.monitorThreads;

import com.sittinglittleduck.DirBuster.Config;
import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.WorkUnit;
import com.sittinglittleduck.DirBuster.gui.JPanelScanInfo;
import java.util.TimerTask;
import java.util.Vector;

public class ProcessChecker
extends TimerTask {
    Manager manager;
    private long timeStarted;
    private long lastTotal = 0L;
    private Vector lastTen = new Vector(10, 1);

    public ProcessChecker() {
        this.manager = Manager.getInstance();
        this.timeStarted = System.currentTimeMillis();
    }

    public void run() {
        if (System.currentTimeMillis() - this.scheduledExecutionTime() > 5000L) {
            return;
        }
        long timePassed = (this.scheduledExecutionTime() - this.timeStarted) / 1000L;
        if (timePassed > 0L) {
            int totalDirs = 1;
            if (this.manager.isRecursive() && this.manager.getDoDirs()) {
                totalDirs = 1 + this.manager.getTotalDirsFound();
            }
            int doingFiles = 1;
            if (this.manager.getDoFiles() && this.manager.getDoDirs()) {
                doingFiles = 1 + this.manager.getExtToUse().size();
            } else if (this.manager.getDoFiles() && !this.manager.getDoDirs()) {
                doingFiles = this.manager.getExtToUse().size();
            }
            long totalToDo = (long)this.manager.getTotalPass() * (long)totalDirs * (long)doingFiles;
            totalToDo += (long)this.manager.getNumberOfBaseCasesProduced();
            if (this.manager.getDoDirs()) {
                ++totalToDo;
            }
            totalToDo += (long)this.manager.getParsedLinksProcessed();
            totalToDo -= (long)this.manager.getWorkAmountCorrection();
            long currentTotal = this.manager.getTotalDone();
            long average = currentTotal / timePassed;
            long current = currentTotal - this.lastTotal;
            if (this.lastTen.size() < 10) {
                this.lastTen.addElement(current);
            } else if (this.lastTen.size() == 10) {
                this.lastTen.removeElementAt(0);
                this.lastTen.addElement(current);
            }
            long lastTenTotal = 0L;
            for (int a = 0; a < this.lastTen.size(); ++a) {
                long temp = (Long)this.lastTen.elementAt(a);
                lastTenTotal += temp;
            }
            long averageLastTen = lastTenTotal / (long)this.lastTen.size();
            String parseQueueLength = "N/A";
            if (Config.parseHTML) {
                parseQueueLength = String.valueOf(this.manager.parseQueue.size());
            }
            if (average == 0L || lastTenTotal == 0L || averageLastTen == 0L) {
                this.manager.updateProgress("Current speed: " + current + " requests/sec", "Average speed: (T) " + average + ", (C) " + averageLastTen + " requests/sec", "Total Requests: " + currentTotal + "/" + totalToDo, "Time To Finish: ~", parseQueueLength);
            } else {
                long timeLeft = (totalToDo - currentTotal) / averageLastTen;
                String timeToCompelete = this.convertSecsToTime(timeLeft);
                this.lastTotal = currentTotal;
                this.manager.updateProgress("Current speed: " + current + " requests/sec", "Average speed: (T) " + average + ", (C) " + averageLastTen + " requests/sec", "Total Requests: " + currentTotal + "/" + totalToDo, "Time To Finish: " + timeToCompelete, parseQueueLength);
            }
            if (Config.debug) {
                System.out.println("dirQ: " + this.manager.dirQueue.size());
            }
            if (!this.manager.isHeadLessMode()) {
                JPanelScanInfo tempInfo;
                if (this.manager.workQueue.peek() != null) {
                    this.manager.gui.jLabelCurrentWork.setText(((WorkUnit)this.manager.workQueue.peek()).getWork().getPath());
                } else {
                    this.manager.gui.jLabelCurrentWork.setText("");
                }
                if (this.manager.getScanType() == 0) {
                    for (int a = 0; a < this.manager.genThreads.size(); ++a) {
                        int complete = this.manager.genThreads.elementAt(a).getCurrentPoint();
                        tempInfo = (JPanelScanInfo)this.manager.gui.jPanelRunning.jPanelScanInfoBase.getComponent(a);
                        tempInfo.setProgressCurrentValue(complete);
                    }
                } else if (this.manager.getScanType() == 2) {
                    for (int a = 0; a < this.manager.genThreads.size(); ++a) {
                        int complete = this.manager.genThreads.elementAt(a).getCurrentPoint();
                        tempInfo = (JPanelScanInfo)this.manager.gui.jPanelRunning.jPanelScanInfoBase.getComponent(a);
                        tempInfo.setProgressCurrentValue(complete);
                    }
                } else if (this.manager.getScanType() == 1) {
                    JPanelScanInfo tempInfo2 = (JPanelScanInfo)this.manager.gui.jPanelRunning.jPanelScanInfoBase.getComponent(0);
                    tempInfo2.setProgressCurrentValue(this.manager.workGenFuzz.getCurrentCount());
                } else if (this.manager.getScanType() == 3) {
                    JPanelScanInfo tempInfo3 = (JPanelScanInfo)this.manager.gui.jPanelRunning.jPanelScanInfoBase.getComponent(0);
                    tempInfo3.setProgressCurrentValue(this.manager.workGenBruteFuzz.getCurrentDone());
                }
                this.manager.gui.jPanelRunning.jTabbedPaneViewResults.setTitleAt(1, "Results - List View: Dirs: " + this.manager.getTotalDirsFound() + " Files: " + this.manager.getTotalFilesFound());
            }
        }
    }

    private String convertSecsToTime(long secs) {
        if (secs < 10L) {
            return "00:00:0" + secs;
        }
        if (secs < 60L) {
            return "00:00:" + secs;
        }
        long mins = secs / 60L;
        long secsleft = secs - mins * 60L;
        String addZeroSecs = "";
        if (secsleft < 10L) {
            addZeroSecs = "0";
        }
        String addZeroMins = "";
        if (mins < 10L) {
            addZeroMins = "0";
        }
        if (mins < 60L) {
            return "00:" + addZeroMins + mins + ":" + addZeroSecs + secsleft;
        }
        long hours = mins / 60L;
        long minsleft = mins - hours * 60L;
        if (minsleft < 10L) {
            addZeroMins = "0";
        }
        if (hours > 24L) {
            long days = hours / 24L;
            if (days == 1L) {
                return days + " Day";
            }
            return days + " Days";
        }
        if (hours < 10L) {
            return "0" + hours + ":" + addZeroMins + minsleft + ":" + addZeroSecs + secsleft;
        }
        return hours + ":" + addZeroMins + minsleft + ":" + addZeroSecs + secsleft;
    }

    public static interface ProcessUpdate {
        public void isAlive();
    }
}

