/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lanchon.multidexlib2.DuplicateTypeException;
import lanchon.multidexlib2.OpcodeUtils;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.MultiDexContainer;

public class MultiDexContainerBackedDexFile<T extends DexFile>
implements DexFile {
    private final Set<? extends ClassDef> classes;
    private final Opcodes opcodes;

    public MultiDexContainerBackedDexFile(MultiDexContainer<T> container) throws IOException {
        List<String> entryNames = container.getDexEntryNames();
        if (entryNames.size() == 1) {
            String entryName = entryNames.get(0);
            T entryDex = container.getEntry(entryName).getDexFile();
            this.classes = Collections.unmodifiableSet(entryDex.getClasses());
            this.opcodes = entryDex.getOpcodes();
        } else {
            LinkedHashSet<ClassDef> accumulatedClasses = new LinkedHashSet<ClassDef>();
            Opcodes resolvedOpcodes = null;
            for (String entryName : entryNames) {
                T entryDex = container.getEntry(entryName).getDexFile();
                for (ClassDef classDef : entryDex.getClasses()) {
                    if (accumulatedClasses.add(classDef)) continue;
                    throw new DuplicateTypeException(classDef.getType());
                }
                resolvedOpcodes = OpcodeUtils.getNewestOpcodes(resolvedOpcodes, entryDex.getOpcodes(), true);
            }
            this.classes = Collections.unmodifiableSet(accumulatedClasses);
            this.opcodes = resolvedOpcodes;
        }
    }

    @Override
    public Set<? extends ClassDef> getClasses() {
        return this.classes;
    }

    @Override
    public Opcodes getOpcodes() {
        return this.opcodes;
    }
}

