/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher;

import java.io.File;
import java.io.IOException;
import lanchon.dexpatcher.Configuration;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.DexPatcher;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.multidexlib2.BasicDexFileNamer;
import lanchon.multidexlib2.DexFileNamer;
import lanchon.multidexlib2.DexIO;
import lanchon.multidexlib2.MultiDexIO;
import lanchon.multidexlib2.OpcodeUtils;
import lanchon.multidexlib2.SingletonDexContainer;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.DexFile;

public class Processor {
    private final Logger logger;
    private final Configuration config;
    private DexFileNamer dexFileNamer;
    private Opcodes opcodes;

    public static boolean processFiles(Logger logger, Configuration config) throws IOException {
        return new Processor(logger, config).processFiles();
    }

    private Processor(Logger logger, Configuration config) {
        this.logger = logger;
        this.config = config;
    }

    private boolean processFiles() throws IOException {
        long time = System.nanoTime();
        this.logger.setLogLevel(this.config.logLevel);
        this.dexFileNamer = new BasicDexFileNamer();
        if (this.config.apiLevel > 0) {
            this.opcodes = Opcodes.forApi(this.config.apiLevel);
        }
        DexFile dex = this.readDex(new File(this.config.sourceFile));
        int types = dex.getClasses().size();
        for (String patchFile : this.config.patchFiles) {
            DexFile patchDex = this.readDex(new File(patchFile));
            types += patchDex.getClasses().size();
            dex = this.processDex(dex, patchDex);
        }
        if (this.logger.hasNotLoggedErrors()) {
            if (this.config.dryRun) {
                this.logger.log(Logger.Level.INFO, "dry run due to '--dry-run' option");
            } else if (this.config.patchedFile == null) {
                this.logger.log(Logger.Level.WARN, "dry run due to missing '--output' option");
            } else {
                this.writeDex(new File(this.config.patchedFile), dex);
            }
        }
        time = System.nanoTime() - time;
        this.logStats("total process", types, time);
        this.logger.logErrorAndWarningCounts();
        return this.logger.hasNotLoggedErrors();
    }

    private Context createContext() {
        Context context = new Context(this.logger);
        context.setAnnotationPackage(this.config.annotationPackage);
        context.setConstructorAutoIgnoreDisabled(this.config.constructorAutoIgnoreDisabled);
        String root = this.config.sourceCodeRoot;
        if (root != null && root.length() > 0 && !root.endsWith(File.separator)) {
            root = root + File.separator;
        }
        context.setSourceCodeRoot(root);
        return context;
    }

    private DexFile processDex(DexFile sourceDex, DexFile patchDex) {
        long time = System.nanoTime();
        Opcodes patchedOpcodes = this.opcodes;
        if (patchedOpcodes == null) {
            int patchedDexVersion;
            int sourceDexVersion;
            Opcodes sourceOpcodes = sourceDex.getOpcodes();
            patchedOpcodes = OpcodeUtils.getNewestOpcodes(sourceOpcodes, patchDex.getOpcodes(), true);
            if (sourceOpcodes != null && patchedOpcodes != null && sourceOpcodes != patchedOpcodes && (sourceDexVersion = OpcodeUtils.getDexVersionFromOpcodes(sourceOpcodes)) != (patchedDexVersion = OpcodeUtils.getDexVersionFromOpcodes(patchedOpcodes))) {
                this.logger.log(Logger.Level.INFO, String.format("patch changes dex version from '%03d' to '%03d'", sourceDexVersion, patchedDexVersion));
            }
        }
        DexFile patchedDex = DexPatcher.process(this.createContext(), sourceDex, patchDex, patchedOpcodes);
        time = System.nanoTime() - time;
        this.logStats("patch process", sourceDex.getClasses().size() + patchDex.getClasses().size(), time);
        return patchedDex;
    }

    private DexFile readDex(File file) throws IOException {
        String message = "read '" + file + "'";
        this.logger.log(Logger.Level.INFO, message);
        long time = System.nanoTime();
        DexFile dex = MultiDexIO.readDexFile(this.config.multiDex, file, this.dexFileNamer, this.opcodes, this.getIOLogger(message));
        time = System.nanoTime() - time;
        if (this.logger.isLogging(Logger.Level.DEBUG) && this.opcodes == null && dex.getOpcodes() != null) {
            int dexVersion = OpcodeUtils.getDexVersionFromOpcodes(dex.getOpcodes());
            this.logger.log(Logger.Level.DEBUG, String.format(message + ": dex version '%03d'", dexVersion));
        }
        this.logStats(message, dex.getClasses().size(), time);
        return dex;
    }

    private void writeDex(File file, DexFile dex) throws IOException {
        String message = "write '" + file + "'";
        this.logger.log(Logger.Level.INFO, message);
        if (this.logger.isLogging(Logger.Level.DEBUG) && dex.getOpcodes() != null) {
            int dexVersion = OpcodeUtils.getDexVersionFromOpcodes(dex.getOpcodes());
            this.logger.log(Logger.Level.DEBUG, String.format(message + ": dex version '%03d'", dexVersion));
        }
        long time = System.nanoTime();
        MultiDexIO.writeDexFile(this.config.multiDex, this.config.multiDexJobs, file, this.dexFileNamer, dex, this.config.maxDexPoolSize, this.getIOLogger(message));
        time = System.nanoTime() - time;
        this.logStats(message, dex.getClasses().size(), time);
    }

    private DexIO.Logger getIOLogger(final String header) {
        if (!this.logger.isLogging(Logger.Level.DEBUG)) {
            return null;
        }
        return new DexIO.Logger(){

            @Override
            public void log(File file, String entryName, int typeCount) {
                if (Processor.this.logger.isLogging(Logger.Level.DEBUG)) {
                    String h = header;
                    if (entryName != SingletonDexContainer.UNDEFINED_ENTRY_NAME) {
                        h = h + ": file '" + entryName + "'";
                    }
                    Processor.this.logger.log(Logger.Level.DEBUG, h + ": " + typeCount + " types");
                }
            }
        };
    }

    private void logStats(String header, int typeCount, long nanoTime) {
        if (this.config.timingStats) {
            this.logger.log(Logger.Level.NONE, "stats: " + header + ": " + typeCount + " types, " + (nanoTime + 500000L) / 1000000L + " ms, " + (nanoTime / (long)typeCount + 500L) / 1000L + " us/type");
        }
    }
}

