/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import com.googlecode.d2j.DexConstants;
import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.node.DexCodeNode;
import com.googlecode.d2j.node.TryCatchNode;
import com.googlecode.d2j.node.insn.DexLabelStmtNode;
import com.googlecode.d2j.node.insn.FilledNewArrayStmtNode;
import com.googlecode.d2j.node.insn.MethodStmtNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.TypeClass;
import com.googlecode.dex2jar.ir.expr.BinopExpr;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Opcodes;

public class Dex2IrAdapter
extends DexCodeVisitor
implements Opcodes,
DexConstants {
    protected IrMethod irMethod;
    private Method method;
    private boolean isStatic;
    private StmtList list;
    private Local[] locals;
    Map<DexLabel, LabelStmt> labelStmtMap = new HashMap<DexLabel, LabelStmt>();
    private Local tmpLocal;
    boolean lastIsInvokeOrFilledNewArray = false;

    public Dex2IrAdapter(boolean isStatic, Method method) {
        IrMethod irMethod = new IrMethod();
        irMethod.args = method.getParameterTypes();
        irMethod.ret = method.getReturnType();
        irMethod.owner = method.getOwner();
        irMethod.name = method.getName();
        irMethod.isStatic = isStatic;
        this.irMethod = irMethod;
        this.list = irMethod.stmts;
        this.irMethod = irMethod;
        this.method = method;
        this.isStatic = isStatic;
    }

    private LabelStmt toLabelStmt(DexLabel label) {
        LabelStmt ls = this.labelStmtMap.get(label);
        if (ls == null) {
            ls = new LabelStmt();
            this.labelStmtMap.put(label, ls);
        }
        return ls;
    }

    static int countParameterRegisters(Method m, boolean isStatic) {
        int a = isStatic ? 0 : 1;
        String[] stringArray = m.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            switch (t.charAt(0)) {
                case 'D': 
                case 'J': {
                    a += 2;
                    break;
                }
                default: {
                    ++a;
                }
            }
            ++n2;
        }
        return a;
    }

    void x(Stmt stmt) {
        this.list.add(stmt);
    }

    public void visitRegister(int total) {
        int nextReg;
        Local[] locals = new Local[total];
        this.locals = locals;
        this.tmpLocal = new Local(total);
        int i = 0;
        while (i < locals.length) {
            locals[i] = new Local(i);
            ++i;
        }
        int nextReg0 = nextReg = total - Dex2IrAdapter.countParameterRegisters(this.method, this.isStatic);
        if (!this.isStatic) {
            this.x((Stmt)Stmts.nIdentity((Value)locals[nextReg], (Value)Exprs.nThisRef((String)this.method.getOwner())));
            ++nextReg;
        }
        String[] args = this.method.getParameterTypes();
        int i2 = 0;
        while (i2 < args.length) {
            String t = args[i2];
            this.x((Stmt)Stmts.nIdentity((Value)locals[nextReg], (Value)Exprs.nParameterRef((String)t, (int)i2)));
            ++nextReg;
            if (t.equals("J") || t.equals("D")) {
                ++nextReg;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < nextReg0) {
            this.x((Stmt)Stmts.nAssign((Value)locals[i2], (Value)Exprs.nInt((int)0)));
            ++i2;
        }
        this.x((Stmt)Stmts.nAssign((Value)this.tmpLocal, (Value)Exprs.nInt((int)0)));
    }

    public void visitStmt2R1N(Op op, int a, int b, int content) {
        BinopExpr to;
        Local va = this.locals[a];
        Local vb = this.locals[b];
        switch (op) {
            case ADD_INT_LIT16: 
            case ADD_INT_LIT8: {
                to = Exprs.nAdd((Value)vb, (Value)Exprs.nInt((int)content), (String)"I");
                break;
            }
            case RSUB_INT: 
            case RSUB_INT_LIT8: {
                to = Exprs.nSub((Value)Exprs.nInt((int)content), (Value)vb, (String)"I");
                break;
            }
            case MUL_INT_LIT16: 
            case MUL_INT_LIT8: {
                to = Exprs.nMul((Value)vb, (Value)Exprs.nInt((int)content), (String)"I");
                break;
            }
            case DIV_INT_LIT16: 
            case DIV_INT_LIT8: {
                to = Exprs.nDiv((Value)vb, (Value)Exprs.nInt((int)content), (String)"I");
                break;
            }
            case REM_INT_LIT16: 
            case REM_INT_LIT8: {
                to = Exprs.nRem((Value)vb, (Value)Exprs.nInt((int)content), (String)"I");
                break;
            }
            case AND_INT_LIT16: 
            case AND_INT_LIT8: {
                to = Exprs.nAnd((Value)vb, (Value)Exprs.nInt((int)content), (String)(content < 0 || content > 1 ? "I" : TypeClass.ZI.name));
                break;
            }
            case OR_INT_LIT16: 
            case OR_INT_LIT8: {
                to = Exprs.nOr((Value)vb, (Value)Exprs.nInt((int)content), (String)(content < 0 || content > 1 ? "I" : TypeClass.ZI.name));
                break;
            }
            case XOR_INT_LIT16: 
            case XOR_INT_LIT8: {
                to = Exprs.nXor((Value)vb, (Value)Exprs.nInt((int)content), (String)(content < 0 || content > 1 ? "I" : TypeClass.ZI.name));
                break;
            }
            case SHL_INT_LIT8: {
                to = Exprs.nShl((Value)vb, (Value)Exprs.nInt((int)content), (String)"I");
                break;
            }
            case SHR_INT_LIT8: {
                to = Exprs.nShr((Value)vb, (Value)Exprs.nInt((int)content), (String)"I");
                break;
            }
            case USHR_INT_LIT8: {
                to = Exprs.nUshr((Value)vb, (Value)Exprs.nInt((int)content), (String)"I");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.x((Stmt)Stmts.nAssign((Value)va, (Value)to));
    }

    public void visitStmt3R(Op op, int a, int b, int c) {
        Local va = this.locals[a];
        Local vb = this.locals[b];
        Local vc = this.locals[c];
        switch (op) {
            case APUT: {
                this.x((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)vb, (Value)vc, (String)TypeClass.IF.name), (Value)va));
                break;
            }
            case APUT_BOOLEAN: {
                this.x((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)vb, (Value)vc, (String)"Z"), (Value)va));
                break;
            }
            case APUT_BYTE: {
                this.x((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)vb, (Value)vc, (String)"B"), (Value)va));
                break;
            }
            case APUT_CHAR: {
                this.x((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)vb, (Value)vc, (String)"C"), (Value)va));
                break;
            }
            case APUT_OBJECT: {
                this.x((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)vb, (Value)vc, (String)"L"), (Value)va));
                break;
            }
            case APUT_SHORT: {
                this.x((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)vb, (Value)vc, (String)"S"), (Value)va));
                break;
            }
            case APUT_WIDE: {
                this.x((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)vb, (Value)vc, (String)TypeClass.JD.name), (Value)va));
                break;
            }
            case AGET: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nArray((Value)vb, (Value)vc, (String)TypeClass.IF.name)));
                break;
            }
            case AGET_BOOLEAN: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nArray((Value)vb, (Value)vc, (String)"Z")));
                break;
            }
            case AGET_BYTE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nArray((Value)vb, (Value)vc, (String)"B")));
                break;
            }
            case AGET_CHAR: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nArray((Value)vb, (Value)vc, (String)"C")));
                break;
            }
            case AGET_OBJECT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nArray((Value)vb, (Value)vc, (String)"L")));
                break;
            }
            case AGET_SHORT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nArray((Value)vb, (Value)vc, (String)"S")));
                break;
            }
            case AGET_WIDE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nArray((Value)vb, (Value)vc, (String)TypeClass.JD.name)));
                break;
            }
            case CMP_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nLCmp((Value)vb, (Value)vc)));
                break;
            }
            case CMPG_DOUBLE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nDCmpg((Value)vb, (Value)vc)));
                break;
            }
            case CMPG_FLOAT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nFCmpg((Value)vb, (Value)vc)));
                break;
            }
            case CMPL_DOUBLE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nDCmpl((Value)vb, (Value)vc)));
                break;
            }
            case CMPL_FLOAT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nFCmpl((Value)vb, (Value)vc)));
                break;
            }
            case ADD_DOUBLE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nAdd((Value)vb, (Value)vc, (String)"D")));
                break;
            }
            case ADD_FLOAT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nAdd((Value)vb, (Value)vc, (String)"F")));
                break;
            }
            case ADD_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nAdd((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case ADD_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nAdd((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case SUB_DOUBLE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nSub((Value)vb, (Value)vc, (String)"D")));
                break;
            }
            case SUB_FLOAT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nSub((Value)vb, (Value)vc, (String)"F")));
                break;
            }
            case SUB_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nSub((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case SUB_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nSub((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case MUL_DOUBLE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nMul((Value)vb, (Value)vc, (String)"D")));
                break;
            }
            case MUL_FLOAT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nMul((Value)vb, (Value)vc, (String)"F")));
                break;
            }
            case MUL_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nMul((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case MUL_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nMul((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case DIV_DOUBLE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nDiv((Value)vb, (Value)vc, (String)"D")));
                break;
            }
            case DIV_FLOAT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nDiv((Value)vb, (Value)vc, (String)"F")));
                break;
            }
            case DIV_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nDiv((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case DIV_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nDiv((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case REM_DOUBLE: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nRem((Value)vb, (Value)vc, (String)"D")));
                break;
            }
            case REM_FLOAT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nRem((Value)vb, (Value)vc, (String)"F")));
                break;
            }
            case REM_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nRem((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case REM_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nRem((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case AND_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nAnd((Value)vb, (Value)vc, (String)TypeClass.ZI.name)));
                break;
            }
            case AND_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nAnd((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case OR_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nOr((Value)vb, (Value)vc, (String)TypeClass.ZI.name)));
                break;
            }
            case OR_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nOr((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case XOR_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nXor((Value)vb, (Value)vc, (String)TypeClass.ZI.name)));
                break;
            }
            case XOR_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nXor((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case SHL_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nShl((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case SHL_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nShl((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case SHR_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nShr((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case SHR_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nShr((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            case USHR_INT: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nUshr((Value)vb, (Value)vc, (String)"I")));
                break;
            }
            case USHR_LONG: {
                this.x((Stmt)Stmts.nAssign((Value)va, (Value)Exprs.nUshr((Value)vb, (Value)vc, (String)"J")));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void visitTypeStmt(Op op, int a, int b, String type) {
        switch (op) {
            case INSTANCE_OF: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nInstanceOf((Value)this.locals[b], (String)type)));
                break;
            }
            case NEW_ARRAY: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nNewArray((String)type.substring(1), (Value)this.locals[b])));
                break;
            }
            case CHECK_CAST: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nCheckCast((Value)this.locals[a], (String)type)));
                break;
            }
            case NEW_INSTANCE: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nNew((String)type)));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void visitFillArrayDataStmt(Op op, int ra, Object array) {
        this.x((Stmt)Stmts.nFillArrayData((Value)this.locals[ra], (Value)Exprs.nArrayValue((Object)array)));
    }

    public void visitConstStmt(Op op, int toReg, Object value) {
        switch (op) {
            case CONST_4: 
            case CONST_16: 
            case CONST: 
            case CONST_HIGH16: {
                this.x((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Exprs.nInt((int)((Integer)value))));
                break;
            }
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: 
            case CONST_WIDE_HIGH16: {
                this.x((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Exprs.nLong((long)((Long)value))));
                break;
            }
            case CONST_CLASS: {
                this.x((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Exprs.nType((String)((DexType)value).desc)));
                break;
            }
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                this.x((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Exprs.nString((String)((String)value))));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void visitEnd() {
        this.irMethod.locals.addAll(Arrays.asList(this.locals));
        this.irMethod.locals.add(this.tmpLocal);
        this.locals = null;
    }

    public void visitFieldStmt(Op op, int a, int b, Field field) {
        switch (op) {
            case IGET: 
            case IGET_WIDE: 
            case IGET_OBJECT: 
            case IGET_BOOLEAN: 
            case IGET_BYTE: 
            case IGET_CHAR: 
            case IGET_SHORT: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nField((Value)this.locals[b], (String)field.getOwner(), (String)field.getName(), (String)field.getType())));
                break;
            }
            case IPUT: 
            case IPUT_WIDE: 
            case IPUT_OBJECT: 
            case IPUT_BOOLEAN: 
            case IPUT_BYTE: 
            case IPUT_CHAR: 
            case IPUT_SHORT: {
                this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nField((Value)this.locals[b], (String)field.getOwner(), (String)field.getName(), (String)field.getType()), (Value)this.locals[a]));
                break;
            }
            case SGET: 
            case SGET_WIDE: 
            case SGET_OBJECT: 
            case SGET_BOOLEAN: 
            case SGET_BYTE: 
            case SGET_CHAR: 
            case SGET_SHORT: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nStaticField((String)field.getOwner(), (String)field.getName(), (String)field.getType())));
                break;
            }
            case SPUT: 
            case SPUT_WIDE: 
            case SPUT_OBJECT: 
            case SPUT_BOOLEAN: 
            case SPUT_BYTE: 
            case SPUT_CHAR: 
            case SPUT_SHORT: {
                this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nStaticField((String)field.getOwner(), (String)field.getName(), (String)field.getType()), (Value)this.locals[a]));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void visitFilledNewArrayStmt(Op opc, int[] args, String type) {
        Local array = this.tmpLocal;
        String elem = type.substring(1);
        this.list.add((Stmt)Stmts.nAssign((Value)array, (Value)Exprs.nNewArray((String)elem, (Value)Exprs.nInt((int)args.length))));
        int i = 0;
        while (i < args.length) {
            this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)array, (Value)Exprs.nInt((int)i), (String)elem), (Value)this.locals[args[i]]));
            ++i;
        }
    }

    public void visitJumpStmt(Op op, int a, int b, DexLabel label) {
        switch (op) {
            case GOTO: 
            case GOTO_16: 
            case GOTO_32: {
                this.x((Stmt)Stmts.nGoto((LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_EQ: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nEq((Value)this.locals[a], (Value)this.locals[b], (String)TypeClass.ZIL.name), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_GE: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nGe((Value)this.locals[a], (Value)this.locals[b], (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_GT: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nGt((Value)this.locals[a], (Value)this.locals[b], (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_LE: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nLe((Value)this.locals[a], (Value)this.locals[b], (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_LT: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nLt((Value)this.locals[a], (Value)this.locals[b], (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_NE: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nNe((Value)this.locals[a], (Value)this.locals[b], (String)TypeClass.ZIL.name), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_EQZ: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nEq((Value)this.locals[a], (Value)Exprs.nInt((int)0), (String)TypeClass.ZIL.name), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_GEZ: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nGe((Value)this.locals[a], (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_GTZ: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nGt((Value)this.locals[a], (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_LEZ: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nLe((Value)this.locals[a], (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_LTZ: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nLt((Value)this.locals[a], (Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            case IF_NEZ: {
                this.x((Stmt)Stmts.nIf((Value)Exprs.nNe((Value)this.locals[a], (Value)Exprs.nInt((int)0), (String)TypeClass.ZIL.name), (LabelStmt)this.toLabelStmt(label)));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void visitLabel(DexLabel label) {
        this.list.add((Stmt)this.toLabelStmt(label));
    }

    public void visitSparseSwitchStmt(Op op, int aA, int[] cases, DexLabel[] labels) {
        LabelStmt[] lss = new LabelStmt[cases.length];
        int i = 0;
        while (i < cases.length) {
            lss[i] = this.toLabelStmt(labels[i]);
            ++i;
        }
        LabelStmt d = new LabelStmt();
        this.x((Stmt)Stmts.nLookupSwitch((Value)this.locals[aA], (int[])cases, (LabelStmt[])lss, (LabelStmt)d));
        this.x((Stmt)d);
    }

    public void visitMethodStmt(Op op, int[] args, Method method) {
        Value[] vs;
        if (args.length > 0) {
            int i = 0;
            ArrayList<Local> ps = new ArrayList<Local>(args.length);
            if (op != Op.INVOKE_STATIC && op != Op.INVOKE_STATIC_RANGE) {
                ps.add(this.locals[args[i]]);
                ++i;
            }
            String[] stringArray = method.getParameterTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                ps.add(this.locals[args[i]]);
                i = t.equals("J") || t.equals("D") ? (i += 2) : ++i;
                ++n2;
            }
            vs = ps.toArray(new Value[ps.size()]);
        } else {
            vs = new Value[]{};
        }
        InvokeExpr invoke = null;
        switch (op) {
            case INVOKE_VIRTUAL: 
            case INVOKE_VIRTUAL_RANGE: {
                invoke = Exprs.nInvokeVirtual((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                break;
            }
            case INVOKE_SUPER: 
            case INVOKE_DIRECT: 
            case INVOKE_SUPER_RANGE: 
            case INVOKE_DIRECT_RANGE: {
                invoke = Exprs.nInvokeSpecial((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                break;
            }
            case INVOKE_STATIC: 
            case INVOKE_STATIC_RANGE: {
                invoke = Exprs.nInvokeStatic((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                break;
            }
            case INVOKE_INTERFACE: 
            case INVOKE_INTERFACE_RANGE: {
                invoke = Exprs.nInvokeInterface((Value[])vs, (String)method.getOwner(), (String)method.getName(), (String[])method.getParameterTypes(), (String)method.getReturnType());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if ("V".equals(method.getReturnType())) {
            this.x((Stmt)Stmts.nVoidInvoke((Value)invoke));
        } else {
            this.x((Stmt)Stmts.nAssign((Value)this.tmpLocal, (Value)invoke));
        }
    }

    public void visitStmt1R(Op op, int reg) {
        Local va = this.locals[reg];
        switch (op) {
            case MONITOR_ENTER: {
                this.x((Stmt)Stmts.nLock((Value)va));
                break;
            }
            case MONITOR_EXIT: {
                this.x((Stmt)Stmts.nUnLock((Value)va));
                break;
            }
            case RETURN: 
            case RETURN_WIDE: 
            case RETURN_OBJECT: {
                this.x((Stmt)Stmts.nReturn((Value)va));
                break;
            }
            case THROW: {
                this.x((Stmt)Stmts.nThrow((Value)va));
                break;
            }
            case MOVE_RESULT: 
            case MOVE_RESULT_WIDE: 
            case MOVE_RESULT_OBJECT: {
                if (this.lastIsInvokeOrFilledNewArray) {
                    this.x((Stmt)Stmts.nAssign((Value)va, (Value)this.tmpLocal));
                    break;
                }
                System.err.println("WARN: find wrong position of " + op + " in method " + this.method);
                this.x((Stmt)Stmts.nThrow((Value)Exprs.nInvokeNew((Value[])new Value[]{Exprs.nString((String)("d2j: wrong position of " + op))}, (String[])new String[]{"Ljava/lang/String;"}, (String)"Ljava/lang/RuntimeException;")));
                break;
            }
            case MOVE_EXCEPTION: {
                this.x((Stmt)Stmts.nIdentity((Value)va, (Value)Exprs.nExceptionRef((String)"Ljava/lang/Throwable;")));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void visitStmt2R(Op op, int a, int b) {
        Local va = this.locals[a];
        Local vb = this.locals[b];
        Local to = null;
        switch (op) {
            case MOVE: 
            case MOVE_FROM16: 
            case MOVE_16: 
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: 
            case MOVE_OBJECT: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_OBJECT_16: {
                to = vb;
                break;
            }
            case ARRAY_LENGTH: {
                to = Exprs.nLength((Value)vb);
                break;
            }
            case ADD_DOUBLE_2ADDR: {
                to = Exprs.nAdd((Value)va, (Value)vb, (String)"D");
                break;
            }
            case ADD_FLOAT_2ADDR: {
                to = Exprs.nAdd((Value)va, (Value)vb, (String)"F");
                break;
            }
            case ADD_INT_2ADDR: {
                to = Exprs.nAdd((Value)va, (Value)vb, (String)"I");
                break;
            }
            case ADD_LONG_2ADDR: {
                to = Exprs.nAdd((Value)va, (Value)vb, (String)"J");
                break;
            }
            case SUB_DOUBLE_2ADDR: {
                to = Exprs.nSub((Value)va, (Value)vb, (String)"D");
                break;
            }
            case SUB_FLOAT_2ADDR: {
                to = Exprs.nSub((Value)va, (Value)vb, (String)"F");
                break;
            }
            case SUB_INT_2ADDR: {
                to = Exprs.nSub((Value)va, (Value)vb, (String)"I");
                break;
            }
            case SUB_LONG_2ADDR: {
                to = Exprs.nSub((Value)va, (Value)vb, (String)"J");
                break;
            }
            case MUL_DOUBLE_2ADDR: {
                to = Exprs.nMul((Value)va, (Value)vb, (String)"D");
                break;
            }
            case MUL_FLOAT_2ADDR: {
                to = Exprs.nMul((Value)va, (Value)vb, (String)"F");
                break;
            }
            case MUL_INT_2ADDR: {
                to = Exprs.nMul((Value)va, (Value)vb, (String)"I");
                break;
            }
            case MUL_LONG_2ADDR: {
                to = Exprs.nMul((Value)va, (Value)vb, (String)"J");
                break;
            }
            case DIV_DOUBLE_2ADDR: {
                to = Exprs.nDiv((Value)va, (Value)vb, (String)"D");
                break;
            }
            case DIV_FLOAT_2ADDR: {
                to = Exprs.nDiv((Value)va, (Value)vb, (String)"F");
                break;
            }
            case DIV_INT_2ADDR: {
                to = Exprs.nDiv((Value)va, (Value)vb, (String)"I");
                break;
            }
            case DIV_LONG_2ADDR: {
                to = Exprs.nDiv((Value)va, (Value)vb, (String)"J");
                break;
            }
            case REM_DOUBLE_2ADDR: {
                to = Exprs.nRem((Value)va, (Value)vb, (String)"D");
                break;
            }
            case REM_FLOAT_2ADDR: {
                to = Exprs.nRem((Value)va, (Value)vb, (String)"F");
                break;
            }
            case REM_INT_2ADDR: {
                to = Exprs.nRem((Value)va, (Value)vb, (String)"I");
                break;
            }
            case REM_LONG_2ADDR: {
                to = Exprs.nRem((Value)va, (Value)vb, (String)"J");
                break;
            }
            case AND_INT_2ADDR: {
                to = Exprs.nAnd((Value)va, (Value)vb, (String)TypeClass.ZI.name);
                break;
            }
            case AND_LONG_2ADDR: {
                to = Exprs.nAnd((Value)va, (Value)vb, (String)"J");
                break;
            }
            case OR_INT_2ADDR: {
                to = Exprs.nOr((Value)va, (Value)vb, (String)TypeClass.ZI.name);
                break;
            }
            case OR_LONG_2ADDR: {
                to = Exprs.nOr((Value)va, (Value)vb, (String)"J");
                break;
            }
            case XOR_INT_2ADDR: {
                to = Exprs.nXor((Value)va, (Value)vb, (String)TypeClass.ZI.name);
                break;
            }
            case XOR_LONG_2ADDR: {
                to = Exprs.nXor((Value)va, (Value)vb, (String)"J");
                break;
            }
            case SHL_INT_2ADDR: {
                to = Exprs.nShl((Value)va, (Value)vb, (String)"I");
                break;
            }
            case SHL_LONG_2ADDR: {
                to = Exprs.nShl((Value)va, (Value)vb, (String)"J");
                break;
            }
            case SHR_INT_2ADDR: {
                to = Exprs.nShr((Value)va, (Value)vb, (String)"I");
                break;
            }
            case SHR_LONG_2ADDR: {
                to = Exprs.nShr((Value)va, (Value)vb, (String)"J");
                break;
            }
            case USHR_INT_2ADDR: {
                to = Exprs.nUshr((Value)va, (Value)vb, (String)"I");
                break;
            }
            case USHR_LONG_2ADDR: {
                to = Exprs.nUshr((Value)va, (Value)vb, (String)"J");
                break;
            }
            case NOT_INT: {
                to = Exprs.nNot((Value)vb, (String)"I");
                break;
            }
            case NOT_LONG: {
                to = Exprs.nNot((Value)vb, (String)"J");
                break;
            }
            case NEG_DOUBLE: {
                to = Exprs.nNeg((Value)vb, (String)"D");
                break;
            }
            case NEG_FLOAT: {
                to = Exprs.nNeg((Value)vb, (String)"F");
                break;
            }
            case NEG_INT: {
                to = Exprs.nNeg((Value)vb, (String)"I");
                break;
            }
            case NEG_LONG: {
                to = Exprs.nNeg((Value)vb, (String)"J");
                break;
            }
            case INT_TO_BYTE: {
                to = Exprs.nCast((Value)vb, (String)"I", (String)"B");
                break;
            }
            case INT_TO_CHAR: {
                to = Exprs.nCast((Value)vb, (String)"I", (String)"C");
                break;
            }
            case INT_TO_DOUBLE: {
                to = Exprs.nCast((Value)vb, (String)"I", (String)"D");
                break;
            }
            case INT_TO_FLOAT: {
                to = Exprs.nCast((Value)vb, (String)"I", (String)"F");
                break;
            }
            case INT_TO_LONG: {
                to = Exprs.nCast((Value)vb, (String)"I", (String)"J");
                break;
            }
            case INT_TO_SHORT: {
                to = Exprs.nCast((Value)vb, (String)"I", (String)"S");
                break;
            }
            case FLOAT_TO_DOUBLE: {
                to = Exprs.nCast((Value)vb, (String)"F", (String)"D");
                break;
            }
            case FLOAT_TO_INT: {
                to = Exprs.nCast((Value)vb, (String)"F", (String)"I");
                break;
            }
            case FLOAT_TO_LONG: {
                to = Exprs.nCast((Value)vb, (String)"F", (String)"J");
                break;
            }
            case DOUBLE_TO_FLOAT: {
                to = Exprs.nCast((Value)vb, (String)"D", (String)"F");
                break;
            }
            case DOUBLE_TO_INT: {
                to = Exprs.nCast((Value)vb, (String)"D", (String)"I");
                break;
            }
            case DOUBLE_TO_LONG: {
                to = Exprs.nCast((Value)vb, (String)"D", (String)"J");
                break;
            }
            case LONG_TO_DOUBLE: {
                to = Exprs.nCast((Value)vb, (String)"J", (String)"D");
                break;
            }
            case LONG_TO_FLOAT: {
                to = Exprs.nCast((Value)vb, (String)"J", (String)"F");
                break;
            }
            case LONG_TO_INT: {
                to = Exprs.nCast((Value)vb, (String)"J", (String)"I");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        this.x((Stmt)Stmts.nAssign((Value)va, (Value)to));
    }

    public void visitStmt0R(Op op) {
        switch (op) {
            case RETURN_VOID: {
                this.x((Stmt)Stmts.nReturnVoid());
                break;
            }
            case NOP: {
                break;
            }
            case BAD_OP: {
                this.x((Stmt)Stmts.nThrow((Value)Exprs.nInvokeNew((Value[])new Value[]{Exprs.nString((String)"bad dex opcode")}, (String[])new String[]{"Ljava/lang/String;"}, (String)"Ljava/lang/VerifyError;")));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void visitPackedSwitchStmt(Op op, int aA, int first_case, DexLabel[] labels) {
        LabelStmt[] lss = new LabelStmt[labels.length];
        int i = 0;
        while (i < labels.length) {
            lss[i] = this.toLabelStmt(labels[i]);
            ++i;
        }
        LabelStmt d = new LabelStmt();
        this.x((Stmt)Stmts.nTableSwitch((Value)this.locals[aA], (int)first_case, (LabelStmt[])lss, (LabelStmt)d));
        this.x((Stmt)d);
    }

    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel[] handlers, String[] types) {
        LabelStmt[] xlabelStmts = new LabelStmt[types.length];
        int i = 0;
        while (i < types.length) {
            xlabelStmts[i] = this.toLabelStmt(handlers[i]);
            ++i;
        }
        this.irMethod.traps.add(new Trap(this.toLabelStmt(start), this.toLabelStmt(end), xlabelStmts, types));
    }

    public IrMethod convert(DexCodeNode codeNode) {
        DexDebugVisitor ddv;
        if (codeNode.tryStmts != null) {
            for (TryCatchNode n : codeNode.tryStmts) {
                n.accept((DexCodeVisitor)this);
            }
        }
        if (codeNode.debugNode != null && (ddv = this.visitDebug()) != null) {
            codeNode.debugNode.accept(ddv);
            ddv.visitEnd();
        }
        this.lastIsInvokeOrFilledNewArray = false;
        if (codeNode.totalRegister >= 0) {
            this.visitRegister(codeNode.totalRegister);
        }
        for (TryCatchNode n : codeNode.stmts) {
            n.accept((DexCodeVisitor)this);
            if (n instanceof FilledNewArrayStmtNode) {
                this.lastIsInvokeOrFilledNewArray = true;
                continue;
            }
            if (n instanceof MethodStmtNode) {
                this.lastIsInvokeOrFilledNewArray = !((MethodStmtNode)n).method.getReturnType().equals("V");
                continue;
            }
            if (n instanceof DexLabelStmtNode) continue;
            this.lastIsInvokeOrFilledNewArray = false;
        }
        this.visitEnd();
        return this.irMethod;
    }
}

