/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.converter;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class J2IRConverter {
    Map<Label, LabelStmt> map = new HashMap<Label, LabelStmt>();
    InsnList insnList;
    int[] parentCount;
    JvmFrame[] frames;
    MethodNode methodNode;
    IrMethod target;
    List<Stmt>[] emitStmts;
    List<Stmt> preEmit = new ArrayList<Stmt>();
    List<Stmt> currentEmit;

    private J2IRConverter() {
    }

    public static IrMethod convert(String owner, MethodNode methodNode) throws AnalyzerException {
        return new J2IRConverter().convert0(owner, methodNode);
    }

    LabelStmt getLabel(LabelNode labelNode) {
        Label label = labelNode.getLabel();
        LabelStmt ls = this.map.get(label);
        if (ls == null) {
            ls = Stmts.nLabel();
            this.map.put(label, ls);
        }
        return ls;
    }

    void emit(Stmt stmt) {
        this.currentEmit.add(stmt);
    }

    IrMethod populate(String owner, MethodNode source) {
        IrMethod target = new IrMethod();
        target.name = source.name;
        target.owner = "L" + owner + ";";
        target.ret = Type.getReturnType((String)source.desc).getDescriptor();
        Type[] args = Type.getArgumentTypes((String)source.desc);
        String[] sArgs = new String[args.length];
        target.args = sArgs;
        int i = 0;
        while (i < args.length) {
            sArgs[i] = args[i].getDescriptor();
            ++i;
        }
        target.isStatic = (source.access & 8) != 0;
        return target;
    }

    IrMethod convert0(String owner, MethodNode methodNode) throws AnalyzerException {
        this.methodNode = methodNode;
        this.target = this.populate(owner, methodNode);
        if (methodNode.instructions.size() == 0) {
            return this.target;
        }
        this.insnList = methodNode.instructions;
        BitSet[] exBranch = new BitSet[this.insnList.size()];
        this.parentCount = new int[this.insnList.size()];
        this.initParentCount(this.parentCount);
        BitSet handlers = new BitSet(this.insnList.size());
        if (methodNode.tryCatchBlocks != null) {
            for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
                this.target.traps.add(new Trap(this.getLabel(tcb.start), this.getLabel(tcb.end), new LabelStmt[]{this.getLabel(tcb.handler)}, new String[]{tcb.type}));
                int handlerIdx = this.insnList.indexOf((AbstractInsnNode)tcb.handler);
                handlers.set(handlerIdx);
                AbstractInsnNode p = tcb.start.getNext();
                while (p != tcb.end) {
                    BitSet x = exBranch[this.insnList.indexOf(p)];
                    if (x == null) {
                        BitSet bitSet = new BitSet(this.insnList.size());
                        exBranch[this.insnList.indexOf((AbstractInsnNode)p)] = bitSet;
                        x = bitSet;
                    }
                    x.set(handlerIdx);
                    int n = handlerIdx;
                    this.parentCount[n] = this.parentCount[n] + 1;
                    p = p.getNext();
                }
            }
        }
        Interpreter<JvmValue> interpreter = this.buildInterpreter();
        this.frames = new JvmFrame[this.insnList.size()];
        this.emitStmts = new ArrayList[this.insnList.size()];
        BitSet access = new BitSet(this.insnList.size());
        this.dfs(exBranch, handlers, access, interpreter);
        StmtList stmts = this.target.stmts;
        stmts.addAll(this.preEmit);
        int i = 0;
        while (i < this.insnList.size()) {
            AbstractInsnNode p = this.insnList.get(i);
            if (access.get(i)) {
                List<Stmt> es = this.emitStmts[i];
                if (es != null) {
                    stmts.addAll(es);
                }
            } else if (p.getType() == 8) {
                stmts.add((Stmt)this.getLabel((LabelNode)p));
            }
            ++i;
        }
        this.emitStmts = null;
        LinkedList<JvmValue> queue = new LinkedList<JvmValue>();
        int i1 = 0;
        while (i1 < this.frames.length) {
            JvmFrame frame = this.frames[i1];
            if (this.parentCount[i1] > 1 && frame != null && access.get(i1)) {
                int j = 0;
                while (j < frame.getLocals()) {
                    JvmValue v = (JvmValue)frame.getLocal(j);
                    this.addToQueue(queue, v);
                    ++j;
                }
                j = 0;
                while (j < frame.getStackSize()) {
                    this.addToQueue(queue, (JvmValue)frame.getStack(j));
                    ++j;
                }
            }
            ++i1;
        }
        while (!queue.isEmpty()) {
            JvmValue v = (JvmValue)queue.poll();
            this.getLocal(v);
            if (v.parent != null && v.parent.local == null) {
                queue.add(v.parent);
            }
            if (v.otherParent == null) continue;
            for (JvmValue v2 : v.otherParent) {
                if (v2.local != null) continue;
                queue.add(v2);
            }
        }
        HashSet<com.googlecode.dex2jar.ir.expr.Value> phiValues = new HashSet<com.googlecode.dex2jar.ir.expr.Value>();
        ArrayList<LabelStmt> phiLabels = new ArrayList<LabelStmt>();
        int i2 = 0;
        while (i2 < this.frames.length) {
            JvmFrame frame = this.frames[i2];
            if (this.parentCount[i2] > 1 && frame != null && access.get(i2)) {
                AbstractInsnNode p = this.insnList.get(i2);
                LabelStmt labelStmt = this.getLabel((LabelNode)p);
                ArrayList<AssignStmt> phis = new ArrayList<AssignStmt>();
                int j = 0;
                while (j < frame.getLocals()) {
                    JvmValue v = (JvmValue)frame.getLocal(j);
                    this.addPhi(v, phiValues, phis);
                    ++j;
                }
                j = 0;
                while (j < frame.getStackSize()) {
                    this.addPhi((JvmValue)frame.getStack(j), phiValues, phis);
                    ++j;
                }
                labelStmt.phis = phis;
                phiLabels.add(labelStmt);
            }
            ++i2;
        }
        if (phiLabels.size() > 0) {
            this.target.phiLabels = phiLabels;
        }
        return this.target;
    }

    private void addPhi(JvmValue v, Set<com.googlecode.dex2jar.ir.expr.Value> phiValues, List<AssignStmt> phis) {
        if (v != null && v.local != null) {
            if (v.parent != null) {
                phiValues.add((com.googlecode.dex2jar.ir.expr.Value)this.getLocal(v.parent));
            }
            if (v.otherParent != null) {
                for (JvmValue v2 : v.otherParent) {
                    phiValues.add((com.googlecode.dex2jar.ir.expr.Value)this.getLocal(v2));
                }
            }
            if (phiValues.size() > 0) {
                phis.add(Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)v.local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nPhi((com.googlecode.dex2jar.ir.expr.Value[])phiValues.toArray(new com.googlecode.dex2jar.ir.expr.Value[phiValues.size()]))));
                phiValues.clear();
            }
        }
    }

    private void addToQueue(Queue<JvmValue> queue, JvmValue v) {
        if (v != null && v.local != null) {
            if (v.parent != null && v.parent.local == null) {
                queue.add(v.parent);
            }
            if (v.otherParent != null) {
                for (JvmValue v2 : v.otherParent) {
                    if (v2.local != null) continue;
                    queue.add(v2);
                }
            }
        }
    }

    private void dfs(BitSet[] exBranch, BitSet handlers, BitSet access, Interpreter<JvmValue> interpreter) throws AnalyzerException {
        this.currentEmit = this.preEmit;
        JvmFrame first = this.initFirstFrame(this.methodNode, this.target);
        if (this.parentCount[0] > 1) {
            this.merge(first, 0);
        } else {
            this.frames[0] = first;
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(this.insnList.getFirst());
        JvmFrame tmp = new JvmFrame(this.methodNode.maxLocals, this.methodNode.maxStack);
        while (!stack.isEmpty()) {
            BitSet ex;
            AbstractInsnNode p = (AbstractInsnNode)stack.pop();
            int index = this.insnList.indexOf(p);
            if (access.get(index)) continue;
            access.set(index);
            JvmFrame frame = this.frames[index];
            this.setCurrentEmit(index);
            if (p.getType() == 8) {
                this.emit((Stmt)this.getLabel((LabelNode)p));
                if (handlers.get(index)) {
                    ex = this.newLocal();
                    this.emit((Stmt)Stmts.nIdentity((com.googlecode.dex2jar.ir.expr.Value)ex, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nExceptionRef((String)"Ljava/lang/Throwable;")));
                    frame.clearStack();
                    frame.push(new JvmValue(1, (Local)ex));
                }
            }
            if ((ex = exBranch[index]) != null) {
                int i = ex.nextSetBit(0);
                while (i >= 0) {
                    this.mergeEx(frame, i);
                    stack.push(this.insnList.get(i));
                    i = ex.nextSetBit(i + 1);
                }
            }
            tmp.init(frame);
            tmp.execute(p, interpreter);
            int op = p.getOpcode();
            if (p.getType() == 7) {
                JumpInsnNode jump = (JumpInsnNode)p;
                stack.push(jump.label);
                this.merge(tmp, this.insnList.indexOf((AbstractInsnNode)jump.label));
            }
            if (op == 170 || op == 171) {
                if (op == 170) {
                    TableSwitchInsnNode tsin = (TableSwitchInsnNode)p;
                    for (LabelNode label : tsin.labels) {
                        stack.push(label);
                        this.merge(tmp, this.insnList.indexOf((AbstractInsnNode)label));
                    }
                    stack.push(tsin.dflt);
                    this.merge(tmp, this.insnList.indexOf((AbstractInsnNode)tsin.dflt));
                } else {
                    LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)p;
                    for (LabelNode label : lsin.labels) {
                        stack.push(label);
                        this.merge(tmp, this.insnList.indexOf((AbstractInsnNode)label));
                    }
                    stack.push(lsin.dflt);
                    this.merge(tmp, this.insnList.indexOf((AbstractInsnNode)lsin.dflt));
                }
            }
            if ((op < 167 || op > 177) && op != 191) {
                stack.push(p.getNext());
                this.merge(tmp, index + 1);
            }
            if (this.parentCount[index] > 1) continue;
            this.frames[index] = null;
        }
    }

    private void setCurrentEmit(int index) {
        this.currentEmit = this.emitStmts[index];
        if (this.currentEmit == null) {
            this.emitStmts[index] = new ArrayList<Stmt>(1);
            this.currentEmit = this.emitStmts[index];
        }
    }

    private Interpreter<JvmValue> buildInterpreter() {
        return new Interpreter<JvmValue>(262144){

            public JvmValue newValue(Type type) {
                return null;
            }

            public JvmValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
                switch (insn.getOpcode()) {
                    case 1: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNull());
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)(insn.getOpcode() - 3)));
                    }
                    case 9: 
                    case 10: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLong((long)(insn.getOpcode() - 9)));
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFloat((float)(insn.getOpcode() - 11)));
                    }
                    case 14: 
                    case 15: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDouble((double)(insn.getOpcode() - 14)));
                    }
                    case 16: 
                    case 17: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)((IntInsnNode)insn).operand));
                    }
                    case 18: {
                        Object cst = ((LdcInsnNode)insn).cst;
                        if (cst instanceof Integer) {
                            return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)((Integer)cst)));
                        }
                        if (cst instanceof Float) {
                            return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFloat((float)((Float)cst).floatValue()));
                        }
                        if (cst instanceof Long) {
                            return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLong((long)((Long)cst)));
                        }
                        if (cst instanceof Double) {
                            return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDouble((double)((Double)cst)));
                        }
                        if (cst instanceof String) {
                            return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nString((String)((String)cst)));
                        }
                        if (cst instanceof Type) {
                            Type type = (Type)cst;
                            int sort = type.getSort();
                            if (sort == 10 || sort == 9) {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nType((String)type.getDescriptor()));
                            }
                            if (sort == 11) {
                                throw new UnsupportedOperationException("Not supported yet.");
                            }
                            throw new IllegalArgumentException("Illegal LDC constant " + cst);
                        }
                        if (cst instanceof Handle) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                        throw new IllegalArgumentException("Illegal LDC constant " + cst);
                    }
                    case 168: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    case 178: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        return this.b(Type.getType((String)fin.desc).getSize(), (com.googlecode.dex2jar.ir.expr.Value)Exprs.nStaticField((String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc));
                    }
                    case 187: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNew((String)("L" + ((TypeInsnNode)insn).desc + ";")));
                    }
                }
                throw new Error("Internal error.");
            }

            public JvmValue copyOperation(AbstractInsnNode insn, JvmValue value) throws AnalyzerException {
                return this.b(value.getSize(), (com.googlecode.dex2jar.ir.expr.Value)J2IRConverter.this.getLocal(value));
            }

            public JvmValue unaryOperation(AbstractInsnNode insn, JvmValue value0) throws AnalyzerException {
                Local local = value0 == null ? null : J2IRConverter.this.getLocal(value0);
                switch (insn.getOpcode()) {
                    case 116: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)local, (String)"I"));
                    }
                    case 132: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)((IincInsnNode)insn).incr), (String)"I"));
                    }
                    case 136: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"J", (String)"I"));
                    }
                    case 139: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"F", (String)"I"));
                    }
                    case 142: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"D", (String)"I"));
                    }
                    case 145: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"I", (String)"B"));
                    }
                    case 146: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"I", (String)"C"));
                    }
                    case 147: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"I", (String)"S"));
                    }
                    case 118: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)local, (String)"F"));
                    }
                    case 134: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"I", (String)"F"));
                    }
                    case 137: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"J", (String)"F"));
                    }
                    case 144: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"D", (String)"F"));
                    }
                    case 117: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)local, (String)"J"));
                    }
                    case 133: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"I", (String)"J"));
                    }
                    case 140: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"F", (String)"J"));
                    }
                    case 143: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"D", (String)"J"));
                    }
                    case 119: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)local, (String)"D"));
                    }
                    case 135: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"I", (String)"D"));
                    }
                    case 138: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"J", (String)"D"));
                    }
                    case 141: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)"F", (String)"D"));
                    }
                    case 153: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 154: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 155: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLt((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 156: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGe((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 157: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGt((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 158: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLe((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 170: {
                        TableSwitchInsnNode ts = (TableSwitchInsnNode)insn;
                        LabelStmt[] targets = new LabelStmt[ts.labels.size()];
                        int i = 0;
                        while (i < ts.labels.size()) {
                            targets[i] = J2IRConverter.this.getLabel((LabelNode)ts.labels.get(i));
                            ++i;
                        }
                        J2IRConverter.this.emit((Stmt)Stmts.nTableSwitch((com.googlecode.dex2jar.ir.expr.Value)local, (int)ts.min, (LabelStmt[])targets, (LabelStmt)J2IRConverter.this.getLabel(ts.dflt)));
                        return null;
                    }
                    case 171: {
                        LookupSwitchInsnNode ls = (LookupSwitchInsnNode)insn;
                        LabelStmt[] targets = new LabelStmt[ls.labels.size()];
                        int[] lookupValues = new int[ls.labels.size()];
                        int i = 0;
                        while (i < ls.labels.size()) {
                            targets[i] = J2IRConverter.this.getLabel((LabelNode)ls.labels.get(i));
                            lookupValues[i] = (Integer)ls.keys.get(i);
                            ++i;
                        }
                        J2IRConverter.this.emit((Stmt)Stmts.nLookupSwitch((com.googlecode.dex2jar.ir.expr.Value)local, (int[])lookupValues, (LabelStmt[])targets, (LabelStmt)J2IRConverter.this.getLabel(ls.dflt)));
                        return null;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: {
                        return null;
                    }
                    case 179: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nStaticField((String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc), (com.googlecode.dex2jar.ir.expr.Value)local));
                        return null;
                    }
                    case 180: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        Type fieldType = Type.getType((String)fin.desc);
                        return this.b(fieldType.getSize(), (com.googlecode.dex2jar.ir.expr.Value)Exprs.nField((com.googlecode.dex2jar.ir.expr.Value)local, (String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc));
                    }
                    case 188: {
                        switch (((IntInsnNode)insn).operand) {
                            case 4: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"Z", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                            case 5: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"C", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                            case 8: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"B", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                            case 9: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"S", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                            case 10: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"I", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                            case 6: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"F", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                            case 7: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"D", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                            case 11: {
                                return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"D", (com.googlecode.dex2jar.ir.expr.Value)local));
                            }
                        }
                        throw new AnalyzerException(insn, "Invalid array type");
                    }
                    case 189: {
                        String desc = "L" + ((TypeInsnNode)insn).desc + ";";
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)desc, (com.googlecode.dex2jar.ir.expr.Value)local));
                    }
                    case 190: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLength((com.googlecode.dex2jar.ir.expr.Value)local));
                    }
                    case 191: {
                        J2IRConverter.this.emit((Stmt)Stmts.nThrow((com.googlecode.dex2jar.ir.expr.Value)local));
                        return null;
                    }
                    case 192: {
                        String orgDesc = ((TypeInsnNode)insn).desc;
                        String desc = orgDesc.startsWith("[") ? orgDesc : "L" + orgDesc + ";";
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCheckCast((com.googlecode.dex2jar.ir.expr.Value)local, (String)desc));
                    }
                    case 193: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInstanceOf((com.googlecode.dex2jar.ir.expr.Value)local, (String)("L" + ((TypeInsnNode)insn).desc + ";")));
                    }
                    case 194: {
                        J2IRConverter.this.emit((Stmt)Stmts.nLock((com.googlecode.dex2jar.ir.expr.Value)local));
                        return null;
                    }
                    case 195: {
                        J2IRConverter.this.emit((Stmt)Stmts.nUnLock((com.googlecode.dex2jar.ir.expr.Value)local));
                        return null;
                    }
                    case 198: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNull(), (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 199: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNull(), (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 167: {
                        J2IRConverter.this.emit((Stmt)Stmts.nGoto((LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                }
                throw new Error("Internal error.");
            }

            JvmValue b(int size, com.googlecode.dex2jar.ir.expr.Value value) {
                Local local = J2IRConverter.this.newLocal();
                J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)local, (com.googlecode.dex2jar.ir.expr.Value)value));
                return new JvmValue(size, local);
            }

            public JvmValue binaryOperation(AbstractInsnNode insn, JvmValue value10, JvmValue value20) throws AnalyzerException {
                Local local1 = J2IRConverter.this.getLocal(value10);
                Local local2 = J2IRConverter.this.getLocal(value20);
                switch (insn.getOpcode()) {
                    case 46: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 51: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"B"));
                    }
                    case 52: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"C"));
                    }
                    case 53: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"S"));
                    }
                    case 48: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"F"));
                    }
                    case 50: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"L"));
                    }
                    case 49: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"D"));
                    }
                    case 47: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 96: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 100: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 104: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 108: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 112: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 120: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShl((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 122: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShr((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 124: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nUshr((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 126: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAnd((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 128: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nOr((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 130: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nXor((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"));
                    }
                    case 98: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"F"));
                    }
                    case 102: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"F"));
                    }
                    case 106: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"F"));
                    }
                    case 110: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"F"));
                    }
                    case 114: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"F"));
                    }
                    case 97: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 101: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 105: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 109: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 113: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 121: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShl((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 123: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShr((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 125: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nUshr((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 127: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAnd((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 129: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nOr((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 131: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nXor((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"));
                    }
                    case 99: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"D"));
                    }
                    case 103: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"D"));
                    }
                    case 107: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"D"));
                    }
                    case 111: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"D"));
                    }
                    case 115: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"D"));
                    }
                    case 148: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLCmp((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2));
                    }
                    case 149: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFCmpl((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2));
                    }
                    case 150: {
                        return this.b(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFCmpg((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2));
                    }
                    case 151: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDCmpl((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2));
                    }
                    case 152: {
                        return this.b(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDCmpg((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2));
                    }
                    case 159: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 160: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 161: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLt((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 162: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGe((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 163: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGt((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 164: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLe((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 165: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 166: {
                        J2IRConverter.this.emit((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 181: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nField((com.googlecode.dex2jar.ir.expr.Value)local1, (String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc), (com.googlecode.dex2jar.ir.expr.Value)local2));
                        return null;
                    }
                }
                throw new Error("Internal error.");
            }

            public JvmValue ternaryOperation(AbstractInsnNode insn, JvmValue value1, JvmValue value2, JvmValue value3) throws AnalyzerException {
                Local local1 = J2IRConverter.this.getLocal(value1);
                Local local2 = J2IRConverter.this.getLocal(value2);
                Local local3 = J2IRConverter.this.getLocal(value3);
                switch (insn.getOpcode()) {
                    case 79: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"I"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                        break;
                    }
                    case 80: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"J"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                        break;
                    }
                    case 81: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"F"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                        break;
                    }
                    case 82: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"D"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                        break;
                    }
                    case 83: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"L"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                        break;
                    }
                    case 84: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"B"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                        break;
                    }
                    case 85: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"C"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                        break;
                    }
                    case 86: {
                        J2IRConverter.this.emit((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)local1, (com.googlecode.dex2jar.ir.expr.Value)local2, (String)"S"), (com.googlecode.dex2jar.ir.expr.Value)local3));
                    }
                }
                return null;
            }

            public String[] toDescArray(Type[] ts) {
                String[] ds = new String[ts.length];
                int i = 0;
                while (i < ts.length) {
                    ds[i] = ts[i].getDescriptor();
                    ++i;
                }
                return ds;
            }

            public JvmValue naryOperation(AbstractInsnNode insn, List<? extends JvmValue> xvalues) throws AnalyzerException {
                com.googlecode.dex2jar.ir.expr.Value[] values = new com.googlecode.dex2jar.ir.expr.Value[xvalues.size()];
                int i = 0;
                while (i < xvalues.size()) {
                    values[i] = J2IRConverter.this.getLocal(xvalues.get(i));
                    ++i;
                }
                if (insn.getOpcode() == 197) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                MethodInsnNode mi = (MethodInsnNode)insn;
                InvokeExpr v = null;
                String ret = Type.getReturnType((String)mi.desc).getDescriptor();
                String owner = "L" + mi.owner + ";";
                String[] ps = this.toDescArray(Type.getArgumentTypes((String)mi.desc));
                switch (insn.getOpcode()) {
                    case 182: {
                        v = Exprs.nInvokeVirtual((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 183: {
                        v = Exprs.nInvokeSpecial((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 184: {
                        v = Exprs.nInvokeStatic((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 185: {
                        v = Exprs.nInvokeInterface((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 186: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
                if ("V".equals(ret)) {
                    J2IRConverter.this.emit((Stmt)Stmts.nVoidInvoke((com.googlecode.dex2jar.ir.expr.Value)v));
                    return null;
                }
                return this.b(Type.getReturnType((String)mi.desc).getSize(), (com.googlecode.dex2jar.ir.expr.Value)v);
            }

            public JvmValue merge(JvmValue v, JvmValue w) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void returnOperation(AbstractInsnNode insn, JvmValue value, JvmValue expected) throws AnalyzerException {
                switch (insn.getOpcode()) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: {
                        J2IRConverter.this.emit((Stmt)Stmts.nReturn((com.googlecode.dex2jar.ir.expr.Value)J2IRConverter.this.getLocal(value)));
                        break;
                    }
                    case 177: {
                        J2IRConverter.this.emit((Stmt)Stmts.nReturnVoid());
                    }
                }
            }
        };
    }

    Local getLocal(JvmValue value) {
        Local local = value.local;
        if (local == null) {
            local = value.local = this.newLocal();
        }
        return local;
    }

    private void initParentCount(int[] parentCount) {
        parentCount[0] = 1;
        AbstractInsnNode p = this.insnList.getFirst();
        while (p != null) {
            AbstractInsnNode next;
            int op;
            if (p.getType() == 7) {
                JumpInsnNode jump = (JumpInsnNode)p;
                int n = this.insnList.indexOf((AbstractInsnNode)jump.label);
                parentCount[n] = parentCount[n] + 1;
            }
            if ((op = p.getOpcode()) == 170 || op == 171) {
                if (op == 170) {
                    TableSwitchInsnNode tsin = (TableSwitchInsnNode)p;
                    for (LabelNode label : tsin.labels) {
                        int n = this.insnList.indexOf((AbstractInsnNode)label);
                        parentCount[n] = parentCount[n] + 1;
                    }
                    int n = this.insnList.indexOf((AbstractInsnNode)tsin.dflt);
                    parentCount[n] = parentCount[n] + 1;
                } else {
                    LookupSwitchInsnNode lsin = (LookupSwitchInsnNode)p;
                    for (LabelNode label : lsin.labels) {
                        int n = this.insnList.indexOf((AbstractInsnNode)label);
                        parentCount[n] = parentCount[n] + 1;
                    }
                    int n = this.insnList.indexOf((AbstractInsnNode)lsin.dflt);
                    parentCount[n] = parentCount[n] + 1;
                }
            }
            if ((op < 167 || op > 177) && op != 191 && (next = p.getNext()) != null) {
                int n = this.insnList.indexOf(p.getNext());
                parentCount[n] = parentCount[n] + 1;
            }
            p = p.getNext();
        }
    }

    private void mergeEx(JvmFrame src, int dst) {
        JvmFrame distFrame = this.frames[dst];
        if (distFrame == null) {
            distFrame = this.frames[dst] = new JvmFrame(this.methodNode.maxLocals, this.methodNode.maxStack);
        }
        int i = 0;
        while (i < src.getLocals()) {
            JvmValue p = (JvmValue)src.getLocal(i);
            JvmValue q = (JvmValue)distFrame.getLocal(i);
            if (p != null) {
                if (q == null) {
                    q = new JvmValue(p.getSize());
                    distFrame.setLocal(i, q);
                }
                this.relate(p, q);
            }
            ++i;
        }
    }

    private void merge(JvmFrame src, int dst) {
        JvmFrame distFrame = this.frames[dst];
        if (distFrame == null) {
            distFrame = this.frames[dst] = new JvmFrame(this.methodNode.maxLocals, this.methodNode.maxStack);
        }
        if (this.parentCount[dst] > 1) {
            JvmValue q;
            JvmValue p;
            int i = 0;
            while (i < src.getLocals()) {
                p = (JvmValue)src.getLocal(i);
                q = (JvmValue)distFrame.getLocal(i);
                if (p != null) {
                    if (q == null) {
                        q = new JvmValue(p.getSize());
                        distFrame.setLocal(i, q);
                    }
                    this.relate(p, q);
                }
                ++i;
            }
            if (src.getStackSize() > 0) {
                if (distFrame.getStackSize() == 0) {
                    i = 0;
                    while (i < src.getStackSize()) {
                        distFrame.push(new JvmValue(((JvmValue)src.getStack(i)).getSize()));
                        ++i;
                    }
                } else if (distFrame.getStackSize() != src.getStackSize()) {
                    throw new RuntimeException("stack not balanced");
                }
                i = 0;
                while (i < src.getStackSize()) {
                    p = (JvmValue)src.getStack(i);
                    q = (JvmValue)distFrame.getStack(i);
                    this.relate(p, q);
                    ++i;
                }
            }
        } else {
            distFrame.init(src);
        }
    }

    private void relate(JvmValue parent, JvmValue child) {
        if (child.parent == null) {
            child.parent = parent;
        } else if (child.parent != parent) {
            if (child.otherParent == null) {
                child.otherParent = new HashSet<JvmValue>(5);
            }
            child.otherParent.add(parent);
        }
    }

    private JvmFrame initFirstFrame(MethodNode methodNode, IrMethod target) {
        JvmFrame first = new JvmFrame(methodNode.maxLocals, methodNode.maxStack);
        int x = 0;
        if (!target.isStatic) {
            Local thiz = this.newLocal();
            this.emit((Stmt)Stmts.nIdentity((com.googlecode.dex2jar.ir.expr.Value)thiz, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nThisRef((String)target.owner)));
            first.setLocal(x++, new JvmValue(1, thiz));
        }
        int i = 0;
        while (i < target.args.length) {
            Local p = this.newLocal();
            this.emit((Stmt)Stmts.nIdentity((com.googlecode.dex2jar.ir.expr.Value)p, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nParameterRef((String)target.args[i], (int)i)));
            int sizeOfType = this.sizeOfType(target.args[i]);
            first.setLocal(x, new JvmValue(sizeOfType, p));
            x += sizeOfType;
            ++i;
        }
        return first;
    }

    private int sizeOfType(String arg) {
        switch (arg.charAt(0)) {
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    private Local newLocal() {
        Local thiz = Exprs.nLocal((int)this.target.locals.size());
        this.target.locals.add(thiz);
        return thiz;
    }

    static class JvmFrame
    extends Frame<JvmValue> {
        public JvmFrame(int nLocals, int nStack) {
            super(nLocals, nStack);
        }

        public void execute(AbstractInsnNode insn, Interpreter<JvmValue> interpreter) throws AnalyzerException {
            if (insn.getType() == 14 || insn.getType() == 15 || insn.getType() == 8) {
                return;
            }
            if (insn.getOpcode() == 177) {
                interpreter.returnOperation(insn, null, null);
            } else if (insn.getOpcode() == 167) {
                interpreter.unaryOperation(insn, null);
            } else {
                if (insn.getOpcode() == 169) {
                    throw new RuntimeException("not support yet!");
                }
                super.execute(insn, interpreter);
            }
        }
    }

    public static class JvmValue
    implements Value {
        private final int size;
        public JvmValue parent;
        public Set<JvmValue> otherParent;
        Local local;

        public JvmValue(int size, Local local) {
            this.size = size;
            this.local = local;
        }

        public JvmValue(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

