/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.DexConstants;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.visitors.DexAnnotationVisitor;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils
implements DexConstants {
    static Map<String, Op> ops = new HashMap<String, Op>();

    static {
        Op[] opArray = Op.values();
        int n = opArray.length;
        int n2 = 0;
        while (n2 < n) {
            Op op = opArray[n2];
            ops.put(op.displayName, op);
            ++n2;
        }
    }

    public static void doAccept(DexAnnotationVisitor dexAnnotationVisitor, String k, Object value) {
        if (value instanceof ArrayList) {
            DexAnnotationVisitor a = dexAnnotationVisitor.visitArray(k);
            for (Object o : (ArrayList)value) {
                Utils.doAccept(a, null, o);
            }
            a.visitEnd();
        } else if (value instanceof Ann) {
            Ann ann = (Ann)value;
            DexAnnotationVisitor a = dexAnnotationVisitor.visitAnnotation(k, ann.name);
            for (Map.Entry<String, Object> e : ann.elements) {
                Utils.doAccept(a, e.getKey(), e.getValue());
            }
            a.visitEnd();
        } else if (value instanceof Field) {
            Field f = (Field)value;
            dexAnnotationVisitor.visitEnum(k, f.getOwner(), f.getName());
        } else {
            dexAnnotationVisitor.visit(k, value);
        }
    }

    public static int getAcc(String name) {
        if (name.equals("public")) {
            return 1;
        }
        if (name.equals("private")) {
            return 2;
        }
        if (name.equals("protected")) {
            return 4;
        }
        if (name.equals("static")) {
            return 8;
        }
        if (name.equals("final")) {
            return 16;
        }
        if (name.equals("synchronized")) {
            return 32;
        }
        if (name.equals("volatile")) {
            return 64;
        }
        if (name.equals("bridge")) {
            return 64;
        }
        if (name.equals("varargs")) {
            return 128;
        }
        if (name.equals("transient")) {
            return 128;
        }
        if (name.equals("native")) {
            return 256;
        }
        if (name.equals("interface")) {
            return 512;
        }
        if (name.equals("abstract")) {
            return 1024;
        }
        if (name.equals("strict")) {
            return 2048;
        }
        if (name.equals("synthetic")) {
            return 4096;
        }
        if (name.equals("annotation")) {
            return 8192;
        }
        if (name.equals("enum")) {
            return 16384;
        }
        if (name.equals("constructor")) {
            return 65536;
        }
        if (name.equals("declared-synchronized")) {
            return 131072;
        }
        return 0;
    }

    public static List<String> listDesc(String desc) {
        ArrayList<String> list = new ArrayList<String>(5);
        if (desc == null) {
            return list;
        }
        char[] chars = desc.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    list.add(Character.toString(chars[i]));
                    ++i;
                    break;
                }
                case '[': {
                    int count = 1;
                    while (chars[i + count] == '[') {
                        ++count;
                    }
                    if (chars[i + count] == 'L') {
                        ++count;
                        while (chars[i + count] != ';') {
                            ++count;
                        }
                    }
                    list.add(new String(chars, i, ++count));
                    i += count;
                    break;
                }
                case 'L': {
                    int count = 1;
                    while (chars[i + count] != ';') {
                        ++count;
                    }
                    list.add(new String(chars, i, ++count));
                    i += count;
                    break;
                }
                default: {
                    throw new RuntimeException("can't parse type list: " + desc);
                }
            }
        }
        return list;
    }

    public static String[] toTypeList(String s) {
        return Utils.listDesc(s).toArray(new String[0]);
    }

    public static Byte parseByte(String str) {
        return (byte)Utils.parseInt(str.substring(0, str.length() - 1));
    }

    public static Short parseShort(String str) {
        return (short)Utils.parseInt(str.substring(0, str.length() - 1));
    }

    public static Long parseLong(String str) {
        BigInteger v;
        int sof = 0;
        int end = str.length() - 1;
        int x = 1;
        if (str.charAt(sof) == '+') {
            ++sof;
        } else if (str.charAt(sof) == '-') {
            ++sof;
            x = -1;
        }
        if (str.charAt(sof) == '0') {
            if (++sof >= end) {
                return 0L;
            }
            char c = str.charAt(sof);
            v = c == 'x' || c == 'X' ? new BigInteger(str.substring(++sof, end), 16) : new BigInteger(str.substring(sof, end), 8);
        } else {
            v = new BigInteger(str.substring(sof, end), 10);
        }
        if (x == -1) {
            return v.negate().longValue();
        }
        return v.longValue();
    }

    public static float parseFloat(String str) {
        str = str.toLowerCase();
        int s = 0;
        float x = 1.0f;
        if (str.charAt(s) == '+') {
            ++s;
        } else if (str.charAt(s) == '-') {
            ++s;
            x = -1.0f;
        }
        int e = str.length() - 1;
        if (str.charAt(e) == 'f') {
            --e;
        }
        if ((str = str.substring(s, e + 1)).equals("nan")) {
            return Float.NaN;
        }
        if (str.equals("infinity")) {
            return x < 0.0f ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        return x * Float.parseFloat(str);
    }

    public static double parseDouble(String str) {
        str = str.toLowerCase();
        int s = 0;
        double x = 1.0;
        if (str.charAt(s) == '+') {
            ++s;
        } else if (str.charAt(s) == '-') {
            ++s;
            x = -1.0;
        }
        int e = str.length() - 1;
        if (str.charAt(e) == 'd') {
            --e;
        }
        if ((str = str.substring(s, e + 1)).equals("nan")) {
            return Double.NaN;
        }
        if (str.equals("infinity")) {
            return x < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        return x * Double.parseDouble(str);
    }

    public static int parseInt(String str, int start, int end) {
        long v;
        int sof = start;
        int x = 1;
        if (str.charAt(sof) == '+') {
            ++sof;
        } else if (str.charAt(sof) == '-') {
            ++sof;
            x = -1;
        }
        if (str.charAt(sof) == '0') {
            if (++sof >= end) {
                return 0;
            }
            char c = str.charAt(sof);
            v = c == 'x' || c == 'X' ? Long.parseLong(str.substring(++sof, end), 16) : Long.parseLong(str.substring(sof, end), 8);
        } else {
            v = Long.parseLong(str.substring(sof, end), 10);
        }
        return (int)(v * (long)x);
    }

    public static int parseInt(String str) {
        return Utils.parseInt(str, 0, str.length());
    }

    public static String unescapeStr(String str) {
        return Utils.unEscape(str);
    }

    public static Character unescapeChar(String str) {
        return Character.valueOf(Utils.unEscape(str).charAt(0));
    }

    public static int[] toIntArray(List<String> ss) {
        int[] vs = new int[ss.size()];
        int i = 0;
        while (i < ss.size()) {
            vs[i] = Utils.parseInt(ss.get(i));
            ++i;
        }
        return vs;
    }

    public static byte[] toByteArray(List<Object> ss) {
        byte[] vs = new byte[ss.size()];
        int i = 0;
        while (i < ss.size()) {
            vs[i] = ((Number)ss.get(i)).byteValue();
            ++i;
        }
        return vs;
    }

    public static Op getOp(String name) {
        return ops.get(name);
    }

    public static String unEscape(String str) {
        return Utils.unEscape0(str, 1, str.length() - 1);
    }

    public static String unEscapeId(String str) {
        return Utils.unEscape0(str, 0, str.length());
    }

    public static String unEscape0(String str, int start, int end) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i < end) {
            char c = str.charAt(i);
            if (c == '\\') {
                char d = str.charAt(i + 1);
                switch (d) {
                    case 'b': {
                        sb.append('\b');
                        i += 2;
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        i += 2;
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        i += 2;
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        i += 2;
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        i += 2;
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        i += 2;
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        i += 2;
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        i += 2;
                        break;
                    }
                    case 'u': {
                        String sub = str.substring(i + 2, i + 6);
                        sb.append((char)Integer.parseInt(sub, 16));
                        i += 6;
                        break;
                    }
                    default: {
                        int x = 0;
                        while (x < 3) {
                            char e = str.charAt(i + 1 + x);
                            if (e < '0' || e > '7') break;
                            ++x;
                        }
                        if (x == 0) {
                            throw new RuntimeException("can't pase string");
                        }
                        sb.append((char)Integer.parseInt(str.substring(i + 1, i + 1 + x), 8));
                        i += 1 + x;
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static Visibility getAnnVisibility(String name) {
        return Visibility.valueOf((String)name.toUpperCase());
    }

    public static int methodIns(Method m, boolean isStatic) {
        int a = isStatic ? 0 : 1;
        String[] stringArray = m.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            switch (t.charAt(0)) {
                case 'D': 
                case 'J': {
                    a += 2;
                    break;
                }
                default: {
                    ++a;
                }
            }
            ++n2;
        }
        return a;
    }

    public static int reg2ParamIdx(Method m, int reg, int locals, boolean isStatic) {
        int x = reg - locals;
        if (x < 0) {
            return -1;
        }
        int a = isStatic ? 0 : 1;
        String[] parameterTypes = m.getParameterTypes();
        int i = 0;
        int parameterTypesLength = parameterTypes.length;
        while (i < parameterTypesLength) {
            if (x == a) {
                return i;
            }
            String t = parameterTypes[i];
            switch (t.charAt(0)) {
                case 'D': 
                case 'J': {
                    a += 2;
                    break;
                }
                default: {
                    ++a;
                }
            }
            ++i;
        }
        return -1;
    }

    public static class Ann {
        public String name;
        public List<Map.Entry<String, Object>> elements = new ArrayList<Map.Entry<String, Object>>();

        public void put(String name, Object value) {
            this.elements.add(new AbstractMap.SimpleEntry<String, Object>(name, value));
        }
    }
}

