/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.smali.BaksmaliDumpOut;
import com.googlecode.d2j.smali.BaksmaliDumper;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;

public class BaksmaliDexFileVisitor
extends DexFileVisitor {
    private final Path dir;
    private final BaksmaliDumper bs;
    private Set<String> hases;
    private int i;

    public BaksmaliDexFileVisitor(Path dir, BaksmaliDumper bs) {
        this.dir = dir;
        this.bs = bs;
        this.hases = new HashSet<String>();
        this.i = 1;
    }

    protected String rebuildFileName(String s) {
        s = BaksmaliDumper.escapeId(s);
        String low = (s = s.replace('\\', '-')).toLowerCase();
        if (this.hases.contains(low)) {
            return String.valueOf(s) + "_d2j" + this.i++;
        }
        this.hases.add(low);
        return s;
    }

    public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
        return new DexClassNode(access_flags, className, superClass, interfaceNames){

            public void visitEnd() {
                super.visitEnd();
                Path smaliFile = BaksmaliDexFileVisitor.this.dir.resolve(String.valueOf(BaksmaliDexFileVisitor.this.rebuildFileName(this.className.substring(1, this.className.length() - 1))) + ".smali");
                try {
                    Path parent = smaliFile.getParent();
                    if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    Throwable e = null;
                    Object var3_6 = null;
                    try (BufferedWriter writer = Files.newBufferedWriter(smaliFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                        BaksmaliDumpOut out = new BaksmaliDumpOut(writer);
                        BaksmaliDexFileVisitor.this.bs.baksmaliClass((DexClassNode)this, out);
                        writer.flush();
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

