/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.smali.Baksmali;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@BaseCmd.Syntax(cmd="d2j-baksmali", syntax="[options] <dex>", desc="disassembles and/or dumps a dex file", onlineHelp="https://sourceforge.net/p/dex2jar/wiki/Smali")
public class BaksmaliCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="b", longOpt="no-debug-info", hasArg=false, description="[not impl] don't write out debug info (.local, .param, .line, etc.)")
    private boolean noDebug;
    @BaseCmd.Opt(opt="p", longOpt="no-parameter-registers", hasArg=false, description="use the v<n> syntax instead of the p<n> syntax for registers mapped to method parameters")
    private boolean noParameterRegisters;
    @BaseCmd.Opt(opt="l", longOpt="use-locals", hasArg=false, description="output the .locals directive with the number of non-parameter registers, rather than the .register")
    private boolean useLocals;
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output dir of .smali files, default is $current_dir/[jar-name]-out/", argName="out")
    private Path output;

    public static void main(String[] args) {
        new BaksmaliCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            System.err.println("ERRPR: no file to process");
            return;
        }
        if (this.remainingArgs.length > 1) {
            System.err.println("ERRPR: too many files to process");
            return;
        }
        File dex = new File(this.remainingArgs[0]);
        if (!dex.exists()) {
            System.err.println("ERROR: " + dex + " is not exists");
            return;
        }
        if (this.output == null) {
            this.output = new File(String.valueOf(BaksmaliCmd.getBaseName((String)dex.getName())) + "-out").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            return;
        }
        Baksmali b = Baksmali.from(dex);
        if (this.noDebug) {
            b.noDebug();
        }
        if (this.noParameterRegisters) {
            b.noParameterRegisters();
        }
        if (this.useLocals) {
            b.useLocals();
        }
        System.err.println("baksmali " + dex + " -> " + this.output);
        b.to(this.output);
    }
}

