/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.tools.jar.InvocationWeaver;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@BaseCmd.Syntax(cmd="d2j-jar-weaver", syntax="[options] jar", desc="replace invoke in jar", onlineHelp="https://sourceforge.net/p/dex2jar/wiki/JarWeaver")
public class JarWeaverCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file", argName="out-jar-file", required=true)
    private Path output;
    @BaseCmd.Opt(opt="c", longOpt="config", description="config file", argName="config", required=true)
    private Path config;
    @BaseCmd.Opt(opt="s", longOpt="stub-jar", description="stub jar", argName="stub")
    private Path stub;

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length == 0) {
            throw new BaseCmd.HelpException("no jar");
        }
        InvocationWeaver invocationWeaver = (InvocationWeaver)new InvocationWeaver().withConfig(this.config);
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileSystem fs = JarWeaverCmd.createZip((Path)this.output);){
            final Path outRoot = fs.getPath("/", new String[0]);
            String[] stringArray = this.remainingArgs;
            int n = this.remainingArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                Path p = new File(str).toPath();
                System.err.println(p + " -> " + this.output);
                if (Files.isDirectory(p, new LinkOption[0])) {
                    invocationWeaver.wave(p, outRoot);
                } else {
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try (FileSystem fs2 = JarWeaverCmd.openZip((Path)p);){
                        invocationWeaver.wave(fs2.getPath("/", new String[0]), outRoot);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                ++n2;
            }
            if (this.stub != null) {
                System.err.println(this.stub + " -> " + this.output);
                JarWeaverCmd.walkJarOrDir((Path)this.stub, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

                    public void visitFile(Path file, String relative) throws IOException {
                        Path out = outRoot.resolve(relative);
                        if (Files.exists(out, new LinkOption[0])) {
                            System.err.println("skip " + relative + " in " + JarWeaverCmd.this.stub);
                        } else {
                            JarWeaverCmd.createParentDirectories((Path)out);
                            Files.copy(file, out, new CopyOption[0]);
                        }
                    }
                });
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        new JarWeaverCmd().doMain(args);
    }
}

