/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;

@BaseCmd.Syntax(cmd="d2j-jar2dex", syntax="[options] <dir>", desc="Convert jar to dex by invoking dx.")
public class Jar2Dex
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .dex file, default is $current_dir/[jar-name]-jar2dex.dex", argName="out-dex-file")
    private Path output;

    public static void main(String ... args) {
        new Jar2Dex().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        Path jar = new File(this.remainingArgs[0]).toPath();
        if (!Files.exists(jar, new LinkOption[0])) {
            System.err.println(jar + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = Files.isDirectory(jar, new LinkOption[0]) ? new File(jar.getFileName() + "-jar2dex.dex").toPath() : new File(String.valueOf(Jar2Dex.getBaseName((String)jar.getFileName().toString())) + "-jar2dex.dex").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        Path tmp = null;
        try {
            Path realJar;
            block18: {
                if (Files.isDirectory(jar, new LinkOption[0])) {
                    tmp = realJar = Files.createTempFile("d2j", ".jar", new FileAttribute[0]);
                    System.out.println("zipping " + jar + " -> " + realJar);
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (FileSystem fs = Jar2Dex.createZip((Path)realJar);){
                        final Path outRoot = fs.getPath("/", new String[0]);
                        Jar2Dex.walkJarOrDir((Path)jar, (BaseCmd.FileVisitorX)new BaseCmd.FileVisitorX(){

                            public void visitFile(Path file, String relative) throws IOException {
                                if (file.getFileName().toString().endsWith(".class")) {
                                    Files.copy(file, outRoot.resolve(relative), new CopyOption[0]);
                                }
                            }
                        });
                        break block18;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                realJar = jar;
            }
            System.out.println("jar2dex " + realJar + " -> " + this.output);
            Class<?> c = Class.forName("com.android.dx.command.Main");
            Method m = c.getMethod("main", String[].class);
            ArrayList<String> ps = new ArrayList<String>();
            ps.addAll(Arrays.asList("--dex", "--no-strict", "--output=" + this.output.toAbsolutePath().toString(), realJar.toAbsolutePath().toString()));
            System.out.println("call com.android.dx.command.Main.main" + ps);
            m.invoke(null, new Object[]{ps.toArray(new String[ps.size()])});
        }
        catch (Throwable throwable) {
            if (tmp != null) {
                Files.deleteIfExists(tmp);
            }
            throw throwable;
        }
        if (tmp != null) {
            Files.deleteIfExists(tmp);
        }
    }
}

