/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.Method;
import com.googlecode.d2j.dex.writer.DexFileWriter;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.reader.zip.ZipUtil;
import com.googlecode.d2j.smali.Utils;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;

@BaseCmd.Syntax(cmd="d2j-dex-weaver", syntax="[options] dex", desc="replace invoke in dex", onlineHelp="https://sourceforge.net/p/dex2jar/wiki/DexWeaver")
public class DexWeaverCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .dex file", argName="out-dex-file")
    private Path output;
    @BaseCmd.Opt(opt="c", longOpt="config", description="config file", argName="config")
    private Path config;
    @BaseCmd.Opt(opt="s", longOpt="stub-dex", description="stub dex", argName="stub")
    private Path stub;

    static Method parseMethod(String str) {
        int i = str.indexOf(46);
        String owner = str.substring(0, i);
        int j = str.indexOf(40, i);
        String name = str.substring(i + 1, j);
        i = str.indexOf(41, j);
        String args = str.substring(j + 1, i);
        String ret = str.substring(i + 1);
        return new Method(owner, name, Utils.toTypeList((String)args), ret);
    }

    protected void doCommandLine() throws Exception {
        byte[] data;
        if (this.remainingArgs.length == 0) {
            throw new BaseCmd.HelpException("no odex");
        }
        final HashMap<String, Method> map = new HashMap<String, Method>();
        for (String ln : Files.readAllLines(this.config, StandardCharsets.UTF_8)) {
            if (ln.startsWith("#") || ln.length() == 0) continue;
            String[] x = ln.split("=");
            map.put(x[0], DexWeaverCmd.parseMethod(x[1]));
        }
        DexFileWriter out = new DexFileWriter();
        DexFileVisitor fv = new DexFileVisitor((DexFileVisitor)out){

            public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
                DexClassVisitor dcv = super.visit(access_flags, className, superClass, interfaceNames);
                if (dcv != null) {
                    return new DexClassVisitor(dcv){

                        public DexMethodVisitor visitMethod(int accessFlags, Method method) {
                            DexMethodVisitor dmv = super.visitMethod(accessFlags, method);
                            if (dmv != null) {
                                return new DexMethodVisitor(dmv){

                                    public DexCodeVisitor visitCode() {
                                        DexCodeVisitor code = super.visitCode();
                                        if (code != null) {
                                            return new DexCodeVisitor(code){

                                                public void visitMethodStmt(Op op, int[] args, Method method) {
                                                    Method replaceTo = (Method)map.get(method.toString());
                                                    if (replaceTo != null) {
                                                        switch (op) {
                                                            case INVOKE_VIRTUAL: 
                                                            case INVOKE_SUPER: 
                                                            case INVOKE_DIRECT: 
                                                            case INVOKE_STATIC: 
                                                            case INVOKE_INTERFACE: {
                                                                super.visitMethodStmt(Op.INVOKE_STATIC, args, replaceTo);
                                                                break;
                                                            }
                                                            case INVOKE_VIRTUAL_RANGE: 
                                                            case INVOKE_SUPER_RANGE: 
                                                            case INVOKE_DIRECT_RANGE: 
                                                            case INVOKE_STATIC_RANGE: 
                                                            case INVOKE_INTERFACE_RANGE: {
                                                                super.visitMethodStmt(Op.INVOKE_STATIC_RANGE, args, replaceTo);
                                                            }
                                                        }
                                                    } else {
                                                        super.visitMethodStmt(op, args, method);
                                                    }
                                                }
                                            };
                                        }
                                        return code;
                                    }
                                };
                            }
                            return dmv;
                        }
                    };
                }
                return dcv;
            }

            public void visitEnd() {
            }
        };
        String[] stringArray = this.remainingArgs;
        int n = this.remainingArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            byte[] data2 = ZipUtil.readDex((Path)new File(f).toPath());
            DexFileReader r = new DexFileReader(data2);
            r.accept(fv);
            ++n2;
        }
        if (this.stub != null) {
            data = ZipUtil.readDex((Path)this.stub);
            DexFileReader r = new DexFileReader(data);
            r.accept(new DexFileVisitor((DexFileVisitor)out){

                public void visitEnd() {
                }
            });
        }
        out.visitEnd();
        data = out.toByteArray();
        Files.write(this.output, data, new OpenOption[0]);
    }

    public static void main(String[] args) {
        new DexWeaverCmd().doMain(args);
    }
}

