/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassVersionSwitch {
    static final int[] jVersions;

    static {
        int[] nArray = new int[10];
        nArray[1] = 196653;
        nArray[2] = 46;
        nArray[3] = 47;
        nArray[4] = 48;
        nArray[5] = 49;
        nArray[6] = 50;
        nArray[7] = 51;
        nArray[8] = 52;
        nArray[9] = 53;
        jVersions = nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String ... args) throws IOException {
        int version;
        if (args.length < 3) {
            System.out.println("Usage: clz-version-switch version old.jar new.jar");
            System.exit(1);
        }
        if ((version = Integer.parseInt(args[0])) < 1 || version > 9) {
            throw new RuntimeException("version not support yet!");
        }
        File old = new File(args[1]);
        File n = new File(args[2]);
        byte[] buff = new byte[51200];
        final int jVersion = jVersions[version];
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            ZipFile zip = new ZipFile(old);
            try {
                try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(n));){
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        zos.putNextEntry(new ZipEntry(zipEntry.getName()));
                        if (!zipEntry.isDirectory()) {
                            Throwable throwable2 = null;
                            Object var13_17 = null;
                            try (InputStream is = zip.getInputStream(zipEntry);){
                                if (zipEntry.getName().endsWith(".class")) {
                                    ClassReader cr = new ClassReader(is);
                                    ClassWriter cw = new ClassWriter(0);
                                    ClassVisitor cv = new ClassVisitor(262144, (ClassVisitor)cw){

                                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                            super.visit(jVersion, access, name, signature, superName, interfaces);
                                        }
                                    };
                                    cr.accept(cv, 12);
                                    zos.write(cw.toByteArray());
                                } else {
                                    int c = is.read(buff);
                                    while (c > 0) {
                                        zos.write(buff, 0, c);
                                        c = is.read(buff);
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                } else {
                                    if (throwable2 == throwable3) throw throwable2;
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        zos.closeEntry();
                    }
                }
                if (zip == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (zip == null) throw throwable;
                zip.close();
                throw throwable;
            }
            zip.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }
}

