/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.signapk;

import com.googlecode.d2j.signapk.Base64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public abstract class AbstractJarSign {
    private static Pattern stripPattern = Pattern.compile("^META-INF/(.*)[.](SF|RSA|DSA)$");
    private static final byte[] EOL = "\r\n".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COL = ": ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NAMES = "Name: ".getBytes(StandardCharsets.UTF_8);
    protected final String digestAlg;
    protected final PrivateKey privateKey;
    protected final String signAlg;

    private static void copyFiles(Manifest manifest, JarFile in, JarOutputStream out, long timestamp) throws IOException {
        byte[] buffer = new byte[4096];
        Map<String, Attributes> entries = manifest.getEntries();
        ArrayList<String> names = new ArrayList<String>(entries.keySet());
        Collections.sort(names);
        for (String name : names) {
            int num;
            JarEntry inEntry = in.getJarEntry(name);
            JarEntry outEntry = null;
            outEntry = inEntry.getMethod() == 0 ? new JarEntry(inEntry) : new JarEntry(name);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            InputStream data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
            }
            out.flush();
        }
    }

    public AbstractJarSign(PrivateKey privateKey) {
        this(privateKey, "SHA1", "SHA1withRSA");
    }

    public AbstractJarSign(PrivateKey privateKey, String digestAlg, String signAlg) {
        this.privateKey = privateKey;
        this.digestAlg = digestAlg;
        this.signAlg = signAlg;
    }

    private Manifest addDigestsToManifest(JarFile jar) throws IOException, GeneralSecurityException {
        Manifest input = jar.getManifest();
        Manifest output = new Manifest();
        Attributes main = output.getMainAttributes();
        if (input != null) {
            main.putAll((Map<?, ?>)input.getMainAttributes());
        }
        main.putValue("Manifest-Version", "1.0");
        main.putValue("Created-By", "1.6.0_21 (d2j-" + AbstractJarSign.class.getPackage().getImplementationVersion() + ")");
        MessageDigest md = MessageDigest.getInstance(this.digestAlg);
        byte[] buffer = new byte[4096];
        TreeMap<String, JarEntry> byName = new TreeMap<String, JarEntry>();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            byName.put(entry.getName(), entry);
        }
        String digName = String.valueOf(this.digestAlg) + "-Digest";
        for (JarEntry entry : byName.values()) {
            int num;
            String name = entry.getName();
            if (entry.isDirectory() || name.equals("META-INF/MANIFEST.MF") || stripPattern.matcher(name).matches()) continue;
            InputStream data = jar.getInputStream(entry);
            while ((num = data.read(buffer)) > 0) {
                md.update(buffer, 0, num);
            }
            Attributes attr = null;
            if (input != null) {
                attr = input.getAttributes(name);
            }
            attr = attr != null ? new Attributes(attr) : new Attributes();
            attr.putValue(digName, this.encodeBase64(md.digest()));
            output.getEntries().put(name, attr);
        }
        return output;
    }

    protected String encodeBase64(byte[] data) {
        return Base64.encodeToString(data, 2);
    }

    public void sign(File in, File out) throws IOException, GeneralSecurityException {
        ZipFile inputJar = null;
        JarOutputStream outputJar = null;
        FileOutputStream outputFile = null;
        try {
            long timestamp = System.currentTimeMillis();
            inputJar = new JarFile(in, false);
            FileOutputStream outputStream = outputFile = new FileOutputStream(out);
            outputJar = new JarOutputStream(outputStream);
            outputJar.setLevel(9);
            Manifest manifest = this.addDigestsToManifest((JarFile)inputJar);
            JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            manifest.write(outputJar);
            Signature signature = Signature.getInstance(this.signAlg);
            signature.initSign(this.privateKey);
            je = new JarEntry("META-INF/CERT.SF");
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            this.writeSignatureFile(manifest, new SignatureOutputStream(outputJar, signature));
            int i = this.digestAlg.toLowerCase().indexOf("with");
            String ext = i > 0 ? this.digestAlg.substring(i + 4) : "RSA";
            je = new JarEntry("META-INF/CERT." + ext);
            je.setTime(timestamp);
            outputJar.putNextEntry(je);
            this.writeSignatureBlock(signature.sign(), outputJar);
            AbstractJarSign.copyFiles(manifest, (JarFile)inputJar, outputJar, timestamp);
            outputJar.close();
            outputJar = null;
            outputStream.flush();
        }
        finally {
            try {
                if (inputJar != null) {
                    inputJar.close();
                }
                if (outputFile != null) {
                    outputFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract void writeSignatureBlock(byte[] var1, OutputStream var2) throws IOException;

    private void writeSignatureFile(Manifest manifest, SignatureOutputStream out) throws IOException, GeneralSecurityException {
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        main.putValue("Created-By", "1.6.0_21 (d2j-" + AbstractJarSign.class.getPackage().getImplementationVersion() + ")");
        MessageDigest md = MessageDigest.getInstance(this.digestAlg);
        DigestOutputStream print = new DigestOutputStream(new OutputStream(){

            @Override
            public void write(byte[] b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }

            @Override
            public void write(int b) throws IOException {
            }
        }, md);
        manifest.write(print);
        print.flush();
        main.putValue(String.valueOf(this.digestAlg) + "-Digest-Manifest", this.encodeBase64(md.digest()));
        Manifest m2 = new Manifest();
        m2.getMainAttributes().putAll((Map<?, ?>)manifest.getMainAttributes());
        m2.write(print);
        main.putValue(String.valueOf(this.digestAlg) + "-Digest-Manifest-Main-Attributes", this.encodeBase64(md.digest()));
        String digName = String.valueOf(this.digestAlg) + "-Digest";
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            print.write(NAMES);
            print.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
            print.write(EOL);
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.write(att.getKey().toString().getBytes(StandardCharsets.UTF_8));
                print.write(COL);
                print.write(att.getKey().toString().getBytes(StandardCharsets.UTF_8));
                print.write(EOL);
            }
            print.write(EOL);
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue(digName, this.encodeBase64(md.digest()));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        sf.write(out);
        if (out.size() % 1024 == 0) {
            out.write(EOL);
        }
    }

    private static class SignatureOutputStream
    extends FilterOutputStream {
        private int mCount;
        private Signature mSignature;

        public SignatureOutputStream(OutputStream out, Signature sig) {
            super(out);
            this.mSignature = sig;
            this.mCount = 0;
        }

        public int size() {
            return this.mCount;
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                this.mSignature.update(b, 0, b.length);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            this.out.write(b);
            this.mCount += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.mSignature.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            this.out.write(b, off, len);
            this.mCount += len;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.mSignature.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("SignatureException: " + e);
            }
            this.out.write(b);
            ++this.mCount;
        }
    }
}

