/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExistsQuery
extends AbstractQuery {
    private final Class<?> type;
    private final String methodName;
    private final Class<?>[] parameterTypes;

    public MethodExistsQuery(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        this.type = type;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public String getName() {
        return "methodName/" + this.type.getName() + "." + this.methodName + " " + Arrays.toString(this.parameterTypes);
    }

    public Method findMethod(Result result, String prefix) {
        try {
            Method method = this.type.getDeclaredMethod(this.methodName, this.parameterTypes);
            result.put(prefix + "method", method);
            return method;
        }
        catch (NoSuchMethodException e) {
            this.thrown(result, prefix, e);
        }
        catch (SecurityException e) {
            this.thrown(result, prefix, e);
        }
        return null;
    }

    @Override
    public void call(Result result, String prefix) {
        Method method = this.findMethod(result, prefix);
        result.put(prefix + "exists", method != null);
    }
}

