/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassExistsQuery
extends AbstractQuery {
    public final String className;

    public ClassExistsQuery(String className) {
        this.className = className;
    }

    @Override
    public String getName() {
        return "classExists/" + this.className;
    }

    public Class<?> findClass(Result result, String prefix, ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        result.put(prefix + "className", this.className);
        try {
            Class<?> type = loader.loadClass(this.className);
            result.put(prefix + "classLoader", loader);
            new ClassQuery(type).call(result, prefix);
            return type;
        }
        catch (ClassNotFoundException e) {
            result.put(prefix + "className", this.className + " (not found)");
        }
        catch (Throwable t) {
            result.put(prefix + "classLoader", loader);
            this.thrown(result, prefix, t);
        }
        return null;
    }

    public Class<?> findClass(Result result, String prefix) {
        ClassLoader contextLoader;
        ClassLoader appLoader;
        Class<?> out = null;
        Class<?> c = this.findClass(result, prefix + "bootClassLoader/", String.class.getClassLoader());
        if (c != null) {
            out = c;
        }
        if ((appLoader = this.getClass().getClassLoader()) != String.class.getClassLoader() && (c = this.findClass(result, prefix + "appClassLoader/", appLoader)) != null) {
            out = c;
        }
        if ((contextLoader = Thread.currentThread().getContextClassLoader()) != String.class.getClassLoader() && contextLoader != appLoader && (c = this.findClass(result, prefix + "contextClassLoader/", Thread.currentThread().getContextClassLoader())) != null) {
            out = c;
        }
        return out;
    }

    @Override
    public void call(Result result, String prefix) {
        Class<?> c = this.findClass(result, prefix);
    }
}

