/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.ossindex.service.client.util.OsType;

public class UserDataLocation
implements Supplier<Path> {
    private static final Logger log = LoggerFactory.getLogger(UserDataLocation.class);
    private final String vendor;
    private final String product;
    @VisibleForTesting
    static final String LOCALAPPDATA = "LOCALAPPDATA";
    @VisibleForTesting
    static final String APPDATA = "APPDATA";
    @VisibleForTesting
    static final String USERPROFILE = "USERPROFILE";

    public UserDataLocation(String vendor, String product) {
        this.vendor = (String)Preconditions.checkNotNull((Object)vendor);
        this.product = (String)Preconditions.checkNotNull((Object)product);
    }

    public Path get() {
        OsType osType = this.osType();
        log.debug("OS type: {}", (Object)osType);
        switch (osType) {
            case MAC: {
                return this.mac();
            }
            case WINDOWS: {
                return this.windows();
            }
            case LINUX: {
                return this.linux();
            }
        }
        return this.other();
    }

    @VisibleForTesting
    protected OsType osType() {
        return OsType.detect();
    }

    @Nullable
    @VisibleForTesting
    protected String getenv(String name) {
        return System.getenv(name);
    }

    @VisibleForTesting
    protected Path userHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    private Path mac() {
        return this.userHome().resolve(Paths.get("Library", "Application Support", this.vendor, this.product));
    }

    private Path linux() {
        String dirName = String.format("%s-%s", this.vendor, this.product).toLowerCase(Locale.ENGLISH);
        return this.userHome().resolve(Paths.get(".config", dirName));
    }

    private Path other() {
        String dirName = String.format(".%s-%s", this.vendor, this.product).toLowerCase(Locale.ENGLISH);
        return this.userHome().resolve(dirName);
    }

    @Nullable
    private Path windowsBaseDir() {
        Path path;
        String dirName = this.getenv(LOCALAPPDATA);
        if (dirName != null) {
            return Paths.get(dirName, new String[0]);
        }
        dirName = this.getenv(APPDATA);
        if (dirName != null) {
            return Paths.get(dirName, new String[0]);
        }
        dirName = this.getenv(USERPROFILE);
        if (dirName != null && Files.exists(path = Paths.get(dirName, "Local Settings", "Application Data"), new LinkOption[0])) {
            return path;
        }
        return null;
    }

    private Path windows() {
        Path basedir = this.windowsBaseDir();
        if (basedir != null) {
            return basedir.resolve(Paths.get(this.vendor, this.product));
        }
        log.warn("Unable to determine user-data location for Windows");
        return this.other();
    }
}

