/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.proxy.Listener;
import org.owasp.webscarab.plugin.proxy.NetworkSimulator;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;
import org.owasp.webscarab.plugin.proxy.ProxyUI;
import org.owasp.webscarab.plugin.proxy.ScriptableConnection;

public class Proxy
implements Plugin {
    private boolean _running = false;
    private Framework _framework = null;
    private ProxyUI _ui = null;
    private ArrayList _plugins = new ArrayList();
    private TreeMap _listeners = new TreeMap();
    private TreeMap _simulators = new TreeMap();
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _status = "Stopped";
    private int _pending = 0;
    private ConnectionHook _allowConnection = new ConnectionHook("Allow connection", "Called when a new connection is received from a browser\nuse connection.getAddress() and connection.closeConnection() to decide and react");
    private ConnectionHook _interceptRequest = new ConnectionHook("Intercept request", "Called when a new request has been submitted by the browser\nuse connection.getRequest() and connection.setRequest(request) to perform changes");
    private ConnectionHook _interceptResponse = new ConnectionHook("Intercept response", "Called when the request has been submitted to the server, and the response has been recieved.\nuse connection.getResponse() and connection.setResponse(response) to perform changes");

    public Proxy(Framework framework) throws IOException {
        this._framework = framework;
        this.createSimulators();
        this.createListeners();
    }

    @Override
    public Hook[] getScriptingHooks() {
        return new Hook[]{this._allowConnection, this._interceptRequest, this._interceptResponse};
    }

    @Override
    public Object getScriptableObject() {
        return null;
    }

    void allowClientConnection(ScriptableConnection connection) {
        this._allowConnection.runScripts(connection);
    }

    void interceptRequest(ScriptableConnection connection) {
        this._interceptRequest.runScripts(connection);
    }

    void interceptResponse(ScriptableConnection connection) {
        this._interceptResponse.runScripts(connection);
    }

    public void setUI(ProxyUI ui) {
        this._ui = ui;
        if (this._ui != null) {
            this._ui.setEnabled(this._running);
        }
    }

    public void addPlugin(ProxyPlugin plugin) {
        this._plugins.add(plugin);
    }

    public ProxyPlugin getPlugin(String name) {
        ProxyPlugin plugin2 = null;
        for (ProxyPlugin plugin2 : this._plugins) {
            if (!plugin2.getPluginName().equals(name)) continue;
            return plugin2;
        }
        return null;
    }

    @Override
    public String getPluginName() {
        return new String("Proxy");
    }

    public String[] getProxies() {
        if (this._listeners.size() == 0) {
            return new String[0];
        }
        return this._listeners.keySet().toArray(new String[0]);
    }

    public String getAddress(String key) {
        Listener l = (Listener)this._listeners.get(key);
        if (l != null) {
            return l.getAddress();
        }
        return null;
    }

    public int getPort(String key) {
        Listener l = (Listener)this._listeners.get(key);
        if (l != null) {
            return l.getPort();
        }
        return -1;
    }

    public HttpUrl getBase(String key) {
        Listener l = (Listener)this._listeners.get(key);
        if (l != null) {
            return l.getBase();
        }
        return null;
    }

    public String[] getSimulators() {
        return this._simulators.keySet().toArray(new String[0]);
    }

    public String getSimulator(String key) {
        Listener l = (Listener)this._listeners.get(key);
        if (l != null) {
            NetworkSimulator netsim = l.getSimulator();
            if (netsim != null) {
                return netsim.getName();
            }
            return "Unlimited";
        }
        return "Unlimited";
    }

    public boolean usesPlugins(String key) {
        Listener l = (Listener)this._listeners.get(key);
        if (l != null) {
            return l.usesPlugins();
        }
        return false;
    }

    public boolean isPrimaryProxy(String key) {
        Listener l = (Listener)this._listeners.get(key);
        if (l != null) {
            return l.isPrimaryProxy();
        }
        return false;
    }

    protected ProxyPlugin[] getPlugins() {
        ProxyPlugin[] plugins = new ProxyPlugin[this._plugins.size()];
        int i = 0;
        while (i < this._plugins.size()) {
            plugins[i] = (ProxyPlugin)this._plugins.get(i);
            ++i;
        }
        return plugins;
    }

    public void addListener(String address, int port, HttpUrl base, String simulator, boolean usePlugins, boolean primary) throws IOException {
        Listener l = this.createListener(address, port, base, simulator, usePlugins, primary);
        this.startListener(l);
        String key2 = l.getKey();
        Preferences.setPreference("Proxy.listener." + key2 + ".base", base == null ? "" : base.toString());
        Preferences.setPreference("Proxy.listener." + key2 + ".useplugins", usePlugins ? "yes" : "no");
        Preferences.setPreference("Proxy.listener." + key2 + ".simulator", simulator);
        Preferences.setPreference("Proxy.listener." + key2 + ".primary", primary ? "yes" : "no");
        String value = null;
        for (String key2 : this._listeners.keySet()) {
            value = value == null ? key2 : String.valueOf(value) + ", " + key2;
        }
        Preferences.setPreference("Proxy.listeners", value);
    }

    private void startListener(Listener l) {
        Thread t = new Thread((Runnable)l, "Listener-" + l.getKey());
        t.setDaemon(true);
        t.start();
        if (this._ui != null) {
            this._ui.proxyStarted(l.getKey());
        }
    }

    private boolean stopListener(Listener l) {
        boolean stopped = l.stop();
        if (stopped && this._ui != null) {
            this._ui.proxyStopped(l.getKey());
        }
        return stopped;
    }

    public boolean removeListener(String key2) {
        Listener l = (Listener)this._listeners.get(key2);
        if (l == null) {
            return false;
        }
        if (this.stopListener(l)) {
            this._listeners.remove(key2);
            if (this._ui != null) {
                this._ui.proxyRemoved(key2);
            }
            Preferences.remove("Proxy.listener." + key2 + ".base");
            Preferences.remove("Proxy.listener." + key2 + ".useplugins");
            Preferences.remove("Proxy.listener." + key2 + ".simulator");
            Preferences.remove("Proxy.listener." + key2 + ".primary");
            String value = null;
            for (String key2 : this._listeners.keySet()) {
                value = value == null ? key2 : String.valueOf(value) + ", " + key2;
            }
            if (value == null) {
                value = "";
            }
            Preferences.setPreference("Proxy.listeners", value);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        for (String key : this._listeners.keySet()) {
            Listener l = (Listener)this._listeners.get(key);
            this.startListener(l);
        }
        this._running = true;
        if (this._ui != null) {
            this._ui.setEnabled(this._running);
        }
        this._status = "Started, Idle";
    }

    @Override
    public boolean stop() {
        this._running = false;
        for (String key : this._listeners.keySet()) {
            Listener l = (Listener)this._listeners.get(key);
            if (this.stopListener(l)) continue;
            this._logger.severe("Failed to stop Listener-" + l.getKey());
            this._running = true;
        }
        if (this._ui != null) {
            this._ui.setEnabled(this._running);
        }
        this._status = "Stopped";
        return !this._running;
    }

    protected ConversationID gotRequest(Request request) {
        ConversationID id = this._framework.reserveConversationID();
        if (this._ui != null) {
            this._ui.requested(id, request.getMethod(), request.getURL());
        }
        ++this._pending;
        this._status = "Started, " + this._pending + " in progress";
        return id;
    }

    protected void gotResponse(ConversationID id, Response response) {
        if (this._ui != null) {
            this._ui.received(id, response.getStatusLine());
        }
        this._framework.addConversation(id, response.getRequest(), response, this.getPluginName());
        --this._pending;
        this._status = "Started, " + (this._pending > 0 ? String.valueOf(this._pending) + " in progress" : "Idle");
    }

    protected void failedResponse(ConversationID id, String reason) {
        if (this._ui != null) {
            this._ui.aborted(id, reason);
        }
        --this._pending;
        this._status = "Started, " + (this._pending > 0 ? String.valueOf(this._pending) + " in progress" : "Idle");
    }

    private void createSimulators() {
        this._simulators.put("Unlimited", null);
        this._simulators.put("T1", new NetworkSimulator("T1", 3, 154400, 154400));
        this._simulators.put("DSL (384k down, 128k up)", new NetworkSimulator("DSL (384k down, 128k up)", 10, 13107, 39321));
        this._simulators.put("Bonded ISDN", new NetworkSimulator("Bonded ISDN", 20, 13107, 13107));
        this._simulators.put("ISDN", new NetworkSimulator("ISDN", 20, 6553, 6553));
        this._simulators.put("56k modem", new NetworkSimulator("56k modem", 200, 3360, 5600));
        this._simulators.put("28k modem", new NetworkSimulator("28k modem", 200, 2880));
    }

    private void createListeners() throws IOException {
        String prop = "Proxy.listeners";
        String value = Preferences.getPreference(prop);
        if (value == null || value.trim().equals("")) {
            value = "127.0.0.1:8008";
        }
        String[] listeners = value.trim().split(" *,+ *");
        int port = 0;
        boolean usePlugins = false;
        String simulator = null;
        boolean primary = false;
        int i = 0;
        while (i < listeners.length) {
            block12: {
                HttpUrl base;
                String addr = listeners[i].substring(0, listeners[i].indexOf(":"));
                try {
                    port = Integer.parseInt(listeners[i].substring(listeners[i].indexOf(":") + 1).trim());
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Error parsing port for " + listeners[i] + ", skipping it!");
                    break block12;
                }
                prop = "Proxy.listener." + listeners[i] + ".base";
                value = Preferences.getPreference(prop, "");
                if (value.equals("")) {
                    base = null;
                } else {
                    try {
                        base = new HttpUrl(value);
                    }
                    catch (MalformedURLException mue) {
                        this._logger.severe("Malformed 'base' parameter for listener '" + listeners[i] + "'");
                        break;
                    }
                }
                prop = "Proxy.listener." + listeners[i] + ".useplugins";
                value = Preferences.getPreference(prop, "true");
                usePlugins = value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
                prop = "Proxy.listener." + listeners[i] + ".simulator";
                value = Preferences.getPreference(prop, "Unlimited");
                if (!value.trim().equals("") && this._simulators.containsKey(value)) {
                    simulator = value;
                } else {
                    this._logger.warning("Unknown network simulator '" + value + "'");
                }
                prop = "Proxy.listener." + listeners[i] + ".primary";
                value = Preferences.getPreference(prop, "false");
                primary = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
                try {
                    Listener l = this.createListener(addr, port, base, simulator, usePlugins, primary);
                }
                catch (IOException ioe) {
                    this._logger.severe("Error starting proxy (" + addr + ":" + port + " " + base + " " + ioe);
                    throw ioe;
                }
            }
            ++i;
        }
    }

    private Listener createListener(String address, int port, HttpUrl base, String simulator, boolean usePlugins, boolean primaryProxy) throws IOException {
        if (base != null && base.equals("")) {
            base = null;
        }
        if (simulator == null || simulator.trim().equals("") || !this._simulators.containsKey(simulator)) {
            simulator = "Unlimited";
        }
        NetworkSimulator netsim = (NetworkSimulator)this._simulators.get(simulator);
        Listener l = new Listener(this, address, port);
        l.setBase(base);
        l.setSimulator(netsim);
        l.usePlugins(usePlugins);
        l.setPrimaryProxy(primaryProxy);
        String key = l.getKey();
        this._listeners.put(key, l);
        if (this._ui != null) {
            this._ui.proxyAdded(key);
        }
        return l;
    }

    @Override
    public void flush() throws StoreException {
        for (ProxyPlugin plugin : this._plugins) {
            plugin.flush();
        }
    }

    @Override
    public boolean isBusy() {
        return this._pending > 0;
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void analyse(ConversationID id, Request request, Response response, String origin) {
    }

    @Override
    public void setSession(String type, Object store, String session) throws StoreException {
        for (ProxyPlugin plugin : this._plugins) {
            plugin.setSession(type, store, session);
        }
    }

    @Override
    public boolean isRunning() {
        return this._running;
    }

    private class ConnectionHook
    extends Hook {
        public ConnectionHook(String name, String description) {
            super(name, description);
        }

        public void runScripts(ScriptableConnection connection) {
        }
    }
}

