/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.ConversationEvent;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationListener;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;

public abstract class AbstractConversationModel
implements ConversationModel {
    private FrameworkModel _model;
    private EventListenerList _listenerList = new EventListenerList();
    private Sync _readLock;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public AbstractConversationModel(FrameworkModel model) {
        this._model = model;
    }

    @Override
    public abstract int getConversationCount();

    @Override
    public abstract ConversationID getConversationAt(int var1);

    @Override
    public abstract int getIndexOfConversation(ConversationID var1);

    @Override
    public abstract Sync readLock();

    @Override
    public String getConversationOrigin(ConversationID id) {
        return this._model.getConversationOrigin(id);
    }

    @Override
    public Date getConversationDate(ConversationID id) {
        return this._model.getConversationDate(id);
    }

    @Override
    public String getRequestMethod(ConversationID id) {
        return this._model.getRequestMethod(id);
    }

    @Override
    public String getResponseStatus(ConversationID id) {
        return this._model.getResponseStatus(id);
    }

    @Override
    public HttpUrl getRequestUrl(ConversationID id) {
        return this._model.getRequestUrl(id);
    }

    @Override
    public Request getRequest(ConversationID id) {
        return this._model.getRequest(id);
    }

    @Override
    public Response getResponse(ConversationID id) {
        return this._model.getResponse(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConversationListener(ConversationListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.remove(ConversationListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConversationListener(ConversationListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.add(ConversationListener.class, listener);
        }
    }

    protected void fireConversationAdded(ConversationID id, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        ConversationEvent evt = new ConversationEvent(this, id, position);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ConversationListener.class) {
                try {
                    ((ConversationListener)listeners[i + 1]).conversationAdded(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireConversationRemoved(ConversationID id, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        ConversationEvent evt = new ConversationEvent(this, id, position);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ConversationListener.class) {
                try {
                    ((ConversationListener)listeners[i + 1]).conversationRemoved(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireConversationChanged(ConversationID id, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        ConversationEvent evt = new ConversationEvent(this, id, position);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ConversationListener.class) {
                try {
                    ((ConversationListener)listeners[i + 1]).conversationChanged(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireConversationsChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ConversationListener.class) {
                try {
                    ((ConversationListener)listeners[i + 1]).conversationsChanged();
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }
}

