/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.CaptureHandler;
import com.cookiecadger.Utils;
import java.io.IOException;
import java.util.Scanner;

public class CookieCadgerHeadless {
    public CookieCadgerHeadless() {
        int captureDevice;
        CaptureHandler captureHandler;
        block7: {
            Scanner systemInput = new Scanner(System.in);
            Utils.consoleMessage("\n\nCookie Cadger (v1.08, https://cookiecadger.com)\nCreated by Matthew Sullivan - mattslifebytes.com\nThis software is freely distributed under the terms of the FreeBSD license.\n");
            if (Utils.programSettings.get("dbEngine").equals("sqlite")) {
                Utils.consoleMessage("Fatal error: headless mode requires the use of an external database. Invoke with '--help' for database options.");
                System.exit(1);
            }
            Utils.initializeDatabase();
            captureHandler = new CaptureHandler();
            captureHandler.initializeDeviceList();
            captureDevice = -1;
            if ((Integer)Utils.programSettings.get("interfaceNum") != -1) {
                captureDevice = (Integer)Utils.programSettings.get("interfaceNum") - 1;
            } else {
                Utils.consoleMessage("Please enter the ID of the device you wish to capture from:");
                captureDevice = systemInput.nextInt() - 1;
            }
            if ((Integer)Utils.programSettings.get("bSessionDetection") == -1) {
                String enableSessionDetection;
                Utils.consoleMessage("\nSession detection replays web requests in the background and analyzes them for evidence that a user is logged in. Enabling session detection will cause Cookie Cadger to utilize a larger amount of available system resources.\n\nBy enabling this feature you also understand that:\n1) Cookie Cadger will (potentially) automatically impersonate any network user without their explicit permission or interaction on your part.\n\n2) The legality of doing so varies between jurisdictions. It is your responsibility to understand and comply with any applicable laws.\n\n");
                do {
                    Utils.consoleMessage("Would you like to enable session detection? [Y/n]");
                    enableSessionDetection = systemInput.next();
                    if (!enableSessionDetection.toLowerCase().equals("y")) continue;
                    Utils.programSettings.put("bSessionDetection", 1);
                    break block7;
                } while (!enableSessionDetection.toLowerCase().equals("n"));
                Utils.programSettings.put("bSessionDetection", 0);
            }
        }
        try {
            captureHandler.startCapture(captureDevice, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

