/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.MBeanElement;
import org.jboss.mx.util.MLetVersion;

public class MBeanInstaller {
    public static final String VERSIONS = "versions";
    public static final String DATE = "date";
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$util$MBeanInstaller == null ? (class$org$jboss$mx$util$MBeanInstaller = MBeanInstaller.class$("org.jboss.mx.util.MBeanInstaller")) : class$org$jboss$mx$util$MBeanInstaller);
    private MBeanServer server;
    private ClassLoader ctxClassLoader;
    private ObjectName loaderName;
    private ObjectName registryName;
    static /* synthetic */ Class class$org$jboss$mx$util$MBeanInstaller;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;

    public MBeanInstaller(MBeanServer server, ClassLoader ctxClassLoader, ObjectName loaderName) throws Exception {
        this.server = server;
        this.ctxClassLoader = ctxClassLoader;
        this.loaderName = loaderName;
        this.registryName = new ObjectName("JMImplementation:type=MBeanRegistry");
    }

    public ObjectInstance installMBean(MBeanElement element) throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        log.debug("Installing MBean: " + element);
        ObjectInstance instance = null;
        ObjectName elementName = this.getElementName(element);
        instance = element.getVersions().isEmpty() || !this.server.isRegistered(elementName) ? this.createMBean(element) : this.updateMBean(element);
        return instance;
    }

    public ObjectInstance createMBean(MBeanElement element) throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        log.debug("Creating MBean.. ");
        ObjectName elementName = this.getElementName(element);
        Map valueMap = this.createValueMap(element);
        Object instance = this.server.instantiate(element.getCode(), this.loaderName, element.getConstructorValues(), element.getConstructorTypes());
        return this.registerMBean(instance, elementName, valueMap);
    }

    public ObjectInstance updateMBean(MBeanElement element) throws MBeanException, ReflectionException, InstanceNotFoundException, MalformedObjectNameException {
        log.debug("updating MBean... ");
        ObjectName elementName = this.getElementName(element);
        MLetVersion preVersion = new MLetVersion(this.getVersions(elementName));
        MLetVersion newVersion = new MLetVersion(element.getVersions());
        log.debug("Installed version : " + preVersion);
        log.debug("Loaded version    : " + newVersion);
        if (!preVersion.isNull() && !newVersion.isNull() && preVersion.compareTo(newVersion) < 0) {
            if (this.server.isRegistered(elementName)) {
                this.unregisterMBean(elementName);
                log.debug("Unregistering previous version " + preVersion);
            }
            log.debug("Installing newer version " + newVersion);
            return this.createMBean(element);
        }
        return this.server.getObjectInstance(elementName);
    }

    private ObjectName getElementName(MBeanElement element) throws MalformedObjectNameException {
        return element.getName() != null ? new ObjectName(element.getName()) : null;
    }

    private Map createValueMap(MBeanElement element) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (element.getVersions() != null && !element.getVersions().isEmpty()) {
            valueMap.put(VERSIONS, element.getVersions());
        }
        valueMap.put(DATE, new Date(System.currentTimeMillis()));
        valueMap.put("org.jboss.mx.classloader", this.ctxClassLoader);
        return valueMap;
    }

    private List getVersions(ObjectName name) throws MBeanException, ReflectionException, InstanceNotFoundException {
        if (!this.server.isRegistered(name)) {
            return null;
        }
        return (List)this.getValue(name, VERSIONS);
    }

    private Object getValue(ObjectName name, String key) throws MBeanException, ReflectionException, InstanceNotFoundException {
        Object value = this.server.invoke(this.registryName, "getValue", new Object[]{name, key}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanInstaller.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (class$java$lang$String == null ? (class$java$lang$String = MBeanInstaller.class$("java.lang.String")) : class$java$lang$String).getName()});
        return value;
    }

    private ObjectInstance registerMBean(Object object, ObjectName name, Map valueMap) throws MBeanException, ReflectionException, InstanceNotFoundException {
        if (object == null) {
            throw new ReflectionException(new IllegalArgumentException("Attempting to register a null object"));
        }
        return (ObjectInstance)this.server.invoke(this.registryName, "registerMBean", new Object[]{object, name, valueMap}, new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = MBeanInstaller.class$("java.lang.Object")) : class$java$lang$Object).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanInstaller.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName(), (class$java$util$Map == null ? (class$java$util$Map = MBeanInstaller.class$("java.util.Map")) : class$java$util$Map).getName()});
    }

    private void unregisterMBean(ObjectName name) throws MBeanException, ReflectionException, InstanceNotFoundException {
        this.server.invoke(this.registryName, "unregisterMBean", new Object[]{name}, new String[]{(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = MBeanInstaller.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

