/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class MBeanServerInvocationHandler
implements InvocationHandler {
    private MBeanServerConnection connection;
    private ObjectName name;
    private HashMap mappings;
    private int count;
    private static final String[] EMPTY_SIGNATURE = new String[0];
    private static final String[] EQUALS_SIGNATURE = new String[]{(class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getName()};
    private static final Class[] LISTENER = new Class[]{class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = MBeanServerInvocationHandler.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener};
    private static final Class[] TRIPLET = new Class[]{class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = MBeanServerInvocationHandler.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener, class$javax$management$NotificationFilter == null ? (class$javax$management$NotificationFilter = MBeanServerInvocationHandler.class$("javax.management.NotificationFilter")) : class$javax$management$NotificationFilter, class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object};
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private static final Method TO_STRING;
    private static final Method ADD_NOTIFICATION_LISTENER;
    private static final Method GET_NOTIFICATION_INFO;
    private static final Method REMOVE_NOTIFICATION_LISTENER;
    private static final Method REMOVE_NOTIFICATION_LISTENER_TRIPLET;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$javax$management$NotificationListener;
    static /* synthetic */ Class class$javax$management$NotificationFilter;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;
    static /* synthetic */ Class class$javax$management$NotificationEmitter;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static Object newProxyInstance(MBeanServerConnection connection, ObjectName name, Class interfaceClass, boolean broadcaster) {
        MBeanServerInvocationHandler handler = new MBeanServerInvocationHandler(connection, name);
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Null interface");
        }
        Class[] interfaces = broadcaster ? new Class[]{interfaceClass, class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = MBeanServerInvocationHandler.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter} : new Class[]{interfaceClass};
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    public MBeanServerInvocationHandler(MBeanServerConnection connection, ObjectName name) {
        if (connection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (name.isPattern()) {
            throw new IllegalArgumentException("Name is a pattern");
        }
        this.connection = connection;
        this.name = name;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.getAction(proxy, method).perform(args);
    }

    private Action getAction(Object proxy, Method method) throws Throwable {
        Action result;
        if (this.mappings == null) {
            this.mappings = this.getMappings(proxy);
        }
        if ((result = (Action)this.mappings.get(method)) == null) {
            throw new IllegalArgumentException("Unknown method " + method);
        }
        return result;
    }

    private HashMap getMappings(Object proxy) throws Throwable {
        HashMap<Method, Action> result = new HashMap<Method, Action>();
        Class<?>[] interfaces = proxy.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(class$javax$management$NotificationEmitter == null ? MBeanServerInvocationHandler.class$("javax.management.NotificationEmitter") : class$javax$management$NotificationEmitter)) {
                result.put(ADD_NOTIFICATION_LISTENER, new AddNotificationListenerAction());
                result.put(GET_NOTIFICATION_INFO, new GetNotificationInfoAction());
                result.put(REMOVE_NOTIFICATION_LISTENER, new RemoveNotificationListenerAction());
                result.put(REMOVE_NOTIFICATION_LISTENER_TRIPLET, new RemoveNotificationListenerTripletAction());
                continue;
            }
            Method[] methods = interfaces[i].getMethods();
            for (int m = 0; m < methods.length; ++m) {
                String methodName = methods[m].getName();
                Class<?> returnType = methods[m].getReturnType();
                Class[] parameterTypes = methods[m].getParameterTypes();
                if (methodName.startsWith("get") && methodName.length() > 3 && !Void.TYPE.equals(returnType) && parameterTypes.length == 0) {
                    result.put(methods[m], new GetAction(methodName.substring(3)));
                    continue;
                }
                if (methodName.startsWith("is") && methodName.length() > 2 && (Boolean.TYPE.equals(returnType) || (class$java$lang$Boolean == null ? MBeanServerInvocationHandler.class$("java.lang.Boolean") : class$java$lang$Boolean).equals(returnType)) && parameterTypes.length == 0) {
                    result.put(methods[m], new GetAction(methodName.substring(2)));
                    continue;
                }
                if (methodName.startsWith("set") && methodName.length() > 3 && Void.TYPE.equals(returnType) && parameterTypes.length == 1) {
                    result.put(methods[m], new SetAction(methodName.substring(3)));
                    continue;
                }
                result.put(methods[m], new InvokeAction(methodName, MBeanServerInvocationHandler.getSignature(parameterTypes)));
            }
        }
        result.put(EQUALS, new InvokeAction(EQUALS.getName(), EQUALS_SIGNATURE));
        result.put(HASH_CODE, new InvokeAction(HASH_CODE.getName(), EMPTY_SIGNATURE));
        result.put(TO_STRING, new InvokeAction(TO_STRING.getName(), EMPTY_SIGNATURE));
        return result;
    }

    private static String[] getSignature(Class[] parameterTypes) {
        String[] signature = new String[parameterTypes.length];
        for (int p = 0; p < parameterTypes.length; ++p) {
            signature[p] = parameterTypes[p].getName();
        }
        return signature;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ADD_NOTIFICATION_LISTENER = (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = MBeanServerInvocationHandler.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getDeclaredMethod("addNotificationListener", TRIPLET);
            GET_NOTIFICATION_INFO = (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = MBeanServerInvocationHandler.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getDeclaredMethod("getNotificationInfo", new Class[0]);
            REMOVE_NOTIFICATION_LISTENER = (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = MBeanServerInvocationHandler.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getDeclaredMethod("removeNotificationListener", LISTENER);
            REMOVE_NOTIFICATION_LISTENER_TRIPLET = (class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = MBeanServerInvocationHandler.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter).getDeclaredMethod("removeNotificationListener", TRIPLET);
            EQUALS = (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getDeclaredMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object);
            HASH_CODE = (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getDeclaredMethod("hashCode", new Class[0]);
            TO_STRING = (class$java$lang$Object == null ? (class$java$lang$Object = MBeanServerInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object).getDeclaredMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    private class RemoveNotificationListenerTripletAction
    implements Action {
        private RemoveNotificationListenerTripletAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            MBeanServerInvocationHandler.this.connection.removeNotificationListener(MBeanServerInvocationHandler.this.name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
            return null;
        }
    }

    private class RemoveNotificationListenerAction
    implements Action {
        private RemoveNotificationListenerAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            MBeanServerInvocationHandler.this.connection.removeNotificationListener(MBeanServerInvocationHandler.this.name, (NotificationListener)args[0]);
            return null;
        }
    }

    private class GetNotificationInfoAction
    implements Action {
        private GetNotificationInfoAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            return MBeanServerInvocationHandler.this.connection.getMBeanInfo(MBeanServerInvocationHandler.this.name).getNotifications();
        }
    }

    private class AddNotificationListenerAction
    implements Action {
        private AddNotificationListenerAction() {
        }

        public Object perform(Object[] args) throws Throwable {
            MBeanServerInvocationHandler.this.connection.addNotificationListener(MBeanServerInvocationHandler.this.name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
            return null;
        }
    }

    private class InvokeAction
    implements Action {
        private String operation;
        private String[] signature;

        public InvokeAction(String operation, String[] signature) {
            this.operation = operation;
            this.signature = signature;
        }

        public Object perform(Object[] args) throws Throwable {
            try {
                return MBeanServerInvocationHandler.this.connection.invoke(MBeanServerInvocationHandler.this.name, this.operation, args, this.signature);
            }
            catch (MBeanException exception) {
                throw exception.getTargetException();
            }
        }
    }

    private class SetAction
    implements Action {
        private String attribute;

        public SetAction(String attribute) {
            this.attribute = attribute;
        }

        public Object perform(Object[] args) throws Throwable {
            try {
                MBeanServerInvocationHandler.this.connection.setAttribute(MBeanServerInvocationHandler.this.name, new Attribute(this.attribute, args[0]));
                return null;
            }
            catch (MBeanException exception) {
                throw exception.getTargetException();
            }
        }
    }

    private class GetAction
    implements Action {
        private String attribute;

        public GetAction(String attribute) {
            this.attribute = attribute;
        }

        public Object perform(Object[] args) throws Throwable {
            try {
                return MBeanServerInvocationHandler.this.connection.getAttribute(MBeanServerInvocationHandler.this.name, this.attribute);
            }
            catch (MBeanException exception) {
                throw exception.getTargetException();
            }
        }
    }

    private static interface Action {
        public Object perform(Object[] var1) throws Throwable;
    }
}

