import type { SignedIdentifier, TableEntityQueryOptions } from "./models.js";
import type { QueryOptions as GeneratedQueryOptions, SignedIdentifier as GeneratedSignedIdentifier } from "./generated/models/index.js";
export declare function serialize(obj: object): Record<string, Record<string, unknown>>;
export declare function deserialize<T extends object = Record<string, any>>(obj: object, disableTypeConversion?: boolean): T;
export declare function deserializeObjectsArray<T extends object>(objArray: object[], disableTypeConversion: boolean): T[];
/**
 * For ACL endpoints the Tables Service takes an ISO Date without decimals however
 * serializing a JavaScript date gives us a date with decimals 2021-07-08T09:10:09.000Z
 * which makes the XML request body invalid, these 2 functions serialize and deserialize the
 * dates so that they are in the expected format
 */
export declare function serializeSignedIdentifiers(signedIdentifiers: SignedIdentifier[]): GeneratedSignedIdentifier[];
export declare function deserializeSignedIdentifier(signedIdentifiers: GeneratedSignedIdentifier[]): SignedIdentifier[];
export declare function serializeQueryOptions(query: TableEntityQueryOptions): GeneratedQueryOptions;
//# sourceMappingURL=serialization.d.ts.map