import type { NamedKeyCredential } from "@azure/core-auth";
import type { TableSasSignatureValues } from "./tableSasSignatureValues.js";
/**
 * Generates a Table Service Shared Access Signature (SAS) URI based on the client properties
 * and parameters passed in. The SAS is signed by the shared key credential of the client.
 *
 * @see https://learn.microsoft.com/rest/api/storageservices/constructing-a-service-sas
 *
 * @param options - Optional parameters.
 * @returns The SAS URI consisting of the URI to the resource represented by this client, followed by the generated SAS token.
 */
export declare function generateTableSas(tableName: string, credential: NamedKeyCredential, options?: TableSasSignatureValues): string;
//# sourceMappingURL=generateTableSas.d.ts.map