#!/usr/bin/env python
import sys
import os
import fnmatch
import glob
import subprocess

#directory = '../../c_file/{0}'.format(sys.argv[1])
#report_name = '../../c_file/Report/{0}'.format(sys.argv[2])
cur_path = os.path.abspath('{0}/../'.format(os.path.realpath(__file__)))
directory = sys.argv[1]
report_name = sys.argv[2]

name_list = []
for root, dirnames, filenames in os.walk(directory):
  for filename in fnmatch.filter(filenames, '*.c'):
    name_list.append(os.path.join(root, filename))
  for filename in fnmatch.filter(filenames, '*.h'):
    name_list.append(os.path.join(root, filename))

print 'Number of files: {0}'.format(str(len(name_list)))
print 'Analyzing files...'

repeat = len(name_list)/100

for i in range(repeat):
  file_name = ''
  test = ''
  for j in range(100):
    file_name = '{0}{1} '.format(file_name, name_list[i*100+j])
  p = subprocess.Popen('python {0}/./main.py -i {1} -o {2} -a'.format(cur_path, file_name, report_name), stdout=subprocess.PIPE, shell=True)
  p.wait()

if len(name_list)%100:
  last = repeat*100
  file_name = ''
  for i in range(len(name_list)%100):
    file_name = '{0}{1} '.format(file_name, name_list[last+i])
#  p = subprocess.call('python ./main.py -i {0} -o {1} -a'.format(file_name, report_name), shell=True)
  p = subprocess.Popen('python {0}/./main.py -i {1} -o {2} -a'.format(cur_path, file_name, report_name), stdout=subprocess.PIPE, shell=True)
  p.wait()
    
print 'Report is generated at {0}'.format(os.path.abspath(report_name))
