#!/usr/bin/env python
import xml.etree.ElementTree as ET
import os
import re

cur_path = os.path.abspath(os.curdir)
func_list_path = '{0}/../../xml_file/func_list.xml'.format(cur_path)

#Parse XML to get dangerous function list
def parse_dangerous_func():
  flist = []
  tree = ET.parse(func_list_path)
  root = tree.getroot()
  for node in root.findall('./class[@type="dangerous"]/func'):
    fname = node.get('name')
    freg = node.find('reg').text
    flist.append({'name': fname, 'reg': freg})
  return flist

#See if input line contains any dangerous functions
def find_match(pattern, input_line):
  result =re.match(pattern, input_line)
  if result:
    return True
  else:
    return False

