/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.StatFactory;

import bluepot.pkgModel.AttackData.Attack;
import bluepot.pkgModel.AttackData.AttackData;
import bluepot.pkgModel.AttackData.AttackList;
import bluepot.pkgModel.AttackData.AttackModule;
import bluepot.pkgModel.Model;
import bluepot.pkgView.StatFactory.ListManager;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class GraphFactory {
    Model model;
    private AttackData a;
    private AttackModule attackModule;
    private AttackList attackList;
    private Minute startTime = new Minute(Calendar.getInstance().getTime());
    private TimeSeries data;
    private int sensor;
    private String module;
    private String list;
    private String title;
    private String x;
    private String y;
    private int type;
    public static int TYPE_BAR = 1;
    public static int TYPE_TIME = 0;
    Millisecond biggestTime;
    private ListManager listManager;

    public GraphFactory(Model model, int sensor, String module, String list, String title, String x, String y, int type, ListManager listManager) {
        this.model = model;
        this.listManager = listManager;
        this.sensor = sensor;
        this.module = module;
        this.list = list;
        this.x = x;
        this.y = y;
        this.title = title;
        this.type = type;
        this.biggestTime = new Millisecond(new Date(0L));
        this.data = new TimeSeries((Comparable)((Object)""));
        this.data.add((RegularTimePeriod)this.startTime, 0.0);
    }

    public void updateData() {
        int i;
        AttackData[] attackDataStore;
        Millisecond tmpBiggestTime = this.biggestTime;
        if (this.sensor >= 0) {
            attackDataStore = new AttackData[]{this.model.readAttackData(this.sensor)};
        } else {
            attackDataStore = new AttackData[this.model.getNoOfDevices()];
            for (i = 0; i < this.model.getNoOfDevices(); ++i) {
                attackDataStore[i] = this.model.readAttackData(i);
            }
        }
        for (i = 0; i < attackDataStore.length; ++i) {
            String[] listOfModules = null;
            if (!this.module.isEmpty()) {
                listOfModules = new String[]{this.module};
            } else {
                listOfModules = new String[attackDataStore[i].getListOfAttacks().length];
                listOfModules = attackDataStore[i].getListOfAttacks();
            }
            for (int j = 0; j < listOfModules.length; ++j) {
                String[] listOfAttacks = null;
                this.attackModule = attackDataStore[i].getModule(listOfModules[j]);
                if (!this.list.isEmpty()) {
                    listOfAttacks = new String[]{this.list};
                } else {
                    listOfAttacks = new String[this.attackModule.getListOfAttacks().length];
                    listOfAttacks = this.attackModule.getListOfAttacks();
                }
                if (listOfAttacks.length <= 0) continue;
                for (int k = 0; k < listOfAttacks.length; ++k) {
                    this.attackList = this.attackModule.get(listOfAttacks[k]);
                    List<Attack> tmpArrayList = Collections.synchronizedList(this.attackList.getArrayList());
                    for (Attack attack : tmpArrayList) {
                        Date d = attack.getTime();
                        Minute rtp = new Minute(d);
                        Millisecond comp = new Millisecond(d);
                        if (comp.compareTo((Object)tmpBiggestTime) > 0) {
                            tmpBiggestTime = comp;
                        }
                        if (comp.compareTo((Object)this.biggestTime) <= 0) continue;
                        this.listManager.addAttack(attack);
                        if (this.data.getDataItem((RegularTimePeriod)rtp) == null) {
                            this.data.add((RegularTimePeriod)rtp, 1.0);
                            continue;
                        }
                        TimeSeriesDataItem tmp = this.data.getDataItem((RegularTimePeriod)rtp);
                        int plusone = tmp.getValue().intValue() + 1;
                        this.data.addOrUpdate((RegularTimePeriod)rtp, (double)plusone);
                    }
                }
            }
        }
        Minute endTime = new Minute(Calendar.getInstance().getTime());
        if (this.data.getDataItem((RegularTimePeriod)endTime) == null) {
            this.data.add((RegularTimePeriod)endTime, 0.0);
        }
        this.biggestTime = tmpBiggestTime;
    }

    public JFreeChart getChart() {
        TimeSeriesCollection dataset = new TimeSeriesCollection(this.data);
        JFreeChart rtn = null;
        switch (this.type) {
            case 0: {
                rtn = ChartFactory.createTimeSeriesChart((String)this.title, (String)this.x, (String)this.y, (XYDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            default: {
                rtn = ChartFactory.createXYBarChart((String)this.title, (String)this.x, (boolean)true, (String)this.y, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            }
        }
        XYPlot plot = (XYPlot)rtn.getPlot();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rtn.setBorderVisible(false);
        rtn.setBackgroundPaint(null);
        rtn.setAntiAlias(true);
        return rtn;
    }
}

