/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.Sensors;

import bluepot.pkgModel.Model;
import bluepot.pkgView.Sensors.Overview.DevicesTableModel;
import bluepot.pkgView.Sensors.Overview.OverviewConfig;
import bluepot.pkgView.Sensors.Overview.OverviewLog;
import bluepot.pkgView.Sensors.Overview.OverviewStatus;
import bluepot.pkgView.Sensors.Sensor.Status;
import bluepot.pkgView.Sensors.SideTreeCellRenderer;
import bluepot.pkgView.Sensors.SideTreeSelectionListener;
import bluepot.pkgView.View;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTitledPanel;

public class ConfigureSensors
extends JPanel {
    View view;
    Model model;
    private JPanel[][] panels;
    private JTree sideTree;
    private JPanel cards;

    public ConfigureSensors(View view, Model model) {
        this.view = view;
        this.model = model;
        this.setLayout((LayoutManager)new MigLayout("wrap 2"));
        this.panels = new JPanel[model.getNoOfDevices() + 1][3];
        this.cards = new JPanel(new CardLayout());
        int number = model.getNoOfDevices() + 1;
        for (int i = 0; i < number; ++i) {
            if (i > 0) {
                this.panels[i][0] = new Status(i, view, model);
                this.cards.add((Component)this.panels[i][0], "Sensor " + (i - 1) + ".Status");
                continue;
            }
            this.panels[i][0] = new OverviewConfig(i, view, model);
            this.panels[i][1] = new OverviewStatus(i, view, model);
            this.panels[i][2] = new OverviewLog(i, view, model);
            this.cards.add((Component)this.panels[i][1], "Overview.Status");
            this.cards.add((Component)this.panels[i][0], "Overview.Config");
            this.cards.add((Component)this.panels[i][2], "Overview.Log");
        }
        JScrollPane scrollTree = new JScrollPane();
        JXTitledPanel pnlTree = new JXTitledPanel("Sensors", (Container)scrollTree);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Sensors");
        this.creatNodes(rootNode);
        UIManager.getDefaults().put("TreeUI", BasicTreeUI.class.getName());
        this.sideTree = new JTree(new DefaultTreeModel(rootNode));
        this.sideTree.setCellRenderer(new SideTreeCellRenderer());
        this.sideTree.setRootVisible(false);
        this.sideTree.getSelectionModel().setSelectionMode(1);
        this.sideTree.addTreeSelectionListener(new SideTreeSelectionListener(view));
        scrollTree.getViewport().add(this.sideTree);
        pnlTree.setMinimumSize(new Dimension(150, 600));
        for (int row = 0; row < this.sideTree.getRowCount(); ++row) {
            this.sideTree.expandRow(row);
        }
        scrollTree.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.sideTree.putClientProperty("JTree.lineStyle", "Angled");
        Font topBarFont = new Font("Arial", 13, 0);
        this.add((Component)pnlTree, "span 1 2, width 200px, height 100%");
        this.add((Component)this.cards, "h 100%, w 100%");
    }

    public void addLog(int i, String s) {
        Status tmp = (Status)this.panels[i + 1][0];
        tmp.addLog(s);
        OverviewLog tmp2 = (OverviewLog)this.panels[0][2];
        tmp2.addLog("[Device " + i + "] " + s);
    }

    private void creatNodes(DefaultMutableTreeNode rootNode) {
        DefaultMutableTreeNode sensorNode = new DefaultMutableTreeNode("Overview");
        sensorNode.add(new DefaultMutableTreeNode("Config"));
        sensorNode.add(new DefaultMutableTreeNode("Log"));
        rootNode.add(sensorNode);
        for (int i = 0; i < this.model.getNoOfDevices(); ++i) {
            sensorNode = new DefaultMutableTreeNode("Sensor " + i);
            rootNode.add(sensorNode);
        }
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return (DefaultMutableTreeNode)this.sideTree.getLastSelectedPathComponent();
    }

    public void setCard(String string) {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, string);
    }

    public DevicesTableModel getTableModel() {
        OverviewConfig tmp = (OverviewConfig)this.panels[0][0];
        return tmp.getTableModel();
    }

    public JButton getBtnSave() {
        OverviewConfig tmp = (OverviewConfig)this.panels[0][0];
        return tmp.getBtnSave();
    }

    public JButton getBtnReset() {
        OverviewConfig tmp = (OverviewConfig)this.panels[0][0];
        return tmp.getBtnReset();
    }

    public void updateOBEXChart() {
        OverviewStatus tmp = (OverviewStatus)this.panels[0][1];
        tmp.updateCharts();
        for (int i = 1; i < this.model.getNoOfDevices() + 1; ++i) {
            Status tmp2 = (Status)this.panels[i][0];
            tmp2.updateGraphs();
        }
    }

    public void fireSmallTableDataChanged() {
        OverviewStatus tmp = (OverviewStatus)this.panels[this.model.getNoOfDevices()][0];
        tmp.updateSmallTable();
    }

    public void updateSensors() {
        int number = this.model.getNoOfDevices() + 1;
        for (int i = 1; i < number; ++i) {
            Status tmp2 = (Status)this.panels[i][0];
            tmp2.deviceChange();
        }
    }
}

