/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyUnicode;
import org.python.util.PythonInterpreter;

public class InterpreterTest
extends TestCase {
    public void testBasicEval() throws Exception {
        PyDictionary test = new PyDictionary();
        test.__setitem__(new PyUnicode("one"), (PyObject)new PyUnicode("two"));
        PythonInterpreter.initialize(System.getProperties(), null, new String[0]);
        PythonInterpreter interp = new PythonInterpreter();
        PyObject pyo = interp.eval("{u'one': u'two'}");
        InterpreterTest.assertEquals((Object)test, (Object)pyo);
    }

    public void testMultipleThreads() {
        final CountDownLatch doneSignal = new CountDownLatch(10);
        for (int i2 = 0; i2 < 10; ++i2) {
            new Thread(){

                public void run() {
                    PythonInterpreter interp = new PythonInterpreter();
                    interp.exec("import sys");
                    interp.set("a", new PyInteger(41));
                    int set = Py.tojava(interp.get("a"), Integer.class);
                    Assert.assertEquals((int)41, (int)set);
                    interp.exec("x = 'hello ' + 'goodbye'");
                    Assert.assertEquals((String)"hello goodbye", (String)Py.tojava(interp.get("x"), String.class));
                    doneSignal.countDown();
                }
            }.start();
        }
        try {
            doneSignal.await();
        }
        catch (InterruptedException e2) {
            System.err.println("Interpreters in multiple threads test interrupted, bailing");
        }
    }

    public void testCallInstancesFromJava() {
        PythonInterpreter interp = new PythonInterpreter();
        interp.exec("class Blah(object):\n    def __init__(self, val):\n        self.val = val\n    def incval(self):\n        self.val += 1\n        return self.val");
        PyObject blahClass = interp.get("Blah");
        int base2 = 42;
        PyObject blahInstance = blahClass.__call__(new PyInteger(base2));
        for (int i2 = 0; i2 < 4; ++i2) {
            InterpreterTest.assertEquals((Object)(++base2), (Object)blahInstance.invoke("incval").__tojava__(Integer.class));
        }
    }
}

