/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.Arrays;

public class CodegenUtils {
    public static String c(String p2) {
        return p2.replace('/', '.');
    }

    public static String p(Class n2) {
        return n2.getName().replace('.', '/');
    }

    public static String ci(Class n2) {
        if (n2.isArray()) {
            if ((n2 = n2.getComponentType()).isPrimitive()) {
                if (n2 == Byte.TYPE) {
                    return "[B";
                }
                if (n2 == Boolean.TYPE) {
                    return "[Z";
                }
                if (n2 == Short.TYPE) {
                    return "[S";
                }
                if (n2 == Character.TYPE) {
                    return "[C";
                }
                if (n2 == Integer.TYPE) {
                    return "[I";
                }
                if (n2 == Float.TYPE) {
                    return "[F";
                }
                if (n2 == Double.TYPE) {
                    return "[D";
                }
                if (n2 == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n2.getName());
            }
            return "[" + CodegenUtils.ci(n2);
        }
        if (n2.isPrimitive()) {
            if (n2 == Byte.TYPE) {
                return "B";
            }
            if (n2 == Boolean.TYPE) {
                return "Z";
            }
            if (n2 == Short.TYPE) {
                return "S";
            }
            if (n2 == Character.TYPE) {
                return "C";
            }
            if (n2 == Integer.TYPE) {
                return "I";
            }
            if (n2 == Float.TYPE) {
                return "F";
            }
            if (n2 == Double.TYPE) {
                return "D";
            }
            if (n2 == Long.TYPE) {
                return "J";
            }
            if (n2 == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n2.getName());
        }
        return "L" + CodegenUtils.p(n2) + ";";
    }

    public static String sig(Class retval, Class ... params) {
        return CodegenUtils.sigParams(params) + CodegenUtils.ci(retval);
    }

    public static String sig(Class retval, String descriptor, Class ... params) {
        return CodegenUtils.sigParams(descriptor, params) + CodegenUtils.ci(retval);
    }

    public static String sigParams(Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.ci(params[i2]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String sigParams(String descriptor, Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        signature.append(descriptor);
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.ci(params[i2]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static Class[] params(Class ... classes) {
        return classes;
    }

    public static Class[] params(Class cls, int times) {
        Object[] classes = new Class[times];
        Arrays.fill(classes, cls);
        return classes;
    }

    public static Class[] params(Class cls1, Class clsFill, int times) {
        Object[] classes = new Class[times + 1];
        Arrays.fill(classes, clsFill);
        classes[0] = cls1;
        return classes;
    }
}

