/*
 * Decompiled with CFR 0.152.
 */
package org.python.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.ClassReader;
import org.python.objectweb.asm.ClassVisitor;
import org.python.objectweb.asm.FieldVisitor;
import org.python.objectweb.asm.MethodVisitor;
import org.python.objectweb.asm.util.ASMifierAbstractVisitor;
import org.python.objectweb.asm.util.ASMifierAnnotationVisitor;
import org.python.objectweb.asm.util.ASMifierFieldVisitor;
import org.python.objectweb.asm.util.ASMifierMethodVisitor;

public class ASMifierClassVisitor
extends ASMifierAbstractVisitor
implements ClassVisitor {
    protected final PrintWriter pw;

    public static void main(String[] stringArray) throws Exception {
        int n2 = 0;
        int n3 = 2;
        boolean bl2 = true;
        if (stringArray.length < 1 || stringArray.length > 2) {
            bl2 = false;
        }
        if (bl2 && "-debug".equals(stringArray[0])) {
            n2 = 1;
            n3 = 0;
            if (stringArray.length != 2) {
                bl2 = false;
            }
        }
        if (!bl2) {
            System.err.println("Prints the ASM code to generate the given class.");
            System.err.println("Usage: ASMifierClassVisitor [-debug] <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[n2].endsWith(".class") || stringArray[n2].indexOf(92) > -1 || stringArray[n2].indexOf(47) > -1 ? new ClassReader(new FileInputStream(stringArray[n2])) : new ClassReader(stringArray[n2]);
        classReader.accept(new ASMifierClassVisitor(new PrintWriter(System.out)), ASMifierClassVisitor.getDefaultAttributes(), n3);
    }

    public ASMifierClassVisitor(PrintWriter printWriter) {
        super("cw");
        this.pw = printWriter;
    }

    public void visit(int n2, int n3, String string2, String string3, String string4, String[] stringArray) {
        String string5;
        int n4 = string2.lastIndexOf(47);
        if (n4 == -1) {
            string5 = string2;
        } else {
            this.text.add("package asm." + string2.substring(0, n4).replace('/', '.') + ";\n");
            string5 = string2.substring(n4 + 1);
        }
        this.text.add("import java.util.*;\n");
        this.text.add("import org.objectweb.asm.*;\n");
        this.text.add("import org.objectweb.asm.attrs.*;\n");
        this.text.add("public class " + string5 + "Dump implements Opcodes {\n\n");
        this.text.add("public static byte[] dump () throws Exception {\n\n");
        this.text.add("ClassWriter cw = new ClassWriter(0);\n");
        this.text.add("FieldVisitor fv;\n");
        this.text.add("MethodVisitor mv;\n");
        this.text.add("AnnotationVisitor av0;\n\n");
        this.buf.setLength(0);
        this.buf.append("cw.visit(");
        switch (n2) {
            case 196653: {
                this.buf.append("V1_1");
                break;
            }
            case 46: {
                this.buf.append("V1_2");
                break;
            }
            case 47: {
                this.buf.append("V1_3");
                break;
            }
            case 48: {
                this.buf.append("V1_4");
                break;
            }
            case 49: {
                this.buf.append("V1_5");
                break;
            }
            case 50: {
                this.buf.append("V1_6");
                break;
            }
            default: {
                this.buf.append(n2);
            }
        }
        this.buf.append(", ");
        this.appendAccess(n3 | 0x40000);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("new String[] {");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.buf.append(i2 == 0 ? " " : ", ");
                this.appendConstant(stringArray[i2]);
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitSource(String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append("cw.visitSource(");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitOuterClass(String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.buf.append("cw.visitOuterClass(");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public void visitInnerClass(String string2, String string3, String string4, int n2) {
        this.buf.setLength(0);
        this.buf.append("cw.visitInnerClass(");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(", ");
        this.appendAccess(n2 | 0x100000);
        this.buf.append(");\n\n");
        this.text.add(this.buf.toString());
    }

    public FieldVisitor visitField(int n2, String string2, String string3, String string4, Object object) {
        this.buf.setLength(0);
        this.buf.append("{\n");
        this.buf.append("fv = cw.visitField(");
        this.appendAccess(n2 | 0x80000);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(", ");
        this.appendConstant(object);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
        ASMifierFieldVisitor aSMifierFieldVisitor = new ASMifierFieldVisitor();
        this.text.add(aSMifierFieldVisitor.getText());
        this.text.add("}\n");
        return aSMifierFieldVisitor;
    }

    public MethodVisitor visitMethod(int n2, String string2, String string3, String string4, String[] stringArray) {
        this.buf.setLength(0);
        this.buf.append("{\n");
        this.buf.append("mv = cw.visitMethod(");
        this.appendAccess(n2);
        this.buf.append(", ");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.appendConstant(string3);
        this.buf.append(", ");
        this.appendConstant(string4);
        this.buf.append(", ");
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append("new String[] {");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.buf.append(i2 == 0 ? " " : ", ");
                this.appendConstant(stringArray[i2]);
            }
            this.buf.append(" }");
        } else {
            this.buf.append("null");
        }
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
        ASMifierMethodVisitor aSMifierMethodVisitor = this.createASMifierMethodVisitor();
        this.text.add(aSMifierMethodVisitor.getText());
        this.text.add("}\n");
        return aSMifierMethodVisitor;
    }

    protected ASMifierMethodVisitor createASMifierMethodVisitor() {
        return new ASMifierMethodVisitor();
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl2) {
        this.buf.setLength(0);
        this.buf.append("{\n");
        this.buf.append("av0 = cw.visitAnnotation(");
        this.appendConstant(string2);
        this.buf.append(", ");
        this.buf.append(bl2);
        this.buf.append(");\n");
        this.text.add(this.buf.toString());
        ASMifierAnnotationVisitor aSMifierAnnotationVisitor = new ASMifierAnnotationVisitor(0);
        this.text.add(aSMifierAnnotationVisitor.getText());
        this.text.add("}\n");
        return aSMifierAnnotationVisitor;
    }

    public void visitEnd() {
        this.text.add("cw.visitEnd();\n\n");
        this.text.add("return cw.toByteArray();\n");
        this.text.add("}\n");
        this.text.add("}\n");
        ASMifierClassVisitor.printList(this.pw, this.text);
        this.pw.flush();
    }

    void appendAccess(int n2) {
        boolean bl2 = true;
        if ((n2 & 1) != 0) {
            this.buf.append("ACC_PUBLIC");
            bl2 = false;
        }
        if ((n2 & 2) != 0) {
            this.buf.append("ACC_PRIVATE");
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            this.buf.append("ACC_PROTECTED");
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_FINAL");
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STATIC");
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            if ((n2 & 0x40000) == 0) {
                this.buf.append("ACC_SYNCHRONIZED");
            } else {
                this.buf.append("ACC_SUPER");
            }
            bl2 = false;
        }
        if ((n2 & 0x40) != 0 && (n2 & 0x80000) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VOLATILE");
            bl2 = false;
        }
        if ((n2 & 0x40) != 0 && (n2 & 0x40000) == 0 && (n2 & 0x80000) == 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_BRIDGE");
            bl2 = false;
        }
        if ((n2 & 0x80) != 0 && (n2 & 0x40000) == 0 && (n2 & 0x80000) == 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_VARARGS");
            bl2 = false;
        }
        if ((n2 & 0x80) != 0 && (n2 & 0x80000) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_TRANSIENT");
            bl2 = false;
        }
        if ((n2 & 0x100) != 0 && (n2 & 0x40000) == 0 && (n2 & 0x80000) == 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_NATIVE");
            bl2 = false;
        }
        if ((n2 & 0x4000) != 0 && ((n2 & 0x40000) != 0 || (n2 & 0x80000) != 0 || (n2 & 0x100000) != 0)) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ENUM");
            bl2 = false;
        }
        if ((n2 & 0x2000) != 0 && (n2 & 0x40000) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ANNOTATION");
            bl2 = false;
        }
        if ((n2 & 0x400) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_ABSTRACT");
            bl2 = false;
        }
        if ((n2 & 0x200) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_INTERFACE");
            bl2 = false;
        }
        if ((n2 & 0x800) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_STRICT");
            bl2 = false;
        }
        if ((n2 & 0x1000) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_SYNTHETIC");
            bl2 = false;
        }
        if ((n2 & 0x20000) != 0) {
            if (!bl2) {
                this.buf.append(" + ");
            }
            this.buf.append("ACC_DEPRECATED");
            bl2 = false;
        }
        if (bl2) {
            this.buf.append('0');
        }
    }
}

