/*
 * Decompiled with CFR 0.152.
 */
package org.python.objectweb.asm.commons;

import org.python.objectweb.asm.Type;
import org.python.objectweb.asm.commons.RemappingSignatureAdapter;
import org.python.objectweb.asm.signature.SignatureReader;
import org.python.objectweb.asm.signature.SignatureVisitor;
import org.python.objectweb.asm.signature.SignatureWriter;

public abstract class Remapper {
    public String mapDesc(String string2) {
        Type type = Type.getType(string2);
        switch (type.getSort()) {
            case 9: {
                String string3 = this.mapDesc(type.getElementType().getDescriptor());
                for (int i2 = 0; i2 < type.getDimensions(); ++i2) {
                    string3 = '[' + string3;
                }
                return string3;
            }
            case 10: {
                String string4 = this.map(type.getInternalName());
                if (string4 == null) break;
                return 'L' + string4 + ';';
            }
        }
        return string2;
    }

    private Type mapType(Type type) {
        switch (type.getSort()) {
            case 9: {
                String string2 = this.mapDesc(type.getElementType().getDescriptor());
                for (int i2 = 0; i2 < type.getDimensions(); ++i2) {
                    string2 = '[' + string2;
                }
                return Type.getType(string2);
            }
            case 10: {
                String string3 = this.map(type.getInternalName());
                if (string3 == null) break;
                return Type.getObjectType(string3);
            }
        }
        return type;
    }

    public String mapType(String string2) {
        if (string2 == null) {
            return null;
        }
        return this.mapType(Type.getObjectType(string2)).getInternalName();
    }

    public String[] mapTypes(String[] stringArray) {
        String[] stringArray2 = null;
        boolean bl2 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            String string3 = this.map(string2);
            if (string3 != null && stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                if (i2 > 0) {
                    System.arraycopy(stringArray, 0, stringArray2, 0, i2);
                }
                bl2 = true;
            }
            if (!bl2) continue;
            stringArray2[i2] = string3 == null ? string2 : string3;
        }
        return bl2 ? stringArray2 : stringArray;
    }

    public String mapMethodDesc(String string2) {
        if ("()V".equals(string2)) {
            return string2;
        }
        Type[] typeArray = Type.getArgumentTypes(string2);
        String string3 = "(";
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            string3 = string3 + this.mapDesc(typeArray[i2].getDescriptor());
        }
        Type type = Type.getReturnType(string2);
        if (type == Type.VOID_TYPE) {
            return string3 + ")V";
        }
        return string3 + ')' + this.mapDesc(type.getDescriptor());
    }

    public Object mapValue(Object object) {
        return object instanceof Type ? this.mapType((Type)object) : object;
    }

    public String mapSignature(String string2, boolean bl2) {
        if (string2 == null) {
            return null;
        }
        SignatureReader signatureReader = new SignatureReader(string2);
        SignatureWriter signatureWriter = new SignatureWriter();
        SignatureVisitor signatureVisitor = this.createRemappingSignatureAdapter(signatureWriter);
        if (bl2) {
            signatureReader.acceptType(signatureVisitor);
        } else {
            signatureReader.accept(signatureVisitor);
        }
        return signatureWriter.toString();
    }

    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor signatureVisitor) {
        return new RemappingSignatureAdapter(signatureVisitor, this);
    }

    public String mapMethodName(String string2, String string3, String string4) {
        return string3;
    }

    public String mapFieldName(String string2, String string3, String string4) {
        return string3;
    }

    public String map(String string2) {
        return string2;
    }
}

