/*
 * Decompiled with CFR 0.152.
 */
package org.python.objectweb.asm.commons;

import java.util.HashMap;
import java.util.Map;
import org.python.objectweb.asm.Type;

public class Method {
    private final String name;
    private final String desc;
    private static final Map DESCRIPTORS = new HashMap();

    public Method(String string2, String string3) {
        this.name = string2;
        this.desc = string3;
    }

    public Method(String string2, Type type, Type[] typeArray) {
        this(string2, Type.getMethodDescriptor(type, typeArray));
    }

    public static Method getMethod(String string2) throws IllegalArgumentException {
        return Method.getMethod(string2, false);
    }

    public static Method getMethod(String string2, boolean bl2) throws IllegalArgumentException {
        int n2;
        int n3 = string2.indexOf(32);
        int n4 = string2.indexOf(40, n3) + 1;
        int n5 = string2.indexOf(41, n4);
        if (n3 == -1 || n4 == -1 || n5 == -1) {
            throw new IllegalArgumentException();
        }
        String string3 = string2.substring(0, n3);
        String string4 = string2.substring(n3 + 1, n4 - 1).trim();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        do {
            String string5;
            if ((n2 = string2.indexOf(44, n4)) == -1) {
                string5 = Method.map(string2.substring(n4, n5).trim(), bl2);
            } else {
                string5 = Method.map(string2.substring(n4, n2).trim(), bl2);
                n4 = n2 + 1;
            }
            stringBuffer.append(string5);
        } while (n2 != -1);
        stringBuffer.append(')');
        stringBuffer.append(Method.map(string3, bl2));
        return new Method(string4, stringBuffer.toString());
    }

    private static String map(String string2, boolean bl2) {
        if ("".equals(string2)) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while ((n2 = string2.indexOf("[]", n2) + 1) > 0) {
            stringBuffer.append('[');
        }
        String string3 = string2.substring(0, string2.length() - stringBuffer.length() * 2);
        String string4 = (String)DESCRIPTORS.get(string3);
        if (string4 != null) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append('L');
            if (string3.indexOf(46) < 0) {
                if (!bl2) {
                    stringBuffer.append("java/lang/");
                }
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string3.replace('.', '/'));
            }
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.desc;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.desc);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.desc);
    }

    public String toString() {
        return this.name + this.desc;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        return this.name.equals(method.name) && this.desc.equals(method.desc);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.desc.hashCode();
    }

    static {
        DESCRIPTORS.put("void", "V");
        DESCRIPTORS.put("byte", "B");
        DESCRIPTORS.put("char", "C");
        DESCRIPTORS.put("double", "D");
        DESCRIPTORS.put("float", "F");
        DESCRIPTORS.put("int", "I");
        DESCRIPTORS.put("long", "J");
        DESCRIPTORS.put("short", "S");
        DESCRIPTORS.put("boolean", "Z");
    }
}

