/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.random;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.random.PyRandom$PyExposer;

@ExposedType(name="_random.Random")
public class PyRandom
extends PyObject {
    public static final PyType TYPE;
    protected Random javaRandom = new Random();

    public PyRandom() {
        this(TYPE);
    }

    public PyRandom(PyType subType) {
        super(subType);
    }

    final void Random_seed(PyObject seed) {
        long l2;
        if (seed == null) {
            seed = new PyLong(System.currentTimeMillis());
        }
        if (seed instanceof PyLong) {
            PyLong pyLong = new PyLong(Long.MAX_VALUE);
            l2 = seed.__mod__(pyLong).asLong();
        } else {
            l2 = seed instanceof PyInteger ? seed.asLong() : (long)seed.hashCode();
        }
        this.javaRandom.setSeed(l2);
    }

    @ExposedNew
    final void Random___init__(PyObject[] args, String[] keywords) {
    }

    final void Random_jumpahead(PyObject arg0) {
        if (!(arg0 instanceof PyInteger) && !(arg0 instanceof PyLong)) {
            throw Py.TypeError(String.format("jumpahead requires an integer, not '%s'", arg0.getType().fastGetName()));
        }
        for (long i2 = arg0.asLong(); i2 > 0L; --i2) {
            this.javaRandom.nextInt();
        }
    }

    final void Random_setstate(PyObject arg0) {
        if (!(arg0 instanceof PyTuple)) {
            throw Py.TypeError("state vector must be a tuple");
        }
        try {
            Object[] arr = ((PyTuple)arg0).toArray();
            byte[] b2 = new byte[arr.length];
            for (int i2 = 0; i2 < arr.length; ++i2) {
                if (!(arr[i2] instanceof Integer)) {
                    throw Py.TypeError("state vector of unexpected type: " + arr[i2].getClass());
                }
                b2[i2] = ((Integer)arr[i2]).byteValue();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(b2);
            ObjectInputStream oin = new ObjectInputStream(bin);
            this.javaRandom = (Random)oin.readObject();
        }
        catch (IOException e2) {
            throw Py.SystemError("state vector invalid: " + e2.getMessage());
        }
        catch (ClassNotFoundException e3) {
            throw Py.SystemError("state vector invalid: " + e3.getMessage());
        }
    }

    final PyObject Random_getstate() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.javaRandom);
            byte[] b2 = bout.toByteArray();
            PyObject[] retarr = new PyInteger[b2.length];
            for (int i2 = 0; i2 < b2.length; ++i2) {
                retarr[i2] = new PyInteger(b2[i2]);
            }
            PyTuple ret = new PyTuple(retarr);
            return ret;
        }
        catch (IOException e2) {
            throw Py.SystemError("creation of state vector failed: " + e2.getMessage());
        }
    }

    final PyObject Random_random() {
        long a2 = this.javaRandom.nextInt() >>> 5;
        long b2 = this.javaRandom.nextInt() >>> 6;
        double ret = ((double)a2 * 6.7108864E7 + (double)b2) * (double)1.110223E-16f;
        return new PyFloat(ret);
    }

    final PyLong Random_getrandbits(int k2) {
        return new PyLong(new BigInteger(k2, this.javaRandom));
    }

    static {
        PyType.addBuilder(PyRandom.class, new PyRandom$PyExposer());
        TYPE = PyType.fromClass(PyRandom.class);
    }
}

