/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Type;
import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.NativeMemory;
import org.python.modules.jffi.Pointer;

final class Util {
    private static final MemoryIO IO = MemoryIO.getInstance();
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    private Util() {
    }

    public static final PyObject newSigned8(int value) {
        return Py.newInteger((value &= 0xFF) < 128 ? value : -128 + (value - 128));
    }

    public static final PyObject newUnsigned8(int value) {
        return Py.newInteger(value < 0 ? ((long)value & 0x7FL) + 128L : (long)value);
    }

    public static final PyObject newSigned16(int value) {
        return Py.newInteger((value &= 0xFFFF) < 32768 ? value : Short.MIN_VALUE + (value - 32768));
    }

    public static final PyObject newUnsigned16(int value) {
        return Py.newInteger(value < 0 ? ((long)value & 0x7FFFL) + 32768L : (long)value);
    }

    public static final PyObject newSigned32(int value) {
        return Py.newInteger(value);
    }

    public static final PyObject newUnsigned32(int value) {
        return Py.newInteger(value < 0 ? ((long)value & Integer.MAX_VALUE) + 0x80000000L : (long)value);
    }

    public static final PyObject newSigned64(long value) {
        return Py.newInteger(value);
    }

    public static final PyObject newUnsigned64(long value) {
        return value < 0L ? Py.newLong(BigInteger.valueOf(value & Long.MAX_VALUE).add(UINT64_BASE)) : Py.newInteger(value);
    }

    public static final PyObject newString(long address) {
        return address != 0L ? Py.newString(new String(IO.getZeroTerminatedByteArray(address))) : Py.None;
    }

    public static final byte int8Value(PyObject parameter) {
        return (byte)parameter.asInt();
    }

    public static final byte uint8Value(PyObject parameter) {
        return (byte)parameter.asInt();
    }

    public static final short int16Value(PyObject parameter) {
        return (short)parameter.asInt();
    }

    public static final short uint16Value(PyObject parameter) {
        return (short)parameter.asInt();
    }

    public static final int int32Value(PyObject parameter) {
        return parameter.asInt();
    }

    public static final int uint32Value(PyObject value) {
        if (value instanceof PyInteger) {
            return value.asInt();
        }
        if (value instanceof PyLong) {
            return (int)((PyLong)value).asLong(0);
        }
        return (int)Util.__long__value(value);
    }

    public static final long int64Value(PyObject value) {
        return value.asLong();
    }

    public static final long uint64Value(PyObject value) {
        if (value instanceof PyLong) {
            return ((PyLong)value).getValue().longValue();
        }
        if (value instanceof PyInteger) {
            return value.asInt();
        }
        return Util.__long__value(value);
    }

    public static final float floatValue(PyObject parameter) {
        return (float)parameter.asDouble();
    }

    public static final double doubleValue(PyObject parameter) {
        return parameter.asDouble();
    }

    private static final long __long__value(PyObject value) {
        PyObject l2 = value.__long__();
        if (l2 instanceof PyLong) {
            return ((PyLong)l2).getValue().longValue();
        }
        if (l2 instanceof PyInteger) {
            return value.asInt();
        }
        throw Py.TypeError("invalid __long__() result");
    }

    public static final void checkBounds(long size, long off, long len) {
        if ((off | len | off + len | size - (off + len)) < 0L) {
            throw Py.IndexError("Memory access offset=" + off + " size=" + len + " is out of bounds");
        }
    }

    static final DirectMemory getMemoryForAddress(PyObject address) {
        if (address instanceof Pointer) {
            return ((Pointer)((Object)address)).getMemory();
        }
        if (address instanceof PyInteger) {
            return new NativeMemory(address.asInt());
        }
        if (address instanceof PyLong) {
            return new NativeMemory(((PyLong)address).getValue().longValue());
        }
        throw Py.TypeError("invalid address");
    }

    static final Type jffiType(CType type) {
        return type.jffiType();
    }
}

