/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import java.util.List;
import org.python.core.Py;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.jffi.AllocatedNativeMemory;
import org.python.modules.jffi.CData;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.MemoryOp;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.StructLayout;
import org.python.modules.jffi.Structure$PyExposer;
import org.python.modules.jffi.Util;

@ExposedType(name="jffi.Structure", base=CData.class)
public class Structure
extends CData
implements Pointer {
    public static final PyType TYPE;
    private final StructLayout layout;
    private final MemoryOp memoryOp;

    Structure(PyType pyType, StructLayout layout) {
        this(pyType, layout, (Memory)AllocatedNativeMemory.allocate(layout.size(), true));
    }

    Structure(PyType pyType, StructLayout layout, Memory m2) {
        super(pyType, layout);
        this.layout = layout;
        this.memoryOp = new MemoryOp.StructOp(pyType, layout);
        this.setReferenceMemory(m2);
    }

    @ExposedNew
    public static PyObject Structure_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        StructLayout layout = Structure.getStructLayout(subtype);
        Structure s2 = new Structure(subtype, layout);
        if (args.length > 0) {
            StructLayout.Field f2;
            int i2;
            int n2 = args.length - keywords.length;
            List<StructLayout.Field> fields = layout.getFieldList();
            DirectMemory m2 = s2.getMemory();
            for (i2 = 0; i2 < n2; ++i2) {
                f2 = fields.get(i2);
                f2.op.put(m2, f2.offset, args[i2]);
            }
            for (i2 = n2; i2 < args.length; ++i2) {
                f2 = layout.getField(keywords[i2 - n2]);
                f2.op.put(m2, f2.offset, args[i2]);
            }
        }
        return s2;
    }

    static final StructLayout getStructLayout(PyType subtype) {
        PyObject jffi_type = subtype.__getattr__("_jffi_type");
        if (!(jffi_type instanceof StructLayout)) {
            throw Py.TypeError("invalid _jffi_type for " + subtype.fastGetName() + "; should be instance of jffi.StructLayout");
        }
        return (StructLayout)jffi_type;
    }

    public static final PyObject from_address(PyType subtype, PyObject address) {
        return new Structure(subtype, Structure.getStructLayout(subtype), (Memory)Util.getMemoryForAddress(address));
    }

    protected final void initReferenceMemory(Memory m2) {
        throw Py.RuntimeError("reference memory already initialized");
    }

    MemoryOp getMemoryOp() {
        return this.memoryOp;
    }

    StructLayout.Field getField(PyObject key) {
        StructLayout.Field f2 = this.layout.getField(key);
        if (f2 == null) {
            throw Py.NameError(String.format("struct %s has no field '%s'", this.getType().fastGetName(), key.toString()));
        }
        return f2;
    }

    public PyObject __getitem__(PyObject key) {
        StructLayout.Field f2 = this.getField(key);
        return f2.op.get(this.getReferenceMemory(), f2.offset);
    }

    public void __setitem__(PyObject key, PyObject value) {
        StructLayout.Field f2 = this.getField(key);
        f2.op.put(this.getReferenceMemory(), f2.offset, value);
    }

    public DirectMemory getMemory() {
        return this.getReferenceMemory();
    }

    static {
        PyType.addBuilder(Structure.class, new Structure$PyExposer());
        TYPE = PyType.fromClass(Structure.class);
    }
}

