/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.Platform;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.Invoker;
import org.python.modules.jffi.NativeType;
import org.python.modules.jffi.Util;

public class FastIntInvokerFactory {
    private FastIntInvokerFactory() {
    }

    public static final FastIntInvokerFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    final boolean isFastIntMethod(CType returnType, CType[] parameterTypes) {
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (this.isFastIntParam(parameterTypes[i2])) continue;
            return false;
        }
        return parameterTypes.length <= 3 && this.isFastIntResult(returnType);
    }

    final boolean isFastIntMethod(PyObject returnType, PyObject[] parameterTypes) {
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            if (this.isFastIntParam(parameterTypes[i2])) continue;
            return false;
        }
        return parameterTypes.length <= 3 && this.isFastIntResult(returnType);
    }

    final boolean isFastIntResult(CType type) {
        if (type instanceof CType.Builtin) {
            switch (type.getNativeType()) {
                case VOID: 
                case BYTE: 
                case UBYTE: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: {
                    return true;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
                case STRING: {
                    return Platform.getPlatform().addressSize() == 32;
                }
            }
        }
        return false;
    }

    final boolean isFastIntResult(PyObject type) {
        return this.isFastIntResult(CType.typeOf(type));
    }

    final boolean isFastIntParam(CType paramType) {
        if (paramType instanceof CType.Builtin) {
            switch (paramType.getNativeType()) {
                case BYTE: 
                case UBYTE: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: {
                    return true;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
            }
        }
        return false;
    }

    final boolean isFastIntParam(PyObject paramType) {
        return this.isFastIntParam(CType.typeOf(paramType));
    }

    final Invoker createInvoker(Function function, CType[] parameterTypes, CType returnType) {
        IntParameterConverter[] parameterConverters = new IntParameterConverter[parameterTypes.length];
        for (int i2 = 0; i2 < parameterConverters.length; ++i2) {
            parameterConverters[i2] = this.getIntParameterConverter(parameterTypes[i2]);
        }
        return this.createIntInvoker(function, this.getIntResultConverter(returnType), parameterConverters);
    }

    final Invoker createInvoker(Function function, PyObject returnType, PyObject[] parameterTypes) {
        IntParameterConverter[] parameterConverters = new IntParameterConverter[parameterTypes.length];
        for (int i2 = 0; i2 < parameterConverters.length; ++i2) {
            parameterConverters[i2] = this.getIntParameterConverter(parameterTypes[i2]);
        }
        return this.createIntInvoker(function, this.getIntResultConverter(returnType), parameterConverters);
    }

    final Invoker createIntInvoker(Function function, IntResultConverter resultConverter, IntParameterConverter[] parameterConverters) {
        switch (parameterConverters.length) {
            case 0: {
                return new FastIntInvokerZero(function, resultConverter, parameterConverters);
            }
            case 1: {
                return new FastIntInvokerOne(function, resultConverter, parameterConverters);
            }
            case 2: {
                return new FastIntInvokerTwo(function, resultConverter, parameterConverters);
            }
            case 3: {
                return new FastIntInvokerThree(function, resultConverter, parameterConverters);
            }
        }
        throw Py.RuntimeError("fast int invoker does not support functions with arity=" + parameterConverters.length);
    }

    final IntParameterConverter getIntParameterConverter(CType type) {
        if (type instanceof CType.Builtin) {
            return this.getIntParameterConverter(type.getNativeType());
        }
        throw Py.TypeError("cannot convert objects of type " + type + " to int");
    }

    final IntParameterConverter getIntParameterConverter(PyObject type) {
        return this.getIntParameterConverter(CType.typeOf(type));
    }

    final IntParameterConverter getIntParameterConverter(NativeType type) {
        switch (type) {
            case BYTE: {
                return Signed8ParameterConverter.INSTANCE;
            }
            case UBYTE: {
                return Unsigned8ParameterConverter.INSTANCE;
            }
            case SHORT: {
                return Signed16ParameterConverter.INSTANCE;
            }
            case USHORT: {
                return Unsigned16ParameterConverter.INSTANCE;
            }
            case INT: {
                return Signed32ParameterConverter.INSTANCE;
            }
            case UINT: {
                return Unsigned32ParameterConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Signed32ParameterConverter.INSTANCE;
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Unsigned32ParameterConverter.INSTANCE;
            }
            case FLOAT: {
                if (Platform.getPlatform().getCPU() != Platform.CPU.I386 && Platform.getPlatform().getCPU() != Platform.CPU.X86_64) break;
                return Float32ParameterConverter.INSTANCE;
            }
        }
        throw Py.TypeError("cannot convert objects of type " + (Object)((Object)type) + " to int");
    }

    final IntResultConverter getIntResultConverter(PyObject type) {
        return this.getIntResultConverter(CType.typeOf(type));
    }

    final IntResultConverter getIntResultConverter(CType type) {
        return type instanceof CType.Builtin ? this.getIntResultConverter(type.getNativeType()) : null;
    }

    final IntResultConverter getIntResultConverter(NativeType type) {
        switch (type) {
            case VOID: {
                return VoidResultConverter.INSTANCE;
            }
            case BYTE: {
                return Signed8ResultConverter.INSTANCE;
            }
            case UBYTE: {
                return Unsigned8ResultConverter.INSTANCE;
            }
            case SHORT: {
                return Signed16ResultConverter.INSTANCE;
            }
            case USHORT: {
                return Unsigned16ResultConverter.INSTANCE;
            }
            case INT: {
                return Signed32ResultConverter.INSTANCE;
            }
            case UINT: {
                return Unsigned32ResultConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Signed32ResultConverter.INSTANCE;
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Unsigned32ResultConverter.INSTANCE;
            }
            case STRING: {
                if (Platform.getPlatform().addressSize() != 32) break;
                return StringResultConverter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Cannot convert objects of type " + (Object)((Object)type) + " from int");
    }

    static final class Float32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Float32ParameterConverter();

        Float32ParameterConverter() {
        }

        public final int intValue(PyObject obj) {
            return Float.floatToIntBits((float)obj.asDouble());
        }
    }

    static final class Unsigned32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned32ParameterConverter();

        Unsigned32ParameterConverter() {
        }

        public final int intValue(PyObject obj) {
            return Util.uint32Value(obj);
        }
    }

    static final class Signed32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed32ParameterConverter();

        Signed32ParameterConverter() {
        }

        public final int intValue(PyObject obj) {
            return Util.int32Value(obj);
        }
    }

    static final class Unsigned16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned16ParameterConverter();

        Unsigned16ParameterConverter() {
        }

        public final int intValue(PyObject obj) {
            return Util.uint16Value(obj);
        }
    }

    static final class Signed16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed16ParameterConverter();

        Signed16ParameterConverter() {
        }

        public final int intValue(PyObject obj) {
            return Util.int16Value(obj);
        }
    }

    static final class Unsigned8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned8ParameterConverter();

        Unsigned8ParameterConverter() {
        }

        public final int intValue(PyObject obj) {
            return Util.uint8Value(obj);
        }
    }

    static final class Signed8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed8ParameterConverter();

        Signed8ParameterConverter() {
        }

        public final int intValue(PyObject obj) {
            return Util.int8Value(obj);
        }
    }

    static abstract class BaseParameterConverter
    implements IntParameterConverter {
        BaseParameterConverter() {
        }
    }

    static final class StringResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new StringResultConverter();

        StringResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Util.newString(value);
        }
    }

    static final class Unsigned32ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned32ResultConverter();

        Unsigned32ResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Util.newUnsigned32(value);
        }
    }

    static final class Signed32ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Signed32ResultConverter();

        Signed32ResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Util.newSigned32(value);
        }
    }

    static final class Unsigned16ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned16ResultConverter();

        Unsigned16ResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Util.newUnsigned16(value);
        }
    }

    static final class Signed16ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Signed16ResultConverter();

        Signed16ResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Util.newSigned16(value);
        }
    }

    static final class Unsigned8ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned8ResultConverter();

        Unsigned8ResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Util.newUnsigned8(value);
        }
    }

    static final class Signed8ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Signed8ResultConverter();

        Signed8ResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Util.newSigned8(value);
        }
    }

    static final class VoidResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new VoidResultConverter();

        VoidResultConverter() {
        }

        public final PyObject pyValue(int value) {
            return Py.None;
        }
    }

    static abstract class BaseResultConverter
    implements IntResultConverter {
        BaseResultConverter() {
        }
    }

    private static final class FastIntInvokerThree
    extends BaseFastIntInvoker {
        public FastIntInvokerThree(Function function, IntResultConverter resultConverter, IntParameterConverter[] parameterConverters) {
            super(function, resultConverter, parameterConverters);
        }

        public PyObject invoke(PyObject arg0, PyObject arg1, PyObject arg2) {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeIIIrI(this.function, this.c0.intValue(arg0), this.c1.intValue(arg1), this.c2.intValue(arg2)));
        }
    }

    private static final class FastIntInvokerTwo
    extends BaseFastIntInvoker {
        public FastIntInvokerTwo(Function function, IntResultConverter resultConverter, IntParameterConverter[] parameterConverters) {
            super(function, resultConverter, parameterConverters);
        }

        public PyObject invoke(PyObject arg0, PyObject arg1) {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeIIrI(this.function, this.c0.intValue(arg0), this.c1.intValue(arg1)));
        }
    }

    private static final class FastIntInvokerOne
    extends BaseFastIntInvoker {
        public FastIntInvokerOne(Function function, IntResultConverter resultConverter, IntParameterConverter[] parameterConverters) {
            super(function, resultConverter, parameterConverters);
        }

        public final PyObject invoke(PyObject arg0) {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeIrI(this.function, this.c0.intValue(arg0)));
        }
    }

    private static final class FastIntInvokerZero
    extends BaseFastIntInvoker {
        public FastIntInvokerZero(Function function, IntResultConverter resultConverter, IntParameterConverter[] parameterConverters) {
            super(function, resultConverter, parameterConverters);
        }

        public final PyObject invoke() {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeVrI(this.function));
        }
    }

    private static abstract class BaseFastIntInvoker
    implements Invoker {
        final com.kenai.jffi.Invoker jffiInvoker = com.kenai.jffi.Invoker.getInstance();
        final Function function;
        final IntResultConverter resultConverter;
        final int arity;
        final IntParameterConverter c0;
        final IntParameterConverter c1;
        final IntParameterConverter c2;

        BaseFastIntInvoker(Function function, IntResultConverter resultConverter, IntParameterConverter[] parameterConverters) {
            this.function = function;
            this.resultConverter = resultConverter;
            this.arity = parameterConverters.length;
            this.c0 = parameterConverters.length > 0 ? parameterConverters[0] : null;
            this.c1 = parameterConverters.length > 1 ? parameterConverters[1] : null;
            this.c2 = parameterConverters.length > 2 ? parameterConverters[2] : null;
        }

        final void checkArity(PyObject[] args) {
            this.checkArity(args.length);
        }

        final void checkArity(int got) {
            if (got != this.arity) {
                throw Py.TypeError(String.format("__call__() takes exactly %d arguments (%d given)", this.arity, got));
            }
        }

        public PyObject invoke(PyObject[] args) {
            this.checkArity(args);
            switch (this.arity) {
                case 0: {
                    return this.invoke();
                }
                case 1: {
                    return this.invoke(args[0]);
                }
                case 2: {
                    return this.invoke(args[0], args[1]);
                }
                case 3: {
                    return this.invoke(args[0], args[1], args[2]);
                }
            }
            throw Py.RuntimeError("invalid fast-int arity");
        }

        public PyObject invoke() {
            this.checkArity(0);
            return Py.None;
        }

        public PyObject invoke(PyObject arg1) {
            this.checkArity(1);
            return Py.None;
        }

        public PyObject invoke(PyObject arg1, PyObject arg2) {
            this.checkArity(2);
            return Py.None;
        }

        public PyObject invoke(PyObject arg1, PyObject arg2, PyObject arg3) {
            this.checkArity(3);
            return Py.None;
        }
    }

    private static interface IntResultConverter {
        public PyObject pyValue(int var1);
    }

    private static interface IntParameterConverter {
        public int intValue(PyObject var1);
    }

    private static final class SingletonHolder {
        private static final FastIntInvokerFactory INSTANCE = new FastIntInvokerFactory();

        private SingletonHolder() {
        }
    }
}

