/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PyType;
import org.python.core.SequenceIndexDelegate;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.jffi.AllocatedNativeMemory;
import org.python.modules.jffi.ArrayCData$PyExposer;
import org.python.modules.jffi.CData;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.MemoryOp;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.PointerCData;
import org.python.modules.jffi.Util;

@ExposedType(name="jffi.ArrayCData", base=CData.class)
public class ArrayCData
extends CData
implements Pointer {
    public static final PyType TYPE;
    final CType.Array arrayType;
    final CType componentType;
    final MemoryOp componentMemoryOp;
    protected final SequenceIndexDelegate delegator = new SequenceIndexDelegate(){

        public String getTypeName() {
            return ArrayCData.this.getType().fastGetName();
        }

        public void setItem(int idx, PyObject value) {
            ArrayCData.this.componentMemoryOp.put(ArrayCData.this.getReferenceMemory(), idx * ArrayCData.this.componentType.size(), value);
        }

        public void setSlice(int start, int stop, int step, PyObject value) {
            if (!(value instanceof PySequenceList)) {
                throw Py.TypeError("expected list or tuple");
            }
            PySequenceList list = (PySequenceList)value;
            for (int i2 = 0; i2 < stop - start; ++i2) {
                this.setItem(start + i2, list.pyget(i2));
            }
        }

        public int len() {
            return ArrayCData.this.arrayType.length;
        }

        public void delItem(int idx) {
            throw Py.TypeError("Array does not support item deletion");
        }

        public void delItems(int start, int stop) {
            throw Py.TypeError("Array does not support item deletion");
        }

        public PyObject getItem(int idx) {
            return ArrayCData.this.componentMemoryOp.get(ArrayCData.this.getReferenceMemory(), idx * ArrayCData.this.componentType.size());
        }

        public PyObject getSlice(int start, int stop, int step) {
            PyObject[] result = new PyObject[stop - start];
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = this.getItem(start + i2);
            }
            return new PyList(result);
        }
    };

    ArrayCData(PyType subtype, CType.Array arrayType, DirectMemory memory, MemoryOp componentMemoryOp) {
        super(subtype, arrayType, memory);
        this.arrayType = arrayType;
        this.componentType = arrayType.componentType;
        this.componentMemoryOp = componentMemoryOp;
    }

    @ExposedNew
    public static PyObject ArrayCData_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        CType.Array arrayType = ArrayCData.getArrayType(subtype);
        boolean clear = args.length < arrayType.length;
        AllocatedNativeMemory memory = AllocatedNativeMemory.allocateAligned(arrayType.componentType.size() * arrayType.length, arrayType.componentType.alignment(), clear);
        int offset = 0;
        for (PyObject value : args) {
            arrayType.componentMemoryOp.put(memory, offset, value);
            offset += arrayType.componentType.size();
        }
        return new ArrayCData(subtype, arrayType, memory, arrayType.componentMemoryOp);
    }

    static final CType.Array getArrayType(PyType subtype) {
        PyObject jffi_type = subtype.__getattr__("_jffi_type");
        if (!(jffi_type instanceof CType.Array)) {
            throw Py.TypeError("invalid _jffi_type for " + subtype.getName());
        }
        return (CType.Array)jffi_type;
    }

    public static final PyObject from_address(PyType subtype, PyObject address) {
        CType.Array arrayType = ArrayCData.getArrayType(subtype);
        DirectMemory m2 = Util.getMemoryForAddress(address);
        PointerCData cdata = new PointerCData(subtype, arrayType, m2.getMemory(0L), arrayType.componentMemoryOp);
        cdata.setReferenceMemory(m2);
        return cdata;
    }

    public final DirectMemory getMemory() {
        return this.getReferenceMemory();
    }

    protected final void initReferenceMemory(Memory m2) {
    }

    public PyObject __finditem__(int index) {
        return this.delegator.checkIdxAndFindItem(index);
    }

    public PyObject __getitem__(PyObject index) {
        return this.delegator.checkIdxAndGetItem(index);
    }

    public void __setitem__(int index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    public void __setitem__(PyObject index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    public void __delitem__(PyObject key) {
        throw Py.TypeError("Array does not support item deletion");
    }

    public PyObject __iter__() {
        return new ArrayIter();
    }

    static {
        PyType.addBuilder(ArrayCData.class, new ArrayCData$PyExposer());
        TYPE = PyType.fromClass(ArrayCData.class);
    }

    public class ArrayIter
    extends PyIterator {
        private int index = 0;

        public PyObject __iternext__() {
            if (this.index >= ArrayCData.this.arrayType.length) {
                return null;
            }
            return ArrayCData.this.componentMemoryOp.get(ArrayCData.this.getReferenceMemory(), this.index++ * ArrayCData.this.componentType.size());
        }
    }
}

