/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import java.util.Map;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.__builtin__;
import org.python.core.codecs;
import org.python.core.exceptions;
import org.python.core.imp;
import org.python.modules.PyIOFile;
import org.python.modules.PyIOFileFactory;
import org.python.modules.cStringIO;
import org.python.util.Generic;

public class cPickle
implements ClassDictInit {
    public static String __doc__ = "Java implementation and optimization of the Python pickle module\n";
    public static String __version__ = "1.30";
    public static final String format_version = "2.0";
    public static final String[] compatible_formats = new String[]{"1.0", "1.1", "1.2", "1.3", "2.0"};
    public static final int HIGHEST_PROTOCOL = 2;
    public static String[] __depends__ = new String[]{"copy_reg"};
    public static PyObject PickleError;
    public static PyObject PicklingError;
    public static PyObject UnpickleableError;
    public static PyObject UnpicklingError;
    public static PyObject BadPickleGet;
    static final char MARK = '(';
    static final char STOP = '.';
    static final char POP = '0';
    static final char POP_MARK = '1';
    static final char DUP = '2';
    static final char FLOAT = 'F';
    static final char INT = 'I';
    static final char BININT = 'J';
    static final char BININT1 = 'K';
    static final char LONG = 'L';
    static final char BININT2 = 'M';
    static final char NONE = 'N';
    static final char PERSID = 'P';
    static final char BINPERSID = 'Q';
    static final char REDUCE = 'R';
    static final char STRING = 'S';
    static final char BINSTRING = 'T';
    static final char SHORT_BINSTRING = 'U';
    static final char UNICODE = 'V';
    static final char BINUNICODE = 'X';
    static final char APPEND = 'a';
    static final char BUILD = 'b';
    static final char GLOBAL = 'c';
    static final char DICT = 'd';
    static final char EMPTY_DICT = '}';
    static final char APPENDS = 'e';
    static final char GET = 'g';
    static final char BINGET = 'h';
    static final char INST = 'i';
    static final char LONG_BINGET = 'j';
    static final char LIST = 'l';
    static final char EMPTY_LIST = ']';
    static final char OBJ = 'o';
    static final char PUT = 'p';
    static final char BINPUT = 'q';
    static final char LONG_BINPUT = 'r';
    static final char SETITEM = 's';
    static final char TUPLE = 't';
    static final char EMPTY_TUPLE = ')';
    static final char SETITEMS = 'u';
    static final char BINFLOAT = 'G';
    static final char PROTO = '\u0080';
    static final char NEWOBJ = '\u0081';
    static final char EXT1 = '\u0082';
    static final char EXT2 = '\u0083';
    static final char EXT4 = '\u0084';
    static final char TUPLE1 = '\u0085';
    static final char TUPLE2 = '\u0086';
    static final char TUPLE3 = '\u0087';
    static final char NEWTRUE = '\u0088';
    static final char NEWFALSE = '\u0089';
    static final char LONG1 = '\u008a';
    static final char LONG4 = '\u008b';
    private static PyDictionary dispatch_table;
    private static PyDictionary extension_registry;
    private static PyDictionary inverted_registry;
    private static PyType BuiltinCallableType;
    private static PyType ReflectedFunctionType;
    private static PyType ClassType;
    private static PyType TypeType;
    private static PyType DictionaryType;
    private static PyType StringMapType;
    private static PyType FloatType;
    private static PyType FunctionType;
    private static PyType InstanceType;
    private static PyType IntType;
    private static PyType ListType;
    private static PyType LongType;
    private static PyType NoneType;
    private static PyType StringType;
    private static PyType UnicodeType;
    private static PyType TupleType;
    private static PyType FileType;
    private static PyType BoolType;
    private static PyObject dict;
    private static final int BATCHSIZE = 1024;
    private static Map<PyObject, PyObject> classmap;

    public static void classDictInit(PyObject dict) {
        cPickle.dict = dict;
        imp.importName("__builtin__", true);
        PyModule copyreg = (PyModule)cPickle.importModule("copy_reg");
        dispatch_table = (PyDictionary)copyreg.__getattr__("dispatch_table");
        extension_registry = (PyDictionary)copyreg.__getattr__("_extension_registry");
        inverted_registry = (PyDictionary)copyreg.__getattr__("_inverted_registry");
        PickleError = Py.makeClass("PickleError", Py.Exception, cPickle._PickleError());
        PicklingError = Py.makeClass("PicklingError", PickleError, cPickle.exceptionNamespace());
        UnpickleableError = Py.makeClass("UnpickleableError", PicklingError, cPickle._UnpickleableError());
        UnpicklingError = Py.makeClass("UnpicklingError", PickleError, cPickle.exceptionNamespace());
        BadPickleGet = Py.makeClass("BadPickleGet", UnpicklingError, cPickle.exceptionNamespace());
    }

    public static PyObject exceptionNamespace() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__module__", (PyObject)new PyString("cPickle"));
        return dict;
    }

    public static PyObject _PickleError() {
        dict = cPickle.exceptionNamespace();
        dict.__setitem__("__str__", cPickle.getJavaFunc("__str__", "_PickleError__str__"));
        return dict;
    }

    public static PyString _PickleError__str__(PyObject self, PyObject[] args, String[] kwargs) {
        PyObject selfArgs = self.__getattr__("args");
        if (selfArgs.__len__() > 0 && selfArgs.__getitem__(0).__len__() > 0) {
            return selfArgs.__getitem__(0).__str__();
        }
        return new PyString("(what)");
    }

    public static PyObject _UnpickleableError() {
        dict = cPickle.exceptionNamespace();
        dict.__setitem__("__str__", cPickle.getJavaFunc("__str__", "_UnpickleableError__str__"));
        return dict;
    }

    public static PyString _UnpickleableError__str__(PyObject self, PyObject[] args, String[] kwargs) {
        PyObject selfArgs = self.__getattr__("args");
        PyObject a2 = selfArgs.__len__() > 0 ? selfArgs.__getitem__(0) : new PyString("(what)");
        return new PyString("Cannot pickle %s objects").__mod__(a2).__str__();
    }

    public static Pickler Pickler(PyObject file) {
        return new Pickler(file, 0);
    }

    public static Pickler Pickler(PyObject file, int protocol) {
        return new Pickler(file, protocol);
    }

    public static Unpickler Unpickler(PyObject file) {
        return new Unpickler(file);
    }

    public static void dump(PyObject object, PyObject file) {
        cPickle.dump(object, file, 0);
    }

    public static void dump(PyObject object, PyObject file, int protocol) {
        new Pickler(file, protocol).dump(object);
    }

    public static PyString dumps(PyObject object) {
        return cPickle.dumps(object, 0);
    }

    public static PyString dumps(PyObject object, int protocol) {
        cStringIO.StringIO file = cStringIO.StringIO();
        cPickle.dump(object, file, protocol);
        return file.getvalue();
    }

    public static Object load(PyObject file) {
        return new Unpickler(file).load();
    }

    public static Object loads(PyObject str) {
        cStringIO.StringIO file = cStringIO.StringIO(str.toString());
        return new Unpickler(file).load();
    }

    private static final PyObject whichmodule(PyObject cls, PyObject clsname) {
        PyObject name = classmap.get(cls);
        if (name != null) {
            return name;
        }
        name = new PyString("__main__");
        PyObject sys = imp.importName("sys", true);
        PyObject modules = sys.__findattr__("modules");
        PyObject keylist = modules.invoke("keys");
        int len = keylist.__len__();
        for (int i2 = 0; i2 < len; ++i2) {
            PyObject key = keylist.__finditem__(i2);
            PyObject value = modules.__finditem__(key);
            if (key.equals("__main__") || value.__findattr__(clsname.toString().intern()) != cls) continue;
            name = key;
            break;
        }
        classmap.put(cls, name);
        return name;
    }

    private static PyObject importModule(String name) {
        PyTuple fromlist = new PyTuple(Py.newString("__doc__"));
        return __builtin__.__import__(name, Py.None, Py.None, fromlist);
    }

    private static PyObject getJavaFunc(String name, String methodName) {
        return exceptions.bindStaticJavaMethod(name, cPickle.class, methodName);
    }

    static {
        BuiltinCallableType = PyType.fromClass(PyBuiltinCallable.class);
        ReflectedFunctionType = PyType.fromClass(PyReflectedFunction.class);
        ClassType = PyType.fromClass(PyClass.class);
        TypeType = PyType.fromClass(PyType.class);
        DictionaryType = PyType.fromClass(PyDictionary.class);
        StringMapType = PyType.fromClass(PyStringMap.class);
        FloatType = PyType.fromClass(PyFloat.class);
        FunctionType = PyType.fromClass(PyFunction.class);
        InstanceType = PyType.fromClass(PyInstance.class);
        IntType = PyType.fromClass(PyInteger.class);
        ListType = PyType.fromClass(PyList.class);
        LongType = PyType.fromClass(PyLong.class);
        NoneType = PyType.fromClass(PyNone.class);
        StringType = PyType.fromClass(PyString.class);
        UnicodeType = PyType.fromClass(PyUnicode.class);
        TupleType = PyType.fromClass(PyTuple.class);
        FileType = PyType.fromClass(PyFile.class);
        BoolType = PyType.fromClass(PyBoolean.class);
        classmap = Generic.map();
    }

    public static class Unpickler {
        private PyIOFile file;
        public Map<String, PyObject> memo = Generic.map();
        public PyObject persistent_load = null;
        public PyObject find_global = null;
        private PyObject mark = new PyString("spam");
        private int stackTop;
        private PyObject[] stack;

        Unpickler(PyObject file) {
            this.file = PyIOFileFactory.createIOFile(file);
        }

        public PyObject load() {
            char key;
            this.stackTop = 0;
            this.stack = new PyObject[10];
            block55: while (true) {
                String s2;
                if ((s2 = this.file.read(1)).length() < 1) {
                    this.load_eof();
                }
                key = s2.charAt(0);
                switch (key) {
                    case 'P': {
                        this.load_persid();
                        continue block55;
                    }
                    case 'Q': {
                        this.load_binpersid();
                        continue block55;
                    }
                    case 'N': {
                        this.load_none();
                        continue block55;
                    }
                    case 'I': {
                        this.load_int();
                        continue block55;
                    }
                    case 'J': {
                        this.load_binint();
                        continue block55;
                    }
                    case 'K': {
                        this.load_binint1();
                        continue block55;
                    }
                    case 'M': {
                        this.load_binint2();
                        continue block55;
                    }
                    case 'L': {
                        this.load_long();
                        continue block55;
                    }
                    case 'F': {
                        this.load_float();
                        continue block55;
                    }
                    case 'G': {
                        this.load_binfloat();
                        continue block55;
                    }
                    case 'S': {
                        this.load_string();
                        continue block55;
                    }
                    case 'T': {
                        this.load_binstring();
                        continue block55;
                    }
                    case 'U': {
                        this.load_short_binstring();
                        continue block55;
                    }
                    case 'V': {
                        this.load_unicode();
                        continue block55;
                    }
                    case 'X': {
                        this.load_binunicode();
                        continue block55;
                    }
                    case 't': {
                        this.load_tuple();
                        continue block55;
                    }
                    case ')': {
                        this.load_empty_tuple();
                        continue block55;
                    }
                    case ']': {
                        this.load_empty_list();
                        continue block55;
                    }
                    case '}': {
                        this.load_empty_dictionary();
                        continue block55;
                    }
                    case 'l': {
                        this.load_list();
                        continue block55;
                    }
                    case 'd': {
                        this.load_dict();
                        continue block55;
                    }
                    case 'i': {
                        this.load_inst();
                        continue block55;
                    }
                    case 'o': {
                        this.load_obj();
                        continue block55;
                    }
                    case 'c': {
                        this.load_global();
                        continue block55;
                    }
                    case 'R': {
                        this.load_reduce();
                        continue block55;
                    }
                    case '0': {
                        this.load_pop();
                        continue block55;
                    }
                    case '1': {
                        this.load_pop_mark();
                        continue block55;
                    }
                    case '2': {
                        this.load_dup();
                        continue block55;
                    }
                    case 'g': {
                        this.load_get();
                        continue block55;
                    }
                    case 'h': {
                        this.load_binget();
                        continue block55;
                    }
                    case 'j': {
                        this.load_long_binget();
                        continue block55;
                    }
                    case 'p': {
                        this.load_put();
                        continue block55;
                    }
                    case 'q': {
                        this.load_binput();
                        continue block55;
                    }
                    case 'r': {
                        this.load_long_binput();
                        continue block55;
                    }
                    case 'a': {
                        this.load_append();
                        continue block55;
                    }
                    case 'e': {
                        this.load_appends();
                        continue block55;
                    }
                    case 's': {
                        this.load_setitem();
                        continue block55;
                    }
                    case 'u': {
                        this.load_setitems();
                        continue block55;
                    }
                    case 'b': {
                        this.load_build();
                        continue block55;
                    }
                    case '(': {
                        this.load_mark();
                        continue block55;
                    }
                    case '\u0080': {
                        this.load_proto();
                        continue block55;
                    }
                    case '\u0081': {
                        this.load_newobj();
                        continue block55;
                    }
                    case '\u0082': {
                        this.load_ext(1);
                        continue block55;
                    }
                    case '\u0083': {
                        this.load_ext(2);
                        continue block55;
                    }
                    case '\u0084': {
                        this.load_ext(4);
                        continue block55;
                    }
                    case '\u0085': {
                        this.load_small_tuple(1);
                        continue block55;
                    }
                    case '\u0086': {
                        this.load_small_tuple(2);
                        continue block55;
                    }
                    case '\u0087': {
                        this.load_small_tuple(3);
                        continue block55;
                    }
                    case '\u0088': {
                        this.load_boolean(true);
                        continue block55;
                    }
                    case '\u0089': {
                        this.load_boolean(false);
                        continue block55;
                    }
                    case '\u008a': {
                        this.load_bin_long(1);
                        continue block55;
                    }
                    case '\u008b': {
                        this.load_bin_long(4);
                        continue block55;
                    }
                    case '.': {
                        return this.load_stop();
                    }
                }
                break;
            }
            throw new PyException(UnpicklingError, String.format("invalid load key, '%s'.", Character.valueOf(key)));
        }

        private final int marker() {
            for (int k2 = this.stackTop - 1; k2 >= 0; --k2) {
                if (this.stack[k2] != this.mark) continue;
                return this.stackTop - k2 - 1;
            }
            throw new PyException(UnpicklingError, "Inputstream corrupt, marker not found");
        }

        private final void load_eof() {
            throw new PyException(Py.EOFError);
        }

        private void load_proto() {
            char proto = this.file.read(1).charAt(0);
            if (proto < '\u0000' || proto > '\u0002') {
                throw Py.ValueError("unsupported pickle protocol: " + proto);
            }
        }

        private final void load_persid() {
            this.load_persid(new PyString(this.file.readlineNoNl()));
        }

        private final void load_binpersid() {
            this.load_persid(this.pop());
        }

        private final void load_persid(PyObject pid) {
            if (this.persistent_load == null) {
                throw new PyException(UnpicklingError, "A load persistent id instruction was encountered,\nbut no persistent_load function was specified.");
            }
            if (this.persistent_load instanceof PyList) {
                ((PyList)this.persistent_load).append(pid);
            } else {
                pid = this.persistent_load.__call__(pid);
            }
            this.push(pid);
        }

        private final void load_none() {
            this.push(Py.None);
        }

        private final void load_int() {
            PyObject value;
            String line = this.file.readlineNoNl();
            if (line.equals("01")) {
                value = Py.True;
            } else if (line.equals("00")) {
                value = Py.False;
            } else {
                try {
                    value = Py.newInteger(Integer.parseInt(line));
                }
                catch (NumberFormatException e2) {
                    try {
                        value = Py.newLong(line);
                    }
                    catch (NumberFormatException e22) {
                        throw Py.ValueError("could not convert string to int");
                    }
                }
            }
            this.push(value);
        }

        private void load_boolean(boolean value) {
            this.push(value ? Py.True : Py.False);
        }

        private final void load_binint() {
            int x2 = this.read_binint();
            this.push(new PyInteger(x2));
        }

        private int read_binint() {
            String s2 = this.file.read(4);
            return s2.charAt(0) | s2.charAt(1) << 8 | s2.charAt(2) << 16 | s2.charAt(3) << 24;
        }

        private final void load_binint1() {
            char val = this.file.read(1).charAt(0);
            this.push(new PyInteger(val));
        }

        private final void load_binint2() {
            int val = this.read_binint2();
            this.push(new PyInteger(val));
        }

        private int read_binint2() {
            String s2 = this.file.read(2);
            return s2.charAt(1) << 8 | s2.charAt(0);
        }

        private final void load_long() {
            String line = this.file.readlineNoNl();
            this.push(new PyLong(line.substring(0, line.length() - 1)));
        }

        private void load_bin_long(int length) {
            int longLength = this.read_binint(length);
            if (longLength == 0) {
                this.push(new PyLong(BigInteger.ZERO));
                return;
            }
            String s2 = this.file.read(longLength);
            byte[] bytes = new byte[s2.length()];
            int n2 = s2.length() - 1;
            int i2 = 0;
            while (i2 < s2.length()) {
                char c2 = s2.charAt(i2);
                bytes[n2] = c2 >= '\u0080' ? (byte)(c2 - 256) : (byte)c2;
                ++i2;
                --n2;
            }
            BigInteger bigint = new BigInteger(bytes);
            this.push(new PyLong(bigint));
        }

        private int read_binint(int length) {
            if (length == 1) {
                return this.file.read(1).charAt(0);
            }
            if (length == 2) {
                return this.read_binint2();
            }
            return this.read_binint();
        }

        private final void load_float() {
            String line = this.file.readlineNoNl();
            this.push(new PyFloat(Double.valueOf(line)));
        }

        private final void load_binfloat() {
            String s2 = this.file.read(8);
            long bits = (long)s2.charAt(7) | (long)s2.charAt(6) << 8 | (long)s2.charAt(5) << 16 | (long)s2.charAt(4) << 24 | (long)s2.charAt(3) << 32 | (long)s2.charAt(2) << 40 | (long)s2.charAt(1) << 48 | (long)s2.charAt(0) << 56;
            this.push(new PyFloat(Double.longBitsToDouble(bits)));
        }

        /*
         * WARNING - void declaration
         */
        private final void load_string() {
            void i2;
            int ch2;
            String line = this.file.readlineNoNl();
            char c2 = line.charAt(0);
            if (c2 != '\"' && c2 != '\'') {
                throw Py.ValueError("insecure string pickle");
            }
            int quote = 0;
            char nslash = '\u0000';
            int n2 = line.length();
            for (ch2 = 1; ch2 < i2 && ((nslash = line.charAt(ch2)) != c2 || quote % 2 != 0); ++ch2) {
                if (nslash == '\\') {
                    ++quote;
                    continue;
                }
                quote = 0;
            }
            if (nslash != c2) {
                throw Py.ValueError("insecure string pickle");
            }
            ++ch2;
            while (ch2 < line.length()) {
                if (line.charAt(ch2) > ' ') {
                    throw Py.ValueError("insecure string pickle " + ch2);
                }
                ++ch2;
            }
            String n3 = PyString.decode_UnicodeEscape(line, 1, (int)(i2 - true), "strict", false);
            this.push(new PyString(n3));
        }

        private final void load_binstring() {
            int len = this.read_binint();
            this.push(new PyString(this.file.read(len)));
        }

        private final void load_short_binstring() {
            char len = this.file.read(1).charAt(0);
            this.push(new PyString(this.file.read(len)));
        }

        private final void load_unicode() {
            String line = this.file.readlineNoNl();
            String value = codecs.PyUnicode_DecodeRawUnicodeEscape(line, "strict");
            this.push(new PyUnicode(value));
        }

        private final void load_binunicode() {
            int len = this.read_binint();
            String line = this.file.read(len);
            this.push(new PyUnicode(codecs.PyUnicode_DecodeUTF8(line, "strict")));
        }

        private final void load_tuple() {
            PyObject[] arr = new PyObject[this.marker()];
            this.pop(arr);
            this.pop();
            this.push(new PyTuple(arr));
        }

        private final void load_empty_tuple() {
            this.push(new PyTuple(Py.EmptyObjects));
        }

        private void load_small_tuple(int length) {
            PyObject[] data = new PyObject[length];
            for (int i2 = length - 1; i2 >= 0; --i2) {
                data[i2] = this.pop();
            }
            this.push(new PyTuple(data));
        }

        private final void load_empty_list() {
            this.push(new PyList(Py.EmptyObjects));
        }

        private final void load_empty_dictionary() {
            this.push(new PyDictionary());
        }

        private final void load_list() {
            PyObject[] arr = new PyObject[this.marker()];
            this.pop(arr);
            this.pop();
            this.push(new PyList(arr));
        }

        private final void load_dict() {
            int k2 = this.marker();
            PyDictionary d2 = new PyDictionary();
            for (int i2 = 0; i2 < k2; i2 += 2) {
                PyObject value = this.pop();
                PyObject key = this.pop();
                d2.__setitem__(key, value);
            }
            this.pop();
            this.push(d2);
        }

        private final void load_inst() {
            PyObject[] args = new PyObject[this.marker()];
            this.pop(args);
            this.pop();
            String module = this.file.readlineNoNl();
            String name = this.file.readlineNoNl();
            PyObject klass = this.find_class(module, name);
            PyObject value = null;
            value = args.length == 0 && klass instanceof PyClass && klass.__findattr__("__getinitargs__") == null ? new PyInstance((PyClass)klass) : klass.__call__(args);
            this.push(value);
        }

        private final void load_obj() {
            PyObject[] args = new PyObject[this.marker() - 1];
            this.pop(args);
            PyObject klass = this.pop();
            this.pop();
            PyObject value = null;
            value = args.length == 0 && klass instanceof PyClass && klass.__findattr__("__getinitargs__") == null ? new PyInstance((PyClass)klass) : klass.__call__(args);
            this.push(value);
        }

        private final void load_global() {
            String module = this.file.readlineNoNl();
            String name = this.file.readlineNoNl();
            PyObject klass = this.find_class(module, name);
            this.push(klass);
        }

        private final PyObject find_class(String module, String name) {
            PyObject global;
            if (this.find_global != null) {
                if (this.find_global == Py.None) {
                    throw new PyException(UnpicklingError, "Global and instance pickles are not supported.");
                }
                return this.find_global.__call__(new PyString(module), (PyObject)new PyString(name));
            }
            PyObject modules = Py.getSystemState().modules;
            PyObject mod2 = modules.__finditem__(module.intern());
            if (mod2 == null) {
                mod2 = cPickle.importModule(module);
            }
            if ((global = mod2.__findattr__(name.intern())) == null) {
                throw new PyException(Py.SystemError, "Failed to import class " + name + " from module " + module);
            }
            return global;
        }

        private void load_ext(int length) {
            int code2 = this.read_binint(length);
            PyObject key = inverted_registry.get(Py.newInteger(code2));
            if (key == null) {
                throw new PyException(Py.ValueError, "unregistered extension code " + code2);
            }
            String module = key.__finditem__(0).toString();
            String name = key.__finditem__(1).toString();
            this.push(this.find_class(module, name));
        }

        private final void load_reduce() {
            PyObject arg_tup = this.pop();
            PyObject callable = this.pop();
            PyObject value = null;
            value = arg_tup == Py.None ? callable.__findattr__("__basicnew__").__call__() : callable.__call__(this.make_array(arg_tup));
            this.push(value);
        }

        private void load_newobj() {
            PyObject arg_tup = this.pop();
            PyObject cls = this.pop();
            PyObject[] args = new PyObject[arg_tup.__len__() + 1];
            args[0] = cls;
            for (int i2 = 1; i2 < args.length; ++i2) {
                args[i2] = arg_tup.__finditem__(i2 - 1);
            }
            this.push(cls.__getattr__("__new__").__call__(args));
        }

        private final PyObject[] make_array(PyObject seq) {
            int n2 = seq.__len__();
            PyObject[] objs = new PyObject[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                objs[i2] = seq.__finditem__(i2);
            }
            return objs;
        }

        private final void load_pop() {
            this.pop();
        }

        private final void load_pop_mark() {
            this.pop(this.marker());
        }

        private final void load_dup() {
            this.push(this.peek());
        }

        private final void load_get() {
            String py_str = this.file.readlineNoNl();
            PyObject value = this.memo.get(py_str);
            if (value == null) {
                throw new PyException(BadPickleGet, py_str);
            }
            this.push(value);
        }

        private final void load_binget() {
            String py_key = String.valueOf((int)this.file.read(1).charAt(0));
            PyObject value = this.memo.get(py_key);
            if (value == null) {
                throw new PyException(BadPickleGet, py_key);
            }
            this.push(value);
        }

        private final void load_long_binget() {
            int i2 = this.read_binint();
            String py_key = String.valueOf(i2);
            PyObject value = this.memo.get(py_key);
            if (value == null) {
                throw new PyException(BadPickleGet, py_key);
            }
            this.push(value);
        }

        private final void load_put() {
            this.memo.put(this.file.readlineNoNl(), this.peek());
        }

        private final void load_binput() {
            char i2 = this.file.read(1).charAt(0);
            this.memo.put(String.valueOf((int)i2), this.peek());
        }

        private final void load_long_binput() {
            int i2 = this.read_binint();
            this.memo.put(String.valueOf(i2), this.peek());
        }

        private final void load_append() {
            PyObject value = this.pop();
            PyObject obj = this.peek();
            if (obj instanceof PyList) {
                ((PyList)obj).append(value);
            } else {
                PyObject appender = obj.__getattr__("append");
                appender.__call__(value);
            }
        }

        private final void load_appends() {
            int mark = this.marker();
            PyObject obj = this.peek(mark + 1);
            if (obj instanceof PyList) {
                for (int i2 = mark - 1; i2 >= 0; --i2) {
                    ((PyList)obj).append(this.peek(i2));
                }
            } else {
                PyObject appender = obj.__getattr__("append");
                for (int i3 = mark - 1; i3 >= 0; --i3) {
                    appender.__call__(this.peek(i3));
                }
            }
            this.pop(mark + 1);
        }

        private final void load_setitem() {
            PyObject value = this.pop();
            PyObject key = this.pop();
            PyDictionary dict = (PyDictionary)this.peek();
            dict.__setitem__(key, value);
        }

        private final void load_setitems() {
            int mark = this.marker();
            PyDictionary dict = (PyDictionary)this.peek(mark + 1);
            for (int i2 = 0; i2 < mark; i2 += 2) {
                PyObject key = this.peek(i2 + 1);
                PyObject value = this.peek(i2);
                dict.__setitem__(key, value);
            }
            this.pop(mark + 1);
        }

        private void load_build() {
            PyObject state = this.pop();
            PyObject inst = this.peek();
            PyObject setstate = inst.__findattr__("__setstate__");
            if (setstate != null) {
                setstate.__call__(state);
                return;
            }
            PyObject slotstate = null;
            if (state instanceof PyTuple && state.__len__() == 2) {
                PyObject temp = state;
                state = temp.__getitem__(0);
                slotstate = temp.__getitem__(1);
            }
            if (state != Py.None) {
                if (!(state instanceof PyDictionary)) {
                    throw new PyException(UnpicklingError, "state is not a dictionary");
                }
                PyObject dict = inst.__getattr__("__dict__");
                for (PyObject item : ((PyDictionary)state).iteritems().asIterable()) {
                    dict.__setitem__(item.__getitem__(0), item.__getitem__(1));
                }
            }
            if (slotstate != null) {
                if (!(slotstate instanceof PyDictionary)) {
                    throw new PyException(UnpicklingError, "slot state is not a dictionary");
                }
                for (PyObject item : ((PyDictionary)slotstate).iteritems().asIterable()) {
                    inst.__setattr__(PyObject.asName(item.__getitem__(0)), item.__getitem__(1));
                }
            }
        }

        private final void load_mark() {
            this.push(this.mark);
        }

        private final PyObject load_stop() {
            return this.pop();
        }

        private final PyObject peek() {
            return this.stack[this.stackTop - 1];
        }

        private final PyObject peek(int count) {
            return this.stack[this.stackTop - count - 1];
        }

        private final PyObject pop() {
            PyObject val = this.stack[--this.stackTop];
            this.stack[this.stackTop] = null;
            return val;
        }

        private final void pop(int count) {
            for (int i2 = 0; i2 < count; ++i2) {
                this.stack[--this.stackTop] = null;
            }
        }

        private final void pop(PyObject[] arr) {
            int len = arr.length;
            System.arraycopy(this.stack, this.stackTop - len, arr, 0, len);
            this.stackTop -= len;
        }

        private final void push(PyObject val) {
            if (this.stackTop >= this.stack.length) {
                PyObject[] newStack = new PyObject[(this.stackTop + 1) * 2];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
            }
            this.stack[this.stackTop++] = val;
        }
    }

    private static class PickleMemo {
        private final int[] primes = new int[]{13, 61, 251, 1021, 4093, 5987, 9551, 15683, 19609, 31397, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD, 33554393, 0x3FFFFFB, 134217689, 0xFFFFFC7, 0x1FFFFFFD, 0x3FFFFFDD};
        private transient int[] keys = null;
        private transient int[] position;
        private transient Object[] values = null;
        private int size;
        private transient int filled;
        private transient int prime = 0;

        public PickleMemo(int capacity) {
            this.resize(capacity);
        }

        public PickleMemo() {
            this(4);
        }

        public int size() {
            return this.size;
        }

        private int findIndex(int key, Object value) {
            int[] table = this.keys;
            int maxindex = table.length;
            int index = (key & Integer.MAX_VALUE) % maxindex;
            int stepsize = maxindex / 5;
            int tkey;
            while ((tkey = table[index]) != key || value != this.values[index]) {
                if (this.values[index] == null) {
                    return -1;
                }
                index = (index + stepsize) % maxindex;
            }
            return index;
        }

        public int findPosition(int key, Object value) {
            int idx = this.findIndex(key, value);
            if (idx < 0) {
                return -1;
            }
            return this.position[idx];
        }

        public Object findValue(int key, Object value) {
            int idx = this.findIndex(key, value);
            if (idx < 0) {
                return null;
            }
            return this.values[idx];
        }

        private final void insertkey(int key, int pos, Object value) {
            int[] table = this.keys;
            int maxindex = table.length;
            int index = (key & Integer.MAX_VALUE) % maxindex;
            int stepsize = maxindex / 5;
            while (true) {
                int tkey = table[index];
                if (this.values[index] == null) {
                    table[index] = key;
                    this.position[index] = pos;
                    this.values[index] = value;
                    ++this.filled;
                    ++this.size;
                    break;
                }
                if (tkey == key && this.values[index] == value) {
                    this.position[index] = pos;
                    break;
                }
                index = (index + stepsize) % maxindex;
            }
        }

        private final void resize(int capacity) {
            int p2;
            for (p2 = this.prime; p2 < this.primes.length && this.primes[p2] < capacity; ++p2) {
            }
            if (this.primes[p2] < capacity) {
                throw Py.ValueError("can't make hashtable of size: " + capacity);
            }
            capacity = this.primes[p2];
            this.prime = p2;
            int[] oldKeys = this.keys;
            int[] oldPositions = this.position;
            Object[] oldValues = this.values;
            this.keys = new int[capacity];
            this.position = new int[capacity];
            this.values = new Object[capacity];
            this.size = 0;
            this.filled = 0;
            if (oldValues != null) {
                int n2 = oldValues.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object value = oldValues[i2];
                    if (value == null) continue;
                    this.insertkey(oldKeys[i2], oldPositions[i2], value);
                }
            }
        }

        public void put(int key, int pos, Object value) {
            if (2 * this.filled > this.keys.length) {
                this.resize(this.keys.length + 1);
            }
            this.insertkey(key, pos, value);
        }
    }

    public static class Pickler {
        private PyIOFile file;
        private int protocol;
        public boolean fast = false;
        private PickleMemo memo = new PickleMemo();
        public PyObject persistent_id = null;
        public PyObject inst_persistent_id = null;

        public Pickler(PyObject file, int protocol) {
            this.file = PyIOFileFactory.createIOFile(file);
            this.protocol = protocol;
        }

        public void dump(PyObject object) {
            if (this.protocol >= 2) {
                this.file.write('\u0080');
                this.file.write((char)this.protocol);
            }
            this.save(object);
            this.file.write('.');
            this.file.flush();
        }

        private static final int get_id(PyObject o2) {
            return System.identityHashCode(o2);
        }

        private void put(int i2) {
            if (this.protocol > 0) {
                if (i2 < 256) {
                    this.file.write('q');
                    this.file.write((char)i2);
                    return;
                }
                this.file.write('r');
                this.file.write((char)(i2 & 0xFF));
                this.file.write((char)(i2 >>> 8 & 0xFF));
                this.file.write((char)(i2 >>> 16 & 0xFF));
                this.file.write((char)(i2 >>> 24 & 0xFF));
                return;
            }
            this.file.write('p');
            this.file.write(String.valueOf(i2));
            this.file.write("\n");
        }

        private void get(int i2) {
            if (this.protocol > 0) {
                if (i2 < 256) {
                    this.file.write('h');
                    this.file.write((char)i2);
                    return;
                }
                this.file.write('j');
                this.file.write((char)(i2 & 0xFF));
                this.file.write((char)(i2 >>> 8 & 0xFF));
                this.file.write((char)(i2 >>> 16 & 0xFF));
                this.file.write((char)(i2 >>> 24 & 0xFF));
                return;
            }
            this.file.write('g');
            this.file.write(String.valueOf(i2));
            this.file.write("\n");
        }

        private void save(PyObject object) {
            this.save(object, false);
        }

        private void save(PyObject object, boolean pers_save) {
            PyObject dictitems;
            if (!pers_save && this.persistent_id != null && this.save_pers(object, this.persistent_id)) {
                return;
            }
            int d2 = Pickler.get_id(object);
            PyType t2 = object.getType();
            if (t2 == TupleType && object.__len__() == 0) {
                if (this.protocol > 0) {
                    this.save_empty_tuple(object);
                } else {
                    this.save_tuple(object);
                }
                return;
            }
            int m2 = this.getMemoPosition(d2, object);
            if (m2 >= 0) {
                this.get(m2);
                return;
            }
            if (this.save_type(object, t2)) {
                return;
            }
            if (!pers_save && this.inst_persistent_id != null && this.save_pers(object, this.inst_persistent_id)) {
                return;
            }
            if (Py.isSubClass(t2, PyType.TYPE)) {
                this.save_global(object);
                return;
            }
            PyObject tup = null;
            PyObject reduce = dispatch_table.__finditem__(t2);
            if (reduce == null) {
                reduce = object.__findattr__("__reduce_ex__");
                if (reduce != null) {
                    tup = reduce.__call__(Py.newInteger(this.protocol));
                } else {
                    reduce = object.__findattr__("__reduce__");
                    if (reduce == null) {
                        throw new PyException(UnpickleableError, object);
                    }
                    tup = reduce.__call__();
                }
            } else {
                tup = reduce.__call__(object);
            }
            if (tup instanceof PyString) {
                this.save_global(object, tup);
                return;
            }
            if (!(tup instanceof PyTuple)) {
                throw new PyException(PicklingError, "Value returned by " + reduce.__repr__() + " must be a tuple");
            }
            int l2 = tup.__len__();
            if (l2 < 2 || l2 > 5) {
                throw new PyException(PicklingError, "tuple returned by " + reduce.__repr__() + " must contain two to five elements");
            }
            PyObject callable = tup.__finditem__(0);
            PyObject arg_tup = tup.__finditem__(1);
            PyObject state = l2 > 2 ? tup.__finditem__(2) : Py.None;
            PyObject listitems = l2 > 3 ? tup.__finditem__(3) : Py.None;
            PyObject pyObject = dictitems = l2 > 4 ? tup.__finditem__(4) : Py.None;
            if (!(arg_tup instanceof PyTuple) && arg_tup != Py.None) {
                throw new PyException(PicklingError, "Second element of tupe returned by " + reduce.__repr__() + " must be a tuple");
            }
            this.save_reduce(callable, arg_tup, state, listitems, dictitems, object);
        }

        private final boolean save_pers(PyObject object, PyObject pers_func) {
            PyObject pid = pers_func.__call__(object);
            if (pid == Py.None) {
                return false;
            }
            if (this.protocol == 0) {
                if (!Py.isInstance(pid, PyString.TYPE)) {
                    throw new PyException(PicklingError, "persistent id must be string");
                }
                this.file.write('P');
                this.file.write(pid.toString());
                this.file.write("\n");
            } else {
                this.save(pid, true);
                this.file.write('Q');
            }
            return true;
        }

        private final void save_reduce(PyObject callable, PyObject arg_tup, PyObject state, PyObject listitems, PyObject dictitems, PyObject object) {
            PyObject callableName = callable.__findattr__("__name__");
            if (this.protocol >= 2 && callableName != null && "__newobj__".equals(callableName.toString())) {
                PyObject cls = arg_tup.__finditem__(0);
                if (cls.__findattr__("__new__") == null) {
                    throw new PyException(PicklingError, "args[0] from __newobj__ args has no __new__");
                }
                this.save(cls);
                this.save(arg_tup.__getslice__(Py.One, Py.None));
                this.file.write('\u0081');
            } else {
                this.save(callable);
                this.save(arg_tup);
                this.file.write('R');
            }
            this.put(this.putMemo(Pickler.get_id(object), object));
            if (listitems != Py.None) {
                this.batch_appends(listitems);
            }
            if (dictitems != Py.None) {
                this.batch_setitems(dictitems);
            }
            if (state != Py.None) {
                this.save(state);
                this.file.write('b');
            }
        }

        private final boolean save_type(PyObject object, PyType type) {
            if (type == NoneType) {
                this.save_none(object);
            } else if (type == StringType) {
                this.save_string(object);
            } else if (type == UnicodeType) {
                this.save_unicode(object);
            } else if (type == IntType) {
                this.save_int(object);
            } else if (type == LongType) {
                this.save_long(object);
            } else if (type == FloatType) {
                this.save_float(object);
            } else if (type == TupleType) {
                this.save_tuple(object);
            } else if (type == ListType) {
                this.save_list(object);
            } else if (type == DictionaryType || type == StringMapType) {
                this.save_dict(object);
            } else if (type == InstanceType) {
                this.save_inst((PyInstance)object);
            } else if (type == ClassType) {
                this.save_global(object);
            } else if (type == TypeType) {
                this.save_global(object);
            } else if (type == FunctionType) {
                this.save_global(object);
            } else if (type == BuiltinCallableType) {
                this.save_global(object);
            } else if (type == ReflectedFunctionType) {
                this.save_global(object);
            } else if (type == BoolType) {
                this.save_bool(object);
            } else {
                return false;
            }
            return true;
        }

        private final void save_none(PyObject object) {
            this.file.write('N');
        }

        private final void save_int(PyObject object) {
            if (this.protocol > 0) {
                int l2 = ((PyInteger)object).getValue();
                char i1 = (char)(l2 & 0xFF);
                char i2 = (char)(l2 >>> 8 & 0xFF);
                char i3 = (char)(l2 >>> 16 & 0xFF);
                char i4 = (char)(l2 >>> 24 & 0xFF);
                if (i3 == '\u0000' && i4 == '\u0000') {
                    if (i2 == '\u0000') {
                        this.file.write('K');
                        this.file.write(i1);
                        return;
                    }
                    this.file.write('M');
                    this.file.write(i1);
                    this.file.write(i2);
                    return;
                }
                this.file.write('J');
                this.file.write(i1);
                this.file.write(i2);
                this.file.write(i3);
                this.file.write(i4);
            } else {
                this.file.write('I');
                this.file.write(object.toString());
                this.file.write("\n");
            }
        }

        private void save_bool(PyObject object) {
            int value = ((PyBoolean)object).getValue();
            if (this.protocol >= 2) {
                this.file.write(value != 0 ? (char)'\u0088' : '\u0089');
            } else {
                this.file.write('I');
                this.file.write(value != 0 ? "01" : "00");
                this.file.write("\n");
            }
        }

        private void save_long(PyObject object) {
            if (this.protocol >= 2) {
                BigInteger integer = ((PyLong)object).getValue();
                if (integer.compareTo(BigInteger.ZERO) == 0) {
                    this.file.write('\u008a');
                    this.file.write('\u0000');
                    return;
                }
                byte[] bytes = integer.toByteArray();
                int l2 = bytes.length;
                if (l2 < 256) {
                    this.file.write('\u008a');
                    this.file.write((char)l2);
                } else {
                    this.file.write('\u008b');
                    this.writeInt4(l2);
                }
                for (int i2 = l2 - 1; i2 >= 0; --i2) {
                    int b2 = bytes[i2] & 0xFF;
                    this.file.write((char)b2);
                }
            } else {
                this.file.write('L');
                this.file.write(object.toString());
                this.file.write("\n");
            }
        }

        private void writeInt4(int l2) {
            char i1 = (char)(l2 & 0xFF);
            char i2 = (char)(l2 >>> 8 & 0xFF);
            char i3 = (char)(l2 >>> 16 & 0xFF);
            char i4 = (char)(l2 >>> 24 & 0xFF);
            this.file.write(i1);
            this.file.write(i2);
            this.file.write(i3);
            this.file.write(i4);
        }

        private final void save_float(PyObject object) {
            if (this.protocol > 0) {
                this.file.write('G');
                double value = ((PyFloat)object).getValue();
                long bits = Double.doubleToLongBits(value);
                this.file.write((char)(bits >>> 56 & 0xFFL));
                this.file.write((char)(bits >>> 48 & 0xFFL));
                this.file.write((char)(bits >>> 40 & 0xFFL));
                this.file.write((char)(bits >>> 32 & 0xFFL));
                this.file.write((char)(bits >>> 24 & 0xFFL));
                this.file.write((char)(bits >>> 16 & 0xFFL));
                this.file.write((char)(bits >>> 8 & 0xFFL));
                this.file.write((char)(bits >>> 0 & 0xFFL));
            } else {
                this.file.write('F');
                this.file.write(object.toString());
                this.file.write("\n");
            }
        }

        private final void save_string(PyObject object) {
            String str = object.toString();
            if (this.protocol > 0) {
                int l2 = str.length();
                if (l2 < 256) {
                    this.file.write('U');
                    this.file.write((char)l2);
                } else {
                    this.file.write('T');
                    this.file.write((char)(l2 & 0xFF));
                    this.file.write((char)(l2 >>> 8 & 0xFF));
                    this.file.write((char)(l2 >>> 16 & 0xFF));
                    this.file.write((char)(l2 >>> 24 & 0xFF));
                }
                this.file.write(str);
            } else {
                this.file.write('S');
                this.file.write(object.__repr__().toString());
                this.file.write("\n");
            }
            this.put(this.putMemo(Pickler.get_id(object), object));
        }

        private void save_unicode(PyObject object) {
            if (this.protocol > 0) {
                String str = codecs.PyUnicode_EncodeUTF8(object.toString(), "struct");
                this.file.write('X');
                this.writeInt4(str.length());
                this.file.write(str);
            } else {
                this.file.write('V');
                this.file.write(codecs.PyUnicode_EncodeRawUnicodeEscape(object.toString(), "strict", true));
                this.file.write("\n");
            }
            this.put(this.putMemo(Pickler.get_id(object), object));
        }

        private void save_tuple(PyObject object) {
            int m2;
            int d2 = Pickler.get_id(object);
            int len = object.__len__();
            if (len > 0 && len <= 3 && this.protocol >= 2) {
                for (int i2 = 0; i2 < len; ++i2) {
                    this.save(object.__finditem__(i2));
                }
                int m3 = this.getMemoPosition(d2, object);
                if (m3 >= 0) {
                    for (int i3 = 0; i3 < len; ++i3) {
                        this.file.write('0');
                    }
                    this.get(m3);
                } else {
                    char opcode2 = (char)(133 + len - 1);
                    this.file.write(opcode2);
                    this.put(this.putMemo(d2, object));
                }
                return;
            }
            this.file.write('(');
            for (int i4 = 0; i4 < len; ++i4) {
                this.save(object.__finditem__(i4));
            }
            if (len > 0 && (m2 = this.getMemoPosition(d2, object)) >= 0) {
                if (this.protocol > 0) {
                    this.file.write('1');
                    this.get(m2);
                    return;
                }
                for (int i5 = 0; i5 < len + 1; ++i5) {
                    this.file.write('0');
                }
                this.get(m2);
                return;
            }
            this.file.write('t');
            this.put(this.putMemo(d2, object));
        }

        private final void save_empty_tuple(PyObject object) {
            this.file.write(')');
        }

        private void save_list(PyObject object) {
            if (this.protocol > 0) {
                this.file.write(']');
            } else {
                this.file.write('(');
                this.file.write('l');
            }
            this.put(this.putMemo(Pickler.get_id(object), object));
            this.batch_appends(object);
        }

        private void batch_appends(PyObject object) {
            int countInBatch = 0;
            for (PyObject nextObj : object.asIterable()) {
                if (this.protocol == 0) {
                    this.save(nextObj);
                    this.file.write('a');
                    continue;
                }
                if (countInBatch == 0) {
                    this.file.write('(');
                }
                this.save(nextObj);
                if (++countInBatch != 1024) continue;
                this.file.write('e');
                countInBatch = 0;
            }
            if (countInBatch > 0) {
                this.file.write('e');
            }
        }

        private void save_dict(PyObject object) {
            if (this.protocol > 0) {
                this.file.write('}');
            } else {
                this.file.write('(');
                this.file.write('d');
            }
            this.put(this.putMemo(Pickler.get_id(object), object));
            this.batch_setitems(object.invoke("iteritems"));
        }

        private void batch_setitems(PyObject object) {
            if (this.protocol == 0) {
                for (PyObject p2 : object.asIterable()) {
                    if (!(p2 instanceof PyTuple) || p2.__len__() != 2) {
                        throw Py.TypeError("dict items iterator must return 2-tuples");
                    }
                    this.save(p2.__getitem__(0));
                    this.save(p2.__getitem__(1));
                    this.file.write('s');
                }
            } else {
                int n2;
                PyObject[] slice2 = new PyObject[1024];
                do {
                    PyObject obj;
                    for (n2 = 0; n2 < 1024 && (obj = object.__iternext__()) != null; ++n2) {
                        slice2[n2] = obj;
                    }
                    if (n2 > 1) {
                        this.file.write('(');
                        for (int i2 = 0; i2 < n2; ++i2) {
                            obj = slice2[i2];
                            this.save(obj.__getitem__(0));
                            this.save(obj.__getitem__(1));
                        }
                        this.file.write('u');
                        continue;
                    }
                    if (n2 != 1) continue;
                    obj = slice2[0];
                    this.save(obj.__getitem__(0));
                    this.save(obj.__getitem__(1));
                    this.file.write('s');
                } while (n2 == 1024);
            }
        }

        private final void save_inst(PyInstance object) {
            PyClass cls = object.instclass;
            PySequence args = null;
            PyObject getinitargs = object.__findattr__("__getinitargs__");
            if (getinitargs != null) {
                args = (PySequence)getinitargs.__call__();
                this.keep_alive(args);
            }
            this.file.write('(');
            if (this.protocol > 0) {
                this.save(cls);
            }
            if (args != null) {
                int len = args.__len__();
                for (int i2 = 0; i2 < len; ++i2) {
                    this.save(args.__finditem__(i2));
                }
            }
            int mid = this.putMemo(Pickler.get_id(object), object);
            if (this.protocol > 0) {
                this.file.write('o');
                this.put(mid);
            } else {
                this.file.write('i');
                this.file.write(cls.__findattr__("__module__").toString());
                this.file.write("\n");
                this.file.write(cls.__name__);
                this.file.write("\n");
                this.put(mid);
            }
            PyObject stuff = null;
            PyObject getstate = object.__findattr__("__getstate__");
            if (getstate == null) {
                stuff = object.__dict__;
            } else {
                stuff = getstate.__call__();
                this.keep_alive(stuff);
            }
            this.save(stuff);
            this.file.write('b');
        }

        private final void save_global(PyObject object) {
            this.save_global(object, null);
        }

        private final void save_global(PyObject object, PyObject name) {
            PyObject module;
            if (name == null) {
                name = object.__findattr__("__name__");
            }
            if ((module = object.__findattr__("__module__")) == null || module == Py.None) {
                module = cPickle.whichmodule(object, name);
            }
            if (this.protocol >= 2) {
                PyTuple extKey = new PyTuple(module, name);
                PyObject extCode = extension_registry.get(extKey);
                if (extCode != Py.None) {
                    int code2 = ((PyInteger)extCode).getValue();
                    if (code2 <= 255) {
                        this.file.write('\u0082');
                        this.file.write((char)code2);
                    } else if (code2 <= 65535) {
                        this.file.write('\u0083');
                        this.file.write((char)(code2 & 0xFF));
                        this.file.write((char)(code2 >> 8));
                    } else {
                        this.file.write('\u0084');
                        this.writeInt4(code2);
                    }
                    return;
                }
            }
            this.file.write('c');
            this.file.write(module.toString());
            this.file.write("\n");
            this.file.write(name.toString());
            this.file.write("\n");
            this.put(this.putMemo(Pickler.get_id(object), object));
        }

        private final int getMemoPosition(int id, Object o2) {
            return this.memo.findPosition(id, o2);
        }

        private final int putMemo(int id, PyObject object) {
            int memo_len = this.memo.size() + 1;
            this.memo.put(id, memo_len, object);
            return memo_len;
        }

        private final void keep_alive(PyObject obj) {
            int id = System.identityHashCode(this.memo);
            PyList list = (PyList)this.memo.findValue(id, this.memo);
            if (list == null) {
                list = new PyList();
                this.memo.put(id, -1, list);
            }
            list.append(obj);
        }
    }
}

