/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.StyleRun;
import org.python.indexer.Util;
import org.python.indexer.types.NModuleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Linker {
    private static final Pattern CONSTANT = Pattern.compile("[A-Z_][A-Z0-9_]*");
    private Map<String, List<StyleRun>> fileStyles = new HashMap<String, List<StyleRun>>();
    private File outDir;
    private String rootPath;

    public Linker(String root, File outdir) {
        this.rootPath = root;
        this.outDir = outdir;
    }

    public void findLinks(Indexer indexer) {
        for (NBinding nb : indexer.getBindings().values()) {
            this.addSemanticStyles(nb);
            this.processDefs(nb);
            this.processRefs(nb);
        }
    }

    public List<StyleRun> getStyles(String path) {
        return this.stylesForFile(path);
    }

    private List<StyleRun> stylesForFile(String path) {
        List<StyleRun> styles = this.fileStyles.get(path);
        if (styles == null) {
            styles = new ArrayList<StyleRun>();
            this.fileStyles.put(path, styles);
        }
        return styles;
    }

    private void addFileStyle(String path, StyleRun style) {
        this.stylesForFile(path).add(style);
    }

    private void addSemanticStyles(NBinding nb) {
        Def def = nb.getSignatureNode();
        if (def == null || !def.isName()) {
            return;
        }
        boolean isConst = CONSTANT.matcher(def.getName()).matches();
        switch (nb.getKind()) {
            case SCOPE: {
                if (!isConst) break;
                this.addSemanticStyle(def, StyleRun.Type.CONSTANT);
                break;
            }
            case VARIABLE: {
                this.addSemanticStyle(def, isConst ? StyleRun.Type.CONSTANT : StyleRun.Type.IDENTIFIER);
                break;
            }
            case PARAMETER: {
                this.addSemanticStyle(def, StyleRun.Type.PARAMETER);
                break;
            }
            case CLASS: {
                this.addSemanticStyle(def, StyleRun.Type.TYPE_NAME);
            }
        }
    }

    private void addSemanticStyle(Def def, StyleRun.Type type) {
        String path = def.getFile();
        if (path != null) {
            this.addFileStyle(path, new StyleRun(type, def.start(), def.length()));
        }
    }

    private void processDefs(NBinding nb) {
        Def def = nb.getSignatureNode();
        if (def == null || def.isURL()) {
            return;
        }
        StyleRun style = new StyleRun(StyleRun.Type.ANCHOR, def.start(), def.length());
        style.message = nb.getQname();
        style.url = nb.getQname();
        this.addFileStyle(def.getFile(), style);
    }

    private void processRefs(NBinding nb) {
        if (nb.hasRefs()) {
            for (Ref ref : nb.getRefs()) {
                this.processRef(ref, nb);
            }
        }
    }

    void processRef(Ref ref, NBinding nb) {
        String path = ref.getFile();
        StyleRun link = new StyleRun(StyleRun.Type.LINK, ref.start(), ref.length());
        link.message = nb.getQname();
        link.url = this.toURL(nb, path);
        if (link.url != null) {
            this.addFileStyle(path, link);
        }
    }

    private String toURL(NBinding nb, String path) {
        Def def = nb.getSignatureNode();
        if (def == null) {
            return null;
        }
        if (nb.isBuiltin()) {
            return def.getURL();
        }
        if (def.isModule()) {
            return this.toModuleUrl(nb);
        }
        String anchor = "#" + nb.getQname();
        if (nb.getFirstFile().equals(path)) {
            return anchor;
        }
        String destPath = def.getFile();
        try {
            String relpath = destPath.substring(this.rootPath.length());
            return Util.joinPath(this.outDir.getAbsolutePath(), relpath) + ".html" + anchor;
        }
        catch (Exception x2) {
            System.err.println("path problem:  dest=" + destPath + ", root=" + this.rootPath + ": " + x2);
            return null;
        }
    }

    private String toModuleUrl(NBinding nb) {
        NModuleType mtype = nb.getType().follow().asModuleType();
        String path = mtype.getFile();
        if (!path.startsWith(this.rootPath)) {
            return "file://" + path;
        }
        String relpath = path.substring(this.rootPath.length());
        return Util.joinPath(this.outDir.getAbsolutePath(), relpath) + ".html";
    }
}

