/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NFor
extends NNode {
    static final long serialVersionUID = 3228529969554646406L;
    public NNode target;
    public NNode iter;
    public NBlock body;
    public NBlock orelse;

    public NFor(NNode target, NNode iter, NBlock body, NBlock orelse) {
        this(target, iter, body, orelse, 0, 1);
    }

    public NFor(NNode target, NNode iter, NBlock body, NBlock orelse, int start, int end) {
        super(start, end);
        this.target = target;
        this.iter = iter;
        this.body = body;
        this.orelse = orelse;
        this.addChildren(target, iter, body, orelse);
    }

    public boolean bindsName() {
        return true;
    }

    protected void bindNames(Scope s2) throws Exception {
        this.bindNames(s2, this.target, NameBinder.make());
    }

    private void bindNames(Scope s2, NNode target, NameBinder binder) throws Exception {
        if (target instanceof NName) {
            binder.bind(s2, (NName)target, (NType)new NUnknownType());
            return;
        }
        if (target instanceof NSequence) {
            for (NNode n2 : ((NSequence)target).getElements()) {
                this.bindNames(s2, n2, binder);
            }
        }
    }

    public NType resolve(Scope s2) throws Exception {
        NameBinder.make().bindIter(s2, this.target, this.iter);
        if (this.body == null) {
            this.setType(new NUnknownType());
        } else {
            this.setType(NFor.resolveExpr(this.body, s2));
        }
        if (this.orelse != null) {
            this.addType(NFor.resolveExpr(this.orelse, s2));
        }
        return this.getType();
    }

    public String toString() {
        return "<For:" + this.target + ":" + this.iter + ":" + this.body + ":" + this.orelse + ">";
    }

    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.target, v2);
            this.visitNode(this.iter, v2);
            this.visitNode(this.body, v2);
            this.visitNode(this.orelse, v2);
        }
    }
}

