/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NSequence;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NComprehension
extends NNode {
    static final long serialVersionUID = -598250664243757218L;
    public NNode target;
    public NNode iter;
    public List<NNode> ifs;

    public NComprehension(NNode target, NNode iter, List<NNode> ifs) {
        this(target, iter, ifs, 0, 1);
    }

    public NComprehension(NNode target, NNode iter, List<NNode> ifs, int start, int end) {
        super(start, end);
        this.target = target;
        this.iter = iter;
        this.ifs = ifs;
        this.addChildren(target, iter);
        this.addChildren(ifs);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s2) throws Exception {
        this.bindNames(s2, this.target, NameBinder.make());
    }

    private void bindNames(Scope s2, NNode target, NameBinder binder) throws Exception {
        if (target instanceof NName) {
            binder.bind(s2, (NName)target, (NType)new NUnknownType());
            return;
        }
        if (target instanceof NSequence) {
            for (NNode n2 : ((NSequence)target).getElements()) {
                this.bindNames(s2, n2, binder);
            }
        }
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NameBinder.make().bindIter(s2, this.target, this.iter);
        this.resolveList(this.ifs, s2);
        return this.setType(this.target.getType());
    }

    public String toString() {
        return "<Comprehension:" + this.start() + ":" + this.target + ":" + this.iter + ":" + this.ifs + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.target, v2);
            this.visitNode(this.iter, v2);
            this.visitNodeList(this.ifs, v2);
        }
    }
}

