/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AbstractIndexedIterator;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.UnmodifiableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class TransformedImmutableList<D, E>
extends ImmutableList<E> {
    private final transient ImmutableList<D> backingList;

    TransformedImmutableList(ImmutableList<D> backingList) {
        this.backingList = Preconditions.checkNotNull(backingList);
    }

    abstract E transform(D var1);

    @Override
    public int indexOf(@Nullable Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!this.get(i2).equals(object)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            if (!this.get(i2).equals(object)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public E get(int index) {
        return this.transform(this.backingList.get(index));
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        Preconditions.checkPositionIndex(index, this.size());
        return new AbstractIndexedIterator<E>(index, this.size()){

            @Override
            protected E get(int index) {
                return TransformedImmutableList.this.get(index);
            }
        };
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        return new TransformedView(this.backingList.subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return this.size() == list.size() && Iterators.elementsEqual(this.iterator(), list.iterator());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object e2 : this) {
            hashCode = 31 * hashCode + (e2 == null ? 0 : e2.hashCode());
        }
        return hashCode;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return ObjectArrays.toArrayImpl(this, array);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformedView
    extends TransformedImmutableList<D, E> {
        TransformedView(ImmutableList<D> backingList) {
            super(backingList);
        }

        @Override
        E transform(D d2) {
            return TransformedImmutableList.this.transform(d2);
        }
    }
}

