/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import javax.annotation.Nullable;
import org.python.google.common.base.Equivalence;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> nullAwareEquals() {
        return Impl.NULL_AWARE_EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            public boolean equivalent(Object a2, @Nullable Object b2) {
                Preconditions.checkNotNull(a2);
                return a2.equals(b2);
            }

            public int hash(Object o2) {
                Preconditions.checkNotNull(o2);
                return o2.hashCode();
            }
        }
        ,
        IDENTITY{

            public boolean equivalent(Object a2, @Nullable Object b2) {
                return Preconditions.checkNotNull(a2) == b2;
            }

            public int hash(@Nullable Object o2) {
                return System.identityHashCode(o2);
            }
        }
        ,
        NULL_AWARE_EQUALS{

            public boolean equivalent(@Nullable Object a2, @Nullable Object b2) {
                return Objects.equal(a2, b2);
            }

            public int hash(@Nullable Object o2) {
                return o2 == null ? 0 : o2.hashCode();
            }
        };

    }
}

