/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;

@Beta
@GwtCompatible
public final class Ascii {
    private Ascii() {
    }

    public static String toLowerCase(String string2) {
        int length = string2.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            builder.append(Ascii.toLowerCase(string2.charAt(i2)));
        }
        return builder.toString();
    }

    public static char toLowerCase(char c2) {
        return Ascii.isUpperCase(c2) ? (char)(c2 ^ 0x20) : c2;
    }

    public static String toUpperCase(String string2) {
        int length = string2.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            builder.append(Ascii.toUpperCase(string2.charAt(i2)));
        }
        return builder.toString();
    }

    public static char toUpperCase(char c2) {
        return Ascii.isLowerCase(c2) ? (char)(c2 & 0x5F) : c2;
    }

    public static boolean isLowerCase(char c2) {
        return c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isUpperCase(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }
}

