/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.lang.reflect.Array;

public class ByteSwapper {
    public static void swap(Object array) {
        Class<?> arrayType = array.getClass().getComponentType();
        if (arrayType.isPrimitive()) {
            if (arrayType == Boolean.TYPE) {
                return;
            }
            if (arrayType == Byte.TYPE) {
                return;
            }
            if (arrayType == Character.TYPE) {
                return;
            }
            if (arrayType == Short.TYPE) {
                ByteSwapper.swapShortArray(array);
            } else if (arrayType == Integer.TYPE) {
                ByteSwapper.swapIntegerArray(array);
            } else if (arrayType == Long.TYPE) {
                ByteSwapper.swapLongArray(array);
            } else if (arrayType == Float.TYPE) {
                ByteSwapper.swapFloatArray(array);
            } else if (arrayType == Double.TYPE) {
                ByteSwapper.swapDoubleArray(array);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapDoubleArray(Object array) {
        int len = Array.getLength(array);
        int n2 = 0;
        while (n2 < len) {
            void dtmp;
            double d2 = Array.getDouble(array, n2);
            long l2 = Double.doubleToLongBits(d2);
            long l3 = l2 >> 0 & 0xFFL;
            long l4 = l2 >> 8 & 0xFFL;
            long l5 = l2 >> 16 & 0xFFL;
            long l6 = l2 >> 24 & 0xFFL;
            long l7 = l2 >> 32 & 0xFFL;
            long l8 = l2 >> 40 & 0xFFL;
            long l9 = l2 >> 48 & 0xFFL;
            long l10 = l2 >> 56 & 0xFFL;
            l2 = l3 << 56 | l4 << 48 | l5 << 40 | l6 << 32 | l7 << 24 | l8 << 16 | l9 << 8 | l10 << 0;
            d2 = Double.longBitsToDouble(l2);
            Array.setDouble(array, (int)dtmp, d2);
            ++dtmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapFloatArray(Object array) {
        int len = Array.getLength(array);
        int n2 = 0;
        while (n2 < len) {
            void ftmp;
            void b4;
            void b3;
            void b2;
            int b1;
            float f2 = Array.getFloat(array, n2);
            int n3 = Float.floatToIntBits(f2);
            int n4 = n3 >> 0 & 0xFF;
            int n5 = b1 >> 8 & 0xFF;
            int n6 = b1 >> 16 & 0xFF;
            int i2 = b1 >> 24 & 0xFF;
            b1 = b2 << 24 | b3 << 16 | b4 << 8 | i2 << 0;
            float tmp = Float.intBitsToFloat(b1);
            Array.setFloat(array, (int)ftmp, tmp);
            ++ftmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapIntegerArray(Object array) {
        int len = Array.getLength(array);
        int n2 = 0;
        while (n2 < len) {
            void tmp;
            void b4;
            void b3;
            void b2;
            int b1;
            int n3 = Array.getInt(array, n2);
            int n4 = n3 >> 0 & 0xFF;
            int n5 = b1 >> 8 & 0xFF;
            int n6 = b1 >> 16 & 0xFF;
            int i2 = b1 >> 24 & 0xFF;
            b1 = b2 << 24 | b3 << 16 | b4 << 8 | i2 << 0;
            Array.setInt(array, (int)tmp, b1);
            ++tmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapLongArray(Object array) {
        int len = Array.getLength(array);
        int n2 = 0;
        while (n2 < len) {
            void tmp;
            long l2 = Array.getLong(array, n2);
            long l3 = l2 >> 0 & 0xFFL;
            long l4 = l2 >> 8 & 0xFFL;
            long l5 = l2 >> 16 & 0xFFL;
            long l6 = l2 >> 24 & 0xFFL;
            long l7 = l2 >> 32 & 0xFFL;
            long l8 = l2 >> 40 & 0xFFL;
            long l9 = l2 >> 48 & 0xFFL;
            long l10 = l2 >> 56 & 0xFFL;
            l2 = l3 << 56 | l4 << 48 | l5 << 40 | l6 << 32 | l7 << 24 | l8 << 16 | l9 << 8 | l10 << 0;
            Array.setLong(array, (int)tmp, l2);
            ++tmp;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void swapShortArray(Object array) {
        int len = Array.getLength(array);
        int n2 = 0;
        while (n2 < len) {
            void tmp;
            void b2;
            short b1;
            short s2 = Array.getShort(array, n2);
            int n3 = s2 >> 0 & 0xFF;
            int i2 = b1 >> 8 & 0xFF;
            b1 = (short)(b2 << 8 | i2 << 0);
            Array.setShort(array, (int)tmp, b1);
            ++tmp;
        }
    }
}

