/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.core.Options;
import org.python.core.packagecache.PackageManager;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedJarsPackageManager
extends PackageManager {
    private boolean indexModified;
    private Map<String, JarXEntry> jarfiles;
    private File cachedir;

    protected void message(String msg) {
    }

    protected void warning(String warn) {
    }

    protected void comment(String msg) {
    }

    protected void debug(String msg) {
    }

    protected boolean filterByName(String name, boolean pkg) {
        return name.indexOf(36) != -1;
    }

    protected boolean filterByAccess(String name, int acc) {
        return (acc & 1) != 1;
    }

    private static String listToString(List<String> list) {
        int n2 = list.size();
        StringBuilder ret = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            ret.append(list.get(i2));
            if (i2 >= n2 - 1) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    private void addZipEntry(Map<String, List<String>[]> zipPackages, ZipEntry entry, ZipInputStream zip) throws IOException {
        int access;
        String name = entry.getName();
        if (!name.endsWith(".class")) {
            return;
        }
        char sep = '/';
        int breakPoint = name.lastIndexOf(sep);
        if (breakPoint == -1) {
            breakPoint = name.lastIndexOf(92);
            sep = '\\';
        }
        String packageName = breakPoint == -1 ? "" : name.substring(0, breakPoint).replace(sep, '.');
        String className = name.substring(breakPoint + 1, name.length() - 6);
        if (this.filterByName(className, false)) {
            return;
        }
        List<String>[] vec = zipPackages.get(packageName);
        if (vec == null) {
            vec = this.createGenericStringListArray();
            zipPackages.put(packageName, vec);
        }
        if ((access = CachedJarsPackageManager.checkAccess(zip)) != -1 && !this.filterByAccess(name, access)) {
            vec[0].add(className);
        } else {
            vec[1].add(className);
        }
    }

    private List<String>[] createGenericStringListArray() {
        return new List[]{Generic.list(), Generic.list()};
    }

    private Map<String, String> getZipPackages(InputStream jarin) throws IOException {
        ZipEntry entry;
        Map<String, List<String>[]> zipPackages = Generic.map();
        ZipInputStream zip = new ZipInputStream(jarin);
        while ((entry = zip.getNextEntry()) != null) {
            this.addZipEntry(zipPackages, entry, zip);
            zip.closeEntry();
        }
        Map<String, String> transformed = Generic.map();
        for (Map.Entry kv : zipPackages.entrySet()) {
            List[] vec = (List[])kv.getValue();
            String classes = CachedJarsPackageManager.listToString(vec[0]);
            if (vec[1].size() > 0) {
                classes = classes + '@' + CachedJarsPackageManager.listToString(vec[1]);
            }
            transformed.put((String)kv.getKey(), classes);
        }
        return transformed;
    }

    public void addJarToPackages(URL jarurl) {
        this.addJarToPackages(jarurl, null, false);
    }

    public void addJarToPackages(URL jarurl, boolean cache) {
        this.addJarToPackages(jarurl, null, cache);
    }

    public void addJarToPackages(File jarfile) {
        this.addJarToPackages(null, jarfile, false);
    }

    public void addJarToPackages(File jarfile, boolean cache) {
        this.addJarToPackages(null, jarfile, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJarToPackages(URL jarurl, File jarfile, boolean cache) {
        try {
            boolean caching = this.jarfiles != null;
            URLConnection jarconn = null;
            boolean localfile = true;
            if (jarfile == null) {
                jarconn = jarurl.openConnection();
                if (jarconn.getURL().getProtocol().equals("file")) {
                    String jarfilename = jarurl.getFile();
                    jarfilename = jarfilename.replace('/', File.separatorChar);
                    jarfile = new File(jarfilename);
                } else {
                    localfile = false;
                }
            }
            if (localfile && !jarfile.exists()) {
                return;
            }
            Map<String, String> zipPackages = null;
            long mtime = 0L;
            String jarcanon = null;
            JarXEntry entry = null;
            boolean brandNew = false;
            if (caching) {
                if (localfile) {
                    mtime = jarfile.lastModified();
                    jarcanon = jarfile.getCanonicalPath();
                } else {
                    mtime = jarconn.getLastModified();
                    jarcanon = jarurl.toString();
                }
                entry = this.jarfiles.get(jarcanon);
                if ((entry == null || !new File(entry.cachefile).exists()) && cache) {
                    String jarname;
                    this.message("processing new jar, '" + jarcanon + "'");
                    if (localfile) {
                        jarname = jarfile.getName();
                    } else {
                        jarname = jarurl.getFile();
                        int slash = jarname.lastIndexOf(47);
                        if (slash != -1) {
                            jarname = jarname.substring(slash + 1);
                        }
                    }
                    jarname = jarname.substring(0, jarname.length() - 4);
                    entry = new JarXEntry(jarname);
                    this.jarfiles.put(jarcanon, entry);
                    brandNew = true;
                }
                if (mtime != 0L && entry != null && entry.mtime == mtime) {
                    zipPackages = this.readCacheFile(entry, jarcanon);
                }
            }
            if (zipPackages == null) {
                boolean bl2 = caching = caching && cache;
                if (caching) {
                    this.indexModified = true;
                    if (entry.mtime != 0L) {
                        this.message("processing modified jar, '" + jarcanon + "'");
                    }
                    entry.mtime = mtime;
                }
                InputStream jarin = null;
                try {
                    jarin = jarconn == null ? new BufferedInputStream(new FileInputStream(jarfile)) : jarconn.getInputStream();
                    zipPackages = this.getZipPackages(jarin);
                }
                finally {
                    if (jarin != null) {
                        jarin.close();
                    }
                }
                if (caching) {
                    this.writeCacheFile(entry, jarcanon, zipPackages, brandNew);
                }
            }
            this.addPackages(zipPackages, jarcanon);
        }
        catch (IOException ioe) {
            this.warning("skipping bad jar, '" + (jarfile != null ? jarfile.toString() : jarurl.toString()) + "'");
        }
    }

    private void addPackages(Map<String, String> zipPackages, String jarfile) {
        for (Map.Entry<String, String> entry : zipPackages.entrySet()) {
            String pkg = entry.getKey();
            String classes = entry.getValue();
            int idx = classes.indexOf(64);
            if (idx >= 0 && Options.respectJavaAccessibility) {
                classes = classes.substring(0, idx);
            }
            this.makeJavaPackage(pkg, classes, jarfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readCacheFile(JarXEntry entry, String jarcanon) {
        String cachefile = entry.cachefile;
        long mtime = entry.mtime;
        this.debug("reading cache, '" + jarcanon + "'");
        DataInputStream istream = null;
        try {
            istream = this.inOpenCacheFile(cachefile);
            String old_jarcanon = istream.readUTF();
            long old_mtime = istream.readLong();
            if (!old_jarcanon.equals(jarcanon) || old_mtime != mtime) {
                this.comment("invalid cache file: " + cachefile + ", " + jarcanon + ":" + old_jarcanon + ", " + mtime + ":" + old_mtime);
                this.deleteCacheFile(cachefile);
                Map<String, String> map = null;
                return map;
            }
            Map<String, String> packs = Generic.map();
            try {
                while (true) {
                    String packageName = istream.readUTF();
                    String classes = istream.readUTF();
                    if (packs.containsKey(packageName)) {
                        classes = packs.get(packageName) + classes;
                    }
                    packs.put(packageName, classes);
                }
            }
            catch (EOFException eof) {
                Map<String, String> map = packs;
                return map;
            }
        }
        catch (IOException ioe) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCacheFile(JarXEntry entry, String jarcanon, Map<String, String> zipPackages, boolean brandNew) {
        DataOutputStream ostream = null;
        try {
            ostream = this.outCreateCacheFile(entry, brandNew);
            ostream.writeUTF(jarcanon);
            ostream.writeLong(entry.mtime);
            this.comment("rewriting cachefile for '" + jarcanon + "'");
            for (Map.Entry<String, String> kv : zipPackages.entrySet()) {
                String classes = kv.getValue();
                for (String part : CachedJarsPackageManager.splitString(classes, 65535)) {
                    ostream.writeUTF(kv.getKey());
                    ostream.writeUTF(part);
                }
            }
        }
        catch (IOException ioe) {
            this.warning("can't write cache file for '" + jarcanon + "'");
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected static String[] splitString(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len <= maxLength) {
            return new String[]{str};
        }
        int chunkCount = (int)Math.ceil((float)len / (float)maxLength);
        String[] chunks = new String[chunkCount];
        for (int i2 = 0; i2 < chunkCount; ++i2) {
            chunks[i2] = str.substring(i2 * maxLength, Math.min(i2 * maxLength + maxLength, len));
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCache() {
        this.indexModified = false;
        this.jarfiles = Generic.map();
        DataInputStream istream = null;
        try {
            istream = this.inOpenIndex();
            if (istream == null) {
                return;
            }
            try {
                while (true) {
                    String jarcanon = istream.readUTF();
                    String cachefile = istream.readUTF();
                    long mtime = istream.readLong();
                    this.jarfiles.put(jarcanon, new JarXEntry(cachefile, mtime));
                }
            }
            catch (EOFException eof) {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        catch (IOException ioe) {
            this.warning("invalid index file");
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCache() {
        if (this.jarfiles == null || !this.indexModified) {
            return;
        }
        this.indexModified = false;
        this.comment("writing modified index file");
        DataOutputStream ostream = null;
        try {
            ostream = this.outOpenIndex();
            for (Map.Entry<String, JarXEntry> entry : this.jarfiles.entrySet()) {
                String jarcanon = entry.getKey();
                JarXEntry xentry = entry.getValue();
                ostream.writeUTF(jarcanon);
                ostream.writeUTF(xentry.cachefile);
                ostream.writeLong(xentry.mtime);
            }
        }
        catch (IOException ioe) {
            this.warning("can't write index file");
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected DataInputStream inOpenIndex() throws IOException {
        File indexFile = new File(this.cachedir, "packages.idx");
        if (!indexFile.exists()) {
            return null;
        }
        DataInputStream istream = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
        return istream;
    }

    protected DataOutputStream outOpenIndex() throws IOException {
        File indexFile = new File(this.cachedir, "packages.idx");
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
    }

    protected DataInputStream inOpenCacheFile(String cachefile) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(cachefile)));
    }

    protected void deleteCacheFile(String cachefile) {
        new File(cachefile).delete();
    }

    protected DataOutputStream outCreateCacheFile(JarXEntry entry, boolean create) throws IOException {
        File cachefile = null;
        if (create) {
            int index = 1;
            String suffix = "";
            String jarname = entry.cachefile;
            while ((cachefile = new File(this.cachedir, jarname + suffix + ".pkc")).exists()) {
                suffix = "$" + index;
                ++index;
            }
            entry.cachefile = cachefile.getCanonicalPath();
        } else {
            cachefile = new File(entry.cachefile);
        }
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cachefile)));
    }

    protected boolean useCacheDir(File aCachedir1) {
        if (aCachedir1 == null) {
            return false;
        }
        try {
            if (!aCachedir1.isDirectory() && !aCachedir1.mkdirs()) {
                this.warning("can't create package cache dir, '" + aCachedir1 + "'");
                return false;
            }
        }
        catch (AccessControlException ace) {
            this.warning("The java security manager isn't allowing access to the package cache dir, '" + aCachedir1 + "'");
            return false;
        }
        this.cachedir = aCachedir1;
        return true;
    }

    public static class JarXEntry {
        public String cachefile;
        public long mtime;

        public JarXEntry(String cachefile) {
            this.cachefile = cachefile;
        }

        public JarXEntry(String cachefile, long mtime) {
            this.cachefile = cachefile;
            this.mtime = mtime;
        }
    }
}

