/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.StringSubsequenceIterator;
import org.python.core.imp;
import org.python.core.util.StringUtil;

public class codecs {
    public static final String BACKSLASHREPLACE = "backslashreplace";
    public static final String IGNORE = "ignore";
    public static final String REPLACE = "replace";
    public static final String XMLCHARREFREPLACE = "xmlcharrefreplace";
    private static char Py_UNICODE_REPLACEMENT_CHARACTER = (char)65533;
    private static PyList searchPath;
    private static PyStringMap searchCache;
    private static PyStringMap errorHandlers;
    private static final Object INIT_LOCK;
    private static String default_encoding;
    private static boolean import_encodings_called;
    static char[] hexdigits;
    public static char[] utf7_special;
    private static final String B64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static byte[] utf8_code_length;
    private static char[] hexdigit;

    public static String getDefaultEncoding() {
        return default_encoding;
    }

    public static void setDefaultEncoding(String encoding) {
        codecs.lookup(encoding);
        default_encoding = encoding;
    }

    public static PyObject lookup_error(String handlerName) {
        PyObject handler2;
        codecs.registry_init();
        if (handlerName == null) {
            handlerName = "strict";
        }
        if ((handler2 = errorHandlers.__finditem__(handlerName.intern())) == null) {
            throw new PyException(Py.LookupError, "unknown error handler name '" + handlerName + "'");
        }
        return handler2;
    }

    public static void register_error(String name, PyObject error) {
        codecs.registry_init();
        if (!error.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        errorHandlers.__setitem__(name.intern(), error);
    }

    public static void register(PyObject search_function) {
        codecs.registry_init();
        if (!search_function.isCallable()) {
            throw Py.TypeError("argument must be callable");
        }
        searchPath.append(search_function);
    }

    public static PyTuple lookup(String encoding) {
        codecs.registry_init();
        PyString v2 = new PyString(codecs.normalizestring(encoding));
        PyObject cached = searchCache.__finditem__(v2);
        if (cached != null) {
            return (PyTuple)cached;
        }
        if (searchPath.__len__() == 0) {
            throw new PyException(Py.LookupError, "no codec search functions registered: can't find encoding '" + encoding + "'");
        }
        for (PyObject func : searchPath.asIterable()) {
            PyObject created = func.__call__(v2);
            if (created == Py.None) continue;
            if (!(created instanceof PyTuple) || created.__len__() != 4) {
                throw Py.TypeError("codec search functions must return 4-tuples");
            }
            searchCache.__setitem__(v2, created);
            return (PyTuple)created;
        }
        throw new PyException(Py.LookupError, "unknown encoding '" + encoding + "'");
    }

    private static String normalizestring(String string2) {
        return string2.toLowerCase().replace(' ', '-');
    }

    private static void import_encodings() {
        block3: {
            if (!import_encodings_called) {
                import_encodings_called = true;
                try {
                    imp.load("encodings");
                }
                catch (PyException exc) {
                    if (exc.type == Py.ImportError) break block3;
                    throw exc;
                }
            }
        }
    }

    public static PyObject decode(PyString v2, String encoding, String errors2) {
        PyObject decoder;
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors2 != null) {
            errors2 = errors2.intern();
        }
        if (encoding.equals("ascii")) {
            return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeASCII(v2.toString(), v2.__len__(), errors2));
        }
        try {
            decoder = codecs.lookup(encoding).__getitem__(1);
        }
        catch (PyException ex) {
            if (ex.match(Py.LookupError)) {
                if (encoding.equals("utf-8")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF8(v2.toString(), errors2));
                }
                if (encoding.equals("utf-7")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeUTF7(v2.toString(), errors2));
                }
                if (encoding.equals("latin-1")) {
                    return codecs.wrapDecodeResult(codecs.PyUnicode_DecodeLatin1(v2.toString(), v2.__len__(), errors2));
                }
            }
            throw ex;
        }
        PyObject result = errors2 != null ? decoder.__call__(v2, (PyObject)new PyString(errors2)) : decoder.__call__(v2);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("decoder must return a tuple (object,integer)");
        }
        return result.__getitem__(0);
    }

    private static PyUnicode wrapDecodeResult(String result) {
        return new PyUnicode(result, true);
    }

    public static String encode(PyString v2, String encoding, String errors2) {
        PyObject encoder;
        encoding = encoding == null ? codecs.getDefaultEncoding() : codecs.normalizestring(encoding);
        if (errors2 != null) {
            errors2 = errors2.intern();
        }
        if (encoding.equals("latin-1")) {
            return codecs.PyUnicode_EncodeLatin1(v2.toString(), v2.__len__(), errors2);
        }
        if (encoding.equals("ascii")) {
            return codecs.PyUnicode_EncodeASCII(v2.toString(), v2.__len__(), errors2);
        }
        try {
            encoder = codecs.lookup(encoding).__getitem__(0);
        }
        catch (PyException ex) {
            if (ex.match(Py.LookupError)) {
                if (encoding.equals("utf-8")) {
                    return codecs.PyUnicode_EncodeUTF8(v2.toString(), errors2);
                }
                if (encoding.equals("utf-7")) {
                    return codecs.PyUnicode_EncodeUTF7(v2.toString(), false, false, errors2);
                }
            }
            throw ex;
        }
        PyObject result = errors2 != null ? encoder.__call__(v2, (PyObject)new PyString(errors2)) : encoder.__call__(v2);
        if (!(result instanceof PyTuple) || result.__len__() != 2) {
            throw Py.TypeError("encoder must return a tuple (object,integer)");
        }
        PyObject encoded = result.__getitem__(0);
        if (encoded instanceof PyString) {
            return encoded.toString();
        }
        throw Py.TypeError("encoder did not return a string/unicode object (type=" + encoded.getType().fastGetName() + ")");
    }

    public static PyObject strict_errors(PyObject[] args, String[] kws) {
        ArgParser ap2 = new ArgParser("strict_errors", args, kws, "exc");
        PyObject exc = ap2.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            throw new PyException(Py.UnicodeDecodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw new PyException(Py.UnicodeEncodeError, exc);
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            throw new PyException(Py.UnicodeTranslateError, exc);
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject ignore_errors(PyObject[] args, String[] kws) {
        ArgParser ap2 = new ArgParser("ignore_errors", args, kws, "exc");
        PyObject exc = ap2.getPyObject(0);
        if (!codecs.isUnicodeError(exc)) {
            throw codecs.wrong_exception_type(exc);
        }
        PyObject end = exc.__getattr__("end");
        return new PyTuple(Py.java2py(""), end);
    }

    private static boolean isUnicodeError(PyObject exc) {
        return Py.isInstance(exc, Py.UnicodeDecodeError) || Py.isInstance(exc, Py.UnicodeEncodeError) || Py.isInstance(exc, Py.UnicodeTranslateError);
    }

    public static PyObject replace_errors(PyObject[] args, String[] kws) {
        ArgParser ap2 = new ArgParser("replace_errors", args, kws, "exc");
        PyObject exc = ap2.getPyObject(0);
        if (Py.isInstance(exc, Py.UnicodeDecodeError)) {
            PyObject object = exc.__getattr__("object");
            if (!Py.isInstance(object, PyString.TYPE) || Py.isInstance(object, PyUnicode.TYPE)) {
                throw Py.TypeError("object attribute must be str");
            }
            PyObject end = exc.__getattr__("end");
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), end);
        }
        if (Py.isInstance(exc, Py.UnicodeEncodeError)) {
            PyObject object = exc.__getattr__("object");
            if (!Py.isInstance(object, PyUnicode.TYPE)) {
                throw Py.TypeError("object attribute must be unicode");
            }
            PyObject end = exc.__getattr__("end");
            return new PyTuple(Py.java2py("?"), end);
        }
        if (Py.isInstance(exc, Py.UnicodeTranslateError)) {
            PyObject end = exc.__getattr__("end");
            return new PyTuple(new PyUnicode(Py_UNICODE_REPLACEMENT_CHARACTER), end);
        }
        throw codecs.wrong_exception_type(exc);
    }

    public static PyObject xmlcharrefreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap2 = new ArgParser("xmlcharrefreplace_errors", args, kws, "exc");
        PyObject exc = ap2.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder xmlcharrefreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.xmlcharrefreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void xmlcharrefreplace_internal(int start, int end, String object, StringBuilder replacement) {
        for (int i2 = start; i2 < end; ++i2) {
            int base2;
            int digits;
            replacement.append("&#");
            char cur = object.charAt(i2);
            if (cur < '\n') {
                digits = 1;
                base2 = 1;
            } else if (cur < 'd') {
                digits = 2;
                base2 = 10;
            } else if (cur < '\u03e8') {
                digits = 3;
                base2 = 100;
            } else if (cur < '\u2710') {
                digits = 4;
                base2 = 1000;
            } else if (cur < '\u186a0') {
                digits = 5;
                base2 = 10000;
            } else if (cur < '\uf4240') {
                digits = 6;
                base2 = 100000;
            } else {
                digits = 7;
                base2 = 1000000;
            }
            while (digits-- > 0) {
                replacement.append((char)(48 + cur / base2));
                cur = (char)(cur % base2);
                base2 /= 10;
            }
            replacement.append(';');
        }
    }

    private static PyException wrong_exception_type(PyObject exc) {
        PyObject excClass = exc.__getattr__("__class__");
        PyObject className = excClass.__getattr__("__name__");
        return new PyException(Py.TypeError, "Don't know how to handle " + className + " in error callback");
    }

    public static PyObject backslashreplace_errors(PyObject[] args, String[] kws) {
        ArgParser ap2 = new ArgParser("backslashreplace_errors", args, kws, "exc");
        PyObject exc = ap2.getPyObject(0);
        if (!Py.isInstance(exc, Py.UnicodeEncodeError)) {
            throw codecs.wrong_exception_type(exc);
        }
        int start = ((PyInteger)exc.__getattr__("start")).getValue();
        int end = ((PyInteger)exc.__getattr__("end")).getValue();
        String object = exc.__getattr__("object").toString();
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, object, replacement);
        return new PyTuple(Py.java2py(replacement.toString()), exc.__getattr__("end"));
    }

    public static StringBuilder backslashreplace(int start, int end, String toReplace) {
        StringBuilder replacement = new StringBuilder();
        codecs.backslashreplace_internal(start, end, toReplace, replacement);
        return replacement;
    }

    private static void backslashreplace_internal(int start, int end, String object, StringBuilder replacement) {
        StringSubsequenceIterator iter = new StringSubsequenceIterator(object, start, end, 1);
        while (iter.hasNext()) {
            int c2 = (Integer)iter.next();
            replacement.append('\\');
            if (c2 >= 65536) {
                replacement.append('U');
                replacement.append(hexdigits[c2 >> 28 & 0xF]);
                replacement.append(hexdigits[c2 >> 24 & 0xF]);
                replacement.append(hexdigits[c2 >> 20 & 0xF]);
                replacement.append(hexdigits[c2 >> 16 & 0xF]);
                replacement.append(hexdigits[c2 >> 12 & 0xF]);
                replacement.append(hexdigits[c2 >> 8 & 0xF]);
            } else if (c2 >= 256) {
                replacement.append('u');
                replacement.append(hexdigits[c2 >> 12 & 0xF]);
                replacement.append(hexdigits[c2 >> 8 & 0xF]);
            } else {
                replacement.append('x');
            }
            replacement.append(hexdigits[c2 >> 4 & 0xF]);
            replacement.append(hexdigits[c2 & 0xF]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registry_init() {
        Object object = INIT_LOCK;
        synchronized (object) {
            String[] builtinErrorHandlers;
            if (searchPath != null) {
                return;
            }
            searchPath = new PyList();
            searchCache = new PyStringMap();
            errorHandlers = new PyStringMap();
            for (String builtinErrorHandler : builtinErrorHandlers = new String[]{"strict", IGNORE, REPLACE, XMLCHARREFREPLACE, BACKSLASHREPLACE}) {
                codecs.register_error(builtinErrorHandler, Py.newJavaFunc(codecs.class, builtinErrorHandler + "_errors"));
            }
            codecs.import_encodings();
        }
    }

    private static boolean SPECIAL(char c2, boolean encodeO, boolean encodeWS) {
        return c2 > '\u007f' || utf7_special[c2] == '\u0001' || encodeWS && utf7_special[c2] == '\u0002' || encodeO && utf7_special[c2] == '\u0003';
    }

    private static char B64(int n2) {
        return B64_CHARS.charAt(n2 & 0x3F);
    }

    private static boolean B64CHAR(char c2) {
        return B64_CHARS.indexOf(c2) != -1;
    }

    private static int UB64(char c2) {
        return c2 == '+' ? 62 : (c2 == '/' ? 63 : (c2 >= 'a' ? c2 - 71 : (c2 >= 'A' ? c2 - 65 : c2 + 4)));
    }

    public static String PyUnicode_DecodeUTF7(String str, String errors2) {
        int s2 = 0;
        int e2 = str.length();
        boolean inShift = false;
        int bitsInCharsleft = 0;
        long charsleft = 0L;
        boolean surrogate = false;
        StringBuilder unicode = new StringBuilder(e2);
        while (s2 < e2) {
            char ch2 = str.charAt(s2);
            if (inShift) {
                char outCh;
                if (ch2 == '-' || !codecs.B64CHAR(ch2)) {
                    inShift = false;
                    ++s2;
                    while (bitsInCharsleft >= 16) {
                        outCh = (char)(charsleft >> (bitsInCharsleft -= 16) & 0xFFFFL);
                        if (surrogate) {
                            s2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-7", str, s2, s2 + 1, "code pairs are not supported");
                            surrogate = false;
                            continue;
                        }
                        if ('\udc00' <= outCh && outCh <= '\udfff') {
                            surrogate = true;
                            continue;
                        }
                        unicode.append(outCh);
                    }
                    if (bitsInCharsleft >= 6) {
                        s2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-7", str, s2, s2 + 1, "partial character in shift sequence");
                    }
                    if (bitsInCharsleft > 0 && (charsleft << 5 - bitsInCharsleft & 0x1FL) > 0L) {
                        s2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-7", str, s2, s2 + 1, "non-zero padding bits in shift sequence");
                    }
                    if (ch2 == '-') {
                        if (s2 < e2 && str.charAt(s2) == '-') {
                            unicode.append('-');
                            inShift = true;
                        }
                    } else if (codecs.SPECIAL(ch2, false, false)) {
                        s2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-7", str, s2, s2 + 1, "unexpected special character");
                    } else {
                        unicode.append(ch2);
                    }
                } else {
                    charsleft = charsleft << 6 | (long)codecs.UB64(ch2);
                    bitsInCharsleft += 6;
                    ++s2;
                    while (bitsInCharsleft >= 16) {
                        outCh = (char)(charsleft >> (bitsInCharsleft -= 16) & 0xFFFFL);
                        if (surrogate) {
                            s2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-7", str, s2, s2 + 1, "code pairs are not supported");
                            continue;
                        }
                        if ('\udc00' <= outCh && outCh <= '\udfff') {
                            surrogate = true;
                            continue;
                        }
                        unicode.append(outCh);
                    }
                }
            } else if (ch2 == '+') {
                if (++s2 < e2 && str.charAt(s2) == '-') {
                    ++s2;
                    unicode.append('+');
                } else {
                    inShift = true;
                    bitsInCharsleft = 0;
                }
            } else if (codecs.SPECIAL(ch2, false, false)) {
                s2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-7", str, s2, s2 + 1, "unexpected special character");
            } else {
                unicode.append(ch2);
                ++s2;
            }
            if (!inShift || s2 != e2) continue;
            s2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-7", str, s2, s2, "unterminated shift sequence");
        }
        return unicode.toString();
    }

    public static String PyUnicode_EncodeUTF7(String str, boolean encodeSetO, boolean encodeWhiteSpace, String errors2) {
        int size = str.length();
        if (size == 0) {
            return "";
        }
        boolean inShift = false;
        int bitsleft = 0;
        int charsleft = 0;
        StringBuilder v2 = new StringBuilder();
        for (int i2 = 0; i2 < size; ++i2) {
            char ch2 = str.charAt(i2);
            if (!inShift) {
                if (ch2 == '+') {
                    v2.append('+');
                    v2.append('-');
                    continue;
                }
                if (codecs.SPECIAL(ch2, encodeSetO, encodeWhiteSpace)) {
                    charsleft = ch2;
                    v2.append('+');
                    for (bitsleft = 16; bitsleft >= 6; bitsleft -= 6) {
                        v2.append(codecs.B64(charsleft >> bitsleft - 6));
                    }
                    inShift = bitsleft > 0;
                    continue;
                }
                v2.append(ch2);
                continue;
            }
            if (!codecs.SPECIAL(ch2, encodeSetO, encodeWhiteSpace)) {
                v2.append(codecs.B64(charsleft << 6 - bitsleft));
                charsleft = 0;
                bitsleft = 0;
                if (codecs.B64CHAR(ch2) || ch2 == '-') {
                    v2.append('-');
                }
                inShift = false;
                v2.append(ch2);
                continue;
            }
            bitsleft += 16;
            charsleft = charsleft << 16 | ch2;
            while (bitsleft >= 6) {
                v2.append(codecs.B64(charsleft >> bitsleft - 6));
                bitsleft -= 6;
            }
            if (bitsleft != 0) continue;
            if (i2 + 1 < size) {
                char ch22 = str.charAt(i2 + 1);
                if (codecs.SPECIAL(ch22, encodeSetO, encodeWhiteSpace)) continue;
                if (codecs.B64CHAR(ch22) || ch22 == '-') {
                    v2.append('-');
                    inShift = false;
                    continue;
                }
                inShift = false;
                continue;
            }
            v2.append('-');
            inShift = false;
        }
        if (bitsleft > 0) {
            v2.append(codecs.B64(charsleft << 6 - bitsleft));
            v2.append('-');
        }
        return v2.toString();
    }

    public static String PyUnicode_DecodeUTF8(String str, String errors2) {
        return codecs.PyUnicode_DecodeUTF8Stateful(str, errors2, null);
    }

    public static String PyUnicode_DecodeUTF8Stateful(String str, String errors2, int[] consumed) {
        int size = str.length();
        StringBuilder unicode = new StringBuilder(size);
        int i2 = 0;
        block7: while (i2 < size) {
            int ch2 = str.charAt(i2);
            if (ch2 < 128) {
                unicode.append((char)ch2);
                ++i2;
                continue;
            }
            if (ch2 > 255) {
                i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 1, "ordinal not in range(255)");
                continue;
            }
            byte n2 = utf8_code_length[ch2];
            if (i2 + n2 > size) {
                if (consumed != null) break;
                i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 1, "unexpected end of data");
                continue;
            }
            switch (n2) {
                case 0: {
                    i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 1, "unexpected code byte");
                    continue block7;
                }
                case 1: {
                    i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 1, "internal error");
                    continue block7;
                }
                case 2: {
                    char ch1 = str.charAt(i2 + 1);
                    if ((ch1 & 0xC0) != 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 2, "invalid data");
                        continue block7;
                    }
                    if ((ch2 = ((ch2 & 0x1F) << 6) + (ch1 & 0x3F)) < 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 2, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch2);
                    break;
                }
                case 3: {
                    char ch1 = str.charAt(i2 + 1);
                    char ch22 = str.charAt(i2 + 2);
                    if ((ch1 & 0xC0) != 128 || (ch22 & 0xC0) != 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 3, "invalid data");
                        continue block7;
                    }
                    if ((ch2 = ((ch2 & 0xF) << 12) + ((ch1 & 0x3F) << 6) + (ch22 & 0x3F)) < 2048 || ch2 >= 55296 && ch2 < 57344) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 3, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch2);
                    break;
                }
                case 4: {
                    char ch1 = str.charAt(i2 + 1);
                    char ch22 = str.charAt(i2 + 2);
                    char ch3 = str.charAt(i2 + 3);
                    if ((ch1 & 0xC0) != 128 || (ch22 & 0xC0) != 128 || (ch3 & 0xC0) != 128) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 4, "invalid data");
                        continue block7;
                    }
                    if ((ch2 = ((ch2 & 7) << 18) + ((ch1 & 0x3F) << 12) + ((ch22 & 0x3F) << 6) + (ch3 & 0x3F)) < 65536 || ch2 > 0x10FFFF) {
                        i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + 4, "illegal encoding");
                        continue block7;
                    }
                    unicode.appendCodePoint(ch2);
                    break;
                }
                default: {
                    i2 = codecs.insertReplacementAndGetResume(unicode, errors2, "utf-8", str, i2, i2 + n2, "unsupported Unicode code range");
                    continue block7;
                }
            }
            i2 += n2;
        }
        if (consumed != null) {
            consumed[0] = i2;
        }
        return unicode.toString();
    }

    public static String PyUnicode_EncodeUTF8(String str, String errors2) {
        return StringUtil.fromBytes(Charset.forName("UTF-8").encode(str));
    }

    public static String PyUnicode_DecodeASCII(String str, int size, String errors2) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors2, "ascii", 128);
    }

    public static String PyUnicode_DecodeLatin1(String str, int size, String errors2) {
        return codecs.PyUnicode_DecodeIntLimited(str, size, errors2, "latin-1", 256);
    }

    private static String PyUnicode_DecodeIntLimited(String str, int size, String errors2, String encoding, int limit) {
        StringBuilder v2 = new StringBuilder(size);
        String reason = "ordinal not in range(" + limit + ")";
        for (int i2 = 0; i2 < size; ++i2) {
            char ch2 = str.charAt(i2);
            if (ch2 < limit) {
                v2.append(ch2);
                continue;
            }
            i2 = codecs.insertReplacementAndGetResume(v2, errors2, encoding, str, i2, i2 + 1, reason) - 1;
        }
        return v2.toString();
    }

    public static String PyUnicode_EncodeASCII(String str, int size, String errors2) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors2, "ascii", 128);
    }

    public static String PyUnicode_EncodeLatin1(String str, int size, String errors2) {
        return codecs.PyUnicode_EncodeIntLimited(str, size, errors2, "latin-1", 256);
    }

    private static String PyUnicode_EncodeIntLimited(String str, int size, String errors2, String encoding, int limit) {
        String reason = "ordinal not in range(" + limit + ")";
        StringBuilder v2 = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            char ch2 = str.charAt(i2);
            if (ch2 >= limit) {
                int nextGood;
                for (nextGood = i2 + 1; nextGood < size && str.charAt(nextGood) >= limit; ++nextGood) {
                }
                if (errors2 != null) {
                    if (errors2.equals(IGNORE)) {
                        i2 = nextGood - 1;
                        continue;
                    }
                    if (errors2.equals(REPLACE)) {
                        for (int j2 = i2; j2 < nextGood; ++j2) {
                            v2.append('?');
                        }
                        i2 = nextGood - 1;
                        continue;
                    }
                    if (errors2.equals(XMLCHARREFREPLACE)) {
                        v2.append((CharSequence)codecs.xmlcharrefreplace(i2, nextGood, str));
                        i2 = nextGood - 1;
                        continue;
                    }
                    if (errors2.equals(BACKSLASHREPLACE)) {
                        v2.append((CharSequence)codecs.backslashreplace(i2, nextGood, str));
                        i2 = nextGood - 1;
                        continue;
                    }
                }
                PyObject replacement = codecs.encoding_error(errors2, encoding, str, i2, nextGood, reason);
                String replStr = replacement.__getitem__(0).toString();
                for (int j3 = 0; j3 < replStr.length(); ++j3) {
                    if (replStr.charAt(j3) < limit) continue;
                    throw Py.UnicodeEncodeError(encoding, str, i2 + j3, i2 + j3 + 1, reason);
                }
                v2.append(replStr);
                i2 = codecs.calcNewPosition(size, replacement) - 1;
                continue;
            }
            v2.append(ch2);
        }
        return v2.toString();
    }

    public static int calcNewPosition(int size, PyObject errorTuple) {
        int newPosition = ((PyInteger)errorTuple.__getitem__(1)).getValue();
        if (newPosition < 0) {
            newPosition = size + newPosition;
        }
        if (newPosition > size || newPosition < 0) {
            throw Py.IndexError(newPosition + " out of bounds of encoded string");
        }
        return newPosition;
    }

    public static String PyUnicode_EncodeRawUnicodeEscape(String str, String errors2, boolean modifed) {
        StringBuilder v2 = new StringBuilder(str.length());
        Iterator<Integer> iter = new PyUnicode(str).newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (codePoint >= 65536) {
                v2.append("\\U");
                v2.append(hexdigit[codePoint >> 28 & 0xF]);
                v2.append(hexdigit[codePoint >> 24 & 0xF]);
                v2.append(hexdigit[codePoint >> 20 & 0xF]);
                v2.append(hexdigit[codePoint >> 16 & 0xF]);
                v2.append(hexdigit[codePoint >> 12 & 0xF]);
                v2.append(hexdigit[codePoint >> 8 & 0xF]);
                v2.append(hexdigit[codePoint >> 4 & 0xF]);
                v2.append(hexdigit[codePoint & 0xF]);
                continue;
            }
            if (codePoint >= 256 || modifed && (codePoint == 92 || codePoint == 10)) {
                v2.append("\\u");
                v2.append(hexdigit[codePoint >> 12 & 0xF]);
                v2.append(hexdigit[codePoint >> 8 & 0xF]);
                v2.append(hexdigit[codePoint >> 4 & 0xF]);
                v2.append(hexdigit[codePoint & 0xF]);
                continue;
            }
            v2.append((char)codePoint);
        }
        return v2.toString();
    }

    public static String PyUnicode_DecodeRawUnicodeEscape(String str, String errors2) {
        int size = str.length();
        StringBuilder v2 = new StringBuilder(size);
        int i2 = 0;
        while (i2 < size) {
            char ch2 = str.charAt(i2);
            if (ch2 != '\\') {
                v2.append(ch2);
                ++i2;
                continue;
            }
            int bs2 = i2;
            while (i2 < size && (ch2 = str.charAt(i2)) == '\\') {
                v2.append(ch2);
                ++i2;
            }
            if ((i2 - bs2 & 1) == 0 || i2 >= size || ch2 != 'u' && ch2 != 'U') continue;
            v2.setLength(v2.length() - 1);
            int count = ch2 == 'u' ? 4 : 8;
            ++i2;
            int codePoint = 0;
            int asDigit = -1;
            for (int j2 = 0; j2 < count; ++j2) {
                if (i2 == size) {
                    asDigit = -1;
                    break;
                }
                ch2 = str.charAt(i2);
                asDigit = Character.digit(ch2, 16);
                if (asDigit == -1) break;
                codePoint = (codePoint << 4 & 0xFFFFFFF0) + asDigit;
                ++i2;
            }
            if (asDigit == -1) {
                i2 = codecs.insertReplacementAndGetResume(v2, errors2, "rawunicodeescape", str, bs2, i2, "truncated \\uXXXX");
                continue;
            }
            v2.appendCodePoint(codePoint);
        }
        return v2.toString();
    }

    public static String PyUnicode_EncodePunycode(PyUnicode input, String errors2) {
        int buffer2;
        int n2 = 128;
        int delta = 0;
        int n3 = 72;
        int n4 = 0;
        StringBuilder bias = new StringBuilder();
        for (int buffer2 : input) {
            if (!Punycode.isBasic(buffer2)) continue;
            bias.appendCodePoint(buffer2);
            ++n4;
        }
        if (n4 > 0) {
            bias.appendCodePoint(45);
        }
        int b2 = n4;
        buffer2 = input.getCodePointCount();
        while (b2 < buffer2) {
            int h2 = Integer.MAX_VALUE;
            int size = 0;
            int m2 = 0;
            for (int codePointIndex : input) {
                if (codePointIndex > n2 && codePointIndex < h2) {
                    h2 = codePointIndex;
                    m2 = size;
                }
                ++size;
            }
            long iter = delta + (h2 - n2) * (b2 + 1);
            if (iter > Integer.MAX_VALUE) {
                throw Py.UnicodeEncodeError("punycode", input.getString(), m2, m2 + 1, "overflow");
            }
            delta = (int)iter;
            n2 = h2;
            size = 0;
            for (int codePointIndex : input) {
                if (codePointIndex < n2) {
                    iter = delta + 1;
                    if (iter > Integer.MAX_VALUE) {
                        throw Py.UnicodeEncodeError("punycode", input.getString(), size, size + 1, "overflow");
                    }
                    delta = (int)iter;
                }
                if (codePointIndex == n2) {
                    int guard_delta;
                    int q2 = delta;
                    int k2 = 36;
                    while (true) {
                        int t2;
                        int n5 = k2 <= guard_delta ? 1 : (t2 = k2 >= guard_delta + 26 ? 26 : k2 - guard_delta);
                        if (q2 < t2) break;
                        bias.appendCodePoint(t2 + (q2 - t2) % (36 - t2));
                        q2 = (q2 - t2) / (36 - t2);
                        k2 += 36;
                    }
                    bias.appendCodePoint(q2);
                    guard_delta = Punycode.adapt(delta, b2 + 1, b2 == n4);
                    delta = 0;
                    ++b2;
                }
                ++size;
            }
            ++delta;
            ++n2;
        }
        return bias.toString();
    }

    public static PyUnicode PyUnicode_DecodePunycode(String input, String errors2) {
        int j2;
        int input_size = input.length();
        int output_size = 0;
        ArrayList<Integer> ucs4 = new ArrayList<Integer>(input_size);
        for (j2 = 0; j2 < input_size; ++j2) {
            char c2 = input.charAt(j2);
            if (!Punycode.isBasic(c2)) {
                throw Py.UnicodeDecodeError("punycode", input, j2, j2 + 1, "not basic");
            }
            if (c2 == '-') break;
            ucs4.add(Integer.valueOf(c2));
            ++output_size;
        }
        int n2 = 128;
        int i2 = 0;
        int bias = 72;
        while (j2 < input_size) {
            int old_i = i2;
            int w2 = 1;
            int k2 = 36;
            while (true) {
                int t2;
                char c3;
                int digit;
                long guard_i;
                if ((guard_i = (long)(i2 + (digit = (c3 = input.charAt(j2++)) - 48) * w2)) > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j2, j2 + 1, "overflow");
                }
                i2 = (int)guard_i;
                int n3 = k2 <= bias ? 1 : (t2 = k2 >= bias + 26 ? 26 : k2 - bias);
                if (digit < t2) break;
                long guard_w = w2 * 36 - t2;
                if (guard_w > Integer.MAX_VALUE) {
                    throw Py.UnicodeDecodeError("punycode", input, j2, j2 + 1, "overflow");
                }
                k2 += 36;
            }
            bias = Punycode.adapt(i2 - old_i, output_size + 1, old_i == 0);
            n2 += i2 / (output_size + 1);
            ucs4.add(i2 %= output_size + 1, n2);
        }
        return new PyUnicode(ucs4);
    }

    public static String PyUnicode_EncodeIDNA(PyUnicode input, String errors2) {
        throw new UnsupportedOperationException();
    }

    public static PyUnicode PyUnicode_DecodeIDNA(String input, String errors2) {
        throw new UnsupportedOperationException();
    }

    public static PyObject encoding_error(String errors2, String encoding, String toEncode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors2);
        PyException exc = Py.UnicodeEncodeError(encoding, toEncode, start, end, reason);
        exc.normalize();
        PyObject replacement = errorHandler.__call__(new PyObject[]{exc.value});
        codecs.checkErrorHandlerReturn(errors2, replacement);
        return replacement;
    }

    public static int insertReplacementAndGetResume(StringBuilder partialDecode, String errors2, String encoding, String toDecode, int start, int end, String reason) {
        if (errors2 != null) {
            if (errors2.equals(IGNORE)) {
                return end;
            }
            if (errors2.equals(REPLACE)) {
                while (start < end) {
                    partialDecode.appendCodePoint(Py_UNICODE_REPLACEMENT_CHARACTER);
                    ++start;
                }
                return end;
            }
        }
        PyObject replacement = codecs.decoding_error(errors2, encoding, toDecode, start, end, reason);
        codecs.checkErrorHandlerReturn(errors2, replacement);
        partialDecode.append(replacement.__getitem__(0).toString());
        return codecs.calcNewPosition(toDecode.length(), replacement);
    }

    public static PyObject decoding_error(String errors2, String encoding, String toEncode, int start, int end, String reason) {
        PyObject errorHandler = codecs.lookup_error(errors2);
        PyException exc = Py.UnicodeDecodeError(encoding, toEncode, start, end, reason);
        exc.normalize();
        return errorHandler.__call__(new PyObject[]{exc.value});
    }

    private static void checkErrorHandlerReturn(String errors2, PyObject replacement) {
        if (!(replacement instanceof PyTuple && replacement.__len__() == 2 && replacement.__getitem__(0) instanceof PyBaseString && replacement.__getitem__(1) instanceof PyInteger)) {
            throw new PyException(Py.TypeError, "error_handler " + errors2 + " must return a tuple of (replacement, new position)");
        }
    }

    static {
        INIT_LOCK = new Object();
        default_encoding = "ascii";
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        utf7_special = new char[]{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0002', '\u0001', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0002', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0001', '\u0003', '\u0003', '\u0003', '\u0003', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0003', '\u0003', '\u0003', '\u0001', '\u0001'};
        utf8_code_length = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 0, 0};
        hexdigit = "0123456789ABCDEF".toCharArray();
    }

    private static class Punycode {
        private static final int BASE = 36;
        private static final int TMIN = 1;
        private static final int TMAX = 26;
        private static final int SKEW = 38;
        private static final int DAMP = 700;
        private static final int INITIAL_BIAS = 72;
        private static final int INITIAL_N = 128;
        private static final int BASIC = 128;

        private Punycode() {
        }

        private static int adapt(int delta, int numpoints, boolean firsttime) {
            delta = firsttime ? delta / 700 : delta >> 1;
            delta += delta / numpoints;
            int k2 = 0;
            while (delta > 455) {
                delta /= 35;
                k2 += 36;
            }
            return k2 + 36 * delta / (delta + 38);
        }

        private static boolean isBasic(int codePoint) {
            return codePoint < 128;
        }
    }
}

