/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.python.core.AllFunction;
import org.python.core.AnyFunction;
import org.python.core.BuiltinFunctions;
import org.python.core.CompileFunction;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.ImportFunction;
import org.python.core.MaxFunction;
import org.python.core.MinFunction;
import org.python.core.OpenFunction;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyBaseCode;
import org.python.core.PyBaseString;
import org.python.core.PyBoolean;
import org.python.core.PyCallIter;
import org.python.core.PyClassMethod;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyEnumerate;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFrozenSet;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyProperty;
import org.python.core.PyReversedIterator;
import org.python.core.PySet;
import org.python.core.PySlice;
import org.python.core.PyStaticMethod;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySuper;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.PyXRange;
import org.python.core.RoundFunction;
import org.python.core.SortedFunction;
import org.python.core.imp;
import org.python.core.util.RelativeFile;

public class __builtin__ {
    private static final PyStringMap internedStrings = new PyStringMap();
    public static PyString __doc__zip = new PyString("zip(seq1 [, seq2 [...]]) -> [(seq1[0], seq2[0] ...), (...)]\n\nReturn a list of tuples, where each tuple contains the i-th element\nfrom each of the argument sequences.  The returned list is\ntruncated in length to the length of the shortest argument sequence.");

    public static void fillWithBuiltins(PyObject dict) {
        dict.__setitem__("object", (PyObject)PyObject.TYPE);
        dict.__setitem__("type", (PyObject)PyType.TYPE);
        dict.__setitem__("bool", (PyObject)PyBoolean.TYPE);
        dict.__setitem__("int", (PyObject)PyInteger.TYPE);
        dict.__setitem__("enumerate", (PyObject)PyEnumerate.TYPE);
        dict.__setitem__("float", (PyObject)PyFloat.TYPE);
        dict.__setitem__("long", (PyObject)PyLong.TYPE);
        dict.__setitem__("complex", (PyObject)PyComplex.TYPE);
        dict.__setitem__("dict", (PyObject)PyDictionary.TYPE);
        dict.__setitem__("list", (PyObject)PyList.TYPE);
        dict.__setitem__("tuple", (PyObject)PyTuple.TYPE);
        dict.__setitem__("set", (PyObject)PySet.TYPE);
        dict.__setitem__("frozenset", (PyObject)PyFrozenSet.TYPE);
        dict.__setitem__("property", (PyObject)PyProperty.TYPE);
        dict.__setitem__("staticmethod", (PyObject)PyStaticMethod.TYPE);
        dict.__setitem__("classmethod", (PyObject)PyClassMethod.TYPE);
        dict.__setitem__("super", (PyObject)PySuper.TYPE);
        dict.__setitem__("str", (PyObject)PyString.TYPE);
        dict.__setitem__("unicode", (PyObject)PyUnicode.TYPE);
        dict.__setitem__("basestring", (PyObject)PyBaseString.TYPE);
        dict.__setitem__("file", (PyObject)PyFile.TYPE);
        dict.__setitem__("slice", (PyObject)PySlice.TYPE);
        dict.__setitem__("xrange", (PyObject)PyXRange.TYPE);
        dict.__setitem__("None", Py.None);
        dict.__setitem__("NotImplemented", Py.NotImplemented);
        dict.__setitem__("Ellipsis", Py.Ellipsis);
        dict.__setitem__("True", (PyObject)Py.True);
        dict.__setitem__("False", (PyObject)Py.False);
        dict.__setitem__("__debug__", (PyObject)Py.One);
        dict.__setitem__("abs", (PyObject)new BuiltinFunctions("abs", 7, 1));
        dict.__setitem__("apply", (PyObject)new BuiltinFunctions("apply", 9, 1, 3));
        dict.__setitem__("callable", (PyObject)new BuiltinFunctions("callable", 14, 1));
        dict.__setitem__("coerce", (PyObject)new BuiltinFunctions("coerce", 13, 2));
        dict.__setitem__("chr", (PyObject)new BuiltinFunctions("chr", 0, 1));
        dict.__setitem__("cmp", (PyObject)new BuiltinFunctions("cmp", 6, 2));
        dict.__setitem__("globals", (PyObject)new BuiltinFunctions("globals", 4, 0));
        dict.__setitem__("hash", (PyObject)new BuiltinFunctions("hash", 5, 1));
        dict.__setitem__("id", (PyObject)new BuiltinFunctions("id", 11, 1));
        dict.__setitem__("isinstance", (PyObject)new BuiltinFunctions("isinstance", 10, 2));
        dict.__setitem__("len", (PyObject)new BuiltinFunctions("len", 1, 1));
        dict.__setitem__("ord", (PyObject)new BuiltinFunctions("ord", 3, 1));
        dict.__setitem__("range", (PyObject)new BuiltinFunctions("range", 2, 1, 3));
        dict.__setitem__("sum", (PyObject)new BuiltinFunctions("sum", 12, 1, 2));
        dict.__setitem__("unichr", (PyObject)new BuiltinFunctions("unichr", 6, 1));
        dict.__setitem__("delattr", (PyObject)new BuiltinFunctions("delattr", 15, 2));
        dict.__setitem__("dir", (PyObject)new BuiltinFunctions("dir", 16, 0, 1));
        dict.__setitem__("divmod", (PyObject)new BuiltinFunctions("divmod", 17, 2));
        dict.__setitem__("eval", (PyObject)new BuiltinFunctions("eval", 18, 1, 3));
        dict.__setitem__("execfile", (PyObject)new BuiltinFunctions("execfile", 19, 1, 3));
        dict.__setitem__("filter", (PyObject)new BuiltinFunctions("filter", 20, 2));
        dict.__setitem__("getattr", (PyObject)new BuiltinFunctions("getattr", 21, 2, 3));
        dict.__setitem__("hasattr", (PyObject)new BuiltinFunctions("hasattr", 22, 2));
        dict.__setitem__("hex", (PyObject)new BuiltinFunctions("hex", 23, 1));
        dict.__setitem__("input", (PyObject)new BuiltinFunctions("input", 24, 0, 1));
        dict.__setitem__("intern", (PyObject)new BuiltinFunctions("intern", 25, 1));
        dict.__setitem__("issubclass", (PyObject)new BuiltinFunctions("issubclass", 26, 2));
        dict.__setitem__("iter", (PyObject)new BuiltinFunctions("iter", 27, 1, 2));
        dict.__setitem__("locals", (PyObject)new BuiltinFunctions("locals", 28, 0));
        dict.__setitem__("map", (PyObject)new BuiltinFunctions("map", 29, 2, -1));
        dict.__setitem__("max", (PyObject)new MaxFunction());
        dict.__setitem__("min", (PyObject)new MinFunction());
        dict.__setitem__("oct", (PyObject)new BuiltinFunctions("oct", 32, 1));
        dict.__setitem__("pow", (PyObject)new BuiltinFunctions("pow", 33, 2, 3));
        dict.__setitem__("raw_input", (PyObject)new BuiltinFunctions("raw_input", 34, 0, 1));
        dict.__setitem__("reduce", (PyObject)new BuiltinFunctions("reduce", 35, 2, 3));
        dict.__setitem__("reload", (PyObject)new BuiltinFunctions("reload", 36, 1));
        dict.__setitem__("repr", (PyObject)new BuiltinFunctions("repr", 37, 1));
        dict.__setitem__("round", (PyObject)new RoundFunction());
        dict.__setitem__("setattr", (PyObject)new BuiltinFunctions("setattr", 39, 3));
        dict.__setitem__("vars", (PyObject)new BuiltinFunctions("vars", 41, 0, 1));
        dict.__setitem__("zip", (PyObject)new BuiltinFunctions("zip", 43, 0, -1));
        dict.__setitem__("compile", (PyObject)new CompileFunction());
        dict.__setitem__("open", (PyObject)new OpenFunction());
        dict.__setitem__("reversed", (PyObject)new BuiltinFunctions("reversed", 45, 1));
        dict.__setitem__("__import__", (PyObject)new ImportFunction());
        dict.__setitem__("sorted", (PyObject)new SortedFunction());
        dict.__setitem__("all", (PyObject)new AllFunction());
        dict.__setitem__("any", (PyObject)new AnyFunction());
    }

    public static PyObject abs(PyObject o2) {
        return o2.__abs__();
    }

    public static PyObject apply(PyObject o2) {
        return o2.__call__();
    }

    public static PyObject apply(PyObject o2, PyObject args) {
        return o2.__call__(Py.make_array(args));
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject apply(PyObject o2, PyObject args, PyDictionary kws) {
        ConcurrentMap<PyObject, PyObject> concurrentMap = kws.getMap();
        if (concurrentMap.size() > 0) {
            Iterator iterator = concurrentMap.keySet().iterator();
            Iterator table = concurrentMap.values().iterator();
            int ik = concurrentMap.size();
            String[] iv = new String[ik];
            PyObject[] n2 = Py.make_array(args);
            PyObject[] aargs = new PyObject[ik + n2.length];
            System.arraycopy(n2, 0, aargs, 0, n2.length);
            int offset = n2.length;
            for (int i2 = 0; i2 < ik; ++i2) {
                void kw;
                PyObject name = (PyObject)kw.next();
                if (name.getClass() != PyString.class) {
                    throw Py.TypeError(String.format("keywords must be strings", new Object[0]));
                }
                iv[i2] = ((PyString)name).internedString();
                aargs[i2 + offset] = (PyObject)table.next();
            }
            return o2.__call__(aargs, iv);
        }
        return __builtin__.apply(o2, args);
    }

    public static boolean callable(PyObject obj) {
        return obj.isCallable();
    }

    public static int unichr(int i2) {
        if (i2 < 0 || i2 > 0x10FFFF) {
            throw Py.ValueError("unichr() arg not in range(0x110000)");
        }
        return i2;
    }

    public static char chr(int i2) {
        if (i2 < 0 || i2 > 255) {
            throw Py.ValueError("chr() arg not in range(256)");
        }
        return (char)i2;
    }

    public static int cmp(PyObject x2, PyObject y2) {
        return x2._cmp(y2);
    }

    public static PyTuple coerce(PyObject o1, PyObject o2) {
        PyObject[] result = o1._coerce(o2);
        if (result != null) {
            return new PyTuple(result);
        }
        throw Py.TypeError("number coercion failed");
    }

    public static void delattr(PyObject obj, PyObject name) {
        obj.__delattr__(__builtin__.asName(name, "delattr"));
    }

    public static PyObject dir(PyObject o2) {
        PyList ret = (PyList)o2.__dir__();
        ret.sort();
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject dir() {
        PyList retObj;
        PyObject l2 = __builtin__.locals();
        PyObject pyObject = l2.invoke("keys");
        try {
            retObj = (PyList)pyObject;
        }
        catch (ClassCastException e2) {
            void ret;
            throw Py.TypeError(String.format("Expected keys() to be a list, not '%s'", ret.getType().fastGetName()));
        }
        retObj.sort();
        return retObj;
    }

    public static PyObject divmod(PyObject x2, PyObject y2) {
        return x2._divmod(y2);
    }

    private static boolean isMappingType(PyObject o2) {
        return o2 == null || o2 == Py.None || o2.isMappingType();
    }

    private static void verify_mappings(PyObject globals, PyObject locals) {
        if (!__builtin__.isMappingType(globals)) {
            throw Py.TypeError("globals must be a mapping");
        }
        if (!__builtin__.isMappingType(locals)) {
            throw Py.TypeError("locals must be a mapping");
        }
    }

    public static PyObject eval(PyObject o2, PyObject globals, PyObject locals) {
        PyCode code2;
        __builtin__.verify_mappings(globals, locals);
        if (o2 instanceof PyCode) {
            code2 = (PyCode)o2;
        } else if (o2 instanceof PyString) {
            code2 = (PyCode)CompileFunction.compile(o2, "<string>", "eval");
        } else {
            throw Py.TypeError("eval: argument 1 must be string or code object");
        }
        return Py.runCode(code2, locals, globals);
    }

    public static PyObject eval(PyObject o2, PyObject globals) {
        return __builtin__.eval(o2, globals, globals);
    }

    public static PyObject eval(PyObject o2) {
        if (o2 instanceof PyBaseCode && ((PyBaseCode)o2).hasFreevars()) {
            throw Py.TypeError("code object passed to eval() may not contain free variables");
        }
        return __builtin__.eval(o2, null, null);
    }

    public static void execfile(String name, PyObject globals, PyObject locals) {
        __builtin__.execfile_flags(name, globals, locals, Py.getCompilerFlags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execfile_flags(String name, PyObject globals, PyObject locals, CompilerFlags cflags) {
        PyCode code2;
        FileInputStream file;
        __builtin__.verify_mappings(globals, locals);
        try {
            file = new FileInputStream(new RelativeFile(name));
        }
        catch (FileNotFoundException e2) {
            throw Py.IOError(e2);
        }
        try {
            code2 = Py.compile_flags(file, name, CompileMode.exec, cflags);
        }
        finally {
            try {
                file.close();
            }
            catch (IOException e3) {
                throw Py.IOError(e3);
            }
        }
        Py.runCode(code2, locals, globals);
    }

    public static void execfile(String name, PyObject globals) {
        __builtin__.execfile(name, globals, globals);
    }

    public static void execfile(String name) {
        __builtin__.execfile(name, null, null);
    }

    public static PyObject filter(PyObject func, PyObject seq) {
        if (seq instanceof PyString) {
            return __builtin__.filterBaseString(func, (PyString)seq, seq instanceof PyUnicode ? PyUnicode.TYPE : PyString.TYPE);
        }
        if (seq instanceof PyTuple) {
            return __builtin__.filterTuple(func, (PyTuple)seq);
        }
        PyList list = new PyList();
        for (PyObject item : seq.asIterable()) {
            if (func == PyBoolean.TYPE || func == Py.None ? !item.__nonzero__() : !func.__call__(item).__nonzero__()) continue;
            list.append(item);
        }
        return list;
    }

    public static PyObject filterBaseString(PyObject func, PyBaseString seq, PyType stringType) {
        if (func == Py.None && seq.getType() == stringType) {
            return seq;
        }
        StringBuilder builder = new StringBuilder();
        for (PyObject item : seq.asIterable()) {
            if (func != Py.None ? !func.__call__(item).__nonzero__() : !item.__nonzero__()) continue;
            if (!Py.isInstance(item, stringType)) {
                String name = stringType.fastGetName();
                throw Py.TypeError(String.format("can't filter %s to %s: __getitem__ returned different type", name, name));
            }
            builder.append(item.toString());
        }
        String result = builder.toString();
        return stringType == PyString.TYPE ? new PyString(result) : new PyUnicode(result);
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject filterTuple(PyObject func, PyTuple seq) {
        int len = seq.size();
        if (len == 0) {
            if (seq.getType() != PyTuple.TYPE) {
                return Py.EmptyTuple;
            }
            return seq;
        }
        PyList list = new PyList();
        int n2 = 0;
        while (n2 < len) {
            void item;
            PyObject i2 = seq.__finditem__(n2);
            if (!(func == Py.None ? !i2.__nonzero__() : !func.__call__(i2).__nonzero__())) {
                list.append(i2);
            }
            ++item;
        }
        return PyTuple.fromIterable(list);
    }

    public static PyObject getattr(PyObject obj, PyObject name) {
        return __builtin__.getattr(obj, name, null);
    }

    public static PyObject getattr(PyObject obj, PyObject nameObj, PyObject def) {
        String name = __builtin__.asName(nameObj, "getattr");
        PyObject result = null;
        PyException attributeError = null;
        try {
            result = obj.__findattr_ex__(name);
        }
        catch (PyException pye) {
            if (!pye.match(Py.AttributeError)) {
                throw pye;
            }
            attributeError = pye;
        }
        if (result != null) {
            return result;
        }
        if (def != null) {
            return def;
        }
        if (attributeError == null) {
            obj.noAttributeError(name);
        }
        throw attributeError;
    }

    public static PyObject globals() {
        return Py.getFrame().f_globals;
    }

    public static boolean hasattr(PyObject obj, PyObject nameObj) {
        String name = __builtin__.asName(nameObj, "hasattr");
        try {
            return obj.__findattr__(name) != null;
        }
        catch (PyException pyException) {
            return false;
        }
    }

    public static PyInteger hash(PyObject o2) {
        return o2.__hash__();
    }

    public static PyString hex(PyObject o2) {
        return o2.__hex__();
    }

    public static long id(PyObject o2) {
        return Py.id(o2);
    }

    public static PyObject input(PyObject prompt) {
        String line = __builtin__.raw_input(prompt);
        return __builtin__.eval(new PyString(line));
    }

    public static PyObject input() {
        return __builtin__.input(new PyString(""));
    }

    public static PyString intern(PyObject obj) {
        if (!(obj instanceof PyString) || obj instanceof PyUnicode) {
            throw Py.TypeError("intern() argument 1 must be string, not " + obj.getType().fastGetName());
        }
        if (obj.getType() != PyString.TYPE) {
            throw Py.TypeError("can't intern subclass of string");
        }
        PyString s2 = (PyString)obj;
        String istring = s2.internedString();
        PyObject ret = internedStrings.__finditem__(istring);
        if (ret != null) {
            return (PyString)ret;
        }
        internedStrings.__setitem__(istring, (PyObject)s2);
        return s2;
    }

    public static boolean isinstance(PyObject obj, PyObject cls) {
        return Py.isInstance(obj, cls);
    }

    public static boolean issubclass(PyObject derived, PyObject cls) {
        return Py.isSubClass(derived, cls);
    }

    public static PyObject iter(PyObject obj) {
        return obj.__iter__();
    }

    public static PyObject iter(PyObject callable, PyObject sentinel) {
        return new PyCallIter(callable, sentinel);
    }

    public static int len(PyObject obj) {
        return obj.__len__();
    }

    public static PyObject locals() {
        return Py.getFrame().getLocals();
    }

    public static PyObject map(PyObject[] argstar) {
        int iters;
        int n2 = argstar.length - 1;
        if (n2 < 1) {
            throw Py.TypeError("map requires at least two arguments");
        }
        PyObject pyObject = argstar[0];
        PyList f2 = new PyList();
        PyObject[] list = new PyObject[n2];
        PyObject[] args = new PyObject[n2];
        for (iters = 0; iters < n2; ++iters) {
            args[iters] = Py.iter(argstar[iters + 1], "argument " + (iters + 1) + " to map() must support iteration");
        }
        while (true) {
            iters = 0;
            for (int any_items = 0; any_items < n2; ++any_items) {
                PyObject j2 = args[any_items].__iternext__();
                if (j2 != null) {
                    list[any_items] = j2;
                    iters = 1;
                    continue;
                }
                list[any_items] = Py.None;
            }
            if (iters == 0) break;
            if (pyObject == Py.None) {
                if (n2 == 1) {
                    f2.append(list[0]);
                    continue;
                }
                f2.append(new PyTuple((PyObject[])list.clone()));
                continue;
            }
            f2.append(pyObject.__call__(list));
        }
        return f2;
    }

    public static PyString oct(PyObject o2) {
        return o2.__oct__();
    }

    /*
     * WARNING - void declaration
     */
    public static final int ord(PyObject c2) {
        void length;
        int x2;
        PyString pyString = (PyString)c2;
        if (pyString instanceof PyUnicode) {
            x2 = pyString.getString().codePointCount(0, pyString.getString().length());
            if (x2 == 1) {
                return length.getString().codePointAt(0);
            }
        } else {
            x2 = length.getString().length();
            if (x2 == 1) {
                return length.getString().charAt(0);
            }
        }
        throw Py.TypeError("ord() expected a character, but string of length " + x2 + " found");
    }

    public static PyObject pow(PyObject x2, PyObject y2) {
        return x2._pow(y2);
    }

    private static boolean coerce(PyObject[] objs) {
        PyObject x2 = objs[0];
        PyObject y2 = objs[1];
        PyObject[] result = x2._coerce(y2);
        if (result != null) {
            objs[0] = result[0];
            objs[1] = result[1];
            return true;
        }
        result = y2._coerce(x2);
        if (result != null) {
            objs[0] = result[1];
            objs[1] = result[0];
            return true;
        }
        return false;
    }

    public static PyObject pow(PyObject x2, PyObject y2, PyObject z2) {
        PyObject result;
        if (z2 == Py.None) {
            return __builtin__.pow(x2, y2);
        }
        PyObject[] tmp = new PyObject[]{x2, y2};
        if (__builtin__.coerce(tmp)) {
            x2 = tmp[0];
            y2 = tmp[1];
            tmp[1] = z2;
            if (__builtin__.coerce(tmp)) {
                x2 = tmp[0];
                z2 = tmp[1];
                tmp[0] = y2;
                if (__builtin__.coerce(tmp)) {
                    z2 = tmp[1];
                    y2 = tmp[0];
                }
            }
        } else {
            tmp[1] = z2;
            if (__builtin__.coerce(tmp)) {
                x2 = tmp[0];
                z2 = tmp[1];
                tmp[0] = y2;
                if (__builtin__.coerce(tmp)) {
                    y2 = tmp[0];
                    z2 = tmp[1];
                    tmp[1] = x2;
                    if (__builtin__.coerce(tmp)) {
                        x2 = tmp[1];
                        y2 = tmp[0];
                    }
                }
            }
        }
        if ((result = x2.__pow__(y2, z2)) != null) {
            return result;
        }
        throw Py.TypeError(String.format("unsupported operand type(s) for pow(): '%.100s', '%.100s', '%.100s'", x2.getType().fastGetName(), y2.getType().fastGetName(), z2.getType().fastGetName()));
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject range(PyObject start, PyObject stop, PyObject step) {
        void range;
        int ilow = 0;
        int ihigh = 0;
        int istep = 1;
        try {
            ilow = start.asInt();
            ihigh = stop.asInt();
            istep = step.asInt();
        }
        catch (PyException pyException) {
            return __builtin__.handleRangeLongs(start, stop, step);
        }
        if (istep == 0) {
            throw Py.ValueError("range() step argument must not be zero");
        }
        int pye = istep > 0 ? PyXRange.getLenOfRange(ilow, ihigh, istep) : PyXRange.getLenOfRange(ihigh, ilow, -istep);
        if (pye < 0) {
            throw Py.OverflowError("range() result has too many items");
        }
        PyObject[] n2 = new PyObject[pye];
        int i2 = 0;
        while (i2 < range) {
            n2[i2] = Py.newInteger(ilow);
            ++i2;
            ilow += istep;
        }
        return new PyList(n2);
    }

    public static PyObject range(PyObject n2) {
        return __builtin__.range(Py.Zero, n2, Py.One);
    }

    public static PyObject range(PyObject start, PyObject stop) {
        return __builtin__.range(start, stop, Py.One);
    }

    private static PyObject handleRangeLongs(PyObject ilow, PyObject ihigh, PyObject istep) {
        if (!(ilow instanceof PyInteger) && !(ilow instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer start argument expected, got %s.", ilow.getType().fastGetName()));
        }
        if (!(ihigh instanceof PyInteger) && !(ihigh instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer end argument expected, got %s.", ihigh.getType().fastGetName()));
        }
        if (!(istep instanceof PyInteger) && !(istep instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer step argument expected, got %s.", istep.getType().fastGetName()));
        }
        int n2 = istep._cmp(Py.Zero);
        if (n2 == 0) {
            throw Py.ValueError("range() step argument must not be zero");
        }
        int cmpResult = n2 > 0 ? __builtin__.getLenOfRangeLongs(ilow, ihigh, istep) : __builtin__.getLenOfRangeLongs(ihigh, ilow, istep.__neg__());
        if (cmpResult < 0) {
            throw Py.OverflowError("range() result has too many items");
        }
        PyObject[] range = new PyObject[cmpResult];
        for (int i2 = 0; i2 < cmpResult; ++i2) {
            range[i2] = ilow.__long__();
            ilow = ilow.__add__(istep);
        }
        return new PyList(range);
    }

    private static int getLenOfRangeLongs(PyObject lo, PyObject hi, PyObject step) {
        if (lo._cmp(hi) >= 0) {
            return 0;
        }
        try {
            PyObject diff = hi.__sub__(lo).__sub__(Py.One);
            PyObject n2 = diff.__floordiv__(step).__add__(Py.One);
            return n2.asInt();
        }
        catch (PyException pye) {
            return -1;
        }
    }

    private static PyString readline(PyObject file) {
        if (file instanceof PyFile) {
            return ((PyFile)file).readline();
        }
        PyObject ret = file.invoke("readline");
        if (!(ret instanceof PyString)) {
            throw Py.TypeError("object.readline() returned non-string");
        }
        return (PyString)ret;
    }

    public static String raw_input(PyObject prompt, PyObject file) {
        PyObject stdout = Py.getSystemState().stdout;
        if (stdout instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("[raw_]input: lost sys.stdout");
        }
        Py.print(stdout, prompt);
        String data = __builtin__.readline(file).toString();
        if (data.endsWith("\n")) {
            return data.substring(0, data.length() - 1);
        }
        if (data.length() == 0) {
            throw Py.EOFError("raw_input()");
        }
        return data;
    }

    public static String raw_input(PyObject prompt) {
        PyObject stdin = Py.getSystemState().stdin;
        if (stdin instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("[raw_]input: lost sys.stdin");
        }
        return __builtin__.raw_input(prompt, stdin);
    }

    public static String raw_input() {
        return __builtin__.raw_input(new PyString(""));
    }

    public static PyObject reduce(PyObject f2, PyObject l2, PyObject z2) {
        PyObject item;
        PyObject result = z2;
        PyObject iter = Py.iter(l2, "reduce() arg 2 must support iteration");
        while ((item = iter.__iternext__()) != null) {
            if (result == null) {
                result = item;
                continue;
            }
            result = f2.__call__(result, item);
        }
        if (result == null) {
            throw Py.TypeError("reduce of empty sequence with no initial value");
        }
        return result;
    }

    public static PyObject reduce(PyObject f2, PyObject l2) {
        return __builtin__.reduce(f2, l2, null);
    }

    public static PyObject reload(PyModule o2) {
        return imp.reload(o2);
    }

    public static PyObject reload(PySystemState o2) {
        o2.reload();
        return o2;
    }

    public static PyString repr(PyObject o2) {
        return o2.__repr__();
    }

    public static void setattr(PyObject obj, PyObject name, PyObject value) {
        obj.__setattr__(__builtin__.asName(name, "setattr"), value);
    }

    public static PyObject sum(PyObject seq, PyObject result) {
        if (result instanceof PyString) {
            throw Py.TypeError("sum() can't sum strings [use ''.join(seq) instead]");
        }
        for (PyObject item : seq.asIterable()) {
            result = result._add(item);
        }
        return result;
    }

    public static PyObject reversed(PyObject seq) {
        if (seq.__findattr__("__getitem__") != null && seq.__findattr__("__len__") != null && seq.__findattr__("keys") == null) {
            return new PyReversedIterator(seq);
        }
        throw Py.TypeError("argument to reversed() must be a sequence");
    }

    public static PyObject sum(PyObject seq) {
        return __builtin__.sum(seq, Py.Zero);
    }

    public static PyType type(PyObject o2) {
        return o2.getType();
    }

    public static PyObject vars() {
        return __builtin__.locals();
    }

    public static PyObject vars(PyObject o2) {
        try {
            return o2.__getattr__("__dict__");
        }
        catch (PyException e2) {
            if (e2.match(Py.AttributeError)) {
                throw Py.TypeError("vars() argument must have __dict__ attribute");
            }
            throw e2;
        }
    }

    public static PyObject zip() {
        return new PyList();
    }

    /*
     * WARNING - void declaration
     */
    public static PyObject zip(PyObject[] argstar) {
        int itemsize = argstar.length;
        PyObject[] iters = new PyObject[itemsize];
        for (int j2 = 0; j2 < itemsize; ++j2) {
            PyObject iter = argstar[j2].__iter__();
            if (iter == null) {
                throw Py.TypeError("zip argument #" + (j2 + 1) + " must support iteration");
            }
            iters[j2] = iter;
        }
        PyList ret = new PyList();
        int i2 = 0;
        while (true) {
            PyObject[] next = new PyObject[itemsize];
            int n2 = 0;
            while (n2 < itemsize) {
                void item;
                PyObject j3;
                try {
                    j3 = iters[n2].__iternext__();
                }
                catch (PyException e2) {
                    if (e2.match(Py.StopIteration)) {
                        return ret;
                    }
                    throw e2;
                }
                if (j3 == null) {
                    return ret;
                }
                next[item] = j3;
                ++item;
            }
            ret.append(new PyTuple(next));
            ++i2;
        }
    }

    public static PyObject __import__(String name) {
        return __builtin__.__import__(name, null, null, null, -1);
    }

    public static PyObject __import__(String name, PyObject globals) {
        return __builtin__.__import__(name, globals, null, null, -1);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals) {
        return __builtin__.__import__(name, globals, locals, null, -1);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals, PyObject fromlist) {
        return __builtin__.__import__(name, globals, locals, fromlist, -1);
    }

    public static PyObject __import__(String name, PyObject globals, PyObject locals, PyObject fromlist, int level) {
        PyFrame frame = Py.getFrame();
        PyObject builtins = frame != null && frame.f_builtins != null ? frame.f_builtins : PySystemState.builtins;
        PyObject __import__ = builtins.__finditem__("__import__");
        if (__import__ == null) {
            return null;
        }
        PyObject[] args = level < 0 ? new PyObject[]{Py.newString(name), globals, locals, fromlist} : new PyObject[]{Py.newString(name), globals, locals, fromlist, Py.newInteger(level)};
        PyObject module = __import__.__call__(args);
        return module;
    }

    private static String asName(PyObject name, String function) {
        if (name instanceof PyUnicode) {
            return ((PyUnicode)name).encode().intern();
        }
        if (name instanceof PyString) {
            return ((PyString)name).internedString();
        }
        throw Py.TypeError(function + "(): attribute name must be string");
    }
}

