/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyUnicode;
import org.python.core.SyspathArchive;
import org.python.core.util.RelativeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyspathJavaLoader
extends ClassLoader {
    private static final char SLASH_CHAR = '/';

    public SyspathJavaLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromInputStream(InputStream input, int size) {
        try {
            byte[] buffer = new byte[size];
            for (int nread = 0; nread < size; nread += input.read(buffer, nread, size - nread)) {
            }
            byte[] byArray = buffer;
            return byArray;
        }
        catch (IOException exc) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e2) {}
        }
    }

    private byte[] getBytesFromDir(String dir, String name) {
        try {
            File file = this.getFile(dir, name);
            if (file == null) {
                return null;
            }
            return this.getBytesFromInputStream(new FileInputStream(file), (int)file.length());
        }
        catch (FileNotFoundException e2) {
            return null;
        }
        catch (SecurityException e3) {
            return null;
        }
    }

    private byte[] getBytesFromArchive(SyspathArchive archive, String name) {
        String entryname = name.replace('.', '/') + ".class";
        ZipEntry ze = archive.getEntry(entryname);
        if (ze == null) {
            return null;
        }
        try {
            return this.getBytesFromInputStream(archive.getInputStream(ze), (int)ze.getSize());
        }
        catch (IOException e2) {
            return null;
        }
    }

    protected Package definePackageForClass(String name) {
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return null;
        }
        String pkgname = name.substring(0, lastDotIndex);
        Package pkg = this.getPackage(pkgname);
        if (pkg == null) {
            pkg = this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
        return pkg;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        PySystemState sys = Py.getSystemState();
        ClassLoader sysClassLoader = sys.getClassLoader();
        if (sysClassLoader != null) {
            return sysClassLoader.loadClass(name);
        }
        PyList path = sys.path;
        for (int i2 = 0; i2 < path.__len__(); ++i2) {
            void var8_8;
            Object entry;
            PyObject pyObject = SyspathJavaLoader.replacePathItem(sys, i2, path);
            if (pyObject instanceof SyspathArchive) {
                entry = (SyspathArchive)pyObject;
                byte[] archive = this.getBytesFromArchive((SyspathArchive)entry, name);
            } else {
                PyString buffer;
                if (!(buffer instanceof PyUnicode)) {
                    buffer = ((PyObject)buffer).__str__();
                }
                entry = ((PyObject)buffer).toString();
                byte[] dir = this.getBytesFromDir((String)entry, name);
            }
            if (var8_8 == null) continue;
            this.definePackageForClass(name);
            return this.defineClass(name, (byte[])var8_8, 0, ((void)var8_8).length);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String res) {
        PySystemState sys = Py.getSystemState();
        if (res.charAt(0) == '/') {
            res = res.substring(1);
        }
        String entryRes = res;
        if (File.separatorChar != '/') {
            res = res.replace('/', File.separatorChar);
            entryRes = entryRes.replace(File.separatorChar, '/');
        }
        PyList path = sys.path;
        for (int i2 = 0; i2 < path.__len__(); ++i2) {
            PyObject entry = SyspathJavaLoader.replacePathItem(sys, i2, path);
            if (entry instanceof SyspathArchive) {
                SyspathArchive archive = (SyspathArchive)entry;
                ZipEntry ze = archive.getEntry(entryRes);
                if (ze == null) continue;
                try {
                    return new URL("jar:file:" + entry.__str__().toString() + "!/" + entryRes);
                }
                catch (MalformedURLException e2) {
                    throw new RuntimeException(e2);
                }
            }
            if (!(entry instanceof PyUnicode)) {
                entry = entry.__str__();
            }
            String dir = sys.getPath(entry.toString());
            try {
                File resource = new File(dir, res);
                if (!resource.exists()) continue;
                return resource.toURI().toURL();
            }
            catch (MalformedURLException e3) {
                throw new RuntimeException(e3);
            }
        }
        return null;
    }

    static PyObject replacePathItem(PySystemState sys, int idx, PyList paths) {
        PyObject path = paths.__getitem__(idx);
        if (path instanceof SyspathArchive) {
            return path;
        }
        try {
            path = new SyspathArchive(sys.getPath(path.toString()));
        }
        catch (Exception e2) {
            return path;
        }
        paths.__setitem__(idx, path);
        return path;
    }

    private File getFile(String dir, String name) {
        String accum = "";
        boolean first = true;
        StringTokenizer t2 = new StringTokenizer(name, ".");
        while (t2.hasMoreTokens()) {
            String token2 = t2.nextToken();
            if (!first) {
                accum = accum + File.separator;
            }
            accum = accum + token2;
            first = false;
        }
        return new RelativeFile(dir, accum + ".class");
    }
}

